/*
 * Copyright(C) 2008 Tetsuro IKEDA <ikdttr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package senna;

/**
 * Wrapper for Column
 */
public class Column extends SennaObject {
    /**
     * call sen_column_create().
     *
     * @param ctx SennaContext
     * @param table table
     * @param name name
     * @param path path
     * @param flags flags
     * @return created column
     * @throws SennaException
     */
    public static native Column create(SennaContext ctx, Table table, String name,
				       String path, int flags) throws SennaException;

    /**
     * call sen_column_open().
     *
     * @param ctx SennaContext
     * @param name name
     * @param flags flags
     * @param type type
     * @return created column
     * @throws SennaException
     */
    private native Column open(SennaContext ctx, Table table, String name,
			       String path, Type type) throws SennaException;

    /**
     * creates new object with sen_column_open().
     *
     * @param ctx
     * @param table
     * @param name
     * @param path
     * @throws SennaException
     */
    public Column(SennaContext ctx, Table table, String name, String path,
		  Type type) throws SennaException {
	open(ctx, table, name, path, type);
    }

    /**
     * call sen_column_index_update().
     *
     * @param sen_id
     * @param section
     * @param old_value
     * @param new_value
     * @throws SennaException
     */
    public native void indexUpdate(int sen_id, int section, String old_value,
				   String new_value) throws SennaException;

    /**
     * call sen_column_table().
     *
     * @return table
     * @throws SennaException
     */
    public native Table getTable() throws SennaException;
}
