#include "oyagame.h"

/**************************
* Strucfure for SDL_mixer *
**************************
typedef struct {
    int allocated;
    Uint8 *abuf;
    Uint32 alen;
    Uint8 volume;     // Per-sample volume, 0-128
} Mix_Chunk;
/*******************************
* End: strucfure for SDL_mixer *
*******************************/


// Basic methods in COMDATA class 
void* COMDATA::pStructure(){
	return StructureAddress;
}
void* COMDATA::SetStructure(int what, void* pStructure /* =NULL */){
	if (StructureAddress && !ImportedStructure) delete StructureAddress;
	StructureType=what;
	if (pStructure) {
		ImportedStructure=true;
		return StructureAddress=pStructure;
	}
	ImportedStructure=false;
	switch((STRUCTURE_TYPE) StructureType){
		case Struct_SDL_AudioSpec:
			return StructureAddress=(void*)new SDL_AudioSpec;
		case Struct_SDL_AudioCVT:
			return StructureAddress=(void*)new SDL_AudioCVT;
		case Struct_SDL_CDtrack:
			return StructureAddress=(void*)new SDL_CDtrack;
		case Struct_SDL_CD:
			return StructureAddress=(void*)new SDL_CD;
		case Struct_SDL_ActiveEvent:
			return StructureAddress=(void*)new SDL_ActiveEvent;
		case Struct_SDL_KeyboardEvent:
			return StructureAddress=(void*)new SDL_KeyboardEvent;
		case Struct_SDL_MouseMotionEvent:
			return StructureAddress=(void*)new SDL_MouseMotionEvent;
		case Struct_SDL_MouseButtonEvent:
			return StructureAddress=(void*)new SDL_MouseButtonEvent;
		case Struct_SDL_JoyAxisEvent:
			return StructureAddress=(void*)new SDL_JoyAxisEvent;
		case Struct_SDL_JoyBallEvent:
			return StructureAddress=(void*)new SDL_JoyBallEvent;
		case Struct_SDL_JoyHatEvent:
			return StructureAddress=(void*)new SDL_JoyHatEvent;
		case Struct_SDL_JoyButtonEvent:
			return StructureAddress=(void*)new SDL_JoyButtonEvent;
		case Struct_SDL_ResizeEvent:
			return StructureAddress=(void*)new SDL_ResizeEvent;
		case Struct_SDL_ExposeEvent:
			return StructureAddress=(void*)new SDL_ExposeEvent;
		case Struct_SDL_QuitEvent:
			return StructureAddress=(void*)new SDL_QuitEvent;
		case Struct_SDL_UserEvent:
			return StructureAddress=(void*)new SDL_UserEvent;
		case Struct_SDL_SysWMEvent:
			return StructureAddress=(void*)new SDL_SysWMEvent;
		case Struct_SDL_keysym:
			return StructureAddress=(void*)new SDL_keysym;
		case Struct_SDL_Cursor:
			return StructureAddress=(void*)new SDL_Cursor;
		case Struct_SDL_RWops:
			return StructureAddress=(void*)new SDL_RWops;
		case Struct_Uint64:
			return StructureAddress=(void*)new Uint64;
		case Struct_Sint64:
			return StructureAddress=(void*)new Sint64;
		case Struct_SDL_SysWMinfo:
			return StructureAddress=(void*)new SDL_SysWMinfo;
		case Struct_SDL_SysWMmsg:
			return StructureAddress=(void*)new SDL_SysWMmsg;
		case Struct_SDL_version:
			return StructureAddress=(void*)new SDL_version;
		case Struct_SDL_Rect:
			return StructureAddress=(void*)new SDL_Rect;
		case Struct_SDL_Color:
			return StructureAddress=(void*)new SDL_Color;
		case Struct_SDL_Palette:
			return StructureAddress=(void*)new SDL_Palette;
		case Struct_SDL_PixelFormat:
			return StructureAddress=(void*)new SDL_PixelFormat;
		case Struct_SDL_Surface:
			return StructureAddress=(void*)new SDL_Surface;
		case Struct_SDL_VideoInfo:
			return StructureAddress=(void*)new SDL_VideoInfo;
		case Struct_SDL_Overlay:
			return StructureAddress=(void*)new SDL_Overlay;
		case Struct_SDL_Event:
			return StructureAddress=(void*)new SDL_Event;
		//case Struct_Mix_Chunk:
		//	return StructureAddress=(void*)new Mix_Chunk;
		case Struct_SDL_Joystick:
		default:
			return NULL;
	}
}

DWORD COMDATA::SetStructureValue(LPWSTR name, VARIANTARG* rgvarg, int key){
	return GetOrSetStructureValue(true,name,rgvarg,key,StructureType,StructureAddress);
}
DWORD COMDATA::GetStructureValue(LPWSTR name, VARIANTARG* rgvarg, int key){
	return GetOrSetStructureValue(false,name,rgvarg,key,StructureType,StructureAddress);
}

// Functions for setting/getting structure values.
void GetOrSetStructureValueSub(bool mode, VARIANTARG* rgvarg, Uint32 *param){
	if (mode) *param=(Uint32)CopyINT(rgvarg);//set
	else {//get
		rgvarg->vt=VT_I4;
		rgvarg->lVal=(int)*param;
	}
}
void GetOrSetStructureValueSub(bool mode, VARIANTARG* rgvarg, Sint32 *param){
	if (mode) *param=(Sint32)CopyINT(rgvarg);//set
	else {//get
		rgvarg->vt=VT_I4;
		rgvarg->lVal=(int)*param;
	}
}
void GetOrSetStructureValueSub(bool mode, VARIANTARG* rgvarg, Uint16 *param){
	if (mode) *param=(Uint16)CopyINT(rgvarg);//set
	else {//get
		rgvarg->vt=VT_I4;
		rgvarg->lVal=(int)*param;
	}
}
void GetOrSetStructureValueSub(bool mode, VARIANTARG* rgvarg, Sint16 *param){
	if (mode) *param=(Sint16)CopyINT(rgvarg);//set
	else {//get
		rgvarg->vt=VT_I4;
		rgvarg->lVal=(int)*param;
	}
}
void GetOrSetStructureValueSub(bool mode, VARIANTARG* rgvarg, Uint8 *param){
	if (mode) *param=(Uint8)CopyINT(rgvarg);//set
	else {//get
		rgvarg->vt=VT_I4;
		rgvarg->lVal=(int)*param;
	}
}
void GetOrSetStructureValueSub(bool mode, VARIANTARG* rgvarg, Sint8 *param){
	if (mode) *param=(Sint8)CopyINT(rgvarg);//set
	else {//get
		rgvarg->vt=VT_I4;
		rgvarg->lVal=(int)*param;
	}
}
void GetOrSetStructureValueSub(bool mode, VARIANTARG* rgvarg, int param){
	// Export the pointer to "structure included in structure".
	// Note that this is NOT for "the pointer of structure in structure".
	if (mode) return;//This method is for export only.
	else {//get
		rgvarg->vt=VT_I4;
		rgvarg->lVal=(int)param;
	}
}
void GetOrSetStructureValueSub(bool mode, VARIANTARG* rgvarg, double *param){
	if (mode) *param=(double)CopyDBL(rgvarg);//set
	else {//get
		rgvarg->vt=VT_R8;
		rgvarg->dblVal=(double)*param;
	}
}

DWORD COMDATA::GetOrSetStructureValue(bool mode, LPWSTR name, VARIANTARG* rgvarg, int key, int sType, void* pSA){
	// Rule: (note that the 'structure' is not pointer to outside structure, but nesting one)
	// numeric              : &((SDL_xxx*)pSA)->xxx
	// structure            : (int)&((SDL_xxx*)pSA)->xxx
	// enum                 : (int*)&((SDL_xxx*)pSA)->xxx
	// pointer to void      : (int*)&((SDL_xxx*)pSA)->xxx
	// pointer to structure : (int*)&((SDL_xxx*)pSA)->xxx
	// pointer to function  : (int*)&((SDL_xxx*)pSA)->xxx
	// pointer to numeric   : ((SDL_xxx*)pSA)->xxx
	// This routine will be automatically created in the future.
	switch((STRUCTURE_TYPE) sType){
		case Struct_SDL_AudioSpec:
			if      (!lstrcmpiW(name,L"format"))   GetOrSetStructureValueSub(mode,rgvarg,&((SDL_AudioSpec*)pSA)->format);
			else if (!lstrcmpiW(name,L"channels")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_AudioSpec*)pSA)->channels);
			else if (!lstrcmpiW(name,L"freq"))     GetOrSetStructureValueSub(mode,rgvarg,&((SDL_AudioSpec*)pSA)->freq);
			else if (!lstrcmpiW(name,L"silence"))  GetOrSetStructureValueSub(mode,rgvarg,&((SDL_AudioSpec*)pSA)->silence);
			else if (!lstrcmpiW(name,L"samples"))  GetOrSetStructureValueSub(mode,rgvarg,&((SDL_AudioSpec*)pSA)->samples);
			else if (!lstrcmpiW(name,L"padding"))  GetOrSetStructureValueSub(mode,rgvarg,&((SDL_AudioSpec*)pSA)->padding);
			else if (!lstrcmpiW(name,L"size"))     GetOrSetStructureValueSub(mode,rgvarg,&((SDL_AudioSpec*)pSA)->size);
			else if (!lstrcmpiW(name,L"callback")) GetOrSetStructureValueSub(mode,rgvarg,(int*)&((SDL_AudioSpec*)pSA)->callback);
			else if (!lstrcmpiW(name,L"userdata")) GetOrSetStructureValueSub(mode,rgvarg,(int*)&((SDL_AudioSpec*)pSA)->userdata);
			else return DISP_E_MEMBERNOTFOUND;
			break;
		case Struct_SDL_AudioCVT:
			if      (!lstrcmpiW(name,L"needed"))       GetOrSetStructureValueSub(mode,rgvarg,&((SDL_AudioCVT*)pSA)->needed);
			else if (!lstrcmpiW(name,L"src_format"))   GetOrSetStructureValueSub(mode,rgvarg,&((SDL_AudioCVT*)pSA)->src_format);
			else if (!lstrcmpiW(name,L"dst_format"))   GetOrSetStructureValueSub(mode,rgvarg,&((SDL_AudioCVT*)pSA)->dst_format);
			else if (!lstrcmpiW(name,L"rate_incr"))    GetOrSetStructureValueSub(mode,rgvarg,&((SDL_AudioCVT*)pSA)->rate_incr);
			else if (!lstrcmpiW(name,L"buf"))          GetOrSetStructureValueSub(mode,rgvarg,((SDL_AudioCVT*)pSA)->buf);
			else if (!lstrcmpiW(name,L"len"))          GetOrSetStructureValueSub(mode,rgvarg,&((SDL_AudioCVT*)pSA)->len);
			else if (!lstrcmpiW(name,L"len_cvt"))      GetOrSetStructureValueSub(mode,rgvarg,&((SDL_AudioCVT*)pSA)->len_cvt);
			else if (!lstrcmpiW(name,L"len_mult"))     GetOrSetStructureValueSub(mode,rgvarg,&((SDL_AudioCVT*)pSA)->len_mult);
			else if (!lstrcmpiW(name,L"len_ratio"))    GetOrSetStructureValueSub(mode,rgvarg,&((SDL_AudioCVT*)pSA)->len_ratio);
			else if (!lstrcmpiW(name,L"filters"))      GetOrSetStructureValueSub(mode,rgvarg,(int*)&((SDL_AudioCVT*)pSA)->filters[key]);
			else if (!lstrcmpiW(name,L"filter_index")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_AudioCVT*)pSA)->filter_index);
			else return DISP_E_MEMBERNOTFOUND;
			break;
		case Struct_SDL_CDtrack:
			if      (!lstrcmpiW(name,L"id"))     GetOrSetStructureValueSub(mode,rgvarg,&((SDL_CDtrack*)pSA)->id);
			else if (!lstrcmpiW(name,L"type"))   GetOrSetStructureValueSub(mode,rgvarg,&((SDL_CDtrack*)pSA)->type);
			else if (!lstrcmpiW(name,L"unused")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_CDtrack*)pSA)->unused);
			else if (!lstrcmpiW(name,L"length")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_CDtrack*)pSA)->length);
			else if (!lstrcmpiW(name,L"offset")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_CDtrack*)pSA)->offset);
			else return DISP_E_MEMBERNOTFOUND;
			break;
		case Struct_SDL_CD:
			if      (!lstrcmpiW(name,L"id"))        GetOrSetStructureValueSub(mode,rgvarg,&((SDL_CD*)pSA)->id);
			else if (!lstrcmpiW(name,L"status"))    GetOrSetStructureValueSub(mode,rgvarg,(int*)&((SDL_CD*)pSA)->status);
			else if (!lstrcmpiW(name,L"numtracks")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_CD*)pSA)->numtracks);
			else if (!lstrcmpiW(name,L"cur_track")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_CD*)pSA)->cur_track);
			else if (!lstrcmpiW(name,L"cur_frame")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_CD*)pSA)->cur_frame);
			else if (!lstrcmpiW(name,L"track"))     GetOrSetStructureValueSub(mode,rgvarg,(int)&((SDL_CD*)pSA)->track[key]);
			else return DISP_E_MEMBERNOTFOUND;
			break;
		case Struct_SDL_ActiveEvent:
			if      (!lstrcmpiW(name,L"type"))  GetOrSetStructureValueSub(mode,rgvarg,&((SDL_ActiveEvent*)pSA)->type);
			else if (!lstrcmpiW(name,L"gain"))  GetOrSetStructureValueSub(mode,rgvarg,&((SDL_ActiveEvent*)pSA)->gain);
			else if (!lstrcmpiW(name,L"state")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_ActiveEvent*)pSA)->state);
			else return DISP_E_MEMBERNOTFOUND;
			break;
		case Struct_SDL_KeyboardEvent:
			if      (!lstrcmpiW(name,L"type"))      GetOrSetStructureValueSub(mode,rgvarg,&((SDL_KeyboardEvent*)pSA)->type);
			else if (!lstrcmpiW(name,L"which"))     GetOrSetStructureValueSub(mode,rgvarg,&((SDL_KeyboardEvent*)pSA)->which);
			else if (!lstrcmpiW(name,L"state"))     GetOrSetStructureValueSub(mode,rgvarg,&((SDL_KeyboardEvent*)pSA)->state);
			else if (!lstrcmpiW(name,L"keysym"))    GetOrSetStructureValueSub(mode,rgvarg,(int)&((SDL_KeyboardEvent*)pSA)->keysym);
			else if (0<lstrcmpiW(name,L"keysym_") && 0>lstrcmpiW(name,L"keysym`"))
				return GetOrSetStructureValue(mode, name+7, rgvarg, key, (int)Struct_SDL_keysym, &((SDL_KeyboardEvent*)pSA)->keysym);
			else return DISP_E_MEMBERNOTFOUND;
			break;
		case Struct_SDL_MouseMotionEvent:
			if      (!lstrcmpiW(name,L"type"))  GetOrSetStructureValueSub(mode,rgvarg,&((SDL_MouseMotionEvent*)pSA)->type);
			else if (!lstrcmpiW(name,L"which")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_MouseMotionEvent*)pSA)->which);
			else if (!lstrcmpiW(name,L"state")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_MouseMotionEvent*)pSA)->state);
			else if (!lstrcmpiW(name,L"x"))     GetOrSetStructureValueSub(mode,rgvarg,&((SDL_MouseMotionEvent*)pSA)->x);
			else if (!lstrcmpiW(name,L"y"))     GetOrSetStructureValueSub(mode,rgvarg,&((SDL_MouseMotionEvent*)pSA)->y);
			else if (!lstrcmpiW(name,L"xrel"))  GetOrSetStructureValueSub(mode,rgvarg,&((SDL_MouseMotionEvent*)pSA)->xrel);
			else if (!lstrcmpiW(name,L"yrel"))  GetOrSetStructureValueSub(mode,rgvarg,&((SDL_MouseMotionEvent*)pSA)->yrel);
			else return DISP_E_MEMBERNOTFOUND;
			break;
		case Struct_SDL_MouseButtonEvent:
			if      (!lstrcmpiW(name,L"type"))   GetOrSetStructureValueSub(mode,rgvarg,&((SDL_MouseButtonEvent*)pSA)->type);
			else if (!lstrcmpiW(name,L"which"))  GetOrSetStructureValueSub(mode,rgvarg,&((SDL_MouseButtonEvent*)pSA)->which);
			else if (!lstrcmpiW(name,L"button")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_MouseButtonEvent*)pSA)->button);
			else if (!lstrcmpiW(name,L"state"))  GetOrSetStructureValueSub(mode,rgvarg,&((SDL_MouseButtonEvent*)pSA)->state);
			else if (!lstrcmpiW(name,L"x"))      GetOrSetStructureValueSub(mode,rgvarg,&((SDL_MouseButtonEvent*)pSA)->x);
			else if (!lstrcmpiW(name,L"y"))      GetOrSetStructureValueSub(mode,rgvarg,&((SDL_MouseButtonEvent*)pSA)->y);
			else return DISP_E_MEMBERNOTFOUND;
			break;
		case Struct_SDL_JoyAxisEvent:
			if      (!lstrcmpiW(name,L"type"))  GetOrSetStructureValueSub(mode,rgvarg,&((SDL_JoyAxisEvent*)pSA)->type);
			else if (!lstrcmpiW(name,L"which")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_JoyAxisEvent*)pSA)->which);
			else if (!lstrcmpiW(name,L"axis"))  GetOrSetStructureValueSub(mode,rgvarg,&((SDL_JoyAxisEvent*)pSA)->axis);
			else if (!lstrcmpiW(name,L"value")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_JoyAxisEvent*)pSA)->value);
			else return DISP_E_MEMBERNOTFOUND;
			break;
		case Struct_SDL_JoyBallEvent:
			if      (!lstrcmpiW(name,L"type"))  GetOrSetStructureValueSub(mode,rgvarg,&((SDL_JoyBallEvent*)pSA)->type);
			else if (!lstrcmpiW(name,L"which")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_JoyBallEvent*)pSA)->which);
			else if (!lstrcmpiW(name,L"ball"))  GetOrSetStructureValueSub(mode,rgvarg,&((SDL_JoyBallEvent*)pSA)->ball);
			else if (!lstrcmpiW(name,L"xrel"))  GetOrSetStructureValueSub(mode,rgvarg,&((SDL_JoyBallEvent*)pSA)->xrel);
			else if (!lstrcmpiW(name,L"yrel"))  GetOrSetStructureValueSub(mode,rgvarg,&((SDL_JoyBallEvent*)pSA)->yrel);
			else return DISP_E_MEMBERNOTFOUND;
			break;
		case Struct_SDL_JoyHatEvent:
			if      (!lstrcmpiW(name,L"type"))  GetOrSetStructureValueSub(mode,rgvarg,&((SDL_JoyHatEvent*)pSA)->type);
			else if (!lstrcmpiW(name,L"which")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_JoyHatEvent*)pSA)->which);
			else if (!lstrcmpiW(name,L"hat"))   GetOrSetStructureValueSub(mode,rgvarg,&((SDL_JoyHatEvent*)pSA)->hat);
			else if (!lstrcmpiW(name,L"value")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_JoyHatEvent*)pSA)->value);
			else return DISP_E_MEMBERNOTFOUND;
			break;
		case Struct_SDL_JoyButtonEvent:
			if      (!lstrcmpiW(name,L"type"))   GetOrSetStructureValueSub(mode,rgvarg,&((SDL_JoyButtonEvent*)pSA)->type);
			else if (!lstrcmpiW(name,L"which"))  GetOrSetStructureValueSub(mode,rgvarg,&((SDL_JoyButtonEvent*)pSA)->which);
			else if (!lstrcmpiW(name,L"button")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_JoyButtonEvent*)pSA)->button);
			else if (!lstrcmpiW(name,L"state"))  GetOrSetStructureValueSub(mode,rgvarg,&((SDL_JoyButtonEvent*)pSA)->state);
			else return DISP_E_MEMBERNOTFOUND;
			break;
		case Struct_SDL_ResizeEvent:
			if      (!lstrcmpiW(name,L"type")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_ResizeEvent*)pSA)->type);
			else if (!lstrcmpiW(name,L"w"))    GetOrSetStructureValueSub(mode,rgvarg,&((SDL_ResizeEvent*)pSA)->w);
			else if (!lstrcmpiW(name,L"h"))    GetOrSetStructureValueSub(mode,rgvarg,&((SDL_ResizeEvent*)pSA)->h);
			else return DISP_E_MEMBERNOTFOUND;
			break;
		case Struct_SDL_ExposeEvent:
			if      (!lstrcmpiW(name,L"type")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_ExposeEvent*)pSA)->type);
			else return DISP_E_MEMBERNOTFOUND;
			break;
		case Struct_SDL_QuitEvent:
			if      (!lstrcmpiW(name,L"type")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_QuitEvent*)pSA)->type);
			else return DISP_E_MEMBERNOTFOUND;
			break;
		case Struct_SDL_UserEvent:
			if      (!lstrcmpiW(name,L"type"))  GetOrSetStructureValueSub(mode,rgvarg,&((SDL_UserEvent*)pSA)->type);
			else if (!lstrcmpiW(name,L"code"))  GetOrSetStructureValueSub(mode,rgvarg,&((SDL_UserEvent*)pSA)->code);
			else if (!lstrcmpiW(name,L"data1")) GetOrSetStructureValueSub(mode,rgvarg,(int*)&((SDL_UserEvent*)pSA)->data1);
			else if (!lstrcmpiW(name,L"data1")) GetOrSetStructureValueSub(mode,rgvarg,(int*)&((SDL_UserEvent*)pSA)->data1);
			else return DISP_E_MEMBERNOTFOUND;
			break;
		case Struct_SDL_SysWMEvent:
			if      (!lstrcmpiW(name,L"type"))    GetOrSetStructureValueSub(mode,rgvarg,&((SDL_SysWMEvent*)pSA)->type);
			else if (!lstrcmpiW(name,L"msg"))     GetOrSetStructureValueSub(mode,rgvarg,(int*)&((SDL_SysWMEvent*)pSA)->msg);
			else if (0<lstrcmpiW(name,L"msg_") && 0>lstrcmpiW(name,L"msg`"))
				return GetOrSetStructureValue(mode, name+4, rgvarg, key, (int)Struct_SDL_SysWMmsg, ((SDL_SysWMEvent*)pSA)->msg);
			else return DISP_E_MEMBERNOTFOUND;
			break;
		case Struct_SDL_SysWMmsg:
			if      (!lstrcmpiW(name,L"hwnd"))    GetOrSetStructureValueSub(mode,rgvarg,(int*)&((SDL_SysWMmsg*)pSA)->hwnd);
			else if (!lstrcmpiW(name,L"msg"))     GetOrSetStructureValueSub(mode,rgvarg,&((SDL_SysWMmsg*)pSA)->msg);
			else if (!lstrcmpiW(name,L"wParam"))  GetOrSetStructureValueSub(mode,rgvarg,(int*)&((SDL_SysWMmsg*)pSA)->wParam);
			else if (!lstrcmpiW(name,L"lParam"))  GetOrSetStructureValueSub(mode,rgvarg,(int*)&((SDL_SysWMmsg*)pSA)->lParam);
			else if (!lstrcmpiW(name,L"version")) GetOrSetStructureValueSub(mode,rgvarg,(int)&((SDL_SysWMmsg*)pSA)->version);
			else if (0<lstrcmpiW(name,L"version_") && 0>lstrcmpiW(name,L"version`"))
				return GetOrSetStructureValue(mode, name+8, rgvarg, key, (int)Struct_SDL_version, &((SDL_SysWMmsg*)pSA)->version);
			else return DISP_E_MEMBERNOTFOUND;
			break;//*/
		case Struct_SDL_keysym:
			if      (!lstrcmpiW(name,L"scancode")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_keysym*)pSA)->scancode);
			else if (!lstrcmpiW(name,L"sym"))      GetOrSetStructureValueSub(mode,rgvarg,(int*)&((SDL_keysym*)pSA)->sym);
			else if (!lstrcmpiW(name,L"mod"))      GetOrSetStructureValueSub(mode,rgvarg,(int*)&((SDL_keysym*)pSA)->mod);
			else if (!lstrcmpiW(name,L"unicode"))  GetOrSetStructureValueSub(mode,rgvarg,&((SDL_keysym*)pSA)->unicode);
			else return DISP_E_MEMBERNOTFOUND;
			break;
		case Struct_SDL_Cursor:
			if      (!lstrcmpiW(name,L"area"))      GetOrSetStructureValueSub(mode,rgvarg,(int)&((SDL_Cursor*)pSA)->area);
			else if (!lstrcmpiW(name,L"hot_x"))     GetOrSetStructureValueSub(mode,rgvarg,&((SDL_Cursor*)pSA)->hot_x);
			else if (!lstrcmpiW(name,L"hot_y"))     GetOrSetStructureValueSub(mode,rgvarg,&((SDL_Cursor*)pSA)->hot_y);
			else if (!lstrcmpiW(name,L"data"))      GetOrSetStructureValueSub(mode,rgvarg,((SDL_Cursor*)pSA)->data);
			else if (!lstrcmpiW(name,L"mask"))      GetOrSetStructureValueSub(mode,rgvarg,((SDL_Cursor*)pSA)->mask);
			else if (!lstrcmpiW(name,L"save"))      GetOrSetStructureValueSub(mode,rgvarg,((SDL_Cursor*)pSA)->save[key]);
			else if (!lstrcmpiW(name,L"wm_cursor")) GetOrSetStructureValueSub(mode,rgvarg,(int*)&((SDL_Cursor*)pSA)->wm_cursor);
			else if (0<lstrcmpiW(name,L"area_") && 0>lstrcmpiW(name,L"area`"))
				return GetOrSetStructureValue(mode, name+5, rgvarg, key, (int)Struct_SDL_Rect, &((SDL_Cursor*)pSA)->area);
			else return DISP_E_MEMBERNOTFOUND;
			break;
		case Struct_SDL_RWops:
			if      (!lstrcmpiW(name,L"seek"))      GetOrSetStructureValueSub(mode,rgvarg,(int*)&((SDL_RWops*)pSA)->seek);
			else if (!lstrcmpiW(name,L"read"))      GetOrSetStructureValueSub(mode,rgvarg,(int*)&((SDL_RWops*)pSA)->read);
			else if (!lstrcmpiW(name,L"write"))     GetOrSetStructureValueSub(mode,rgvarg,(int*)&((SDL_RWops*)pSA)->write);
			else if (!lstrcmpiW(name,L"close"))     GetOrSetStructureValueSub(mode,rgvarg,(int*)&((SDL_RWops*)pSA)->close);
			else if (!lstrcmpiW(name,L"type"))      GetOrSetStructureValueSub(mode,rgvarg,&((SDL_RWops*)pSA)->type);
			else if (!lstrcmpiW(name,L"hidden"))    GetOrSetStructureValueSub(mode,rgvarg,(int)&((SDL_RWops*)pSA)->hidden);
			else if (!lstrcmpiW(name,L"hidden_mem"))       GetOrSetStructureValueSub(mode,rgvarg,(int)&((SDL_RWops*)pSA)->hidden.mem);
			else if (!lstrcmpiW(name,L"hidden_mem_base"))      GetOrSetStructureValueSub(mode,rgvarg,((SDL_RWops*)pSA)->hidden.mem.base);
			else if (!lstrcmpiW(name,L"hidden_mem_here"))      GetOrSetStructureValueSub(mode,rgvarg,((SDL_RWops*)pSA)->hidden.mem.here);
			else if (!lstrcmpiW(name,L"hidden_mem_stop"))      GetOrSetStructureValueSub(mode,rgvarg,((SDL_RWops*)pSA)->hidden.mem.stop);
			else if (!lstrcmpiW(name,L"hidden_stdio"))     GetOrSetStructureValueSub(mode,rgvarg,(int)&((SDL_RWops*)pSA)->hidden.stdio);
			else if (!lstrcmpiW(name,L"hidden_stdio_autoclose")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_RWops*)pSA)->hidden.stdio.autoclose);
			else if (!lstrcmpiW(name,L"hidden_stdio_fp"))        GetOrSetStructureValueSub(mode,rgvarg,(int*)((SDL_RWops*)pSA)->hidden.stdio.fp);
			else if (!lstrcmpiW(name,L"hidden_win32io"))   GetOrSetStructureValueSub(mode,rgvarg,(int)&((SDL_RWops*)pSA)->hidden.win32io);
			else if (!lstrcmpiW(name,L"hidden_win32io_buffer")) GetOrSetStructureValueSub(mode,rgvarg,(int)&((SDL_RWops*)pSA)->hidden.win32io.buffer);
			else if (!lstrcmpiW(name,L"hidden_win32io_buffer_data")) GetOrSetStructureValueSub(mode,rgvarg,(int*)&((SDL_RWops*)pSA)->hidden.win32io.buffer.data);
			else if (!lstrcmpiW(name,L"hidden_win32io_buffer_left")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_RWops*)pSA)->hidden.win32io.buffer.left);
			else if (!lstrcmpiW(name,L"hidden_win32io_buffer_size")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_RWops*)pSA)->hidden.win32io.buffer.size);
			else if (!lstrcmpiW(name,L"hidden_win32io_append")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_RWops*)pSA)->hidden.win32io.append);
			else if (!lstrcmpiW(name,L"hidden_win32io_h"))      GetOrSetStructureValueSub(mode,rgvarg,(int*)&((SDL_RWops*)pSA)->hidden.win32io.h);
			else if (!lstrcmpiW(name,L"hidden_unknown"))       GetOrSetStructureValueSub(mode,rgvarg,(int)&((SDL_RWops*)pSA)->hidden.unknown);
			else if (!lstrcmpiW(name,L"hidden_unknown_data1")) GetOrSetStructureValueSub(mode,rgvarg,(int*)&((SDL_RWops*)pSA)->hidden.unknown.data1);
			else return DISP_E_MEMBERNOTFOUND;
			break;//*/
		case Struct_Uint64:
			if      (!lstrcmpiW(name,L"hi")) GetOrSetStructureValueSub(mode,rgvarg,(int*)&StructureAddress+4);
			else if (!lstrcmpiW(name,L"lo")) GetOrSetStructureValueSub(mode,rgvarg,(int*)&StructureAddress);
			else return DISP_E_MEMBERNOTFOUND;
			break;
		case Struct_Sint64:
			if      (!lstrcmpiW(name,L"hi")) GetOrSetStructureValueSub(mode,rgvarg,(int*)&StructureAddress+4);
			else if (!lstrcmpiW(name,L"lo")) GetOrSetStructureValueSub(mode,rgvarg,(int*)&StructureAddress);
			else return DISP_E_MEMBERNOTFOUND;
			break;
		case Struct_SDL_SysWMinfo:
			if      (!lstrcmpiW(name,L"version")) GetOrSetStructureValueSub(mode,rgvarg,(int)&((SDL_SysWMinfo*)pSA)->version);
			else if (!lstrcmpiW(name,L"window"))  GetOrSetStructureValueSub(mode,rgvarg,(int*)&((SDL_SysWMinfo*)pSA)->window);
			else if (!lstrcmpiW(name,L"hglrc"))   GetOrSetStructureValueSub(mode,rgvarg,(int*)&((SDL_SysWMinfo*)pSA)->hglrc);
			else if (0<lstrcmpiW(name,L"version_") && 0>lstrcmpiW(name,L"version`"))
				return GetOrSetStructureValue(mode, name+8, rgvarg, key, (int)Struct_SDL_version, &((SDL_SysWMinfo*)pSA)->version);
			else return DISP_E_MEMBERNOTFOUND;
			break;
		case Struct_SDL_version:
			if      (!lstrcmpiW(name,L"major")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_version*)pSA)->major);
			else if (!lstrcmpiW(name,L"minor")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_version*)pSA)->minor);
			else if (!lstrcmpiW(name,L"patch")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_version*)pSA)->patch);
			else return DISP_E_MEMBERNOTFOUND;
			break;//*/
			return DISP_E_MEMBERNOTFOUND;
		case Struct_SDL_Rect:
			if      (!lstrcmpiW(name,L"x")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_Rect*)pSA)->x);
			else if (!lstrcmpiW(name,L"y")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_Rect*)pSA)->y);
			else if (!lstrcmpiW(name,L"w")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_Rect*)pSA)->w);
			else if (!lstrcmpiW(name,L"h")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_Rect*)pSA)->h);
			else return DISP_E_MEMBERNOTFOUND;
			break;
		case Struct_SDL_Color:
			if      (!lstrcmpiW(name,L"r"))      GetOrSetStructureValueSub(mode,rgvarg,&((SDL_Color*)pSA)->r);
			else if (!lstrcmpiW(name,L"g"))      GetOrSetStructureValueSub(mode,rgvarg,&((SDL_Color*)pSA)->g);
			else if (!lstrcmpiW(name,L"b"))      GetOrSetStructureValueSub(mode,rgvarg,&((SDL_Color*)pSA)->b);
			else if (!lstrcmpiW(name,L"unused")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_Color*)pSA)->unused);
			else return DISP_E_MEMBERNOTFOUND;
			break;
		case Struct_SDL_Palette:
			if      (!lstrcmpiW(name,L"ncolors")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_Palette*)pSA)->ncolors);
			else if (!lstrcmpiW(name,L"colors"))  GetOrSetStructureValueSub(mode,rgvarg,(int*)&((SDL_Palette*)pSA)->colors);
			else if (0<lstrcmpiW(name,L"colors_") && 0>lstrcmpiW(name,L"colors`"))
				return GetOrSetStructureValue(mode, name+7, rgvarg, key, (int)Struct_SDL_Color, ((SDL_Palette*)pSA)->colors);
			else return DISP_E_MEMBERNOTFOUND;
			break;
		case Struct_SDL_PixelFormat:
			if      (!lstrcmpiW(name,L"palette"))       GetOrSetStructureValueSub(mode,rgvarg,(int*)&((SDL_PixelFormat*)pSA)->palette);
			else if (!lstrcmpiW(name,L"BitsPerPixel"))  GetOrSetStructureValueSub(mode,rgvarg,&((SDL_PixelFormat*)pSA)->BitsPerPixel);
			else if (!lstrcmpiW(name,L"BytesPerPixel")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_PixelFormat*)pSA)->BytesPerPixel);
			else if (!lstrcmpiW(name,L"Rloss"))         GetOrSetStructureValueSub(mode,rgvarg,&((SDL_PixelFormat*)pSA)->Rloss);
			else if (!lstrcmpiW(name,L"Gloss"))         GetOrSetStructureValueSub(mode,rgvarg,&((SDL_PixelFormat*)pSA)->Gloss);
			else if (!lstrcmpiW(name,L"Bloss"))         GetOrSetStructureValueSub(mode,rgvarg,&((SDL_PixelFormat*)pSA)->Bloss);
			else if (!lstrcmpiW(name,L"Aloss"))         GetOrSetStructureValueSub(mode,rgvarg,&((SDL_PixelFormat*)pSA)->Aloss);
			else if (!lstrcmpiW(name,L"Rshift"))        GetOrSetStructureValueSub(mode,rgvarg,&((SDL_PixelFormat*)pSA)->Rshift);
			else if (!lstrcmpiW(name,L"Gshift"))        GetOrSetStructureValueSub(mode,rgvarg,&((SDL_PixelFormat*)pSA)->Gshift);
			else if (!lstrcmpiW(name,L"Bshift"))        GetOrSetStructureValueSub(mode,rgvarg,&((SDL_PixelFormat*)pSA)->Bshift);
			else if (!lstrcmpiW(name,L"Ashift"))        GetOrSetStructureValueSub(mode,rgvarg,&((SDL_PixelFormat*)pSA)->Ashift);
			else if (!lstrcmpiW(name,L"Rmask"))         GetOrSetStructureValueSub(mode,rgvarg,&((SDL_PixelFormat*)pSA)->Rmask);
			else if (!lstrcmpiW(name,L"Gmask"))         GetOrSetStructureValueSub(mode,rgvarg,&((SDL_PixelFormat*)pSA)->Gmask);
			else if (!lstrcmpiW(name,L"Bmask"))         GetOrSetStructureValueSub(mode,rgvarg,&((SDL_PixelFormat*)pSA)->Bmask);
			else if (!lstrcmpiW(name,L"Amask"))         GetOrSetStructureValueSub(mode,rgvarg,&((SDL_PixelFormat*)pSA)->Amask);
			else if (!lstrcmpiW(name,L"colorkey"))      GetOrSetStructureValueSub(mode,rgvarg,&((SDL_PixelFormat*)pSA)->colorkey);
			else if (!lstrcmpiW(name,L"alpha"))         GetOrSetStructureValueSub(mode,rgvarg,&((SDL_PixelFormat*)pSA)->alpha);
			else if (0<lstrcmpiW(name,L"palette_") && 0>lstrcmpiW(name,L"palette`"))
				return GetOrSetStructureValue(mode, name+8, rgvarg, key, (int)Struct_SDL_Palette, ((SDL_PixelFormat*)pSA)->palette);
			else return DISP_E_MEMBERNOTFOUND;
			break;
		case Struct_SDL_Surface:
			if      (!lstrcmpiW(name,L"flags"))     GetOrSetStructureValueSub(mode,rgvarg,&((SDL_Surface*)pSA)->flags);
			else if (!lstrcmpiW(name,L"format"))    GetOrSetStructureValueSub(mode,rgvarg,(int*)&((SDL_Surface*)pSA)->format);
			else if (!lstrcmpiW(name,L"w"))         GetOrSetStructureValueSub(mode,rgvarg,&((SDL_Surface*)pSA)->w);
			else if (!lstrcmpiW(name,L"h"))         GetOrSetStructureValueSub(mode,rgvarg,&((SDL_Surface*)pSA)->h);
			else if (!lstrcmpiW(name,L"pitch"))     GetOrSetStructureValueSub(mode,rgvarg,&((SDL_Surface*)pSA)->pitch);
			else if (!lstrcmpiW(name,L"pixels"))    GetOrSetStructureValueSub(mode,rgvarg,(int*)&((SDL_Surface*)pSA)->pixels);
			else if (!lstrcmpiW(name,L"offset"))    GetOrSetStructureValueSub(mode,rgvarg,&((SDL_Surface*)pSA)->offset);
			else if (!lstrcmpiW(name,L"clip_rect")) GetOrSetStructureValueSub(mode,rgvarg,(int)&((SDL_Surface*)pSA)->clip_rect);
			else if (!lstrcmpiW(name,L"refcount"))  GetOrSetStructureValueSub(mode,rgvarg,&((SDL_Surface*)pSA)->refcount);
			else if (0<lstrcmpiW(name,L"format_") && 0>lstrcmpiW(name,L"format`"))
				return GetOrSetStructureValue(mode, name+7, rgvarg, key, (int)Struct_SDL_PixelFormat, ((SDL_Surface*)pSA)->format);
			else if (0<lstrcmpiW(name,L"clip_rect_") && 0>lstrcmpiW(name,L"clip_rect`"))
				return GetOrSetStructureValue(mode, name+10, rgvarg, key, (int)Struct_SDL_Rect, &((SDL_Surface*)pSA)->clip_rect);
			else return DISP_E_MEMBERNOTFOUND;
			break;//*/
		case Struct_SDL_VideoInfo:
			if (!lstrcmpiW(name,L"video_mem"))         GetOrSetStructureValueSub(mode,rgvarg,&((SDL_VideoInfo*)pSA)->video_mem);
			else if (!lstrcmpiW(name,L"vfmt"))         GetOrSetStructureValueSub(mode,rgvarg,(int*)&((SDL_VideoInfo*)pSA)->vfmt);
			else if (!lstrcmpiW(name,L"current_w"))    GetOrSetStructureValueSub(mode,rgvarg,&((SDL_VideoInfo*)pSA)->current_w);
			else if (!lstrcmpiW(name,L"current_h"))    GetOrSetStructureValueSub(mode,rgvarg,&((SDL_VideoInfo*)pSA)->current_h);
			else if (0<lstrcmpiW(name,L"vfmt_") && 0>lstrcmpiW(name,L"vfmt`"))
				return GetOrSetStructureValue(mode, name+5, rgvarg, key, (int)Struct_SDL_PixelFormat, ((SDL_VideoInfo*)pSA)->vfmt);
			else if (mode){//set bit
				if      (!lstrcmpiW(name,L"hw_available")) ((SDL_VideoInfo*)pSA)->hw_available=CopyINT(rgvarg);
				else if (!lstrcmpiW(name,L"wm_available")) ((SDL_VideoInfo*)pSA)->wm_available=CopyINT(rgvarg);
				else if (!lstrcmpiW(name,L"UnusedBits1"))  ((SDL_VideoInfo*)pSA)->UnusedBits1=CopyINT(rgvarg);
				else if (!lstrcmpiW(name,L"UnusedBits2"))  ((SDL_VideoInfo*)pSA)->UnusedBits2=CopyINT(rgvarg);
				else if (!lstrcmpiW(name,L"blit_hw"))      ((SDL_VideoInfo*)pSA)->blit_hw=CopyINT(rgvarg);
				else if (!lstrcmpiW(name,L"blit_hw_CC"))   ((SDL_VideoInfo*)pSA)->blit_hw_CC=CopyINT(rgvarg);
				else if (!lstrcmpiW(name,L"blit_hw_A"))    ((SDL_VideoInfo*)pSA)->blit_hw_A=CopyINT(rgvarg);
				else if (!lstrcmpiW(name,L"blit_sw"))      ((SDL_VideoInfo*)pSA)->blit_sw=CopyINT(rgvarg);
				else if (!lstrcmpiW(name,L"blit_sw_CC"))   ((SDL_VideoInfo*)pSA)->blit_sw_CC=CopyINT(rgvarg);
				else if (!lstrcmpiW(name,L"blit_sw_A"))    ((SDL_VideoInfo*)pSA)->blit_sw_A=CopyINT(rgvarg);
				else if (!lstrcmpiW(name,L"blit_fill"))    ((SDL_VideoInfo*)pSA)->blit_fill=CopyINT(rgvarg);
				else if (!lstrcmpiW(name,L"UnusedBits3"))  ((SDL_VideoInfo*)pSA)->UnusedBits3=CopyINT(rgvarg);
				else return DISP_E_MEMBERNOTFOUND;
			} else {// get bit
				if      (!lstrcmpiW(name,L"hw_available")) rgvarg->lVal=(int)((SDL_VideoInfo*)pSA)->hw_available;
				else if (!lstrcmpiW(name,L"wm_available")) rgvarg->lVal=(int)((SDL_VideoInfo*)pSA)->wm_available;
				else if (!lstrcmpiW(name,L"UnusedBits1"))  rgvarg->lVal=(int)((SDL_VideoInfo*)pSA)->UnusedBits1;
				else if (!lstrcmpiW(name,L"UnusedBits2"))  rgvarg->lVal=(int)((SDL_VideoInfo*)pSA)->UnusedBits2;
				else if (!lstrcmpiW(name,L"blit_hw"))      rgvarg->lVal=(int)((SDL_VideoInfo*)pSA)->blit_hw;
				else if (!lstrcmpiW(name,L"blit_hw_CC"))   rgvarg->lVal=(int)((SDL_VideoInfo*)pSA)->blit_hw_CC;
				else if (!lstrcmpiW(name,L"blit_hw_A"))    rgvarg->lVal=(int)((SDL_VideoInfo*)pSA)->blit_hw_A;
				else if (!lstrcmpiW(name,L"blit_sw"))      rgvarg->lVal=(int)((SDL_VideoInfo*)pSA)->blit_sw;
				else if (!lstrcmpiW(name,L"blit_sw_CC"))   rgvarg->lVal=(int)((SDL_VideoInfo*)pSA)->blit_sw_CC;
				else if (!lstrcmpiW(name,L"blit_sw_A"))    rgvarg->lVal=(int)((SDL_VideoInfo*)pSA)->blit_sw_A;
				else if (!lstrcmpiW(name,L"blit_fill"))    rgvarg->lVal=(int)((SDL_VideoInfo*)pSA)->blit_fill;
				else if (!lstrcmpiW(name,L"UnusedBits3"))  rgvarg->lVal=(int)((SDL_VideoInfo*)pSA)->UnusedBits3;
				else return DISP_E_MEMBERNOTFOUND;
				rgvarg->vt=VT_I4;
			}
			break;
		case Struct_SDL_Overlay:
			if      (!lstrcmpiW(name,L"format")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_Overlay*)pSA)->format);
			else if (!lstrcmpiW(name,L"w")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_Overlay*)pSA)->w);
			else if (!lstrcmpiW(name,L"h")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_Overlay*)pSA)->h);
			else if (!lstrcmpiW(name,L"planes")) GetOrSetStructureValueSub(mode,rgvarg,&((SDL_Overlay*)pSA)->planes);
			else if (!lstrcmpiW(name,L"pitches")) GetOrSetStructureValueSub(mode,rgvarg,((SDL_Overlay*)pSA)->pitches);
			else if (!lstrcmpiW(name,L"pixels")) GetOrSetStructureValueSub(mode,rgvarg,(int*)&((SDL_Overlay*)pSA)->pixels);
			else return DISP_E_MEMBERNOTFOUND;
			break;
		case Struct_SDL_Event:
			if      (!lstrcmpiW(name,L"type"))    GetOrSetStructureValueSub(mode,rgvarg,&((SDL_Event*)pSA)->type);
			else if (!lstrcmpiW(name,L"active"))  GetOrSetStructureValueSub(mode,rgvarg,(int)&((SDL_Event*)pSA)->active);
			else if (!lstrcmpiW(name,L"key"))     GetOrSetStructureValueSub(mode,rgvarg,(int)&((SDL_Event*)pSA)->key);
			else if (!lstrcmpiW(name,L"motion"))  GetOrSetStructureValueSub(mode,rgvarg,(int)&((SDL_Event*)pSA)->motion);
			else if (!lstrcmpiW(name,L"button"))  GetOrSetStructureValueSub(mode,rgvarg,(int)&((SDL_Event*)pSA)->button);
			else if (!lstrcmpiW(name,L"jaxis"))   GetOrSetStructureValueSub(mode,rgvarg,(int)&((SDL_Event*)pSA)->jaxis);
			else if (!lstrcmpiW(name,L"jball"))   GetOrSetStructureValueSub(mode,rgvarg,(int)&((SDL_Event*)pSA)->jball);
			else if (!lstrcmpiW(name,L"jhat"))    GetOrSetStructureValueSub(mode,rgvarg,(int)&((SDL_Event*)pSA)->jhat);
			else if (!lstrcmpiW(name,L"jbutton")) GetOrSetStructureValueSub(mode,rgvarg,(int)&((SDL_Event*)pSA)->jbutton);
			else if (!lstrcmpiW(name,L"resize"))  GetOrSetStructureValueSub(mode,rgvarg,(int)&((SDL_Event*)pSA)->resize);
			else if (!lstrcmpiW(name,L"expose"))  GetOrSetStructureValueSub(mode,rgvarg,(int)&((SDL_Event*)pSA)->expose);
			else if (!lstrcmpiW(name,L"quit"))    GetOrSetStructureValueSub(mode,rgvarg,(int)&((SDL_Event*)pSA)->quit);
			else if (!lstrcmpiW(name,L"user"))    GetOrSetStructureValueSub(mode,rgvarg,(int)&((SDL_Event*)pSA)->user);
			else if (!lstrcmpiW(name,L"syswm"))   GetOrSetStructureValueSub(mode,rgvarg,(int)&((SDL_Event*)pSA)->syswm);
			else if (0<lstrcmpiW(name,L"active_") && 0>lstrcmpiW(name,L"active`"))
				return GetOrSetStructureValue(mode, name+7, rgvarg, key, (int)Struct_SDL_ActiveEvent, &((SDL_Event*)pSA)->active);
			else if (0<lstrcmpiW(name,L"key_") && 0>lstrcmpiW(name,L"key`"))
				return GetOrSetStructureValue(mode, name+4, rgvarg, key, (int)Struct_SDL_KeyboardEvent, &((SDL_Event*)pSA)->key);
			else if (0<lstrcmpiW(name,L"motion_") && 0>lstrcmpiW(name,L"motion`"))
				return GetOrSetStructureValue(mode, name+7, rgvarg, key, (int)Struct_SDL_MouseMotionEvent, &((SDL_Event*)pSA)->motion);
			else if (0<lstrcmpiW(name,L"button_") && 0>lstrcmpiW(name,L"button`"))
				return GetOrSetStructureValue(mode, name+7, rgvarg, key, (int)Struct_SDL_MouseButtonEvent, &((SDL_Event*)pSA)->button);
			else if (0<lstrcmpiW(name,L"jaxis_") && 0>lstrcmpiW(name,L"jaxis`"))
				return GetOrSetStructureValue(mode, name+6, rgvarg, key, (int)Struct_SDL_JoyAxisEvent, &((SDL_Event*)pSA)->jaxis);
			else if (0<lstrcmpiW(name,L"jball_") && 0>lstrcmpiW(name,L"jball`"))
				return GetOrSetStructureValue(mode, name+6, rgvarg, key, (int)Struct_SDL_JoyBallEvent, &((SDL_Event*)pSA)->jball);
			else if (0<lstrcmpiW(name,L"jhat_") && 0>lstrcmpiW(name,L"jhat`"))
				return GetOrSetStructureValue(mode, name+5, rgvarg, key, (int)Struct_SDL_JoyHatEvent, &((SDL_Event*)pSA)->jhat);
			else if (0<lstrcmpiW(name,L"jbutton_") && 0>lstrcmpiW(name,L"jbutton`"))
				return GetOrSetStructureValue(mode, name+8, rgvarg, key, (int)Struct_SDL_JoyButtonEvent, &((SDL_Event*)pSA)->jbutton);
			else if (0<lstrcmpiW(name,L"resize_") && 0>lstrcmpiW(name,L"resize`"))
				return GetOrSetStructureValue(mode, name+7, rgvarg, key, (int)Struct_SDL_ResizeEvent, &((SDL_Event*)pSA)->resize);
			else if (0<lstrcmpiW(name,L"expose_") && 0>lstrcmpiW(name,L"expose`"))
				return GetOrSetStructureValue(mode, name+7, rgvarg, key, (int)Struct_SDL_ExposeEvent, &((SDL_Event*)pSA)->expose);
			else if (0<lstrcmpiW(name,L"quit_") && 0>lstrcmpiW(name,L"quit`"))
				return GetOrSetStructureValue(mode, name+5, rgvarg, key, (int)Struct_SDL_QuitEvent, &((SDL_Event*)pSA)->quit);
			else if (0<lstrcmpiW(name,L"user_") && 0>lstrcmpiW(name,L"user`"))
				return GetOrSetStructureValue(mode, name+5, rgvarg, key, (int)Struct_SDL_UserEvent, &((SDL_Event*)pSA)->user);
			else if (0<lstrcmpiW(name,L"syswm_") && 0>lstrcmpiW(name,L"syswm`"))
				return GetOrSetStructureValue(mode, name+6, rgvarg, key, (int)Struct_SDL_SysWMEvent, &((SDL_Event*)pSA)->syswm);
			else return DISP_E_MEMBERNOTFOUND;
			break;
		/*case Struct_Mix_Chunk:
			if      (!lstrcmpiW(name,L"allocated")) GetOrSetStructureValueSub(mode,rgvarg,&((Mix_Chunk*)pSA)->allocated);
			else if (!lstrcmpiW(name,L"abuf")) GetOrSetStructureValueSub(mode,rgvarg,((Mix_Chunk*)pSA)->abuf);
			else if (!lstrcmpiW(name,L"alen")) GetOrSetStructureValueSub(mode,rgvarg,&((Mix_Chunk*)pSA)->alen);
			else if (!lstrcmpiW(name,L"volume")) GetOrSetStructureValueSub(mode,rgvarg,&((Mix_Chunk*)pSA)->volume);
			else return DISP_E_MEMBERNOTFOUND;
			break;//*/
		case Struct_SDL_Joystick:
		default:
			return DISP_E_MEMBERNOTFOUND;
	}
	return S_OK;
}

// Get the STRUCTURE_TYPE from string name.
STRUCTURE_TYPE ResolveStructureTypeFromName(LPWSTR name){
	if (!name) return Struct_NULL;
	if (0<lstrcmpiW(name,L"SDL_") && 0>lstrcmpiW(name,L"SDL`")) {
		if      (!lstrcmpiW(name+4,L"AudioSpec"))        return Struct_SDL_AudioSpec;
		else if (!lstrcmpiW(name+4,L"AudioCVT"))         return Struct_SDL_AudioCVT;
		else if (!lstrcmpiW(name+4,L"CDtrack"))          return Struct_SDL_CDtrack;
		else if (!lstrcmpiW(name+4,L"CD"))               return Struct_SDL_CD;
		else if (!lstrcmpiW(name+4,L"ActiveEvent"))      return Struct_SDL_ActiveEvent;
		else if (!lstrcmpiW(name+4,L"KeyboardEvent"))    return Struct_SDL_KeyboardEvent;
		else if (!lstrcmpiW(name+4,L"MouseMotionEvent")) return Struct_SDL_MouseMotionEvent;
		else if (!lstrcmpiW(name+4,L"MouseButtonEvent")) return Struct_SDL_MouseButtonEvent;
		else if (!lstrcmpiW(name+4,L"JoyAxisEvent"))     return Struct_SDL_JoyAxisEvent;
		else if (!lstrcmpiW(name+4,L"JoyBallEvent"))     return Struct_SDL_JoyBallEvent;
		else if (!lstrcmpiW(name+4,L"JoyHatEvent"))      return Struct_SDL_JoyHatEvent;
		else if (!lstrcmpiW(name+4,L"JoyButtonEvent"))   return Struct_SDL_JoyButtonEvent;
		else if (!lstrcmpiW(name+4,L"ResizeEvent"))      return Struct_SDL_ResizeEvent;
		else if (!lstrcmpiW(name+4,L"ExposeEvent"))      return Struct_SDL_ExposeEvent;
		else if (!lstrcmpiW(name+4,L"QuitEvent"))        return Struct_SDL_QuitEvent;
		else if (!lstrcmpiW(name+4,L"UserEvent"))        return Struct_SDL_UserEvent;
		else if (!lstrcmpiW(name+4,L"SysWMEvent"))       return Struct_SDL_SysWMEvent;
		else if (!lstrcmpiW(name+4,L"SysWMmsg"))         return Struct_SDL_SysWMmsg;
		else if (!lstrcmpiW(name+4,L"keysym"))           return Struct_SDL_keysym;
		else if (!lstrcmpiW(name+4,L"Cursor"))           return Struct_SDL_Cursor;
		else if (!lstrcmpiW(name+4,L"RWops"))            return Struct_SDL_RWops;
		else if (!lstrcmpiW(name+4,L"Rect"))             return Struct_SDL_Rect;
		else if (!lstrcmpiW(name+4,L"Color"))            return Struct_SDL_Color;
		else if (!lstrcmpiW(name+4,L"Palette"))          return Struct_SDL_Palette;
		else if (!lstrcmpiW(name+4,L"PixelFormat"))      return Struct_SDL_PixelFormat;
		else if (!lstrcmpiW(name+4,L"Surface"))          return Struct_SDL_Surface;
		else if (!lstrcmpiW(name+4,L"VideoInfo"))        return Struct_SDL_VideoInfo;
		else if (!lstrcmpiW(name+4,L"Overlay"))          return Struct_SDL_Overlay;
		else if (!lstrcmpiW(name+4,L"Event"))            return Struct_SDL_Event;
		else if (!lstrcmpiW(name+4,L"Joystick"))         return Struct_SDL_Joystick;
		else return Struct_NULL;
	} else if (!lstrcmpiW(name,L"Uint64"))             return Struct_Uint64;
	else if (!lstrcmpiW(name,L"Sint64"))               return Struct_Sint64;
	//else if (!lstrcmpiW(name,L"Mix_Chunk"))            return Struct_Mix_Chunk;
	else return Struct_NULL;
}
// Convert pointer to structure object or unicode when return to WSH
bool ConverToStructureObjectOrString(LPWSTR funcName, void* pStruct, VARIANT* pVarResult){
	if (!pStruct) return false;
	STRUCTURE_TYPE sType=Struct_NULL;
	if (0<lstrcmpiW(funcName,L"SDL_") && 0>lstrcmpiW(funcName,L"SDL`")) {
		if      (!lstrcmpiW(funcName+4,L"GetVideoSurface"))      sType=Struct_SDL_Surface;
		else if (!lstrcmpiW(funcName+4,L"GetVideoInfo"))         sType=Struct_SDL_VideoInfo;
		else if (!lstrcmpiW(funcName+4,L"SetVideoMode"))         sType=Struct_SDL_Surface;
		else if (!lstrcmpiW(funcName+4,L"CreateRGBSurface"))     sType=Struct_SDL_Surface;
		else if (!lstrcmpiW(funcName+4,L"CreateRGBSurfaceFrom")) sType=Struct_SDL_Surface;
		else if (!lstrcmpiW(funcName+4,L"LoadBMP"))              sType=Struct_SDL_Surface;
		else if (!lstrcmpiW(funcName+4,L"ConvertSurface"))       sType=Struct_SDL_Surface;
		else if (!lstrcmpiW(funcName+4,L"DisplayFormat"))        sType=Struct_SDL_Surface;
		else if (!lstrcmpiW(funcName+4,L"DisplayFormatAlpha"))   sType=Struct_SDL_Surface;
		else if (!lstrcmpiW(funcName+4,L"CreateCursor"))         sType=Struct_SDL_Cursor;
		else if (!lstrcmpiW(funcName+4,L"GetCursor"))            sType=Struct_SDL_Cursor;
		else if (!lstrcmpiW(funcName+4,L"CreateYUVOverlay"))     sType=Struct_SDL_Overlay;
		else if (!lstrcmpiW(funcName+4,L"JoystickOpen"))         sType=Struct_SDL_Joystick;
		else if (!lstrcmpiW(funcName+4,L"LoadWAV"))              sType=Struct_SDL_AudioSpec;
		else if (!lstrcmpiW(funcName+4,L"CDOpen"))               sType=Struct_SDL_CD;
		else if (!lstrcmpiW(funcName+4,L"VideoDriverName"))      sType=Struct_NULL;
		else if (!lstrcmpiW(funcName+4,L"GetError"))             sType=Struct_NULL;
		else if (!lstrcmpiW(funcName+4,L"GetKeyName"))           sType=Struct_NULL;
		else if (!lstrcmpiW(funcName+4,L"JoystickName"))         sType=Struct_NULL;
		else if (!lstrcmpiW(funcName+4,L"CDName"))               sType=Struct_NULL;
		else if (!lstrcmpiW(funcName+4,L"ListModes"))            sType=Struct_NULL;
		else return false;
	} else return false;
	if (sType!=Struct_NULL) {// Structure
		pVarResult->vt=VT_DISPATCH;
		pVarResult->pdispVal=NewStructureObject(sType,pStruct);
	} else {// String
		TempMemory* temp;
		temp=new TempMemory;
		pVarResult->vt=VT_BSTR;
		pVarResult->bstrVal=SysAllocString(temp->TempUNI((LPSTR)pStruct));
		delete temp;
	}
	return true;

/*
SDL_Rect **SDL_();
*/
	return NULL;
}