#include "oyagame.h"

// Following function will be used in ConstScriptSub macro.
// This function returns true if an error occurs.
bool _ConstScriptSub(int* position, int max, char* code, char* name,int i,bool init=false){
	static char *prefix, *postfix;
	static int l_prefix,l_postfix;
	if (init) {// Initialize the prefic and post fix.
		prefix=code;
		postfix=name;
		l_prefix=strlen(prefix);
		l_postfix=strlen(postfix);
		return false;
	}
	int pos=*position;
	int l_name=strlen(name);
	char value[32]="=";
	_ltoa_s(i,(char*)&value+1,31,10);
	int l_value=strlen(value);
	if (strcpy_s(code+pos,max-pos,prefix)) return true;
	if (strcpy_s(code+pos+l_prefix,max-pos-l_prefix,name)) return true;
	if (strcpy_s(code+pos+l_prefix+l_name,max-pos-l_prefix-l_name,(char*)&value)) return true;
	if (strcpy_s(code+pos+l_prefix+l_name+l_value,max-pos-l_prefix-l_name-l_value,postfix)) return true;
	*position+=l_prefix+l_name+l_value+l_postfix;
	return false;
}

// Macro to wrap above function.
// If an error occurs, throw the error.
#define ConstScriptSub(a,b) if (_ConstScriptSub(&pos,max,code,a,b)) throw NTE_NO_MEMORY;

// Note that following function returns BSTR.
// SysAllocString() is used in this function.
BSTR ConstScript(char* header, char* footer, char* prefix, char* postfix){
	_ConstScriptSub(NULL,NULL,prefix,postfix,0,true);
	TempMemory temp;
	int max=32768;
	int pos=0;
	char* code=temp.TempANSI(max);
	if (strcpy_s(code,max,header)) throw NTE_NO_MEMORY;
	pos+=strlen(header);

/********************
* Constants for SDL *
********************/
// #define SDLCALL __cdecl
// #define SDLCALL _System
// #define __inline__	__inline
// #define __inline__ inline
#ifdef NULL
//ConstScriptSub("NULL",NULL); //#define NULL 0
#endif
#ifdef SDL_INIT_JOYSTICK
ConstScriptSub("SDL_INIT_JOYSTICK",SDL_INIT_JOYSTICK); //#define SDL_INIT_JOYSTICK	0x00000200
#endif
#ifdef SDL_INIT_NOPARACHUTE
ConstScriptSub("SDL_INIT_NOPARACHUTE",SDL_INIT_NOPARACHUTE); //#define SDL_INIT_NOPARACHUTE	0x00100000	
#endif
#ifdef SDL_INIT_EVENTTHREAD
ConstScriptSub("SDL_INIT_EVENTTHREAD",SDL_INIT_EVENTTHREAD); //#define SDL_INIT_EVENTTHREAD	0x01000000	
#endif
#ifdef SDL_INIT_EVERYTHING
ConstScriptSub("SDL_INIT_EVERYTHING",SDL_INIT_EVERYTHING); //#define SDL_INIT_EVERYTHING	0x0000FFFF
#endif
#ifdef SDL_APPMOUSEFOCUS
ConstScriptSub("SDL_APPMOUSEFOCUS",SDL_APPMOUSEFOCUS); //#define SDL_APPMOUSEFOCUS	0x01		
#endif
#ifdef SDL_APPINPUTFOCUS
ConstScriptSub("SDL_APPINPUTFOCUS",SDL_APPINPUTFOCUS); //#define SDL_APPINPUTFOCUS	0x02		
#endif
#ifdef AUDIO_U8
ConstScriptSub("AUDIO_U8",AUDIO_U8); //#define AUDIO_U8	0x0008	
#endif
#ifdef AUDIO_S8
ConstScriptSub("AUDIO_S8",AUDIO_S8); //#define AUDIO_S8	0x8008	
#endif
#ifdef AUDIO_U16LSB
ConstScriptSub("AUDIO_U16LSB",AUDIO_U16LSB); //#define AUDIO_U16LSB	0x0010	
#endif
#ifdef AUDIO_S16LSB
ConstScriptSub("AUDIO_S16LSB",AUDIO_S16LSB); //#define AUDIO_S16LSB	0x8010	
#endif
#ifdef AUDIO_U16MSB
ConstScriptSub("AUDIO_U16MSB",AUDIO_U16MSB); //#define AUDIO_U16MSB	0x1010	
#endif
#ifdef AUDIO_S16MSB
ConstScriptSub("AUDIO_S16MSB",AUDIO_S16MSB); //#define AUDIO_S16MSB	0x9010	
#endif
#ifdef AUDIO_U16LSB
#ifdef AUDIO_U16
ConstScriptSub("AUDIO_U16",AUDIO_U16); //#define AUDIO_U16	AUDIO_U16LSB
#endif
#endif
#ifdef AUDIO_S16LSB
#ifdef AUDIO_S16
ConstScriptSub("AUDIO_S16",AUDIO_S16); //#define AUDIO_S16	AUDIO_S16LSB
#endif
#endif
#ifdef AUDIO_U16LSB
#ifdef AUDIO_U16SYS
ConstScriptSub("AUDIO_U16SYS",AUDIO_U16SYS); //#define AUDIO_U16SYS	AUDIO_U16LSB
#endif
#endif
#ifdef AUDIO_S16LSB
#ifdef AUDIO_S16SYS
ConstScriptSub("AUDIO_S16SYS",AUDIO_S16SYS); //#define AUDIO_S16SYS	AUDIO_S16LSB
#endif
#endif
ConstScriptSub("SDL_AUDIO_STOPPED",SDL_AUDIO_STOPPED); //	SDL_AUDIO_STOPPED = 0,
ConstScriptSub("SDL_AUDIO_PLAYING",SDL_AUDIO_PLAYING); //	SDL_AUDIO_PLAYING,
ConstScriptSub("SDL_AUDIO_PAUSED",SDL_AUDIO_PAUSED); //	SDL_AUDIO_PAUSED
#ifdef SDL_MIX_MAXVOLUME
ConstScriptSub("SDL_MIX_MAXVOLUME",SDL_MIX_MAXVOLUME); //#define SDL_MIX_MAXVOLUME 128
#endif
#ifdef SDL_MAX_TRACKS
ConstScriptSub("SDL_MAX_TRACKS",SDL_MAX_TRACKS); //#define SDL_MAX_TRACKS	99
#endif
#ifdef SDL_AUDIO_TRACK
ConstScriptSub("SDL_AUDIO_TRACK",SDL_AUDIO_TRACK); //#define SDL_AUDIO_TRACK	0x00
#endif
#ifdef SDL_DATA_TRACK
ConstScriptSub("SDL_DATA_TRACK",SDL_DATA_TRACK); //#define SDL_DATA_TRACK	0x04
#endif
ConstScriptSub("CD_TRAYEMPTY",CD_TRAYEMPTY); //	CD_TRAYEMPTY,
ConstScriptSub("CD_STOPPED",CD_STOPPED); //	CD_STOPPED,
ConstScriptSub("CD_PLAYING",CD_PLAYING); //	CD_PLAYING,
ConstScriptSub("CD_PAUSED",CD_PAUSED); //	CD_PAUSED,
ConstScriptSub("CD_ERROR",CD_ERROR); //	CD_ERROR = -1
#ifdef CD_FPS
ConstScriptSub("CD_FPS",CD_FPS); //#define CD_FPS	75
#endif
#ifdef SDL_HAS_64BIT_TYPE
ConstScriptSub("SDL_HAS_64BIT_TYPE",SDL_HAS_64BIT_TYPE); //#define SDL_HAS_64BIT_TYPE	1
#endif
#ifdef HAVE_SYS_TYPES_H
ConstScriptSub("HAVE_SYS_TYPES_H",HAVE_SYS_TYPES_H); //#define HAVE_SYS_TYPES_H	1
#endif
#ifdef HAVE_STDIO_H
ConstScriptSub("HAVE_STDIO_H",HAVE_STDIO_H); //#define HAVE_STDIO_H	1
#endif
#ifdef STDC_HEADERS
ConstScriptSub("STDC_HEADERS",STDC_HEADERS); //#define STDC_HEADERS	1
#endif
#ifdef HAVE_STRING_H
ConstScriptSub("HAVE_STRING_H",HAVE_STRING_H); //#define HAVE_STRING_H	1
#endif
#ifdef HAVE_INTTYPES_H
ConstScriptSub("HAVE_INTTYPES_H",HAVE_INTTYPES_H); //#define HAVE_INTTYPES_H	1
#endif
#ifdef HAVE_SIGNAL_H
ConstScriptSub("HAVE_SIGNAL_H",HAVE_SIGNAL_H); //#define HAVE_SIGNAL_H	1
#endif
#ifdef HAVE_MALLOC
ConstScriptSub("HAVE_MALLOC",HAVE_MALLOC); //#define HAVE_MALLOC	1
#endif
#ifdef HAVE_CALLOC
ConstScriptSub("HAVE_CALLOC",HAVE_CALLOC); //#define HAVE_CALLOC	1
#endif
#ifdef HAVE_REALLOC
ConstScriptSub("HAVE_REALLOC",HAVE_REALLOC); //#define HAVE_REALLOC	1
#endif
#ifdef HAVE_FREE
ConstScriptSub("HAVE_FREE",HAVE_FREE); //#define HAVE_FREE	1
#endif
#ifdef HAVE_ALLOCA
ConstScriptSub("HAVE_ALLOCA",HAVE_ALLOCA); //#define HAVE_ALLOCA	1
#endif
#ifdef HAVE_GETENV
ConstScriptSub("HAVE_GETENV",HAVE_GETENV); //#define HAVE_GETENV	1
#endif
#ifdef HAVE_PUTENV
ConstScriptSub("HAVE_PUTENV",HAVE_PUTENV); //#define HAVE_PUTENV	1
#endif
#ifdef HAVE_MEMSET
ConstScriptSub("HAVE_MEMSET",HAVE_MEMSET); //#define HAVE_MEMSET	1
#endif
#ifdef HAVE_MEMCPY
ConstScriptSub("HAVE_MEMCPY",HAVE_MEMCPY); //#define HAVE_MEMCPY	1
#endif
#ifdef HAVE_MEMMOVE
ConstScriptSub("HAVE_MEMMOVE",HAVE_MEMMOVE); //#define HAVE_MEMMOVE	1
#endif
#ifdef HAVE_MEMCMP
ConstScriptSub("HAVE_MEMCMP",HAVE_MEMCMP); //#define HAVE_MEMCMP	1
#endif
#ifdef SDL_AUDIO_DRIVER_AHI
ConstScriptSub("SDL_AUDIO_DRIVER_AHI",SDL_AUDIO_DRIVER_AHI); //#define SDL_AUDIO_DRIVER_AHI	1
#endif
#ifdef SDL_AUDIO_DRIVER_DISK
ConstScriptSub("SDL_AUDIO_DRIVER_DISK",SDL_AUDIO_DRIVER_DISK); //#define SDL_AUDIO_DRIVER_DISK	1
#endif
#ifdef SDL_AUDIO_DRIVER_DUMMY
ConstScriptSub("SDL_AUDIO_DRIVER_DUMMY",SDL_AUDIO_DRIVER_DUMMY); //#define SDL_AUDIO_DRIVER_DUMMY	1
#endif
#ifdef SDL_CDROM_DUMMY
ConstScriptSub("SDL_CDROM_DUMMY",SDL_CDROM_DUMMY); //#define SDL_CDROM_DUMMY	1
#endif
#ifdef SDL_JOYSTICK_AMIGA
ConstScriptSub("SDL_JOYSTICK_AMIGA",SDL_JOYSTICK_AMIGA); //#define SDL_JOYSTICK_AMIGA	1
#endif
#ifdef SDL_LOADSO_DUMMY
ConstScriptSub("SDL_LOADSO_DUMMY",SDL_LOADSO_DUMMY); //#define SDL_LOADSO_DUMMY	1
#endif
#ifdef SDL_THREAD_AMIGA
ConstScriptSub("SDL_THREAD_AMIGA",SDL_THREAD_AMIGA); //#define SDL_THREAD_AMIGA	1
#endif
#ifdef SDL_TIMER_AMIGA
ConstScriptSub("SDL_TIMER_AMIGA",SDL_TIMER_AMIGA); //#define SDL_TIMER_AMIGA	1
#endif
#ifdef SDL_VIDEO_DRIVER_CYBERGRAPHICS
ConstScriptSub("SDL_VIDEO_DRIVER_CYBERGRAPHICS",SDL_VIDEO_DRIVER_CYBERGRAPHICS); //#define SDL_VIDEO_DRIVER_CYBERGRAPHICS	1
#endif
#ifdef SDL_VIDEO_DRIVER_DUMMY
ConstScriptSub("SDL_VIDEO_DRIVER_DUMMY",SDL_VIDEO_DRIVER_DUMMY); //#define SDL_VIDEO_DRIVER_DUMMY	1
#endif
#ifdef SDL_VIDEO_OPENGL
ConstScriptSub("SDL_VIDEO_OPENGL",SDL_VIDEO_OPENGL); //#define SDL_VIDEO_OPENGL	1
#endif
#ifdef HAVE_CTYPE_H
ConstScriptSub("HAVE_CTYPE_H",HAVE_CTYPE_H); //#define HAVE_CTYPE_H	1
#endif
#ifdef HAVE_QSORT
ConstScriptSub("HAVE_QSORT",HAVE_QSORT); //#define HAVE_QSORT	1
#endif
#ifdef HAVE_ABS
ConstScriptSub("HAVE_ABS",HAVE_ABS); //#define HAVE_ABS	1
#endif
#ifdef HAVE_BCOPY
ConstScriptSub("HAVE_BCOPY",HAVE_BCOPY); //#define HAVE_BCOPY	1
#endif
#ifdef HAVE_STRLEN
ConstScriptSub("HAVE_STRLEN",HAVE_STRLEN); //#define HAVE_STRLEN	1
#endif
#ifdef HAVE_STRDUP
ConstScriptSub("HAVE_STRDUP",HAVE_STRDUP); //#define HAVE_STRDUP	1
#endif
#ifdef HAVE_INDEX
ConstScriptSub("HAVE_INDEX",HAVE_INDEX); //#define HAVE_INDEX	1
#endif
#ifdef HAVE_RINDEX
ConstScriptSub("HAVE_RINDEX",HAVE_RINDEX); //#define HAVE_RINDEX	1
#endif
#ifdef HAVE_STRCHR
ConstScriptSub("HAVE_STRCHR",HAVE_STRCHR); //#define HAVE_STRCHR	1
#endif
#ifdef HAVE_STRRCHR
ConstScriptSub("HAVE_STRRCHR",HAVE_STRRCHR); //#define HAVE_STRRCHR	1
#endif
#ifdef HAVE_STRSTR
ConstScriptSub("HAVE_STRSTR",HAVE_STRSTR); //#define HAVE_STRSTR	1
#endif
#ifdef HAVE_STRTOL
ConstScriptSub("HAVE_STRTOL",HAVE_STRTOL); //#define HAVE_STRTOL	1
#endif
#ifdef HAVE_STRTOD
ConstScriptSub("HAVE_STRTOD",HAVE_STRTOD); //#define HAVE_STRTOD	1
#endif
#ifdef HAVE_ATOI
ConstScriptSub("HAVE_ATOI",HAVE_ATOI); //#define HAVE_ATOI	1
#endif
#ifdef HAVE_ATOF
ConstScriptSub("HAVE_ATOF",HAVE_ATOF); //#define HAVE_ATOF	1
#endif
#ifdef HAVE_STRCMP
ConstScriptSub("HAVE_STRCMP",HAVE_STRCMP); //#define HAVE_STRCMP	1
#endif
#ifdef HAVE_STRNCMP
ConstScriptSub("HAVE_STRNCMP",HAVE_STRNCMP); //#define HAVE_STRNCMP	1
#endif
#ifdef HAVE_STRICMP
ConstScriptSub("HAVE_STRICMP",HAVE_STRICMP); //#define HAVE_STRICMP	1
#endif
#ifdef HAVE_STRCASECMP
ConstScriptSub("HAVE_STRCASECMP",HAVE_STRCASECMP); //#define HAVE_STRCASECMP	1
#endif
#ifdef HAVE_SSCANF
ConstScriptSub("HAVE_SSCANF",HAVE_SSCANF); //#define HAVE_SSCANF	1
#endif
#ifdef HAVE_SNPRINTF
ConstScriptSub("HAVE_SNPRINTF",HAVE_SNPRINTF); //#define HAVE_SNPRINTF	1
#endif
#ifdef HAVE_VSNPRINTF
ConstScriptSub("HAVE_VSNPRINTF",HAVE_VSNPRINTF); //#define HAVE_VSNPRINTF	1
#endif
#ifdef SDL_AUDIO_DRIVER_DC
ConstScriptSub("SDL_AUDIO_DRIVER_DC",SDL_AUDIO_DRIVER_DC); //#define SDL_AUDIO_DRIVER_DC	1
#endif
#ifdef SDL_CDROM_DC
ConstScriptSub("SDL_CDROM_DC",SDL_CDROM_DC); //#define SDL_CDROM_DC	1
#endif
#ifdef SDL_JOYSTICK_DC
ConstScriptSub("SDL_JOYSTICK_DC",SDL_JOYSTICK_DC); //#define SDL_JOYSTICK_DC	1
#endif
#ifdef SDL_THREAD_DC
ConstScriptSub("SDL_THREAD_DC",SDL_THREAD_DC); //#define SDL_THREAD_DC	1
#endif
#ifdef SDL_TIMER_DC
ConstScriptSub("SDL_TIMER_DC",SDL_TIMER_DC); //#define SDL_TIMER_DC	1
#endif
#ifdef SDL_VIDEO_DRIVER_DC
ConstScriptSub("SDL_VIDEO_DRIVER_DC",SDL_VIDEO_DRIVER_DC); //#define SDL_VIDEO_DRIVER_DC	1
#endif
#ifdef HAVE_MATH_H
ConstScriptSub("HAVE_MATH_H",HAVE_MATH_H); //#define HAVE_MATH_H	1
#endif
#ifdef HAVE_ITOA
ConstScriptSub("HAVE_ITOA",HAVE_ITOA); //#define HAVE_ITOA	1
#endif
#ifdef SDL_AUDIO_DRIVER_SNDMGR
ConstScriptSub("SDL_AUDIO_DRIVER_SNDMGR",SDL_AUDIO_DRIVER_SNDMGR); //#define SDL_AUDIO_DRIVER_SNDMGR	1
#endif
#ifdef SDL_JOYSTICK_DUMMY
ConstScriptSub("SDL_JOYSTICK_DUMMY",SDL_JOYSTICK_DUMMY); //#define SDL_JOYSTICK_DUMMY	1
#endif
#ifdef SDL_JOYSTICK_MACOS
ConstScriptSub("SDL_JOYSTICK_MACOS",SDL_JOYSTICK_MACOS); //#define SDL_JOYSTICK_MACOS	1
#endif
#ifdef SDL_LOADSO_MACOS
ConstScriptSub("SDL_LOADSO_MACOS",SDL_LOADSO_MACOS); //#define SDL_LOADSO_MACOS	1
#endif
#ifdef SDL_THREADS_DISABLED
ConstScriptSub("SDL_THREADS_DISABLED",SDL_THREADS_DISABLED); //#define SDL_THREADS_DISABLED	1
#endif
#ifdef SDL_TIMER_MACOS
ConstScriptSub("SDL_TIMER_MACOS",SDL_TIMER_MACOS); //#define SDL_TIMER_MACOS	1
#endif
#ifdef SDL_VIDEO_DRIVER_DRAWSPROCKET
ConstScriptSub("SDL_VIDEO_DRIVER_DRAWSPROCKET",SDL_VIDEO_DRIVER_DRAWSPROCKET); //#define SDL_VIDEO_DRIVER_DRAWSPROCKET	1
#endif
#ifdef SDL_VIDEO_DRIVER_TOOLBOX
ConstScriptSub("SDL_VIDEO_DRIVER_TOOLBOX",SDL_VIDEO_DRIVER_TOOLBOX); //#define SDL_VIDEO_DRIVER_TOOLBOX	1
#endif
#ifdef HAVE_STDINT_H
ConstScriptSub("HAVE_STDINT_H",HAVE_STDINT_H); //#define HAVE_STDINT_H	1
#endif
#ifdef HAVE_UNSETENV
ConstScriptSub("HAVE_UNSETENV",HAVE_UNSETENV); //#define HAVE_UNSETENV	1
#endif
#ifdef HAVE_STRLCPY
ConstScriptSub("HAVE_STRLCPY",HAVE_STRLCPY); //#define HAVE_STRLCPY	1
#endif
#ifdef HAVE_STRLCAT
ConstScriptSub("HAVE_STRLCAT",HAVE_STRLCAT); //#define HAVE_STRLCAT	1
#endif
#ifdef HAVE_STRTOUL
ConstScriptSub("HAVE_STRTOUL",HAVE_STRTOUL); //#define HAVE_STRTOUL	1
#endif
#ifdef HAVE_STRTOLL
ConstScriptSub("HAVE_STRTOLL",HAVE_STRTOLL); //#define HAVE_STRTOLL	1
#endif
#ifdef HAVE_STRTOULL
ConstScriptSub("HAVE_STRTOULL",HAVE_STRTOULL); //#define HAVE_STRTOULL	1
#endif
#ifdef HAVE_STRNCASECMP
ConstScriptSub("HAVE_STRNCASECMP",HAVE_STRNCASECMP); //#define HAVE_STRNCASECMP 1
#endif
#ifdef HAVE_SIGACTION
ConstScriptSub("HAVE_SIGACTION",HAVE_SIGACTION); //#define HAVE_SIGACTION	1
#endif
#ifdef HAVE_SETJMP
ConstScriptSub("HAVE_SETJMP",HAVE_SETJMP); //#define HAVE_SETJMP	1
#endif
#ifdef HAVE_NANOSLEEP
ConstScriptSub("HAVE_NANOSLEEP",HAVE_NANOSLEEP); //#define HAVE_NANOSLEEP	1
#endif
#ifdef SDL_AUDIO_DRIVER_COREAUDIO
ConstScriptSub("SDL_AUDIO_DRIVER_COREAUDIO",SDL_AUDIO_DRIVER_COREAUDIO); //#define SDL_AUDIO_DRIVER_COREAUDIO	1
#endif
#ifdef SDL_CDROM_MACOSX
ConstScriptSub("SDL_CDROM_MACOSX",SDL_CDROM_MACOSX); //#define SDL_CDROM_MACOSX	1
#endif
#ifdef SDL_JOYSTICK_IOKIT
ConstScriptSub("SDL_JOYSTICK_IOKIT",SDL_JOYSTICK_IOKIT); //#define SDL_JOYSTICK_IOKIT	1
#endif
#ifdef SDL_LOADSO_DLCOMPAT
ConstScriptSub("SDL_LOADSO_DLCOMPAT",SDL_LOADSO_DLCOMPAT); //#define SDL_LOADSO_DLCOMPAT	1
#endif
#ifdef SDL_LOADSO_DLOPEN
ConstScriptSub("SDL_LOADSO_DLOPEN",SDL_LOADSO_DLOPEN); //#define SDL_LOADSO_DLOPEN	1
#endif
#ifdef SDL_THREAD_PTHREAD
ConstScriptSub("SDL_THREAD_PTHREAD",SDL_THREAD_PTHREAD); //#define SDL_THREAD_PTHREAD	1
#endif
#ifdef SDL_THREAD_PTHREAD_RECURSIVE_MUTEX
ConstScriptSub("SDL_THREAD_PTHREAD_RECURSIVE_MUTEX",SDL_THREAD_PTHREAD_RECURSIVE_MUTEX); //#define SDL_THREAD_PTHREAD_RECURSIVE_MUTEX	1
#endif
#ifdef SDL_TIMER_UNIX
ConstScriptSub("SDL_TIMER_UNIX",SDL_TIMER_UNIX); //#define SDL_TIMER_UNIX	1
#endif
#ifdef SDL_VIDEO_DRIVER_QUARTZ
ConstScriptSub("SDL_VIDEO_DRIVER_QUARTZ",SDL_VIDEO_DRIVER_QUARTZ); //#define SDL_VIDEO_DRIVER_QUARTZ	1
#endif
#ifdef SDL_ASSEMBLY_ROUTINES
ConstScriptSub("SDL_ASSEMBLY_ROUTINES",SDL_ASSEMBLY_ROUTINES); //#define SDL_ASSEMBLY_ROUTINES	1
#endif
#ifdef SDL_ALTIVEC_BLITTERS
ConstScriptSub("SDL_ALTIVEC_BLITTERS",SDL_ALTIVEC_BLITTERS); //#define SDL_ALTIVEC_BLITTERS	1
#endif
#ifdef SDL_CDROM_DISABLED
ConstScriptSub("SDL_CDROM_DISABLED",SDL_CDROM_DISABLED); //#define SDL_CDROM_DISABLED	1
#endif
#ifdef SDL_JOYSTICK_DISABLED
ConstScriptSub("SDL_JOYSTICK_DISABLED",SDL_JOYSTICK_DISABLED); //#define SDL_JOYSTICK_DISABLED	1
#endif
#ifdef SDL_LOADSO_DISABLED
ConstScriptSub("SDL_LOADSO_DISABLED",SDL_LOADSO_DISABLED); //#define SDL_LOADSO_DISABLED	1
#endif
#ifdef SDL_TIMERS_DISABLED
ConstScriptSub("SDL_TIMERS_DISABLED",SDL_TIMERS_DISABLED); //#define SDL_TIMERS_DISABLED	1
#endif
#ifdef SDL_BYTEORDER
ConstScriptSub("SDL_BYTEORDER",SDL_BYTEORDER); //#define SDL_BYTEORDER 1234
#endif
#ifdef HAVE_ALLOCA_H
ConstScriptSub("HAVE_ALLOCA_H",HAVE_ALLOCA_H); //#define HAVE_ALLOCA_H 1
#endif
#ifdef HAVE_STDLIB_H
ConstScriptSub("HAVE_STDLIB_H",HAVE_STDLIB_H); //#define HAVE_STDLIB_H 1
#endif
#ifdef HAVE_STDARG_H
ConstScriptSub("HAVE_STDARG_H",HAVE_STDARG_H); //#define HAVE_STDARG_H 1
#endif
#ifdef HAVE_MALLOC_H
ConstScriptSub("HAVE_MALLOC_H",HAVE_MALLOC_H); //#define HAVE_MALLOC_H 1
#endif
#ifdef HAVE_ICONV_H
ConstScriptSub("HAVE_ICONV_H",HAVE_ICONV_H); //#define HAVE_ICONV_H 1
#endif
#ifdef SDL_AUDIO_DRIVER_NDS
ConstScriptSub("SDL_AUDIO_DRIVER_NDS",SDL_AUDIO_DRIVER_NDS); //#define SDL_AUDIO_DRIVER_NDS	1
#endif
#ifdef SDL_JOYSTICK_NDS
ConstScriptSub("SDL_JOYSTICK_NDS",SDL_JOYSTICK_NDS); //#define SDL_JOYSTICK_NDS	1
#endif
#ifdef SDL_TIMER_NDS
ConstScriptSub("SDL_TIMER_NDS",SDL_TIMER_NDS); //#define SDL_TIMER_NDS	1
#endif
#ifdef SDL_VIDEO_DRIVER_NDS
ConstScriptSub("SDL_VIDEO_DRIVER_NDS",SDL_VIDEO_DRIVER_NDS); //#define SDL_VIDEO_DRIVER_NDS	1
#endif
#ifdef HAVE_LIBC
ConstScriptSub("HAVE_LIBC",HAVE_LIBC); //#define HAVE_LIBC 1
#endif
#ifdef HAVE_MEMORY_H
ConstScriptSub("HAVE_MEMORY_H",HAVE_MEMORY_H); //#define HAVE_MEMORY_H 1
#endif
#ifdef HAVE_STRINGS_H
ConstScriptSub("HAVE_STRINGS_H",HAVE_STRINGS_H); //#define HAVE_STRINGS_H 1
#endif
#ifdef HAVE__STRREV
ConstScriptSub("HAVE__STRREV",HAVE__STRREV); //#define HAVE__STRREV 1
#endif
#ifdef HAVE__STRUPR
ConstScriptSub("HAVE__STRUPR",HAVE__STRUPR); //#define HAVE__STRUPR 1
#endif
#ifdef HAVE__STRLWR
ConstScriptSub("HAVE__STRLWR",HAVE__STRLWR); //#define HAVE__STRLWR 1
#endif
#ifdef HAVE__LTOA
ConstScriptSub("HAVE__LTOA",HAVE__LTOA); //#define HAVE__LTOA 1
#endif
#ifdef HAVE__UITOA
ConstScriptSub("HAVE__UITOA",HAVE__UITOA); //#define HAVE__UITOA 1
#endif
#ifdef HAVE__ULTOA
ConstScriptSub("HAVE__ULTOA",HAVE__ULTOA); //#define HAVE__ULTOA 1
#endif
#ifdef HAVE__I64TOA
ConstScriptSub("HAVE__I64TOA",HAVE__I64TOA); //#define HAVE__I64TOA 1
#endif
#ifdef HAVE__UI64TOA
ConstScriptSub("HAVE__UI64TOA",HAVE__UI64TOA); //#define HAVE__UI64TOA 1
#endif
#ifdef HAVE_CLOCK_GETTIME
ConstScriptSub("HAVE_CLOCK_GETTIME",HAVE_CLOCK_GETTIME); //#define HAVE_CLOCK_GETTIME 1
#endif
#ifdef SDL_AUDIO_DRIVER_DART
ConstScriptSub("SDL_AUDIO_DRIVER_DART",SDL_AUDIO_DRIVER_DART); //#define SDL_AUDIO_DRIVER_DART	1
#endif
#ifdef SDL_CDROM_OS2
ConstScriptSub("SDL_CDROM_OS2",SDL_CDROM_OS2); //#define SDL_CDROM_OS2	1
#endif
#ifdef SDL_JOYSTICK_OS2
ConstScriptSub("SDL_JOYSTICK_OS2",SDL_JOYSTICK_OS2); //#define SDL_JOYSTICK_OS2	1
#endif
#ifdef SDL_LOADSO_OS2
ConstScriptSub("SDL_LOADSO_OS2",SDL_LOADSO_OS2); //#define SDL_LOADSO_OS2	1
#endif
#ifdef SDL_THREAD_OS2
ConstScriptSub("SDL_THREAD_OS2",SDL_THREAD_OS2); //#define SDL_THREAD_OS2	1
#endif
#ifdef SDL_TIMER_OS2
ConstScriptSub("SDL_TIMER_OS2",SDL_TIMER_OS2); //#define SDL_TIMER_OS2	1
#endif
#ifdef SDL_VIDEO_DRIVER_OS2FS
ConstScriptSub("SDL_VIDEO_DRIVER_OS2FS",SDL_VIDEO_DRIVER_OS2FS); //#define SDL_VIDEO_DRIVER_OS2FS	1
#endif
#ifdef SDL_AUDIO_DRIVER_EPOCAUDIO
ConstScriptSub("SDL_AUDIO_DRIVER_EPOCAUDIO",SDL_AUDIO_DRIVER_EPOCAUDIO); //#define SDL_AUDIO_DRIVER_EPOCAUDIO	1
#endif
#ifdef SDL_THREAD_SYMBIAN
ConstScriptSub("SDL_THREAD_SYMBIAN",SDL_THREAD_SYMBIAN); //#define SDL_THREAD_SYMBIAN 1
#endif
#ifdef HAVE__STRNICMP
ConstScriptSub("HAVE__STRNICMP",HAVE__STRNICMP); //#define HAVE__STRNICMP 1
#endif
#ifdef HAVE_STDDEF_H
ConstScriptSub("HAVE_STDDEF_H",HAVE_STDDEF_H); //#define HAVE_STDDEF_H	1
#endif
#ifdef DWORD
#ifdef DWORD_PTR
ConstScriptSub("DWORD_PTR",DWORD_PTR); //#define DWORD_PTR DWORD
#endif
#endif
#ifdef LONG
#ifdef LONG_PTR
ConstScriptSub("LONG_PTR",LONG_PTR); //#define LONG_PTR LONG
#endif
#endif
#ifdef HAVE__STRICMP
ConstScriptSub("HAVE__STRICMP",HAVE__STRICMP); //#define HAVE__STRICMP 1
#endif
#ifdef SDL_AUDIO_DRIVER_DSOUND
ConstScriptSub("SDL_AUDIO_DRIVER_DSOUND",SDL_AUDIO_DRIVER_DSOUND); //#define SDL_AUDIO_DRIVER_DSOUND	1
#endif
#ifdef SDL_AUDIO_DRIVER_WAVEOUT
ConstScriptSub("SDL_AUDIO_DRIVER_WAVEOUT",SDL_AUDIO_DRIVER_WAVEOUT); //#define SDL_AUDIO_DRIVER_WAVEOUT	1
#endif
#ifdef SDL_JOYSTICK_WINMM
ConstScriptSub("SDL_JOYSTICK_WINMM",SDL_JOYSTICK_WINMM); //#define SDL_JOYSTICK_WINMM	1
#endif
#ifdef SDL_LOADSO_WIN32
ConstScriptSub("SDL_LOADSO_WIN32",SDL_LOADSO_WIN32); //#define SDL_LOADSO_WIN32	1
#endif
#ifdef SDL_THREAD_WIN32
ConstScriptSub("SDL_THREAD_WIN32",SDL_THREAD_WIN32); //#define SDL_THREAD_WIN32	1
#endif
#ifdef SDL_TIMER_WINCE
ConstScriptSub("SDL_TIMER_WINCE",SDL_TIMER_WINCE); //#define SDL_TIMER_WINCE	1
#endif
#ifdef SDL_TIMER_WIN32
ConstScriptSub("SDL_TIMER_WIN32",SDL_TIMER_WIN32); //#define SDL_TIMER_WIN32	1
#endif
#ifdef SDL_VIDEO_DRIVER_GAPI
ConstScriptSub("SDL_VIDEO_DRIVER_GAPI",SDL_VIDEO_DRIVER_GAPI); //#define SDL_VIDEO_DRIVER_GAPI	1
#endif
#ifdef SDL_VIDEO_DRIVER_DDRAW
ConstScriptSub("SDL_VIDEO_DRIVER_DDRAW",SDL_VIDEO_DRIVER_DDRAW); //#define SDL_VIDEO_DRIVER_DDRAW	1
#endif
#ifdef SDL_VIDEO_DRIVER_WINDIB
ConstScriptSub("SDL_VIDEO_DRIVER_WINDIB",SDL_VIDEO_DRIVER_WINDIB); //#define SDL_VIDEO_DRIVER_WINDIB	1
#endif
#ifdef SDL_VIDEO_OPENGL_WGL
ConstScriptSub("SDL_VIDEO_OPENGL_WGL",SDL_VIDEO_OPENGL_WGL); //#define SDL_VIDEO_OPENGL_WGL	1
#endif
#ifdef SDL_LIL_ENDIAN
ConstScriptSub("SDL_LIL_ENDIAN",SDL_LIL_ENDIAN); //#define SDL_LIL_ENDIAN	1234
#endif
#ifdef SDL_BIG_ENDIAN
ConstScriptSub("SDL_BIG_ENDIAN",SDL_BIG_ENDIAN); //#define SDL_BIG_ENDIAN	4321
#endif
ConstScriptSub("SDL_ENOMEM",SDL_ENOMEM); //	SDL_ENOMEM,
ConstScriptSub("SDL_EFREAD",SDL_EFREAD); //	SDL_EFREAD,
ConstScriptSub("SDL_EFWRITE",SDL_EFWRITE); //	SDL_EFWRITE,
ConstScriptSub("SDL_EFSEEK",SDL_EFSEEK); //	SDL_EFSEEK,
ConstScriptSub("SDL_UNSUPPORTED",SDL_UNSUPPORTED); //	SDL_UNSUPPORTED,
ConstScriptSub("SDL_LASTERROR",SDL_LASTERROR); //	SDL_LASTERROR
#ifdef SDL_RELEASED
ConstScriptSub("SDL_RELEASED",SDL_RELEASED); //#define SDL_RELEASED	0
#endif
#ifdef SDL_PRESSED
ConstScriptSub("SDL_PRESSED",SDL_PRESSED); //#define SDL_PRESSED	1
#endif
ConstScriptSub("SDL_NOEVENT",SDL_NOEVENT); //       SDL_NOEVENT = 0,			
ConstScriptSub("SDL_ACTIVEEVENT",SDL_ACTIVEEVENT); //       SDL_ACTIVEEVENT,			
ConstScriptSub("SDL_KEYDOWN",SDL_KEYDOWN); //       SDL_KEYDOWN,			
ConstScriptSub("SDL_KEYUP",SDL_KEYUP); //       SDL_KEYUP,			
ConstScriptSub("SDL_MOUSEMOTION",SDL_MOUSEMOTION); //       SDL_MOUSEMOTION,			
ConstScriptSub("SDL_MOUSEBUTTONDOWN",SDL_MOUSEBUTTONDOWN); //       SDL_MOUSEBUTTONDOWN,		
ConstScriptSub("SDL_MOUSEBUTTONUP",SDL_MOUSEBUTTONUP); //       SDL_MOUSEBUTTONUP,		
ConstScriptSub("SDL_JOYAXISMOTION",SDL_JOYAXISMOTION); //       SDL_JOYAXISMOTION,		
ConstScriptSub("SDL_JOYBALLMOTION",SDL_JOYBALLMOTION); //       SDL_JOYBALLMOTION,		
ConstScriptSub("SDL_JOYHATMOTION",SDL_JOYHATMOTION); //       SDL_JOYHATMOTION,		
ConstScriptSub("SDL_JOYBUTTONDOWN",SDL_JOYBUTTONDOWN); //       SDL_JOYBUTTONDOWN,		
ConstScriptSub("SDL_JOYBUTTONUP",SDL_JOYBUTTONUP); //       SDL_JOYBUTTONUP,			
ConstScriptSub("SDL_QUIT",SDL_QUIT); //       SDL_QUIT,			
ConstScriptSub("SDL_SYSWMEVENT",SDL_SYSWMEVENT); //       SDL_SYSWMEVENT,			
ConstScriptSub("SDL_EVENT_RESERVEDA",SDL_EVENT_RESERVEDA); //       SDL_EVENT_RESERVEDA,		
ConstScriptSub("SDL_EVENT_RESERVEDB",SDL_EVENT_RESERVEDB); //       SDL_EVENT_RESERVEDB,		
ConstScriptSub("SDL_VIDEORESIZE",SDL_VIDEORESIZE); //       SDL_VIDEORESIZE,			
ConstScriptSub("SDL_VIDEOEXPOSE",SDL_VIDEOEXPOSE); //       SDL_VIDEOEXPOSE,			
ConstScriptSub("SDL_EVENT_RESERVED2",SDL_EVENT_RESERVED2); //       SDL_EVENT_RESERVED2,		
ConstScriptSub("SDL_EVENT_RESERVED3",SDL_EVENT_RESERVED3); //       SDL_EVENT_RESERVED3,		
ConstScriptSub("SDL_EVENT_RESERVED4",SDL_EVENT_RESERVED4); //       SDL_EVENT_RESERVED4,		
ConstScriptSub("SDL_EVENT_RESERVED5",SDL_EVENT_RESERVED5); //       SDL_EVENT_RESERVED5,		
ConstScriptSub("SDL_EVENT_RESERVED6",SDL_EVENT_RESERVED6); //       SDL_EVENT_RESERVED6,		
ConstScriptSub("SDL_EVENT_RESERVED7",SDL_EVENT_RESERVED7); //       SDL_EVENT_RESERVED7,		
//        
ConstScriptSub("SDL_USEREVENT",SDL_USEREVENT); //       SDL_USEREVENT = 24,
//        
ConstScriptSub("SDL_NUMEVENTS",SDL_NUMEVENTS); //       SDL_NUMEVENTS = 32
ConstScriptSub("SDL_ACTIVEEVENTMASK",SDL_ACTIVEEVENTMASK); //	SDL_ACTIVEEVENTMASK	= SDL_EVENTMASK(SDL_ACTIVEEVENT),
ConstScriptSub("SDL_KEYDOWNMASK",SDL_KEYDOWNMASK); //	SDL_KEYDOWNMASK		= SDL_EVENTMASK(SDL_KEYDOWN),
ConstScriptSub("SDL_KEYUPMASK",SDL_KEYUPMASK); //	SDL_KEYUPMASK		= SDL_EVENTMASK(SDL_KEYUP),
ConstScriptSub("SDL_KEYEVENTMASK",SDL_KEYEVENTMASK); //	SDL_KEYEVENTMASK	= SDL_EVENTMASK(SDL_KEYDOWN)|
//ConstScriptSub("SDL_EVENTMASK",SDL_EVENTMASK); //	                          SDL_EVENTMASK(SDL_KEYUP),
ConstScriptSub("SDL_MOUSEMOTIONMASK",SDL_MOUSEMOTIONMASK); //	SDL_MOUSEMOTIONMASK	= SDL_EVENTMASK(SDL_MOUSEMOTION),
ConstScriptSub("SDL_MOUSEBUTTONDOWNMASK",SDL_MOUSEBUTTONDOWNMASK); //	SDL_MOUSEBUTTONDOWNMASK	= SDL_EVENTMASK(SDL_MOUSEBUTTONDOWN),
ConstScriptSub("SDL_MOUSEBUTTONUPMASK",SDL_MOUSEBUTTONUPMASK); //	SDL_MOUSEBUTTONUPMASK	= SDL_EVENTMASK(SDL_MOUSEBUTTONUP),
ConstScriptSub("SDL_MOUSEEVENTMASK",SDL_MOUSEEVENTMASK); //	SDL_MOUSEEVENTMASK	= SDL_EVENTMASK(SDL_MOUSEMOTION)|
ConstScriptSub("SDL_JOYAXISMOTIONMASK",SDL_JOYAXISMOTIONMASK); //	SDL_JOYAXISMOTIONMASK	= SDL_EVENTMASK(SDL_JOYAXISMOTION),
ConstScriptSub("SDL_JOYBALLMOTIONMASK",SDL_JOYBALLMOTIONMASK); //	SDL_JOYBALLMOTIONMASK	= SDL_EVENTMASK(SDL_JOYBALLMOTION),
ConstScriptSub("SDL_JOYHATMOTIONMASK",SDL_JOYHATMOTIONMASK); //	SDL_JOYHATMOTIONMASK	= SDL_EVENTMASK(SDL_JOYHATMOTION),
ConstScriptSub("SDL_JOYBUTTONDOWNMASK",SDL_JOYBUTTONDOWNMASK); //	SDL_JOYBUTTONDOWNMASK	= SDL_EVENTMASK(SDL_JOYBUTTONDOWN),
ConstScriptSub("SDL_JOYBUTTONUPMASK",SDL_JOYBUTTONUPMASK); //	SDL_JOYBUTTONUPMASK	= SDL_EVENTMASK(SDL_JOYBUTTONUP),
ConstScriptSub("SDL_JOYEVENTMASK",SDL_JOYEVENTMASK); //	SDL_JOYEVENTMASK	= SDL_EVENTMASK(SDL_JOYAXISMOTION)|
ConstScriptSub("SDL_VIDEORESIZEMASK",SDL_VIDEORESIZEMASK); //	SDL_VIDEORESIZEMASK	= SDL_EVENTMASK(SDL_VIDEORESIZE),
ConstScriptSub("SDL_VIDEOEXPOSEMASK",SDL_VIDEOEXPOSEMASK); //	SDL_VIDEOEXPOSEMASK	= SDL_EVENTMASK(SDL_VIDEOEXPOSE),
ConstScriptSub("SDL_QUITMASK",SDL_QUITMASK); //	SDL_QUITMASK		= SDL_EVENTMASK(SDL_QUIT),
ConstScriptSub("SDL_SYSWMEVENTMASK",SDL_SYSWMEVENTMASK); //	SDL_SYSWMEVENTMASK	= SDL_EVENTMASK(SDL_SYSWMEVENT)
ConstScriptSub("SDL_ADDEVENT",SDL_ADDEVENT); //	SDL_ADDEVENT,
ConstScriptSub("SDL_PEEKEVENT",SDL_PEEKEVENT); //	SDL_PEEKEVENT,
ConstScriptSub("SDL_GETEVENT",SDL_GETEVENT); //	SDL_GETEVENT
// #define SDL_QUERY	-1
#ifdef SDL_HAT_CENTERED
ConstScriptSub("SDL_HAT_CENTERED",SDL_HAT_CENTERED); //#define SDL_HAT_CENTERED	0x00
#endif
#ifdef SDL_DEFAULT_REPEAT_DELAY
ConstScriptSub("SDL_DEFAULT_REPEAT_DELAY",SDL_DEFAULT_REPEAT_DELAY); //#define SDL_DEFAULT_REPEAT_DELAY	500
#endif
#ifdef SDL_DEFAULT_REPEAT_INTERVAL
ConstScriptSub("SDL_DEFAULT_REPEAT_INTERVAL",SDL_DEFAULT_REPEAT_INTERVAL); //#define SDL_DEFAULT_REPEAT_INTERVAL	30
#endif
// 	
ConstScriptSub("SDLK_UNKNOWN",SDLK_UNKNOWN); //	SDLK_UNKNOWN		= 0,
ConstScriptSub("SDLK_FIRST",SDLK_FIRST); //	SDLK_FIRST		= 0,
ConstScriptSub("SDLK_BACKSPACE",SDLK_BACKSPACE); //	SDLK_BACKSPACE		= 8,
ConstScriptSub("SDLK_TAB",SDLK_TAB); //	SDLK_TAB		= 9,
ConstScriptSub("SDLK_CLEAR",SDLK_CLEAR); //	SDLK_CLEAR		= 12,
ConstScriptSub("SDLK_RETURN",SDLK_RETURN); //	SDLK_RETURN		= 13,
ConstScriptSub("SDLK_PAUSE",SDLK_PAUSE); //	SDLK_PAUSE		= 19,
ConstScriptSub("SDLK_ESCAPE",SDLK_ESCAPE); //	SDLK_ESCAPE		= 27,
ConstScriptSub("SDLK_SPACE",SDLK_SPACE); //	SDLK_SPACE		= 32,
ConstScriptSub("SDLK_EXCLAIM",SDLK_EXCLAIM); //	SDLK_EXCLAIM		= 33,
ConstScriptSub("SDLK_QUOTEDBL",SDLK_QUOTEDBL); //	SDLK_QUOTEDBL		= 34,
ConstScriptSub("SDLK_HASH",SDLK_HASH); //	SDLK_HASH		= 35,
ConstScriptSub("SDLK_DOLLAR",SDLK_DOLLAR); //	SDLK_DOLLAR		= 36,
ConstScriptSub("SDLK_AMPERSAND",SDLK_AMPERSAND); //	SDLK_AMPERSAND		= 38,
ConstScriptSub("SDLK_QUOTE",SDLK_QUOTE); //	SDLK_QUOTE		= 39,
ConstScriptSub("SDLK_LEFTPAREN",SDLK_LEFTPAREN); //	SDLK_LEFTPAREN		= 40,
ConstScriptSub("SDLK_RIGHTPAREN",SDLK_RIGHTPAREN); //	SDLK_RIGHTPAREN		= 41,
ConstScriptSub("SDLK_ASTERISK",SDLK_ASTERISK); //	SDLK_ASTERISK		= 42,
ConstScriptSub("SDLK_PLUS",SDLK_PLUS); //	SDLK_PLUS		= 43,
ConstScriptSub("SDLK_COMMA",SDLK_COMMA); //	SDLK_COMMA		= 44,
ConstScriptSub("SDLK_MINUS",SDLK_MINUS); //	SDLK_MINUS		= 45,
ConstScriptSub("SDLK_PERIOD",SDLK_PERIOD); //	SDLK_PERIOD		= 46,
ConstScriptSub("SDLK_SLASH",SDLK_SLASH); //	SDLK_SLASH		= 47,
ConstScriptSub("SDLK_0",SDLK_0); //	SDLK_0			= 48,
ConstScriptSub("SDLK_1",SDLK_1); //	SDLK_1			= 49,
ConstScriptSub("SDLK_2",SDLK_2); //	SDLK_2			= 50,
ConstScriptSub("SDLK_3",SDLK_3); //	SDLK_3			= 51,
ConstScriptSub("SDLK_4",SDLK_4); //	SDLK_4			= 52,
ConstScriptSub("SDLK_5",SDLK_5); //	SDLK_5			= 53,
ConstScriptSub("SDLK_6",SDLK_6); //	SDLK_6			= 54,
ConstScriptSub("SDLK_7",SDLK_7); //	SDLK_7			= 55,
ConstScriptSub("SDLK_8",SDLK_8); //	SDLK_8			= 56,
ConstScriptSub("SDLK_9",SDLK_9); //	SDLK_9			= 57,
ConstScriptSub("SDLK_COLON",SDLK_COLON); //	SDLK_COLON		= 58,
ConstScriptSub("SDLK_SEMICOLON",SDLK_SEMICOLON); //	SDLK_SEMICOLON		= 59,
ConstScriptSub("SDLK_LESS",SDLK_LESS); //	SDLK_LESS		= 60,
ConstScriptSub("SDLK_EQUALS",SDLK_EQUALS); //	SDLK_EQUALS		= 61,
ConstScriptSub("SDLK_GREATER",SDLK_GREATER); //	SDLK_GREATER		= 62,
ConstScriptSub("SDLK_QUESTION",SDLK_QUESTION); //	SDLK_QUESTION		= 63,
ConstScriptSub("SDLK_AT",SDLK_AT); //	SDLK_AT			= 64,
// 	
ConstScriptSub("SDLK_LEFTBRACKET",SDLK_LEFTBRACKET); //	SDLK_LEFTBRACKET	= 91,
ConstScriptSub("SDLK_BACKSLASH",SDLK_BACKSLASH); //	SDLK_BACKSLASH		= 92,
ConstScriptSub("SDLK_RIGHTBRACKET",SDLK_RIGHTBRACKET); //	SDLK_RIGHTBRACKET	= 93,
ConstScriptSub("SDLK_CARET",SDLK_CARET); //	SDLK_CARET		= 94,
ConstScriptSub("SDLK_UNDERSCORE",SDLK_UNDERSCORE); //	SDLK_UNDERSCORE		= 95,
ConstScriptSub("SDLK_BACKQUOTE",SDLK_BACKQUOTE); //	SDLK_BACKQUOTE		= 96,
ConstScriptSub("SDLK_a",SDLK_a); //	SDLK_a			= 97,
ConstScriptSub("SDLK_b",SDLK_b); //	SDLK_b			= 98,
ConstScriptSub("SDLK_c",SDLK_c); //	SDLK_c			= 99,
ConstScriptSub("SDLK_d",SDLK_d); //	SDLK_d			= 100,
ConstScriptSub("SDLK_e",SDLK_e); //	SDLK_e			= 101,
ConstScriptSub("SDLK_f",SDLK_f); //	SDLK_f			= 102,
ConstScriptSub("SDLK_g",SDLK_g); //	SDLK_g			= 103,
ConstScriptSub("SDLK_h",SDLK_h); //	SDLK_h			= 104,
ConstScriptSub("SDLK_i",SDLK_i); //	SDLK_i			= 105,
ConstScriptSub("SDLK_j",SDLK_j); //	SDLK_j			= 106,
ConstScriptSub("SDLK_k",SDLK_k); //	SDLK_k			= 107,
ConstScriptSub("SDLK_l",SDLK_l); //	SDLK_l			= 108,
ConstScriptSub("SDLK_m",SDLK_m); //	SDLK_m			= 109,
ConstScriptSub("SDLK_n",SDLK_n); //	SDLK_n			= 110,
ConstScriptSub("SDLK_o",SDLK_o); //	SDLK_o			= 111,
ConstScriptSub("SDLK_p",SDLK_p); //	SDLK_p			= 112,
ConstScriptSub("SDLK_q",SDLK_q); //	SDLK_q			= 113,
ConstScriptSub("SDLK_r",SDLK_r); //	SDLK_r			= 114,
ConstScriptSub("SDLK_s",SDLK_s); //	SDLK_s			= 115,
ConstScriptSub("SDLK_t",SDLK_t); //	SDLK_t			= 116,
ConstScriptSub("SDLK_u",SDLK_u); //	SDLK_u			= 117,
ConstScriptSub("SDLK_v",SDLK_v); //	SDLK_v			= 118,
ConstScriptSub("SDLK_w",SDLK_w); //	SDLK_w			= 119,
ConstScriptSub("SDLK_x",SDLK_x); //	SDLK_x			= 120,
ConstScriptSub("SDLK_y",SDLK_y); //	SDLK_y			= 121,
ConstScriptSub("SDLK_z",SDLK_z); //	SDLK_z			= 122,
ConstScriptSub("SDLK_DELETE",SDLK_DELETE); //	SDLK_DELETE		= 127,
// 	
// 	
ConstScriptSub("SDLK_WORLD_0",SDLK_WORLD_0); //	SDLK_WORLD_0		= 160,		
ConstScriptSub("SDLK_WORLD_1",SDLK_WORLD_1); //	SDLK_WORLD_1		= 161,
ConstScriptSub("SDLK_WORLD_2",SDLK_WORLD_2); //	SDLK_WORLD_2		= 162,
ConstScriptSub("SDLK_WORLD_3",SDLK_WORLD_3); //	SDLK_WORLD_3		= 163,
ConstScriptSub("SDLK_WORLD_4",SDLK_WORLD_4); //	SDLK_WORLD_4		= 164,
ConstScriptSub("SDLK_WORLD_5",SDLK_WORLD_5); //	SDLK_WORLD_5		= 165,
ConstScriptSub("SDLK_WORLD_6",SDLK_WORLD_6); //	SDLK_WORLD_6		= 166,
ConstScriptSub("SDLK_WORLD_7",SDLK_WORLD_7); //	SDLK_WORLD_7		= 167,
ConstScriptSub("SDLK_WORLD_8",SDLK_WORLD_8); //	SDLK_WORLD_8		= 168,
ConstScriptSub("SDLK_WORLD_9",SDLK_WORLD_9); //	SDLK_WORLD_9		= 169,
ConstScriptSub("SDLK_WORLD_10",SDLK_WORLD_10); //	SDLK_WORLD_10		= 170,
ConstScriptSub("SDLK_WORLD_11",SDLK_WORLD_11); //	SDLK_WORLD_11		= 171,
ConstScriptSub("SDLK_WORLD_12",SDLK_WORLD_12); //	SDLK_WORLD_12		= 172,
ConstScriptSub("SDLK_WORLD_13",SDLK_WORLD_13); //	SDLK_WORLD_13		= 173,
ConstScriptSub("SDLK_WORLD_14",SDLK_WORLD_14); //	SDLK_WORLD_14		= 174,
ConstScriptSub("SDLK_WORLD_15",SDLK_WORLD_15); //	SDLK_WORLD_15		= 175,
ConstScriptSub("SDLK_WORLD_16",SDLK_WORLD_16); //	SDLK_WORLD_16		= 176,
ConstScriptSub("SDLK_WORLD_17",SDLK_WORLD_17); //	SDLK_WORLD_17		= 177,
ConstScriptSub("SDLK_WORLD_18",SDLK_WORLD_18); //	SDLK_WORLD_18		= 178,
ConstScriptSub("SDLK_WORLD_19",SDLK_WORLD_19); //	SDLK_WORLD_19		= 179,
ConstScriptSub("SDLK_WORLD_20",SDLK_WORLD_20); //	SDLK_WORLD_20		= 180,
ConstScriptSub("SDLK_WORLD_21",SDLK_WORLD_21); //	SDLK_WORLD_21		= 181,
ConstScriptSub("SDLK_WORLD_22",SDLK_WORLD_22); //	SDLK_WORLD_22		= 182,
ConstScriptSub("SDLK_WORLD_23",SDLK_WORLD_23); //	SDLK_WORLD_23		= 183,
ConstScriptSub("SDLK_WORLD_24",SDLK_WORLD_24); //	SDLK_WORLD_24		= 184,
ConstScriptSub("SDLK_WORLD_25",SDLK_WORLD_25); //	SDLK_WORLD_25		= 185,
ConstScriptSub("SDLK_WORLD_26",SDLK_WORLD_26); //	SDLK_WORLD_26		= 186,
ConstScriptSub("SDLK_WORLD_27",SDLK_WORLD_27); //	SDLK_WORLD_27		= 187,
ConstScriptSub("SDLK_WORLD_28",SDLK_WORLD_28); //	SDLK_WORLD_28		= 188,
ConstScriptSub("SDLK_WORLD_29",SDLK_WORLD_29); //	SDLK_WORLD_29		= 189,
ConstScriptSub("SDLK_WORLD_30",SDLK_WORLD_30); //	SDLK_WORLD_30		= 190,
ConstScriptSub("SDLK_WORLD_31",SDLK_WORLD_31); //	SDLK_WORLD_31		= 191,
ConstScriptSub("SDLK_WORLD_32",SDLK_WORLD_32); //	SDLK_WORLD_32		= 192,
ConstScriptSub("SDLK_WORLD_33",SDLK_WORLD_33); //	SDLK_WORLD_33		= 193,
ConstScriptSub("SDLK_WORLD_34",SDLK_WORLD_34); //	SDLK_WORLD_34		= 194,
ConstScriptSub("SDLK_WORLD_35",SDLK_WORLD_35); //	SDLK_WORLD_35		= 195,
ConstScriptSub("SDLK_WORLD_36",SDLK_WORLD_36); //	SDLK_WORLD_36		= 196,
ConstScriptSub("SDLK_WORLD_37",SDLK_WORLD_37); //	SDLK_WORLD_37		= 197,
ConstScriptSub("SDLK_WORLD_38",SDLK_WORLD_38); //	SDLK_WORLD_38		= 198,
ConstScriptSub("SDLK_WORLD_39",SDLK_WORLD_39); //	SDLK_WORLD_39		= 199,
ConstScriptSub("SDLK_WORLD_40",SDLK_WORLD_40); //	SDLK_WORLD_40		= 200,
ConstScriptSub("SDLK_WORLD_41",SDLK_WORLD_41); //	SDLK_WORLD_41		= 201,
ConstScriptSub("SDLK_WORLD_42",SDLK_WORLD_42); //	SDLK_WORLD_42		= 202,
ConstScriptSub("SDLK_WORLD_43",SDLK_WORLD_43); //	SDLK_WORLD_43		= 203,
ConstScriptSub("SDLK_WORLD_44",SDLK_WORLD_44); //	SDLK_WORLD_44		= 204,
ConstScriptSub("SDLK_WORLD_45",SDLK_WORLD_45); //	SDLK_WORLD_45		= 205,
ConstScriptSub("SDLK_WORLD_46",SDLK_WORLD_46); //	SDLK_WORLD_46		= 206,
ConstScriptSub("SDLK_WORLD_47",SDLK_WORLD_47); //	SDLK_WORLD_47		= 207,
ConstScriptSub("SDLK_WORLD_48",SDLK_WORLD_48); //	SDLK_WORLD_48		= 208,
ConstScriptSub("SDLK_WORLD_49",SDLK_WORLD_49); //	SDLK_WORLD_49		= 209,
ConstScriptSub("SDLK_WORLD_50",SDLK_WORLD_50); //	SDLK_WORLD_50		= 210,
ConstScriptSub("SDLK_WORLD_51",SDLK_WORLD_51); //	SDLK_WORLD_51		= 211,
ConstScriptSub("SDLK_WORLD_52",SDLK_WORLD_52); //	SDLK_WORLD_52		= 212,
ConstScriptSub("SDLK_WORLD_53",SDLK_WORLD_53); //	SDLK_WORLD_53		= 213,
ConstScriptSub("SDLK_WORLD_54",SDLK_WORLD_54); //	SDLK_WORLD_54		= 214,
ConstScriptSub("SDLK_WORLD_55",SDLK_WORLD_55); //	SDLK_WORLD_55		= 215,
ConstScriptSub("SDLK_WORLD_56",SDLK_WORLD_56); //	SDLK_WORLD_56		= 216,
ConstScriptSub("SDLK_WORLD_57",SDLK_WORLD_57); //	SDLK_WORLD_57		= 217,
ConstScriptSub("SDLK_WORLD_58",SDLK_WORLD_58); //	SDLK_WORLD_58		= 218,
ConstScriptSub("SDLK_WORLD_59",SDLK_WORLD_59); //	SDLK_WORLD_59		= 219,
ConstScriptSub("SDLK_WORLD_60",SDLK_WORLD_60); //	SDLK_WORLD_60		= 220,
ConstScriptSub("SDLK_WORLD_61",SDLK_WORLD_61); //	SDLK_WORLD_61		= 221,
ConstScriptSub("SDLK_WORLD_62",SDLK_WORLD_62); //	SDLK_WORLD_62		= 222,
ConstScriptSub("SDLK_WORLD_63",SDLK_WORLD_63); //	SDLK_WORLD_63		= 223,
ConstScriptSub("SDLK_WORLD_64",SDLK_WORLD_64); //	SDLK_WORLD_64		= 224,
ConstScriptSub("SDLK_WORLD_65",SDLK_WORLD_65); //	SDLK_WORLD_65		= 225,
ConstScriptSub("SDLK_WORLD_66",SDLK_WORLD_66); //	SDLK_WORLD_66		= 226,
ConstScriptSub("SDLK_WORLD_67",SDLK_WORLD_67); //	SDLK_WORLD_67		= 227,
ConstScriptSub("SDLK_WORLD_68",SDLK_WORLD_68); //	SDLK_WORLD_68		= 228,
ConstScriptSub("SDLK_WORLD_69",SDLK_WORLD_69); //	SDLK_WORLD_69		= 229,
ConstScriptSub("SDLK_WORLD_70",SDLK_WORLD_70); //	SDLK_WORLD_70		= 230,
ConstScriptSub("SDLK_WORLD_71",SDLK_WORLD_71); //	SDLK_WORLD_71		= 231,
ConstScriptSub("SDLK_WORLD_72",SDLK_WORLD_72); //	SDLK_WORLD_72		= 232,
ConstScriptSub("SDLK_WORLD_73",SDLK_WORLD_73); //	SDLK_WORLD_73		= 233,
ConstScriptSub("SDLK_WORLD_74",SDLK_WORLD_74); //	SDLK_WORLD_74		= 234,
ConstScriptSub("SDLK_WORLD_75",SDLK_WORLD_75); //	SDLK_WORLD_75		= 235,
ConstScriptSub("SDLK_WORLD_76",SDLK_WORLD_76); //	SDLK_WORLD_76		= 236,
ConstScriptSub("SDLK_WORLD_77",SDLK_WORLD_77); //	SDLK_WORLD_77		= 237,
ConstScriptSub("SDLK_WORLD_78",SDLK_WORLD_78); //	SDLK_WORLD_78		= 238,
ConstScriptSub("SDLK_WORLD_79",SDLK_WORLD_79); //	SDLK_WORLD_79		= 239,
ConstScriptSub("SDLK_WORLD_80",SDLK_WORLD_80); //	SDLK_WORLD_80		= 240,
ConstScriptSub("SDLK_WORLD_81",SDLK_WORLD_81); //	SDLK_WORLD_81		= 241,
ConstScriptSub("SDLK_WORLD_82",SDLK_WORLD_82); //	SDLK_WORLD_82		= 242,
ConstScriptSub("SDLK_WORLD_83",SDLK_WORLD_83); //	SDLK_WORLD_83		= 243,
ConstScriptSub("SDLK_WORLD_84",SDLK_WORLD_84); //	SDLK_WORLD_84		= 244,
ConstScriptSub("SDLK_WORLD_85",SDLK_WORLD_85); //	SDLK_WORLD_85		= 245,
ConstScriptSub("SDLK_WORLD_86",SDLK_WORLD_86); //	SDLK_WORLD_86		= 246,
ConstScriptSub("SDLK_WORLD_87",SDLK_WORLD_87); //	SDLK_WORLD_87		= 247,
ConstScriptSub("SDLK_WORLD_88",SDLK_WORLD_88); //	SDLK_WORLD_88		= 248,
ConstScriptSub("SDLK_WORLD_89",SDLK_WORLD_89); //	SDLK_WORLD_89		= 249,
ConstScriptSub("SDLK_WORLD_90",SDLK_WORLD_90); //	SDLK_WORLD_90		= 250,
ConstScriptSub("SDLK_WORLD_91",SDLK_WORLD_91); //	SDLK_WORLD_91		= 251,
ConstScriptSub("SDLK_WORLD_92",SDLK_WORLD_92); //	SDLK_WORLD_92		= 252,
ConstScriptSub("SDLK_WORLD_93",SDLK_WORLD_93); //	SDLK_WORLD_93		= 253,
ConstScriptSub("SDLK_WORLD_94",SDLK_WORLD_94); //	SDLK_WORLD_94		= 254,
ConstScriptSub("SDLK_WORLD_95",SDLK_WORLD_95); //	SDLK_WORLD_95		= 255,		
// 	
ConstScriptSub("SDLK_KP0",SDLK_KP0); //	SDLK_KP0		= 256,
ConstScriptSub("SDLK_KP1",SDLK_KP1); //	SDLK_KP1		= 257,
ConstScriptSub("SDLK_KP2",SDLK_KP2); //	SDLK_KP2		= 258,
ConstScriptSub("SDLK_KP3",SDLK_KP3); //	SDLK_KP3		= 259,
ConstScriptSub("SDLK_KP4",SDLK_KP4); //	SDLK_KP4		= 260,
ConstScriptSub("SDLK_KP5",SDLK_KP5); //	SDLK_KP5		= 261,
ConstScriptSub("SDLK_KP6",SDLK_KP6); //	SDLK_KP6		= 262,
ConstScriptSub("SDLK_KP7",SDLK_KP7); //	SDLK_KP7		= 263,
ConstScriptSub("SDLK_KP8",SDLK_KP8); //	SDLK_KP8		= 264,
ConstScriptSub("SDLK_KP9",SDLK_KP9); //	SDLK_KP9		= 265,
ConstScriptSub("SDLK_KP_PERIOD",SDLK_KP_PERIOD); //	SDLK_KP_PERIOD		= 266,
ConstScriptSub("SDLK_KP_DIVIDE",SDLK_KP_DIVIDE); //	SDLK_KP_DIVIDE		= 267,
ConstScriptSub("SDLK_KP_MULTIPLY",SDLK_KP_MULTIPLY); //	SDLK_KP_MULTIPLY	= 268,
ConstScriptSub("SDLK_KP_MINUS",SDLK_KP_MINUS); //	SDLK_KP_MINUS		= 269,
ConstScriptSub("SDLK_KP_PLUS",SDLK_KP_PLUS); //	SDLK_KP_PLUS		= 270,
ConstScriptSub("SDLK_KP_ENTER",SDLK_KP_ENTER); //	SDLK_KP_ENTER		= 271,
ConstScriptSub("SDLK_KP_EQUALS",SDLK_KP_EQUALS); //	SDLK_KP_EQUALS		= 272,
// 	
ConstScriptSub("SDLK_UP",SDLK_UP); //	SDLK_UP			= 273,
ConstScriptSub("SDLK_DOWN",SDLK_DOWN); //	SDLK_DOWN		= 274,
ConstScriptSub("SDLK_RIGHT",SDLK_RIGHT); //	SDLK_RIGHT		= 275,
ConstScriptSub("SDLK_LEFT",SDLK_LEFT); //	SDLK_LEFT		= 276,
ConstScriptSub("SDLK_INSERT",SDLK_INSERT); //	SDLK_INSERT		= 277,
ConstScriptSub("SDLK_HOME",SDLK_HOME); //	SDLK_HOME		= 278,
ConstScriptSub("SDLK_END",SDLK_END); //	SDLK_END		= 279,
ConstScriptSub("SDLK_PAGEUP",SDLK_PAGEUP); //	SDLK_PAGEUP		= 280,
ConstScriptSub("SDLK_PAGEDOWN",SDLK_PAGEDOWN); //	SDLK_PAGEDOWN		= 281,
// 	
ConstScriptSub("SDLK_F1",SDLK_F1); //	SDLK_F1			= 282,
ConstScriptSub("SDLK_F2",SDLK_F2); //	SDLK_F2			= 283,
ConstScriptSub("SDLK_F3",SDLK_F3); //	SDLK_F3			= 284,
ConstScriptSub("SDLK_F4",SDLK_F4); //	SDLK_F4			= 285,
ConstScriptSub("SDLK_F5",SDLK_F5); //	SDLK_F5			= 286,
ConstScriptSub("SDLK_F6",SDLK_F6); //	SDLK_F6			= 287,
ConstScriptSub("SDLK_F7",SDLK_F7); //	SDLK_F7			= 288,
ConstScriptSub("SDLK_F8",SDLK_F8); //	SDLK_F8			= 289,
ConstScriptSub("SDLK_F9",SDLK_F9); //	SDLK_F9			= 290,
ConstScriptSub("SDLK_F10",SDLK_F10); //	SDLK_F10		= 291,
ConstScriptSub("SDLK_F11",SDLK_F11); //	SDLK_F11		= 292,
ConstScriptSub("SDLK_F12",SDLK_F12); //	SDLK_F12		= 293,
ConstScriptSub("SDLK_F13",SDLK_F13); //	SDLK_F13		= 294,
ConstScriptSub("SDLK_F14",SDLK_F14); //	SDLK_F14		= 295,
ConstScriptSub("SDLK_F15",SDLK_F15); //	SDLK_F15		= 296,
// 	
ConstScriptSub("SDLK_NUMLOCK",SDLK_NUMLOCK); //	SDLK_NUMLOCK		= 300,
ConstScriptSub("SDLK_CAPSLOCK",SDLK_CAPSLOCK); //	SDLK_CAPSLOCK		= 301,
ConstScriptSub("SDLK_SCROLLOCK",SDLK_SCROLLOCK); //	SDLK_SCROLLOCK		= 302,
ConstScriptSub("SDLK_RSHIFT",SDLK_RSHIFT); //	SDLK_RSHIFT		= 303,
ConstScriptSub("SDLK_LSHIFT",SDLK_LSHIFT); //	SDLK_LSHIFT		= 304,
ConstScriptSub("SDLK_RCTRL",SDLK_RCTRL); //	SDLK_RCTRL		= 305,
ConstScriptSub("SDLK_LCTRL",SDLK_LCTRL); //	SDLK_LCTRL		= 306,
ConstScriptSub("SDLK_RALT",SDLK_RALT); //	SDLK_RALT		= 307,
ConstScriptSub("SDLK_LALT",SDLK_LALT); //	SDLK_LALT		= 308,
ConstScriptSub("SDLK_RMETA",SDLK_RMETA); //	SDLK_RMETA		= 309,
ConstScriptSub("SDLK_LMETA",SDLK_LMETA); //	SDLK_LMETA		= 310,
ConstScriptSub("SDLK_LSUPER",SDLK_LSUPER); //	SDLK_LSUPER		= 311,		
ConstScriptSub("SDLK_RSUPER",SDLK_RSUPER); //	SDLK_RSUPER		= 312,		
ConstScriptSub("SDLK_MODE",SDLK_MODE); //	SDLK_MODE		= 313,		
ConstScriptSub("SDLK_COMPOSE",SDLK_COMPOSE); //	SDLK_COMPOSE		= 314,		
// 	
ConstScriptSub("SDLK_HELP",SDLK_HELP); //	SDLK_HELP		= 315,
ConstScriptSub("SDLK_PRINT",SDLK_PRINT); //	SDLK_PRINT		= 316,
ConstScriptSub("SDLK_SYSREQ",SDLK_SYSREQ); //	SDLK_SYSREQ		= 317,
ConstScriptSub("SDLK_BREAK",SDLK_BREAK); //	SDLK_BREAK		= 318,
ConstScriptSub("SDLK_MENU",SDLK_MENU); //	SDLK_MENU		= 319,
ConstScriptSub("SDLK_POWER",SDLK_POWER); //	SDLK_POWER		= 320,		
ConstScriptSub("SDLK_EURO",SDLK_EURO); //	SDLK_EURO		= 321,		
ConstScriptSub("SDLK_UNDO",SDLK_UNDO); //	SDLK_UNDO		= 322,		
// 	
ConstScriptSub("SDLK_LAST",SDLK_LAST); //	SDLK_LAST
ConstScriptSub("KMOD_NONE",KMOD_NONE); //	KMOD_NONE  = 0x0000,
ConstScriptSub("KMOD_LSHIFT",KMOD_LSHIFT); //	KMOD_LSHIFT= 0x0001,
ConstScriptSub("KMOD_RSHIFT",KMOD_RSHIFT); //	KMOD_RSHIFT= 0x0002,
ConstScriptSub("KMOD_LCTRL",KMOD_LCTRL); //	KMOD_LCTRL = 0x0040,
ConstScriptSub("KMOD_RCTRL",KMOD_RCTRL); //	KMOD_RCTRL = 0x0080,
ConstScriptSub("KMOD_LALT",KMOD_LALT); //	KMOD_LALT  = 0x0100,
ConstScriptSub("KMOD_RALT",KMOD_RALT); //	KMOD_RALT  = 0x0200,
ConstScriptSub("KMOD_LMETA",KMOD_LMETA); //	KMOD_LMETA = 0x0400,
ConstScriptSub("KMOD_RMETA",KMOD_RMETA); //	KMOD_RMETA = 0x0800,
ConstScriptSub("KMOD_NUM",KMOD_NUM); //	KMOD_NUM   = 0x1000,
ConstScriptSub("KMOD_CAPS",KMOD_CAPS); //	KMOD_CAPS  = 0x2000,
ConstScriptSub("KMOD_MODE",KMOD_MODE); //	KMOD_MODE  = 0x4000,
ConstScriptSub("KMOD_RESERVED",KMOD_RESERVED); //	KMOD_RESERVED = 0x8000
// #define C_LINKAGE	"C"
#ifdef SDL_main
#ifdef main
ConstScriptSub("main",main); //#define main	SDL_main
#endif
#endif
#ifdef SDL_BUTTON_MIDDLE
ConstScriptSub("SDL_BUTTON_MIDDLE",SDL_BUTTON_MIDDLE); //#define SDL_BUTTON_MIDDLE	2
#endif
#ifdef SDL_BUTTON_RIGHT
ConstScriptSub("SDL_BUTTON_RIGHT",SDL_BUTTON_RIGHT); //#define SDL_BUTTON_RIGHT	3
#endif
#ifdef SDL_BUTTON_WHEELUP
ConstScriptSub("SDL_BUTTON_WHEELUP",SDL_BUTTON_WHEELUP); //#define SDL_BUTTON_WHEELUP	4
#endif
#ifdef SDL_BUTTON_WHEELDOWN
ConstScriptSub("SDL_BUTTON_WHEELDOWN",SDL_BUTTON_WHEELDOWN); //#define SDL_BUTTON_WHEELDOWN	5
#endif
#ifdef SDL_MUTEX_TIMEDOUT
ConstScriptSub("SDL_MUTEX_TIMEDOUT",SDL_MUTEX_TIMEDOUT); //#define SDL_MUTEX_TIMEDOUT	1
#endif
#ifdef NeedFunctionPrototypes
ConstScriptSub("NeedFunctionPrototypes",NeedFunctionPrototypes); //#define NeedFunctionPrototypes 1
#endif
#ifdef WIN32_LEAN_AND_MEAN
//ConstScriptSub("WIN32_LEAN_AND_MEAN",WIN32_LEAN_AND_MEAN); //#define WIN32_LEAN_AND_MEAN 1
#endif
#ifdef APIENTRY
#ifdef APIENTRYP
ConstScriptSub("APIENTRYP",APIENTRYP); //#define APIENTRYP APIENTRY *
#endif
#endif
#ifdef extern
#ifdef GLAPI
ConstScriptSub("GLAPI",GLAPI); //#define GLAPI extern
#endif
#endif
#ifdef GL_GLEXT_VERSION
ConstScriptSub("GL_GLEXT_VERSION",GL_GLEXT_VERSION); //#define GL_GLEXT_VERSION 29
#endif
#ifdef GL_PROXY_POST_CONVOLUTION_COLOR_TABLE
ConstScriptSub("GL_PROXY_POST_CONVOLUTION_COLOR_TABLE",GL_PROXY_POST_CONVOLUTION_COLOR_TABLE); //#define GL_PROXY_POST_CONVOLUTION_COLOR_TABLE 0x80D4
#endif
#ifdef GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE
ConstScriptSub("GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE",GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE); //#define GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE 0x80D5
#endif
#ifdef GL_NUM_COMPRESSED_TEXTURE_FORMATS
ConstScriptSub("GL_NUM_COMPRESSED_TEXTURE_FORMATS",GL_NUM_COMPRESSED_TEXTURE_FORMATS); //#define GL_NUM_COMPRESSED_TEXTURE_FORMATS 0x86A2
#endif
#ifdef GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING
ConstScriptSub("GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING",GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING); //#define GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING 0x889A
#endif
#ifdef GL_EDGE_FLAG_ARRAY_BUFFER_BINDING
ConstScriptSub("GL_EDGE_FLAG_ARRAY_BUFFER_BINDING",GL_EDGE_FLAG_ARRAY_BUFFER_BINDING); //#define GL_EDGE_FLAG_ARRAY_BUFFER_BINDING 0x889B
#endif
#ifdef GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING
ConstScriptSub("GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING",GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING); //#define GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING 0x889C
#endif
#ifdef GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING
ConstScriptSub("GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING",GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING); //#define GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING 0x889D
#endif
#ifdef GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING
ConstScriptSub("GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING",GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING); //#define GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING 0x889F
#endif
#ifdef GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING
#ifdef GL_FOG_COORD_ARRAY_BUFFER_BINDING
ConstScriptSub("GL_FOG_COORD_ARRAY_BUFFER_BINDING",GL_FOG_COORD_ARRAY_BUFFER_BINDING); //#define GL_FOG_COORD_ARRAY_BUFFER_BINDING GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING
#endif
#endif
#ifdef GL_VERTEX_ATTRIB_ARRAY_NORMALIZED
ConstScriptSub("GL_VERTEX_ATTRIB_ARRAY_NORMALIZED",GL_VERTEX_ATTRIB_ARRAY_NORMALIZED); //#define GL_VERTEX_ATTRIB_ARRAY_NORMALIZED 0x886A
#endif
#ifdef GL_MAX_FRAGMENT_UNIFORM_COMPONENTS
ConstScriptSub("GL_MAX_FRAGMENT_UNIFORM_COMPONENTS",GL_MAX_FRAGMENT_UNIFORM_COMPONENTS); //#define GL_MAX_FRAGMENT_UNIFORM_COMPONENTS 0x8B49
#endif
#ifdef GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS
ConstScriptSub("GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS",GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS); //#define GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS 0x8B4C
#endif
#ifdef GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS
ConstScriptSub("GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS",GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS); //#define GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS 0x8B4D
#endif
#ifdef GL_FRAGMENT_SHADER_DERIVATIVE_HINT
ConstScriptSub("GL_FRAGMENT_SHADER_DERIVATIVE_HINT",GL_FRAGMENT_SHADER_DERIVATIVE_HINT); //#define GL_FRAGMENT_SHADER_DERIVATIVE_HINT 0x8B8B
#endif
#ifdef GL_TRANSPOSE_MODELVIEW_MATRIX_ARB
ConstScriptSub("GL_TRANSPOSE_MODELVIEW_MATRIX_ARB",GL_TRANSPOSE_MODELVIEW_MATRIX_ARB); //#define GL_TRANSPOSE_MODELVIEW_MATRIX_ARB 0x84E3
#endif
#ifdef GL_TRANSPOSE_PROJECTION_MATRIX_ARB
ConstScriptSub("GL_TRANSPOSE_PROJECTION_MATRIX_ARB",GL_TRANSPOSE_PROJECTION_MATRIX_ARB); //#define GL_TRANSPOSE_PROJECTION_MATRIX_ARB 0x84E4
#endif
#ifdef GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB
ConstScriptSub("GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB",GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB); //#define GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB 0x8515
#endif
#ifdef GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB
ConstScriptSub("GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB",GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB); //#define GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB 0x8516
#endif
#ifdef GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB
ConstScriptSub("GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB",GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB); //#define GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB 0x8517
#endif
#ifdef GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB
ConstScriptSub("GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB",GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB); //#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB 0x8518
#endif
#ifdef GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB
ConstScriptSub("GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB",GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB); //#define GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB 0x8519
#endif
#ifdef GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB
ConstScriptSub("GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB",GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB); //#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB 0x851A
#endif
#ifdef GL_COMPRESSED_LUMINANCE_ALPHA_ARB
ConstScriptSub("GL_COMPRESSED_LUMINANCE_ALPHA_ARB",GL_COMPRESSED_LUMINANCE_ALPHA_ARB); //#define GL_COMPRESSED_LUMINANCE_ALPHA_ARB 0x84EB
#endif
#ifdef GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB
ConstScriptSub("GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB",GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB); //#define GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB 0x86A0
#endif
#ifdef GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB
ConstScriptSub("GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB",GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB); //#define GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB 0x86A2
#endif
#ifdef GL_COMPRESSED_TEXTURE_FORMATS_ARB
ConstScriptSub("GL_COMPRESSED_TEXTURE_FORMATS_ARB",GL_COMPRESSED_TEXTURE_FORMATS_ARB); //#define GL_COMPRESSED_TEXTURE_FORMATS_ARB 0x86A3
#endif
#ifdef GL_POINT_DISTANCE_ATTENUATION_ARB
ConstScriptSub("GL_POINT_DISTANCE_ATTENUATION_ARB",GL_POINT_DISTANCE_ATTENUATION_ARB); //#define GL_POINT_DISTANCE_ATTENUATION_ARB 0x8129
#endif
#ifdef GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB
ConstScriptSub("GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB",GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB); //#define GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB 0x8841
#endif
#ifdef GL_MATRIX_INDEX_ARRAY_POINTER_ARB
ConstScriptSub("GL_MATRIX_INDEX_ARRAY_POINTER_ARB",GL_MATRIX_INDEX_ARRAY_POINTER_ARB); //#define GL_MATRIX_INDEX_ARRAY_POINTER_ARB 0x8849
#endif
#ifdef GL_TEXTURE_COMPARE_FAIL_VALUE_ARB
ConstScriptSub("GL_TEXTURE_COMPARE_FAIL_VALUE_ARB",GL_TEXTURE_COMPARE_FAIL_VALUE_ARB); //#define GL_TEXTURE_COMPARE_FAIL_VALUE_ARB 0x80BF
#endif
#ifdef GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB
ConstScriptSub("GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB",GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB); //#define GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB 0x8622
#endif
#ifdef GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB
ConstScriptSub("GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB",GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB); //#define GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB 0x8624
#endif
#ifdef GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB
ConstScriptSub("GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB",GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB); //#define GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB 0x862E
#endif
#ifdef GL_CURRENT_MATRIX_STACK_DEPTH_ARB
ConstScriptSub("GL_CURRENT_MATRIX_STACK_DEPTH_ARB",GL_CURRENT_MATRIX_STACK_DEPTH_ARB); //#define GL_CURRENT_MATRIX_STACK_DEPTH_ARB 0x8640
#endif
#ifdef GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB
ConstScriptSub("GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB",GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB); //#define GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB 0x8645
#endif
#ifdef GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB
ConstScriptSub("GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB",GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB); //#define GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB 0x886A
#endif
#ifdef GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB
ConstScriptSub("GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB",GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB); //#define GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB 0x88A2
#endif
#ifdef GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB
ConstScriptSub("GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB",GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB); //#define GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB 0x88A3
#endif
#ifdef GL_PROGRAM_NATIVE_TEMPORARIES_ARB
ConstScriptSub("GL_PROGRAM_NATIVE_TEMPORARIES_ARB",GL_PROGRAM_NATIVE_TEMPORARIES_ARB); //#define GL_PROGRAM_NATIVE_TEMPORARIES_ARB 0x88A6
#endif
#ifdef GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB
ConstScriptSub("GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB",GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB); //#define GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB 0x88A7
#endif
#ifdef GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB
ConstScriptSub("GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB",GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB); //#define GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB 0x88AB
#endif
#ifdef GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB
ConstScriptSub("GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB",GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB); //#define GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB 0x88AF
#endif
#ifdef GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB
ConstScriptSub("GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB",GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB); //#define GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB 0x88B1
#endif
#ifdef GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB
ConstScriptSub("GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB",GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB); //#define GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB 0x88B2
#endif
#ifdef GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB
ConstScriptSub("GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB",GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB); //#define GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB 0x88B3
#endif
#ifdef GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB
ConstScriptSub("GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB",GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB); //#define GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB 0x88B4
#endif
#ifdef GL_MAX_PROGRAM_ENV_PARAMETERS_ARB
ConstScriptSub("GL_MAX_PROGRAM_ENV_PARAMETERS_ARB",GL_MAX_PROGRAM_ENV_PARAMETERS_ARB); //#define GL_MAX_PROGRAM_ENV_PARAMETERS_ARB 0x88B5
#endif
#ifdef GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB
ConstScriptSub("GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB",GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB); //#define GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB 0x88B6
#endif
#ifdef GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB
ConstScriptSub("GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB",GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB); //#define GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB 0x8808
#endif
#ifdef GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB
ConstScriptSub("GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB",GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB); //#define GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB 0x8809
#endif
#ifdef GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB
ConstScriptSub("GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB",GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB); //#define GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB 0x880A
#endif
#ifdef GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB
ConstScriptSub("GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB",GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB); //#define GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB 0x880B
#endif
#ifdef GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB
ConstScriptSub("GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB",GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB); //#define GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB 0x880C
#endif
#ifdef GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB
ConstScriptSub("GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB",GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB); //#define GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB 0x880D
#endif
#ifdef GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB
ConstScriptSub("GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB",GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB); //#define GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB 0x880E
#endif
#ifdef GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB
ConstScriptSub("GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB",GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB); //#define GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB 0x880F
#endif
#ifdef GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB
ConstScriptSub("GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB",GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB); //#define GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB 0x8810
#endif
#ifdef GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB
ConstScriptSub("GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB",GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB); //#define GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB 0x8895
#endif
#ifdef GL_VERTEX_ARRAY_BUFFER_BINDING_ARB
ConstScriptSub("GL_VERTEX_ARRAY_BUFFER_BINDING_ARB",GL_VERTEX_ARRAY_BUFFER_BINDING_ARB); //#define GL_VERTEX_ARRAY_BUFFER_BINDING_ARB 0x8896
#endif
#ifdef GL_NORMAL_ARRAY_BUFFER_BINDING_ARB
ConstScriptSub("GL_NORMAL_ARRAY_BUFFER_BINDING_ARB",GL_NORMAL_ARRAY_BUFFER_BINDING_ARB); //#define GL_NORMAL_ARRAY_BUFFER_BINDING_ARB 0x8897
#endif
#ifdef GL_COLOR_ARRAY_BUFFER_BINDING_ARB
ConstScriptSub("GL_COLOR_ARRAY_BUFFER_BINDING_ARB",GL_COLOR_ARRAY_BUFFER_BINDING_ARB); //#define GL_COLOR_ARRAY_BUFFER_BINDING_ARB 0x8898
#endif
#ifdef GL_INDEX_ARRAY_BUFFER_BINDING_ARB
ConstScriptSub("GL_INDEX_ARRAY_BUFFER_BINDING_ARB",GL_INDEX_ARRAY_BUFFER_BINDING_ARB); //#define GL_INDEX_ARRAY_BUFFER_BINDING_ARB 0x8899
#endif
#ifdef GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB
ConstScriptSub("GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB",GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB); //#define GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB 0x889A
#endif
#ifdef GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB
ConstScriptSub("GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB",GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB); //#define GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB 0x889B
#endif
#ifdef GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB
ConstScriptSub("GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB",GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB); //#define GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB 0x889C
#endif
#ifdef GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB
ConstScriptSub("GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB",GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB); //#define GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB 0x889D
#endif
#ifdef GL_WEIGHT_ARRAY_BUFFER_BINDING_ARB
ConstScriptSub("GL_WEIGHT_ARRAY_BUFFER_BINDING_ARB",GL_WEIGHT_ARRAY_BUFFER_BINDING_ARB); //#define GL_WEIGHT_ARRAY_BUFFER_BINDING_ARB 0x889E
#endif
#ifdef GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB
ConstScriptSub("GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB",GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB); //#define GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB 0x889F
#endif
#ifdef GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB
ConstScriptSub("GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB",GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB); //#define GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB 0x8B87
#endif
#ifdef GL_OBJECT_SHADER_SOURCE_LENGTH_ARB
ConstScriptSub("GL_OBJECT_SHADER_SOURCE_LENGTH_ARB",GL_OBJECT_SHADER_SOURCE_LENGTH_ARB); //#define GL_OBJECT_SHADER_SOURCE_LENGTH_ARB 0x8B88
#endif
#ifdef GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB
ConstScriptSub("GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB",GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB); //#define GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB 0x8B4A
#endif
#ifdef GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB
ConstScriptSub("GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB",GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB); //#define GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB 0x8B4C
#endif
#ifdef GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB
ConstScriptSub("GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB",GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB); //#define GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB 0x8B4D
#endif
#ifdef GL_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB
ConstScriptSub("GL_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB",GL_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB); //#define GL_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB 0x8B8A
#endif
#ifdef GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB
ConstScriptSub("GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB",GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB); //#define GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB 0x8B49
#endif
#ifdef GL_FRAGMENT_SHADER_DERIVATIVE_HINT_ARB
ConstScriptSub("GL_FRAGMENT_SHADER_DERIVATIVE_HINT_ARB",GL_FRAGMENT_SHADER_DERIVATIVE_HINT_ARB); //#define GL_FRAGMENT_SHADER_DERIVATIVE_HINT_ARB 0x8B8B
#endif
#ifdef GL_MAX_RECTANGLE_TEXTURE_SIZE_ARB
ConstScriptSub("GL_MAX_RECTANGLE_TEXTURE_SIZE_ARB",GL_MAX_RECTANGLE_TEXTURE_SIZE_ARB); //#define GL_MAX_RECTANGLE_TEXTURE_SIZE_ARB 0x84F8
#endif
#ifdef GL_PIXEL_UNPACK_BUFFER_BINDING_ARB
ConstScriptSub("GL_PIXEL_UNPACK_BUFFER_BINDING_ARB",GL_PIXEL_UNPACK_BUFFER_BINDING_ARB); //#define GL_PIXEL_UNPACK_BUFFER_BINDING_ARB 0x88EF
#endif
#ifdef GL_POST_CONVOLUTION_RED_SCALE_EXT
ConstScriptSub("GL_POST_CONVOLUTION_RED_SCALE_EXT",GL_POST_CONVOLUTION_RED_SCALE_EXT); //#define GL_POST_CONVOLUTION_RED_SCALE_EXT 0x801C
#endif
#ifdef GL_POST_CONVOLUTION_GREEN_SCALE_EXT
ConstScriptSub("GL_POST_CONVOLUTION_GREEN_SCALE_EXT",GL_POST_CONVOLUTION_GREEN_SCALE_EXT); //#define GL_POST_CONVOLUTION_GREEN_SCALE_EXT 0x801D
#endif
#ifdef GL_POST_CONVOLUTION_BLUE_SCALE_EXT
ConstScriptSub("GL_POST_CONVOLUTION_BLUE_SCALE_EXT",GL_POST_CONVOLUTION_BLUE_SCALE_EXT); //#define GL_POST_CONVOLUTION_BLUE_SCALE_EXT 0x801E
#endif
#ifdef GL_POST_CONVOLUTION_ALPHA_SCALE_EXT
ConstScriptSub("GL_POST_CONVOLUTION_ALPHA_SCALE_EXT",GL_POST_CONVOLUTION_ALPHA_SCALE_EXT); //#define GL_POST_CONVOLUTION_ALPHA_SCALE_EXT 0x801F
#endif
#ifdef GL_POST_CONVOLUTION_GREEN_BIAS_EXT
ConstScriptSub("GL_POST_CONVOLUTION_GREEN_BIAS_EXT",GL_POST_CONVOLUTION_GREEN_BIAS_EXT); //#define GL_POST_CONVOLUTION_GREEN_BIAS_EXT 0x8021
#endif
#ifdef GL_POST_CONVOLUTION_BLUE_BIAS_EXT
ConstScriptSub("GL_POST_CONVOLUTION_BLUE_BIAS_EXT",GL_POST_CONVOLUTION_BLUE_BIAS_EXT); //#define GL_POST_CONVOLUTION_BLUE_BIAS_EXT 0x8022
#endif
#ifdef GL_POST_CONVOLUTION_ALPHA_BIAS_EXT
ConstScriptSub("GL_POST_CONVOLUTION_ALPHA_BIAS_EXT",GL_POST_CONVOLUTION_ALPHA_BIAS_EXT); //#define GL_POST_CONVOLUTION_ALPHA_BIAS_EXT 0x8023
#endif
#ifdef GL_MAX_COLOR_MATRIX_STACK_DEPTH_SGI
ConstScriptSub("GL_MAX_COLOR_MATRIX_STACK_DEPTH_SGI",GL_MAX_COLOR_MATRIX_STACK_DEPTH_SGI); //#define GL_MAX_COLOR_MATRIX_STACK_DEPTH_SGI 0x80B3
#endif
#ifdef GL_POST_COLOR_MATRIX_RED_SCALE_SGI
ConstScriptSub("GL_POST_COLOR_MATRIX_RED_SCALE_SGI",GL_POST_COLOR_MATRIX_RED_SCALE_SGI); //#define GL_POST_COLOR_MATRIX_RED_SCALE_SGI 0x80B4
#endif
#ifdef GL_POST_COLOR_MATRIX_GREEN_SCALE_SGI
ConstScriptSub("GL_POST_COLOR_MATRIX_GREEN_SCALE_SGI",GL_POST_COLOR_MATRIX_GREEN_SCALE_SGI); //#define GL_POST_COLOR_MATRIX_GREEN_SCALE_SGI 0x80B5
#endif
#ifdef GL_POST_COLOR_MATRIX_BLUE_SCALE_SGI
ConstScriptSub("GL_POST_COLOR_MATRIX_BLUE_SCALE_SGI",GL_POST_COLOR_MATRIX_BLUE_SCALE_SGI); //#define GL_POST_COLOR_MATRIX_BLUE_SCALE_SGI 0x80B6
#endif
#ifdef GL_POST_COLOR_MATRIX_ALPHA_SCALE_SGI
ConstScriptSub("GL_POST_COLOR_MATRIX_ALPHA_SCALE_SGI",GL_POST_COLOR_MATRIX_ALPHA_SCALE_SGI); //#define GL_POST_COLOR_MATRIX_ALPHA_SCALE_SGI 0x80B7
#endif
#ifdef GL_POST_COLOR_MATRIX_RED_BIAS_SGI
ConstScriptSub("GL_POST_COLOR_MATRIX_RED_BIAS_SGI",GL_POST_COLOR_MATRIX_RED_BIAS_SGI); //#define GL_POST_COLOR_MATRIX_RED_BIAS_SGI 0x80B8
#endif
#ifdef GL_POST_COLOR_MATRIX_GREEN_BIAS_SGI
ConstScriptSub("GL_POST_COLOR_MATRIX_GREEN_BIAS_SGI",GL_POST_COLOR_MATRIX_GREEN_BIAS_SGI); //#define GL_POST_COLOR_MATRIX_GREEN_BIAS_SGI 0x80B9
#endif
#ifdef GL_POST_COLOR_MATRIX_BLUE_BIAS_SGI
ConstScriptSub("GL_POST_COLOR_MATRIX_BLUE_BIAS_SGI",GL_POST_COLOR_MATRIX_BLUE_BIAS_SGI); //#define GL_POST_COLOR_MATRIX_BLUE_BIAS_SGI 0x80BA
#endif
#ifdef GL_POST_COLOR_MATRIX_ALPHA_BIAS_SGI
ConstScriptSub("GL_POST_COLOR_MATRIX_ALPHA_BIAS_SGI",GL_POST_COLOR_MATRIX_ALPHA_BIAS_SGI); //#define GL_POST_COLOR_MATRIX_ALPHA_BIAS_SGI 0x80BB
#endif
#ifdef GL_POST_CONVOLUTION_COLOR_TABLE_SGI
ConstScriptSub("GL_POST_CONVOLUTION_COLOR_TABLE_SGI",GL_POST_CONVOLUTION_COLOR_TABLE_SGI); //#define GL_POST_CONVOLUTION_COLOR_TABLE_SGI 0x80D1
#endif
#ifdef GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI
ConstScriptSub("GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI",GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI); //#define GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI 0x80D2
#endif
#ifdef GL_PROXY_POST_CONVOLUTION_COLOR_TABLE_SGI
ConstScriptSub("GL_PROXY_POST_CONVOLUTION_COLOR_TABLE_SGI",GL_PROXY_POST_CONVOLUTION_COLOR_TABLE_SGI); //#define GL_PROXY_POST_CONVOLUTION_COLOR_TABLE_SGI 0x80D4
#endif
#ifdef GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE_SGI
ConstScriptSub("GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE_SGI",GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE_SGI); //#define GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE_SGI 0x80D5
#endif
#ifdef GL_COLOR_TABLE_LUMINANCE_SIZE_SGI
ConstScriptSub("GL_COLOR_TABLE_LUMINANCE_SIZE_SGI",GL_COLOR_TABLE_LUMINANCE_SIZE_SGI); //#define GL_COLOR_TABLE_LUMINANCE_SIZE_SGI 0x80DE
#endif
#ifdef GL_COLOR_TABLE_INTENSITY_SIZE_SGI
ConstScriptSub("GL_COLOR_TABLE_INTENSITY_SIZE_SGI",GL_COLOR_TABLE_INTENSITY_SIZE_SGI); //#define GL_COLOR_TABLE_INTENSITY_SIZE_SGI 0x80DF
#endif
#ifdef GL_PIXEL_FRAGMENT_RGB_SOURCE_SGIS
ConstScriptSub("GL_PIXEL_FRAGMENT_RGB_SOURCE_SGIS",GL_PIXEL_FRAGMENT_RGB_SOURCE_SGIS); //#define GL_PIXEL_FRAGMENT_RGB_SOURCE_SGIS 0x8354
#endif
#ifdef GL_PIXEL_FRAGMENT_ALPHA_SOURCE_SGIS
ConstScriptSub("GL_PIXEL_FRAGMENT_ALPHA_SOURCE_SGIS",GL_PIXEL_FRAGMENT_ALPHA_SOURCE_SGIS); //#define GL_PIXEL_FRAGMENT_ALPHA_SOURCE_SGIS 0x8355
#endif
#ifdef GL_DETAIL_TEXTURE_2D_BINDING_SGIS
ConstScriptSub("GL_DETAIL_TEXTURE_2D_BINDING_SGIS",GL_DETAIL_TEXTURE_2D_BINDING_SGIS); //#define GL_DETAIL_TEXTURE_2D_BINDING_SGIS 0x8096
#endif
#ifdef GL_DETAIL_TEXTURE_FUNC_POINTS_SGIS
ConstScriptSub("GL_DETAIL_TEXTURE_FUNC_POINTS_SGIS",GL_DETAIL_TEXTURE_FUNC_POINTS_SGIS); //#define GL_DETAIL_TEXTURE_FUNC_POINTS_SGIS 0x809C
#endif
#ifdef GL_SHARPEN_TEXTURE_FUNC_POINTS_SGIS
ConstScriptSub("GL_SHARPEN_TEXTURE_FUNC_POINTS_SGIS",GL_SHARPEN_TEXTURE_FUNC_POINTS_SGIS); //#define GL_SHARPEN_TEXTURE_FUNC_POINTS_SGIS 0x80B0
#endif
#ifdef GL_TEXTURE_COORD_ARRAY_STRIDE_EXT
ConstScriptSub("GL_TEXTURE_COORD_ARRAY_STRIDE_EXT",GL_TEXTURE_COORD_ARRAY_STRIDE_EXT); //#define GL_TEXTURE_COORD_ARRAY_STRIDE_EXT 0x808A
#endif
#ifdef GL_TEXTURE_COORD_ARRAY_POINTER_EXT
ConstScriptSub("GL_TEXTURE_COORD_ARRAY_POINTER_EXT",GL_TEXTURE_COORD_ARRAY_POINTER_EXT); //#define GL_TEXTURE_COORD_ARRAY_POINTER_EXT 0x8092
#endif
#ifdef GL_TEXTURE_CLIPMAP_VIRTUAL_DEPTH_SGIX
ConstScriptSub("GL_TEXTURE_CLIPMAP_VIRTUAL_DEPTH_SGIX",GL_TEXTURE_CLIPMAP_VIRTUAL_DEPTH_SGIX); //#define GL_TEXTURE_CLIPMAP_VIRTUAL_DEPTH_SGIX 0x8174
#endif
#ifdef GL_TEXTURE_CLIPMAP_LOD_OFFSET_SGIX
ConstScriptSub("GL_TEXTURE_CLIPMAP_LOD_OFFSET_SGIX",GL_TEXTURE_CLIPMAP_LOD_OFFSET_SGIX); //#define GL_TEXTURE_CLIPMAP_LOD_OFFSET_SGIX 0x8175
#endif
#ifdef GL_MAX_CLIPMAP_VIRTUAL_DEPTH_SGIX
ConstScriptSub("GL_MAX_CLIPMAP_VIRTUAL_DEPTH_SGIX",GL_MAX_CLIPMAP_VIRTUAL_DEPTH_SGIX); //#define GL_MAX_CLIPMAP_VIRTUAL_DEPTH_SGIX 0x8178
#endif
#ifdef GL_PIXEL_TILE_BEST_ALIGNMENT_SGIX
ConstScriptSub("GL_PIXEL_TILE_BEST_ALIGNMENT_SGIX",GL_PIXEL_TILE_BEST_ALIGNMENT_SGIX); //#define GL_PIXEL_TILE_BEST_ALIGNMENT_SGIX 0x813E
#endif
#ifdef GL_PIXEL_TILE_CACHE_INCREMENT_SGIX
ConstScriptSub("GL_PIXEL_TILE_CACHE_INCREMENT_SGIX",GL_PIXEL_TILE_CACHE_INCREMENT_SGIX); //#define GL_PIXEL_TILE_CACHE_INCREMENT_SGIX 0x813F
#endif
#ifdef GL_TEXTURE_MULTI_BUFFER_HINT_SGIX
ConstScriptSub("GL_TEXTURE_MULTI_BUFFER_HINT_SGIX",GL_TEXTURE_MULTI_BUFFER_HINT_SGIX); //#define GL_TEXTURE_MULTI_BUFFER_HINT_SGIX 0x812E
#endif
#ifdef GL_POINT_FADE_THRESHOLD_SIZE_SGIS
ConstScriptSub("GL_POINT_FADE_THRESHOLD_SIZE_SGIS",GL_POINT_FADE_THRESHOLD_SIZE_SGIS); //#define GL_POINT_FADE_THRESHOLD_SIZE_SGIS 0x8128
#endif
#ifdef GL_INSTRUMENT_BUFFER_POINTER_SGIX
ConstScriptSub("GL_INSTRUMENT_BUFFER_POINTER_SGIX",GL_INSTRUMENT_BUFFER_POINTER_SGIX); //#define GL_INSTRUMENT_BUFFER_POINTER_SGIX 0x8180
#endif
#ifdef GL_POST_TEXTURE_FILTER_SCALE_SGIX
ConstScriptSub("GL_POST_TEXTURE_FILTER_SCALE_SGIX",GL_POST_TEXTURE_FILTER_SCALE_SGIX); //#define GL_POST_TEXTURE_FILTER_SCALE_SGIX 0x817A
#endif
#ifdef GL_POST_TEXTURE_FILTER_BIAS_RANGE_SGIX
ConstScriptSub("GL_POST_TEXTURE_FILTER_BIAS_RANGE_SGIX",GL_POST_TEXTURE_FILTER_BIAS_RANGE_SGIX); //#define GL_POST_TEXTURE_FILTER_BIAS_RANGE_SGIX 0x817B
#endif
#ifdef GL_POST_TEXTURE_FILTER_SCALE_RANGE_SGIX
ConstScriptSub("GL_POST_TEXTURE_FILTER_SCALE_RANGE_SGIX",GL_POST_TEXTURE_FILTER_SCALE_RANGE_SGIX); //#define GL_POST_TEXTURE_FILTER_SCALE_RANGE_SGIX 0x817C
#endif
#ifdef GL_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP
ConstScriptSub("GL_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP",GL_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP); //#define GL_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP 0x8162
#endif
#ifdef GL_PROXY_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP
ConstScriptSub("GL_PROXY_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP",GL_PROXY_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP); //#define GL_PROXY_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP 0x8163
#endif
#ifdef GL_MAT_AMBIENT_AND_DIFFUSE_BIT_PGI
ConstScriptSub("GL_MAT_AMBIENT_AND_DIFFUSE_BIT_PGI",GL_MAT_AMBIENT_AND_DIFFUSE_BIT_PGI); //#define GL_MAT_AMBIENT_AND_DIFFUSE_BIT_PGI 0x00200000
#endif
#ifdef GL_NATIVE_GRAPHICS_BEGIN_HINT_PGI
ConstScriptSub("GL_NATIVE_GRAPHICS_BEGIN_HINT_PGI",GL_NATIVE_GRAPHICS_BEGIN_HINT_PGI); //#define GL_NATIVE_GRAPHICS_BEGIN_HINT_PGI 0x1A203
#endif
#ifdef GL_CULL_VERTEX_OBJECT_POSITION_EXT
ConstScriptSub("GL_CULL_VERTEX_OBJECT_POSITION_EXT",GL_CULL_VERTEX_OBJECT_POSITION_EXT); //#define GL_CULL_VERTEX_OBJECT_POSITION_EXT 0x81AC
#endif
#ifdef GL_FRAGMENT_COLOR_MATERIAL_FACE_SGIX
ConstScriptSub("GL_FRAGMENT_COLOR_MATERIAL_FACE_SGIX",GL_FRAGMENT_COLOR_MATERIAL_FACE_SGIX); //#define GL_FRAGMENT_COLOR_MATERIAL_FACE_SGIX 0x8402
#endif
#ifdef GL_FRAGMENT_COLOR_MATERIAL_PARAMETER_SGIX
ConstScriptSub("GL_FRAGMENT_COLOR_MATERIAL_PARAMETER_SGIX",GL_FRAGMENT_COLOR_MATERIAL_PARAMETER_SGIX); //#define GL_FRAGMENT_COLOR_MATERIAL_PARAMETER_SGIX 0x8403
#endif
#ifdef GL_FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_SGIX
ConstScriptSub("GL_FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_SGIX",GL_FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_SGIX); //#define GL_FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_SGIX 0x8408
#endif
#ifdef GL_FRAGMENT_LIGHT_MODEL_TWO_SIDE_SGIX
ConstScriptSub("GL_FRAGMENT_LIGHT_MODEL_TWO_SIDE_SGIX",GL_FRAGMENT_LIGHT_MODEL_TWO_SIDE_SGIX); //#define GL_FRAGMENT_LIGHT_MODEL_TWO_SIDE_SGIX 0x8409
#endif
#ifdef GL_FRAGMENT_LIGHT_MODEL_AMBIENT_SGIX
ConstScriptSub("GL_FRAGMENT_LIGHT_MODEL_AMBIENT_SGIX",GL_FRAGMENT_LIGHT_MODEL_AMBIENT_SGIX); //#define GL_FRAGMENT_LIGHT_MODEL_AMBIENT_SGIX 0x840A
#endif
#ifdef GL_FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_SGIX
ConstScriptSub("GL_FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_SGIX",GL_FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_SGIX); //#define GL_FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_SGIX 0x840B
#endif
#ifdef GL_TEXTURE_MATERIAL_PARAMETER_EXT
ConstScriptSub("GL_TEXTURE_MATERIAL_PARAMETER_EXT",GL_TEXTURE_MATERIAL_PARAMETER_EXT); //#define GL_TEXTURE_MATERIAL_PARAMETER_EXT 0x8352
#endif
#ifdef GL_PIXEL_TEX_GEN_ALPHA_REPLACE_SGIX
ConstScriptSub("GL_PIXEL_TEX_GEN_ALPHA_REPLACE_SGIX",GL_PIXEL_TEX_GEN_ALPHA_REPLACE_SGIX); //#define GL_PIXEL_TEX_GEN_ALPHA_REPLACE_SGIX 0x8187
#endif
#ifdef GL_PIXEL_TEX_GEN_ALPHA_NO_REPLACE_SGIX
ConstScriptSub("GL_PIXEL_TEX_GEN_ALPHA_NO_REPLACE_SGIX",GL_PIXEL_TEX_GEN_ALPHA_NO_REPLACE_SGIX); //#define GL_PIXEL_TEX_GEN_ALPHA_NO_REPLACE_SGIX 0x8188
#endif
#ifdef GL_VERTEX_ARRAY_PARALLEL_POINTERS_INTEL
ConstScriptSub("GL_VERTEX_ARRAY_PARALLEL_POINTERS_INTEL",GL_VERTEX_ARRAY_PARALLEL_POINTERS_INTEL); //#define GL_VERTEX_ARRAY_PARALLEL_POINTERS_INTEL 0x83F5
#endif
#ifdef GL_NORMAL_ARRAY_PARALLEL_POINTERS_INTEL
ConstScriptSub("GL_NORMAL_ARRAY_PARALLEL_POINTERS_INTEL",GL_NORMAL_ARRAY_PARALLEL_POINTERS_INTEL); //#define GL_NORMAL_ARRAY_PARALLEL_POINTERS_INTEL 0x83F6
#endif
#ifdef GL_COLOR_ARRAY_PARALLEL_POINTERS_INTEL
ConstScriptSub("GL_COLOR_ARRAY_PARALLEL_POINTERS_INTEL",GL_COLOR_ARRAY_PARALLEL_POINTERS_INTEL); //#define GL_COLOR_ARRAY_PARALLEL_POINTERS_INTEL 0x83F7
#endif
#ifdef GL_TEXTURE_COORD_ARRAY_PARALLEL_POINTERS_INTEL
ConstScriptSub("GL_TEXTURE_COORD_ARRAY_PARALLEL_POINTERS_INTEL",GL_TEXTURE_COORD_ARRAY_PARALLEL_POINTERS_INTEL); //#define GL_TEXTURE_COORD_ARRAY_PARALLEL_POINTERS_INTEL 0x83F8
#endif
#ifdef GL_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT
ConstScriptSub("GL_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT",GL_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT); //#define GL_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT 0x8336
#endif
#ifdef GL_MAX_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT
ConstScriptSub("GL_MAX_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT",GL_MAX_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT); //#define GL_MAX_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT 0x8337
#endif
#ifdef GL_SECONDARY_COLOR_ARRAY_SIZE_EXT
ConstScriptSub("GL_SECONDARY_COLOR_ARRAY_SIZE_EXT",GL_SECONDARY_COLOR_ARRAY_SIZE_EXT); //#define GL_SECONDARY_COLOR_ARRAY_SIZE_EXT 0x845A
#endif
#ifdef GL_SECONDARY_COLOR_ARRAY_TYPE_EXT
ConstScriptSub("GL_SECONDARY_COLOR_ARRAY_TYPE_EXT",GL_SECONDARY_COLOR_ARRAY_TYPE_EXT); //#define GL_SECONDARY_COLOR_ARRAY_TYPE_EXT 0x845B
#endif
#ifdef GL_SECONDARY_COLOR_ARRAY_STRIDE_EXT
ConstScriptSub("GL_SECONDARY_COLOR_ARRAY_STRIDE_EXT",GL_SECONDARY_COLOR_ARRAY_STRIDE_EXT); //#define GL_SECONDARY_COLOR_ARRAY_STRIDE_EXT 0x845C
#endif
#ifdef GL_SECONDARY_COLOR_ARRAY_POINTER_EXT
ConstScriptSub("GL_SECONDARY_COLOR_ARRAY_POINTER_EXT",GL_SECONDARY_COLOR_ARRAY_POINTER_EXT); //#define GL_SECONDARY_COLOR_ARRAY_POINTER_EXT 0x845D
#endif
#ifdef GL_FOG_COORDINATE_ARRAY_STRIDE_EXT
ConstScriptSub("GL_FOG_COORDINATE_ARRAY_STRIDE_EXT",GL_FOG_COORDINATE_ARRAY_STRIDE_EXT); //#define GL_FOG_COORDINATE_ARRAY_STRIDE_EXT 0x8455
#endif
#ifdef GL_FOG_COORDINATE_ARRAY_POINTER_EXT
ConstScriptSub("GL_FOG_COORDINATE_ARRAY_POINTER_EXT",GL_FOG_COORDINATE_ARRAY_POINTER_EXT); //#define GL_FOG_COORDINATE_ARRAY_POINTER_EXT 0x8456
#endif
#ifdef GL_LIGHT_MODEL_SPECULAR_VECTOR_APPLE
ConstScriptSub("GL_LIGHT_MODEL_SPECULAR_VECTOR_APPLE",GL_LIGHT_MODEL_SPECULAR_VECTOR_APPLE); //#define GL_LIGHT_MODEL_SPECULAR_VECTOR_APPLE 0x85B0
#endif
#ifdef GL_REPLACEMENT_CODE_ARRAY_TYPE_SUN
ConstScriptSub("GL_REPLACEMENT_CODE_ARRAY_TYPE_SUN",GL_REPLACEMENT_CODE_ARRAY_TYPE_SUN); //#define GL_REPLACEMENT_CODE_ARRAY_TYPE_SUN 0x85C1
#endif
#ifdef GL_REPLACEMENT_CODE_ARRAY_STRIDE_SUN
ConstScriptSub("GL_REPLACEMENT_CODE_ARRAY_STRIDE_SUN",GL_REPLACEMENT_CODE_ARRAY_STRIDE_SUN); //#define GL_REPLACEMENT_CODE_ARRAY_STRIDE_SUN 0x85C2
#endif
#ifdef GL_REPLACEMENT_CODE_ARRAY_POINTER_SUN
ConstScriptSub("GL_REPLACEMENT_CODE_ARRAY_POINTER_SUN",GL_REPLACEMENT_CODE_ARRAY_POINTER_SUN); //#define GL_REPLACEMENT_CODE_ARRAY_POINTER_SUN 0x85C3
#endif
#ifdef GL_TEXTURE_CUBE_MAP_POSITIVE_X_EXT
ConstScriptSub("GL_TEXTURE_CUBE_MAP_POSITIVE_X_EXT",GL_TEXTURE_CUBE_MAP_POSITIVE_X_EXT); //#define GL_TEXTURE_CUBE_MAP_POSITIVE_X_EXT 0x8515
#endif
#ifdef GL_TEXTURE_CUBE_MAP_NEGATIVE_X_EXT
ConstScriptSub("GL_TEXTURE_CUBE_MAP_NEGATIVE_X_EXT",GL_TEXTURE_CUBE_MAP_NEGATIVE_X_EXT); //#define GL_TEXTURE_CUBE_MAP_NEGATIVE_X_EXT 0x8516
#endif
#ifdef GL_TEXTURE_CUBE_MAP_POSITIVE_Y_EXT
ConstScriptSub("GL_TEXTURE_CUBE_MAP_POSITIVE_Y_EXT",GL_TEXTURE_CUBE_MAP_POSITIVE_Y_EXT); //#define GL_TEXTURE_CUBE_MAP_POSITIVE_Y_EXT 0x8517
#endif
#ifdef GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_EXT
ConstScriptSub("GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_EXT",GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_EXT); //#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_EXT 0x8518
#endif
#ifdef GL_TEXTURE_CUBE_MAP_POSITIVE_Z_EXT
ConstScriptSub("GL_TEXTURE_CUBE_MAP_POSITIVE_Z_EXT",GL_TEXTURE_CUBE_MAP_POSITIVE_Z_EXT); //#define GL_TEXTURE_CUBE_MAP_POSITIVE_Z_EXT 0x8519
#endif
#ifdef GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_EXT
ConstScriptSub("GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_EXT",GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_EXT); //#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_EXT 0x851A
#endif
#ifdef GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT
ConstScriptSub("GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT",GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT); //#define GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT 0x84FF
#endif
#ifdef GL_VERTEX_WEIGHT_ARRAY_STRIDE_EXT
ConstScriptSub("GL_VERTEX_WEIGHT_ARRAY_STRIDE_EXT",GL_VERTEX_WEIGHT_ARRAY_STRIDE_EXT); //#define GL_VERTEX_WEIGHT_ARRAY_STRIDE_EXT 0x850F
#endif
#ifdef GL_VERTEX_WEIGHT_ARRAY_POINTER_EXT
ConstScriptSub("GL_VERTEX_WEIGHT_ARRAY_POINTER_EXT",GL_VERTEX_WEIGHT_ARRAY_POINTER_EXT); //#define GL_VERTEX_WEIGHT_ARRAY_POINTER_EXT 0x8510
#endif
#ifdef GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV
ConstScriptSub("GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV",GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV); //#define GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV 0x8520
#endif
#ifdef GL_SPARE0_PLUS_SECONDARY_COLOR_NV
ConstScriptSub("GL_SPARE0_PLUS_SECONDARY_COLOR_NV",GL_SPARE0_PLUS_SECONDARY_COLOR_NV); //#define GL_SPARE0_PLUS_SECONDARY_COLOR_NV 0x8532
#endif
#ifdef GL_SECONDARY_COLOR_ARRAY_LIST_IBM
ConstScriptSub("GL_SECONDARY_COLOR_ARRAY_LIST_IBM",GL_SECONDARY_COLOR_ARRAY_LIST_IBM); //#define GL_SECONDARY_COLOR_ARRAY_LIST_IBM 103077
#endif
#ifdef GL_TEXTURE_COORD_ARRAY_LIST_STRIDE_IBM
ConstScriptSub("GL_TEXTURE_COORD_ARRAY_LIST_STRIDE_IBM",GL_TEXTURE_COORD_ARRAY_LIST_STRIDE_IBM); //#define GL_TEXTURE_COORD_ARRAY_LIST_STRIDE_IBM 103084
#endif
#ifdef GL_EDGE_FLAG_ARRAY_LIST_STRIDE_IBM
ConstScriptSub("GL_EDGE_FLAG_ARRAY_LIST_STRIDE_IBM",GL_EDGE_FLAG_ARRAY_LIST_STRIDE_IBM); //#define GL_EDGE_FLAG_ARRAY_LIST_STRIDE_IBM 103085
#endif
#ifdef GL_FOG_COORDINATE_ARRAY_LIST_STRIDE_IBM
ConstScriptSub("GL_FOG_COORDINATE_ARRAY_LIST_STRIDE_IBM",GL_FOG_COORDINATE_ARRAY_LIST_STRIDE_IBM); //#define GL_FOG_COORDINATE_ARRAY_LIST_STRIDE_IBM 103086
#endif
#ifdef GL_SECONDARY_COLOR_ARRAY_LIST_STRIDE_IBM
ConstScriptSub("GL_SECONDARY_COLOR_ARRAY_LIST_STRIDE_IBM",GL_SECONDARY_COLOR_ARRAY_LIST_STRIDE_IBM); //#define GL_SECONDARY_COLOR_ARRAY_LIST_STRIDE_IBM 103087
#endif
#ifdef GL_DEPTH_PASS_INSTRUMENT_COUNTERS_SGIX
ConstScriptSub("GL_DEPTH_PASS_INSTRUMENT_COUNTERS_SGIX",GL_DEPTH_PASS_INSTRUMENT_COUNTERS_SGIX); //#define GL_DEPTH_PASS_INSTRUMENT_COUNTERS_SGIX 0x8311
#endif
#ifdef GL_DEPTH_PASS_INSTRUMENT_MAX_SGIX
ConstScriptSub("GL_DEPTH_PASS_INSTRUMENT_MAX_SGIX",GL_DEPTH_PASS_INSTRUMENT_MAX_SGIX); //#define GL_DEPTH_PASS_INSTRUMENT_MAX_SGIX 0x8312
#endif
#ifdef GL_EVAL_FRACTIONAL_TESSELLATION_NV
ConstScriptSub("GL_EVAL_FRACTIONAL_TESSELLATION_NV",GL_EVAL_FRACTIONAL_TESSELLATION_NV); //#define GL_EVAL_FRACTIONAL_TESSELLATION_NV 0x86C5
#endif
#ifdef GL_OFFSET_TEXTURE_RECTANGLE_SCALE_NV
ConstScriptSub("GL_OFFSET_TEXTURE_RECTANGLE_SCALE_NV",GL_OFFSET_TEXTURE_RECTANGLE_SCALE_NV); //#define GL_OFFSET_TEXTURE_RECTANGLE_SCALE_NV 0x864D
#endif
#ifdef GL_DOT_PRODUCT_TEXTURE_RECTANGLE_NV
ConstScriptSub("GL_DOT_PRODUCT_TEXTURE_RECTANGLE_NV",GL_DOT_PRODUCT_TEXTURE_RECTANGLE_NV); //#define GL_DOT_PRODUCT_TEXTURE_RECTANGLE_NV 0x864E
#endif
#ifdef GL_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV
ConstScriptSub("GL_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV",GL_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV); //#define GL_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV 0x86D9
#endif
#ifdef GL_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV
ConstScriptSub("GL_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV",GL_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV); //#define GL_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV 0x86F0
#endif
#ifdef GL_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV
ConstScriptSub("GL_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV",GL_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV); //#define GL_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV 0x86F1
#endif
#ifdef GL_DOT_PRODUCT_REFLECT_CUBE_MAP_NV
ConstScriptSub("GL_DOT_PRODUCT_REFLECT_CUBE_MAP_NV",GL_DOT_PRODUCT_REFLECT_CUBE_MAP_NV); //#define GL_DOT_PRODUCT_REFLECT_CUBE_MAP_NV 0x86F2
#endif
#ifdef GL_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV
ConstScriptSub("GL_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV",GL_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV); //#define GL_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV 0x86F3
#endif
#ifdef GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV
ConstScriptSub("GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV",GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV); //#define GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV 0x870D
#endif
#ifdef GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV
ConstScriptSub("GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV",GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV); //#define GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV 0x8533
#endif
#ifdef GL_MAX_TRACK_MATRIX_STACK_DEPTH_NV
ConstScriptSub("GL_MAX_TRACK_MATRIX_STACK_DEPTH_NV",GL_MAX_TRACK_MATRIX_STACK_DEPTH_NV); //#define GL_MAX_TRACK_MATRIX_STACK_DEPTH_NV 0x862E
#endif
#ifdef GL_NUM_INPUT_INTERPOLATOR_COMPONENTS_ATI
ConstScriptSub("GL_NUM_INPUT_INTERPOLATOR_COMPONENTS_ATI",GL_NUM_INPUT_INTERPOLATOR_COMPONENTS_ATI); //#define GL_NUM_INPUT_INTERPOLATOR_COMPONENTS_ATI 0x8973
#endif
#ifdef GL_MAX_PN_TRIANGLES_TESSELATION_LEVEL_ATI
ConstScriptSub("GL_MAX_PN_TRIANGLES_TESSELATION_LEVEL_ATI",GL_MAX_PN_TRIANGLES_TESSELATION_LEVEL_ATI); //#define GL_MAX_PN_TRIANGLES_TESSELATION_LEVEL_ATI 0x87F1
#endif
#ifdef GL_PN_TRIANGLES_TESSELATION_LEVEL_ATI
ConstScriptSub("GL_PN_TRIANGLES_TESSELATION_LEVEL_ATI",GL_PN_TRIANGLES_TESSELATION_LEVEL_ATI); //#define GL_PN_TRIANGLES_TESSELATION_LEVEL_ATI 0x87F4
#endif
#ifdef GL_PN_TRIANGLES_POINT_MODE_LINEAR_ATI
ConstScriptSub("GL_PN_TRIANGLES_POINT_MODE_LINEAR_ATI",GL_PN_TRIANGLES_POINT_MODE_LINEAR_ATI); //#define GL_PN_TRIANGLES_POINT_MODE_LINEAR_ATI 0x87F5
#endif
#ifdef GL_PN_TRIANGLES_POINT_MODE_CUBIC_ATI
ConstScriptSub("GL_PN_TRIANGLES_POINT_MODE_CUBIC_ATI",GL_PN_TRIANGLES_POINT_MODE_CUBIC_ATI); //#define GL_PN_TRIANGLES_POINT_MODE_CUBIC_ATI 0x87F6
#endif
#ifdef GL_PN_TRIANGLES_NORMAL_MODE_LINEAR_ATI
ConstScriptSub("GL_PN_TRIANGLES_NORMAL_MODE_LINEAR_ATI",GL_PN_TRIANGLES_NORMAL_MODE_LINEAR_ATI); //#define GL_PN_TRIANGLES_NORMAL_MODE_LINEAR_ATI 0x87F7
#endif
#ifdef GL_PN_TRIANGLES_NORMAL_MODE_QUADRATIC_ATI
ConstScriptSub("GL_PN_TRIANGLES_NORMAL_MODE_QUADRATIC_ATI",GL_PN_TRIANGLES_NORMAL_MODE_QUADRATIC_ATI); //#define GL_PN_TRIANGLES_NORMAL_MODE_QUADRATIC_ATI 0x87F8
#endif
#ifdef GL_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT
ConstScriptSub("GL_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT",GL_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT); //#define GL_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT 0x87C5
#endif
#ifdef GL_MAX_VERTEX_SHADER_VARIANTS_EXT
ConstScriptSub("GL_MAX_VERTEX_SHADER_VARIANTS_EXT",GL_MAX_VERTEX_SHADER_VARIANTS_EXT); //#define GL_MAX_VERTEX_SHADER_VARIANTS_EXT 0x87C6
#endif
#ifdef GL_MAX_VERTEX_SHADER_INVARIANTS_EXT
ConstScriptSub("GL_MAX_VERTEX_SHADER_INVARIANTS_EXT",GL_MAX_VERTEX_SHADER_INVARIANTS_EXT); //#define GL_MAX_VERTEX_SHADER_INVARIANTS_EXT 0x87C7
#endif
#ifdef GL_MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT
ConstScriptSub("GL_MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT",GL_MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT); //#define GL_MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT 0x87C8
#endif
#ifdef GL_MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT
ConstScriptSub("GL_MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT",GL_MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT); //#define GL_MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT 0x87CA
#endif
#ifdef GL_MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT
ConstScriptSub("GL_MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT",GL_MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT); //#define GL_MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT 0x87CB
#endif
#ifdef GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT
ConstScriptSub("GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT",GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT); //#define GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT 0x87CC
#endif
#ifdef GL_MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT
ConstScriptSub("GL_MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT",GL_MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT); //#define GL_MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT 0x87CD
#endif
#ifdef GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT
ConstScriptSub("GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT",GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT); //#define GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT 0x87CE
#endif
#ifdef GL_VERTEX_SHADER_INSTRUCTIONS_EXT
ConstScriptSub("GL_VERTEX_SHADER_INSTRUCTIONS_EXT",GL_VERTEX_SHADER_INSTRUCTIONS_EXT); //#define GL_VERTEX_SHADER_INSTRUCTIONS_EXT 0x87CF
#endif
#ifdef GL_VERTEX_SHADER_LOCAL_CONSTANTS_EXT
ConstScriptSub("GL_VERTEX_SHADER_LOCAL_CONSTANTS_EXT",GL_VERTEX_SHADER_LOCAL_CONSTANTS_EXT); //#define GL_VERTEX_SHADER_LOCAL_CONSTANTS_EXT 0x87D2
#endif
#ifdef GL_OFFSET_PROJECTIVE_TEXTURE_2D_NV
ConstScriptSub("GL_OFFSET_PROJECTIVE_TEXTURE_2D_NV",GL_OFFSET_PROJECTIVE_TEXTURE_2D_NV); //#define GL_OFFSET_PROJECTIVE_TEXTURE_2D_NV 0x8850
#endif
#ifdef GL_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV
ConstScriptSub("GL_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV",GL_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV); //#define GL_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV 0x8851
#endif
#ifdef GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV
ConstScriptSub("GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV",GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV); //#define GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV 0x8852
#endif
#ifdef GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV
ConstScriptSub("GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV",GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV); //#define GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV 0x8853
#endif
#ifdef GL_OFFSET_HILO_TEXTURE_RECTANGLE_NV
ConstScriptSub("GL_OFFSET_HILO_TEXTURE_RECTANGLE_NV",GL_OFFSET_HILO_TEXTURE_RECTANGLE_NV); //#define GL_OFFSET_HILO_TEXTURE_RECTANGLE_NV 0x8855
#endif
#ifdef GL_OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV
ConstScriptSub("GL_OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV",GL_OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV); //#define GL_OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV 0x8856
#endif
#ifdef GL_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV
ConstScriptSub("GL_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV",GL_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV); //#define GL_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV 0x8857
#endif
#ifdef GL_DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV
ConstScriptSub("GL_DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV",GL_DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV); //#define GL_DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV 0x885A
#endif
#ifdef GL_DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV
ConstScriptSub("GL_DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV",GL_DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV); //#define GL_DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV 0x885D
#endif
#ifdef GL_VERTEX_ARRAY_RANGE_LENGTH_APPLE
ConstScriptSub("GL_VERTEX_ARRAY_RANGE_LENGTH_APPLE",GL_VERTEX_ARRAY_RANGE_LENGTH_APPLE); //#define GL_VERTEX_ARRAY_RANGE_LENGTH_APPLE 0x851E
#endif
#ifdef GL_VERTEX_ARRAY_STORAGE_HINT_APPLE
ConstScriptSub("GL_VERTEX_ARRAY_STORAGE_HINT_APPLE",GL_VERTEX_ARRAY_STORAGE_HINT_APPLE); //#define GL_VERTEX_ARRAY_STORAGE_HINT_APPLE 0x851F
#endif
#ifdef GL_VERTEX_ARRAY_RANGE_POINTER_APPLE
ConstScriptSub("GL_VERTEX_ARRAY_RANGE_POINTER_APPLE",GL_VERTEX_ARRAY_RANGE_POINTER_APPLE); //#define GL_VERTEX_ARRAY_RANGE_POINTER_APPLE 0x8521
#endif
#ifdef GL_COLOR_CLEAR_UNCLAMPED_VALUE_ATI
ConstScriptSub("GL_COLOR_CLEAR_UNCLAMPED_VALUE_ATI",GL_COLOR_CLEAR_UNCLAMPED_VALUE_ATI); //#define GL_COLOR_CLEAR_UNCLAMPED_VALUE_ATI 0x8835
#endif
#ifdef GL_MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV
ConstScriptSub("GL_MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV",GL_MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV); //#define GL_MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV 0x8868
#endif
#ifdef GL_WRITE_PIXEL_DATA_RANGE_LENGTH_NV
ConstScriptSub("GL_WRITE_PIXEL_DATA_RANGE_LENGTH_NV",GL_WRITE_PIXEL_DATA_RANGE_LENGTH_NV); //#define GL_WRITE_PIXEL_DATA_RANGE_LENGTH_NV 0x887A
#endif
#ifdef GL_READ_PIXEL_DATA_RANGE_LENGTH_NV
ConstScriptSub("GL_READ_PIXEL_DATA_RANGE_LENGTH_NV",GL_READ_PIXEL_DATA_RANGE_LENGTH_NV); //#define GL_READ_PIXEL_DATA_RANGE_LENGTH_NV 0x887B
#endif
#ifdef GL_WRITE_PIXEL_DATA_RANGE_POINTER_NV
ConstScriptSub("GL_WRITE_PIXEL_DATA_RANGE_POINTER_NV",GL_WRITE_PIXEL_DATA_RANGE_POINTER_NV); //#define GL_WRITE_PIXEL_DATA_RANGE_POINTER_NV 0x887C
#endif
#ifdef GL_READ_PIXEL_DATA_RANGE_POINTER_NV
ConstScriptSub("GL_READ_PIXEL_DATA_RANGE_POINTER_NV",GL_READ_PIXEL_DATA_RANGE_POINTER_NV); //#define GL_READ_PIXEL_DATA_RANGE_POINTER_NV 0x887D
#endif
#ifdef GL_TEXTURE_UNSIGNED_REMAP_MODE_NV
ConstScriptSub("GL_TEXTURE_UNSIGNED_REMAP_MODE_NV",GL_TEXTURE_UNSIGNED_REMAP_MODE_NV); //#define GL_TEXTURE_UNSIGNED_REMAP_MODE_NV 0x888F
#endif
#ifdef GL_STENCIL_BACK_PASS_DEPTH_FAIL_ATI
ConstScriptSub("GL_STENCIL_BACK_PASS_DEPTH_FAIL_ATI",GL_STENCIL_BACK_PASS_DEPTH_FAIL_ATI); //#define GL_STENCIL_BACK_PASS_DEPTH_FAIL_ATI 0x8802
#endif
#ifdef GL_STENCIL_BACK_PASS_DEPTH_PASS_ATI
ConstScriptSub("GL_STENCIL_BACK_PASS_DEPTH_PASS_ATI",GL_STENCIL_BACK_PASS_DEPTH_PASS_ATI); //#define GL_STENCIL_BACK_PASS_DEPTH_PASS_ATI 0x8803
#endif
#ifdef GL_IMPLEMENTATION_COLOR_READ_TYPE_OES
ConstScriptSub("GL_IMPLEMENTATION_COLOR_READ_TYPE_OES",GL_IMPLEMENTATION_COLOR_READ_TYPE_OES); //#define GL_IMPLEMENTATION_COLOR_READ_TYPE_OES 0x8B9A
#endif
#ifdef GL_IMPLEMENTATION_COLOR_READ_FORMAT_OES
ConstScriptSub("GL_IMPLEMENTATION_COLOR_READ_FORMAT_OES",GL_IMPLEMENTATION_COLOR_READ_FORMAT_OES); //#define GL_IMPLEMENTATION_COLOR_READ_FORMAT_OES 0x8B9B
#endif
#ifdef GL_PIXEL_UNPACK_BUFFER_BINDING_EXT
ConstScriptSub("GL_PIXEL_UNPACK_BUFFER_BINDING_EXT",GL_PIXEL_UNPACK_BUFFER_BINDING_EXT); //#define GL_PIXEL_UNPACK_BUFFER_BINDING_EXT 0x88EF
#endif
#ifdef GL_MAX_PROGRAM_EXEC_INSTRUCTIONS_NV
ConstScriptSub("GL_MAX_PROGRAM_EXEC_INSTRUCTIONS_NV",GL_MAX_PROGRAM_EXEC_INSTRUCTIONS_NV); //#define GL_MAX_PROGRAM_EXEC_INSTRUCTIONS_NV 0x88F4
#endif
#ifdef GL_INVALID_FRAMEBUFFER_OPERATION_EXT
ConstScriptSub("GL_INVALID_FRAMEBUFFER_OPERATION_EXT",GL_INVALID_FRAMEBUFFER_OPERATION_EXT); //#define GL_INVALID_FRAMEBUFFER_OPERATION_EXT 0x0506
#endif
#ifdef GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT
ConstScriptSub("GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT",GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT); //#define GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT 0x8CD0
#endif
#ifdef GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT
ConstScriptSub("GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT",GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT); //#define GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT 0x8CD1
#endif
#ifdef GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT
ConstScriptSub("GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT",GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT); //#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT 0x8CD2
#endif
#ifdef GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT
ConstScriptSub("GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT",GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT); //#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT 0x8CD3
#endif
#ifdef GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT
ConstScriptSub("GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT",GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT); //#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT 0x8CD4
#endif
#ifdef GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT
ConstScriptSub("GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT",GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT); //#define GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT 0x8CD6
#endif
#ifdef GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT
ConstScriptSub("GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT",GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT); //#define GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT 0x8CD7
#endif
#ifdef GL_FRAMEBUFFER_INCOMPLETE_DUPLICATE_ATTACHMENT_EXT
ConstScriptSub("GL_FRAMEBUFFER_INCOMPLETE_DUPLICATE_ATTACHMENT_EXT",GL_FRAMEBUFFER_INCOMPLETE_DUPLICATE_ATTACHMENT_EXT); //#define GL_FRAMEBUFFER_INCOMPLETE_DUPLICATE_ATTACHMENT_EXT 0x8CD8
#endif
#ifdef GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT
ConstScriptSub("GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT",GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT); //#define GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT 0x8CD9
#endif
#ifdef GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT
ConstScriptSub("GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT",GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT); //#define GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT 0x8CDA
#endif
#ifdef GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT
ConstScriptSub("GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT",GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT); //#define GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT 0x8CDB
#endif
#ifdef GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT
ConstScriptSub("GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT",GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT); //#define GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT 0x8CDC
#endif
#ifdef GL_RENDERBUFFER_INTERNAL_FORMAT_EXT
ConstScriptSub("GL_RENDERBUFFER_INTERNAL_FORMAT_EXT",GL_RENDERBUFFER_INTERNAL_FORMAT_EXT); //#define GL_RENDERBUFFER_INTERNAL_FORMAT_EXT 0x8D44
#endif
#ifdef GL_VERSION_1_2
ConstScriptSub("GL_VERSION_1_2",GL_VERSION_1_2); //#define GL_VERSION_1_2 1
#endif
#ifdef GL_VERSION_1_3
ConstScriptSub("GL_VERSION_1_3",GL_VERSION_1_3); //#define GL_VERSION_1_3 1
#endif
#ifdef GL_VERSION_1_4
ConstScriptSub("GL_VERSION_1_4",GL_VERSION_1_4); //#define GL_VERSION_1_4 1
#endif
#ifdef GL_VERSION_1_5
ConstScriptSub("GL_VERSION_1_5",GL_VERSION_1_5); //#define GL_VERSION_1_5 1
#endif
#ifdef GL_VERSION_2_0
ConstScriptSub("GL_VERSION_2_0",GL_VERSION_2_0); //#define GL_VERSION_2_0 1
#endif
#ifdef GL_ARB_multitexture
ConstScriptSub("GL_ARB_multitexture",GL_ARB_multitexture); //#define GL_ARB_multitexture 1
#endif
#ifdef GL_ARB_transpose_matrix
ConstScriptSub("GL_ARB_transpose_matrix",GL_ARB_transpose_matrix); //#define GL_ARB_transpose_matrix 1
#endif
#ifdef GL_ARB_multisample
ConstScriptSub("GL_ARB_multisample",GL_ARB_multisample); //#define GL_ARB_multisample 1
#endif
#ifdef GL_ARB_texture_env_add
ConstScriptSub("GL_ARB_texture_env_add",GL_ARB_texture_env_add); //#define GL_ARB_texture_env_add 1
#endif
#ifdef GL_ARB_texture_cube_map
ConstScriptSub("GL_ARB_texture_cube_map",GL_ARB_texture_cube_map); //#define GL_ARB_texture_cube_map 1
#endif
#ifdef GL_ARB_texture_compression
ConstScriptSub("GL_ARB_texture_compression",GL_ARB_texture_compression); //#define GL_ARB_texture_compression 1
#endif
#ifdef GL_ARB_texture_border_clamp
ConstScriptSub("GL_ARB_texture_border_clamp",GL_ARB_texture_border_clamp); //#define GL_ARB_texture_border_clamp 1
#endif
#ifdef GL_ARB_point_parameters
ConstScriptSub("GL_ARB_point_parameters",GL_ARB_point_parameters); //#define GL_ARB_point_parameters 1
#endif
#ifdef GL_ARB_vertex_blend
ConstScriptSub("GL_ARB_vertex_blend",GL_ARB_vertex_blend); //#define GL_ARB_vertex_blend 1
#endif
#ifdef GL_ARB_matrix_palette
ConstScriptSub("GL_ARB_matrix_palette",GL_ARB_matrix_palette); //#define GL_ARB_matrix_palette 1
#endif
#ifdef GL_ARB_texture_env_combine
ConstScriptSub("GL_ARB_texture_env_combine",GL_ARB_texture_env_combine); //#define GL_ARB_texture_env_combine 1
#endif
#ifdef GL_ARB_texture_env_crossbar
ConstScriptSub("GL_ARB_texture_env_crossbar",GL_ARB_texture_env_crossbar); //#define GL_ARB_texture_env_crossbar 1
#endif
#ifdef GL_ARB_texture_env_dot3
ConstScriptSub("GL_ARB_texture_env_dot3",GL_ARB_texture_env_dot3); //#define GL_ARB_texture_env_dot3 1
#endif
#ifdef GL_ARB_texture_mirrored_repeat
ConstScriptSub("GL_ARB_texture_mirrored_repeat",GL_ARB_texture_mirrored_repeat); //#define GL_ARB_texture_mirrored_repeat 1
#endif
#ifdef GL_ARB_depth_texture
ConstScriptSub("GL_ARB_depth_texture",GL_ARB_depth_texture); //#define GL_ARB_depth_texture 1
#endif
#ifdef GL_ARB_shadow
ConstScriptSub("GL_ARB_shadow",GL_ARB_shadow); //#define GL_ARB_shadow 1
#endif
#ifdef GL_ARB_shadow_ambient
ConstScriptSub("GL_ARB_shadow_ambient",GL_ARB_shadow_ambient); //#define GL_ARB_shadow_ambient 1
#endif
#ifdef GL_ARB_window_pos
ConstScriptSub("GL_ARB_window_pos",GL_ARB_window_pos); //#define GL_ARB_window_pos 1
#endif
#ifdef GL_ARB_vertex_program
ConstScriptSub("GL_ARB_vertex_program",GL_ARB_vertex_program); //#define GL_ARB_vertex_program 1
#endif
#ifdef GL_ARB_fragment_program
ConstScriptSub("GL_ARB_fragment_program",GL_ARB_fragment_program); //#define GL_ARB_fragment_program 1
#endif
#ifdef GL_ARB_vertex_buffer_object
ConstScriptSub("GL_ARB_vertex_buffer_object",GL_ARB_vertex_buffer_object); //#define GL_ARB_vertex_buffer_object 1
#endif
#ifdef GL_ARB_occlusion_query
ConstScriptSub("GL_ARB_occlusion_query",GL_ARB_occlusion_query); //#define GL_ARB_occlusion_query 1
#endif
#ifdef GL_ARB_shader_objects
ConstScriptSub("GL_ARB_shader_objects",GL_ARB_shader_objects); //#define GL_ARB_shader_objects 1
#endif
#ifdef GL_ARB_vertex_shader
ConstScriptSub("GL_ARB_vertex_shader",GL_ARB_vertex_shader); //#define GL_ARB_vertex_shader 1
#endif
#ifdef GL_ARB_fragment_shader
ConstScriptSub("GL_ARB_fragment_shader",GL_ARB_fragment_shader); //#define GL_ARB_fragment_shader 1
#endif
#ifdef GL_ARB_shading_language_100
ConstScriptSub("GL_ARB_shading_language_100",GL_ARB_shading_language_100); //#define GL_ARB_shading_language_100 1
#endif
#ifdef GL_ARB_texture_non_power_of_two
ConstScriptSub("GL_ARB_texture_non_power_of_two",GL_ARB_texture_non_power_of_two); //#define GL_ARB_texture_non_power_of_two 1
#endif
#ifdef GL_ARB_point_sprite
ConstScriptSub("GL_ARB_point_sprite",GL_ARB_point_sprite); //#define GL_ARB_point_sprite 1
#endif
#ifdef GL_ARB_fragment_program_shadow
ConstScriptSub("GL_ARB_fragment_program_shadow",GL_ARB_fragment_program_shadow); //#define GL_ARB_fragment_program_shadow 1
#endif
#ifdef GL_ARB_draw_buffers
ConstScriptSub("GL_ARB_draw_buffers",GL_ARB_draw_buffers); //#define GL_ARB_draw_buffers 1
#endif
#ifdef GL_ARB_texture_rectangle
ConstScriptSub("GL_ARB_texture_rectangle",GL_ARB_texture_rectangle); //#define GL_ARB_texture_rectangle 1
#endif
#ifdef GL_ARB_color_buffer_float
ConstScriptSub("GL_ARB_color_buffer_float",GL_ARB_color_buffer_float); //#define GL_ARB_color_buffer_float 1
#endif
#ifdef GL_ARB_half_float_pixel
ConstScriptSub("GL_ARB_half_float_pixel",GL_ARB_half_float_pixel); //#define GL_ARB_half_float_pixel 1
#endif
#ifdef GL_ARB_texture_float
ConstScriptSub("GL_ARB_texture_float",GL_ARB_texture_float); //#define GL_ARB_texture_float 1
#endif
#ifdef GL_ARB_pixel_buffer_object
ConstScriptSub("GL_ARB_pixel_buffer_object",GL_ARB_pixel_buffer_object); //#define GL_ARB_pixel_buffer_object 1
#endif
#ifdef GL_EXT_abgr
ConstScriptSub("GL_EXT_abgr",GL_EXT_abgr); //#define GL_EXT_abgr 1
#endif
#ifdef GL_EXT_blend_color
ConstScriptSub("GL_EXT_blend_color",GL_EXT_blend_color); //#define GL_EXT_blend_color 1
#endif
#ifdef GL_EXT_polygon_offset
ConstScriptSub("GL_EXT_polygon_offset",GL_EXT_polygon_offset); //#define GL_EXT_polygon_offset 1
#endif
#ifdef GL_EXT_texture
ConstScriptSub("GL_EXT_texture",GL_EXT_texture); //#define GL_EXT_texture 1
#endif
#ifdef GL_EXT_texture3D
ConstScriptSub("GL_EXT_texture3D",GL_EXT_texture3D); //#define GL_EXT_texture3D 1
#endif
#ifdef GL_SGIS_texture_filter4
ConstScriptSub("GL_SGIS_texture_filter4",GL_SGIS_texture_filter4); //#define GL_SGIS_texture_filter4 1
#endif
#ifdef GL_EXT_subtexture
ConstScriptSub("GL_EXT_subtexture",GL_EXT_subtexture); //#define GL_EXT_subtexture 1
#endif
#ifdef GL_EXT_copy_texture
ConstScriptSub("GL_EXT_copy_texture",GL_EXT_copy_texture); //#define GL_EXT_copy_texture 1
#endif
#ifdef GL_EXT_histogram
ConstScriptSub("GL_EXT_histogram",GL_EXT_histogram); //#define GL_EXT_histogram 1
#endif
#ifdef GL_EXT_convolution
ConstScriptSub("GL_EXT_convolution",GL_EXT_convolution); //#define GL_EXT_convolution 1
#endif
#ifdef GL_EXT_color_matrix
ConstScriptSub("GL_EXT_color_matrix",GL_EXT_color_matrix); //#define GL_EXT_color_matrix 1
#endif
#ifdef GL_SGI_color_table
ConstScriptSub("GL_SGI_color_table",GL_SGI_color_table); //#define GL_SGI_color_table 1
#endif
#ifdef GL_SGIX_pixel_texture
ConstScriptSub("GL_SGIX_pixel_texture",GL_SGIX_pixel_texture); //#define GL_SGIX_pixel_texture 1
#endif
#ifdef GL_SGIS_pixel_texture
ConstScriptSub("GL_SGIS_pixel_texture",GL_SGIS_pixel_texture); //#define GL_SGIS_pixel_texture 1
#endif
#ifdef GL_SGIS_texture4D
ConstScriptSub("GL_SGIS_texture4D",GL_SGIS_texture4D); //#define GL_SGIS_texture4D 1
#endif
#ifdef GL_SGI_texture_color_table
ConstScriptSub("GL_SGI_texture_color_table",GL_SGI_texture_color_table); //#define GL_SGI_texture_color_table 1
#endif
#ifdef GL_EXT_cmyka
ConstScriptSub("GL_EXT_cmyka",GL_EXT_cmyka); //#define GL_EXT_cmyka 1
#endif
#ifdef GL_EXT_texture_object
ConstScriptSub("GL_EXT_texture_object",GL_EXT_texture_object); //#define GL_EXT_texture_object 1
#endif
#ifdef GL_SGIS_detail_texture
ConstScriptSub("GL_SGIS_detail_texture",GL_SGIS_detail_texture); //#define GL_SGIS_detail_texture 1
#endif
#ifdef GL_SGIS_sharpen_texture
ConstScriptSub("GL_SGIS_sharpen_texture",GL_SGIS_sharpen_texture); //#define GL_SGIS_sharpen_texture 1
#endif
#ifdef GL_EXT_packed_pixels
ConstScriptSub("GL_EXT_packed_pixels",GL_EXT_packed_pixels); //#define GL_EXT_packed_pixels 1
#endif
#ifdef GL_SGIS_texture_lod
ConstScriptSub("GL_SGIS_texture_lod",GL_SGIS_texture_lod); //#define GL_SGIS_texture_lod 1
#endif
#ifdef GL_SGIS_multisample
ConstScriptSub("GL_SGIS_multisample",GL_SGIS_multisample); //#define GL_SGIS_multisample 1
#endif
#ifdef GL_EXT_rescale_normal
ConstScriptSub("GL_EXT_rescale_normal",GL_EXT_rescale_normal); //#define GL_EXT_rescale_normal 1
#endif
#ifdef GL_EXT_vertex_array
ConstScriptSub("GL_EXT_vertex_array",GL_EXT_vertex_array); //#define GL_EXT_vertex_array 1
#endif
#ifdef GL_EXT_misc_attribute
ConstScriptSub("GL_EXT_misc_attribute",GL_EXT_misc_attribute); //#define GL_EXT_misc_attribute 1
#endif
#ifdef GL_SGIS_generate_mipmap
ConstScriptSub("GL_SGIS_generate_mipmap",GL_SGIS_generate_mipmap); //#define GL_SGIS_generate_mipmap 1
#endif
#ifdef GL_SGIX_clipmap
ConstScriptSub("GL_SGIX_clipmap",GL_SGIX_clipmap); //#define GL_SGIX_clipmap 1
#endif
#ifdef GL_SGIX_shadow
ConstScriptSub("GL_SGIX_shadow",GL_SGIX_shadow); //#define GL_SGIX_shadow 1
#endif
#ifdef GL_SGIS_texture_edge_clamp
ConstScriptSub("GL_SGIS_texture_edge_clamp",GL_SGIS_texture_edge_clamp); //#define GL_SGIS_texture_edge_clamp 1
#endif
#ifdef GL_SGIS_texture_border_clamp
ConstScriptSub("GL_SGIS_texture_border_clamp",GL_SGIS_texture_border_clamp); //#define GL_SGIS_texture_border_clamp 1
#endif
#ifdef GL_EXT_blend_minmax
ConstScriptSub("GL_EXT_blend_minmax",GL_EXT_blend_minmax); //#define GL_EXT_blend_minmax 1
#endif
#ifdef GL_EXT_blend_subtract
ConstScriptSub("GL_EXT_blend_subtract",GL_EXT_blend_subtract); //#define GL_EXT_blend_subtract 1
#endif
#ifdef GL_EXT_blend_logic_op
ConstScriptSub("GL_EXT_blend_logic_op",GL_EXT_blend_logic_op); //#define GL_EXT_blend_logic_op 1
#endif
#ifdef GL_SGIX_interlace
ConstScriptSub("GL_SGIX_interlace",GL_SGIX_interlace); //#define GL_SGIX_interlace 1
#endif
#ifdef GL_SGIX_pixel_tiles
ConstScriptSub("GL_SGIX_pixel_tiles",GL_SGIX_pixel_tiles); //#define GL_SGIX_pixel_tiles 1
#endif
#ifdef GL_SGIX_texture_select
ConstScriptSub("GL_SGIX_texture_select",GL_SGIX_texture_select); //#define GL_SGIX_texture_select 1
#endif
#ifdef GL_SGIX_sprite
ConstScriptSub("GL_SGIX_sprite",GL_SGIX_sprite); //#define GL_SGIX_sprite 1
#endif
#ifdef GL_SGIX_texture_multi_buffer
ConstScriptSub("GL_SGIX_texture_multi_buffer",GL_SGIX_texture_multi_buffer); //#define GL_SGIX_texture_multi_buffer 1
#endif
#ifdef GL_EXT_point_parameters
ConstScriptSub("GL_EXT_point_parameters",GL_EXT_point_parameters); //#define GL_EXT_point_parameters 1
#endif
#ifdef GL_SGIS_point_parameters
ConstScriptSub("GL_SGIS_point_parameters",GL_SGIS_point_parameters); //#define GL_SGIS_point_parameters 1
#endif
#ifdef GL_SGIX_instruments
ConstScriptSub("GL_SGIX_instruments",GL_SGIX_instruments); //#define GL_SGIX_instruments 1
#endif
#ifdef GL_SGIX_texture_scale_bias
ConstScriptSub("GL_SGIX_texture_scale_bias",GL_SGIX_texture_scale_bias); //#define GL_SGIX_texture_scale_bias 1
#endif
#ifdef GL_SGIX_framezoom
ConstScriptSub("GL_SGIX_framezoom",GL_SGIX_framezoom); //#define GL_SGIX_framezoom 1
#endif
#ifdef GL_SGIX_tag_sample_buffer
ConstScriptSub("GL_SGIX_tag_sample_buffer",GL_SGIX_tag_sample_buffer); //#define GL_SGIX_tag_sample_buffer 1
#endif
#ifdef GL_SGIX_polynomial_ffd
ConstScriptSub("GL_SGIX_polynomial_ffd",GL_SGIX_polynomial_ffd); //#define GL_SGIX_polynomial_ffd 1
#endif
#ifdef GL_SGIX_reference_plane
ConstScriptSub("GL_SGIX_reference_plane",GL_SGIX_reference_plane); //#define GL_SGIX_reference_plane 1
#endif
#ifdef GL_SGIX_flush_raster
ConstScriptSub("GL_SGIX_flush_raster",GL_SGIX_flush_raster); //#define GL_SGIX_flush_raster 1
#endif
#ifdef GL_SGIX_depth_texture
ConstScriptSub("GL_SGIX_depth_texture",GL_SGIX_depth_texture); //#define GL_SGIX_depth_texture 1
#endif
#ifdef GL_SGIS_fog_function
ConstScriptSub("GL_SGIS_fog_function",GL_SGIS_fog_function); //#define GL_SGIS_fog_function 1
#endif
#ifdef GL_SGIX_fog_offset
ConstScriptSub("GL_SGIX_fog_offset",GL_SGIX_fog_offset); //#define GL_SGIX_fog_offset 1
#endif
#ifdef GL_HP_image_transform
ConstScriptSub("GL_HP_image_transform",GL_HP_image_transform); //#define GL_HP_image_transform 1
#endif
#ifdef GL_HP_convolution_border_modes
ConstScriptSub("GL_HP_convolution_border_modes",GL_HP_convolution_border_modes); //#define GL_HP_convolution_border_modes 1
#endif
#ifdef GL_SGIX_texture_add_env
ConstScriptSub("GL_SGIX_texture_add_env",GL_SGIX_texture_add_env); //#define GL_SGIX_texture_add_env 1
#endif
#ifdef GL_EXT_color_subtable
ConstScriptSub("GL_EXT_color_subtable",GL_EXT_color_subtable); //#define GL_EXT_color_subtable 1
#endif
#ifdef GL_PGI_vertex_hints
ConstScriptSub("GL_PGI_vertex_hints",GL_PGI_vertex_hints); //#define GL_PGI_vertex_hints 1
#endif
#ifdef GL_PGI_misc_hints
ConstScriptSub("GL_PGI_misc_hints",GL_PGI_misc_hints); //#define GL_PGI_misc_hints 1
#endif
#ifdef GL_EXT_paletted_texture
ConstScriptSub("GL_EXT_paletted_texture",GL_EXT_paletted_texture); //#define GL_EXT_paletted_texture 1
#endif
#ifdef GL_EXT_clip_volume_hint
ConstScriptSub("GL_EXT_clip_volume_hint",GL_EXT_clip_volume_hint); //#define GL_EXT_clip_volume_hint 1
#endif
#ifdef GL_SGIX_list_priority
ConstScriptSub("GL_SGIX_list_priority",GL_SGIX_list_priority); //#define GL_SGIX_list_priority 1
#endif
#ifdef GL_SGIX_ir_instrument1
ConstScriptSub("GL_SGIX_ir_instrument1",GL_SGIX_ir_instrument1); //#define GL_SGIX_ir_instrument1 1
#endif
#ifdef GL_SGIX_calligraphic_fragment
ConstScriptSub("GL_SGIX_calligraphic_fragment",GL_SGIX_calligraphic_fragment); //#define GL_SGIX_calligraphic_fragment 1
#endif
#ifdef GL_SGIX_texture_lod_bias
ConstScriptSub("GL_SGIX_texture_lod_bias",GL_SGIX_texture_lod_bias); //#define GL_SGIX_texture_lod_bias 1
#endif
#ifdef GL_SGIX_shadow_ambient
ConstScriptSub("GL_SGIX_shadow_ambient",GL_SGIX_shadow_ambient); //#define GL_SGIX_shadow_ambient 1
#endif
#ifdef GL_EXT_index_texture
ConstScriptSub("GL_EXT_index_texture",GL_EXT_index_texture); //#define GL_EXT_index_texture 1
#endif
#ifdef GL_EXT_index_material
ConstScriptSub("GL_EXT_index_material",GL_EXT_index_material); //#define GL_EXT_index_material 1
#endif
#ifdef GL_EXT_index_func
ConstScriptSub("GL_EXT_index_func",GL_EXT_index_func); //#define GL_EXT_index_func 1
#endif
#ifdef GL_EXT_index_array_formats
ConstScriptSub("GL_EXT_index_array_formats",GL_EXT_index_array_formats); //#define GL_EXT_index_array_formats 1
#endif
#ifdef GL_EXT_compiled_vertex_array
ConstScriptSub("GL_EXT_compiled_vertex_array",GL_EXT_compiled_vertex_array); //#define GL_EXT_compiled_vertex_array 1
#endif
#ifdef GL_EXT_cull_vertex
ConstScriptSub("GL_EXT_cull_vertex",GL_EXT_cull_vertex); //#define GL_EXT_cull_vertex 1
#endif
#ifdef GL_SGIX_ycrcb
ConstScriptSub("GL_SGIX_ycrcb",GL_SGIX_ycrcb); //#define GL_SGIX_ycrcb 1
#endif
#ifdef GL_SGIX_fragment_lighting
ConstScriptSub("GL_SGIX_fragment_lighting",GL_SGIX_fragment_lighting); //#define GL_SGIX_fragment_lighting 1
#endif
#ifdef GL_IBM_rasterpos_clip
ConstScriptSub("GL_IBM_rasterpos_clip",GL_IBM_rasterpos_clip); //#define GL_IBM_rasterpos_clip 1
#endif
#ifdef GL_HP_texture_lighting
ConstScriptSub("GL_HP_texture_lighting",GL_HP_texture_lighting); //#define GL_HP_texture_lighting 1
#endif
#ifdef GL_EXT_draw_range_elements
ConstScriptSub("GL_EXT_draw_range_elements",GL_EXT_draw_range_elements); //#define GL_EXT_draw_range_elements 1
#endif
#ifdef GL_WIN_phong_shading
ConstScriptSub("GL_WIN_phong_shading",GL_WIN_phong_shading); //#define GL_WIN_phong_shading 1
#endif
#ifdef GL_WIN_specular_fog
ConstScriptSub("GL_WIN_specular_fog",GL_WIN_specular_fog); //#define GL_WIN_specular_fog 1
#endif
#ifdef GL_EXT_light_texture
ConstScriptSub("GL_EXT_light_texture",GL_EXT_light_texture); //#define GL_EXT_light_texture 1
#endif
#ifdef GL_SGIX_blend_alpha_minmax
ConstScriptSub("GL_SGIX_blend_alpha_minmax",GL_SGIX_blend_alpha_minmax); //#define GL_SGIX_blend_alpha_minmax 1
#endif
#ifdef GL_EXT_bgra
ConstScriptSub("GL_EXT_bgra",GL_EXT_bgra); //#define GL_EXT_bgra 1
#endif
#ifdef GL_SGIX_async
ConstScriptSub("GL_SGIX_async",GL_SGIX_async); //#define GL_SGIX_async 1
#endif
#ifdef GL_SGIX_async_pixel
ConstScriptSub("GL_SGIX_async_pixel",GL_SGIX_async_pixel); //#define GL_SGIX_async_pixel 1
#endif
#ifdef GL_SGIX_async_histogram
ConstScriptSub("GL_SGIX_async_histogram",GL_SGIX_async_histogram); //#define GL_SGIX_async_histogram 1
#endif
#ifdef GL_INTEL_parallel_arrays
ConstScriptSub("GL_INTEL_parallel_arrays",GL_INTEL_parallel_arrays); //#define GL_INTEL_parallel_arrays 1
#endif
#ifdef GL_HP_occlusion_test
ConstScriptSub("GL_HP_occlusion_test",GL_HP_occlusion_test); //#define GL_HP_occlusion_test 1
#endif
#ifdef GL_EXT_pixel_transform
ConstScriptSub("GL_EXT_pixel_transform",GL_EXT_pixel_transform); //#define GL_EXT_pixel_transform 1
#endif
#ifdef GL_EXT_pixel_transform_color_table
ConstScriptSub("GL_EXT_pixel_transform_color_table",GL_EXT_pixel_transform_color_table); //#define GL_EXT_pixel_transform_color_table 1
#endif
#ifdef GL_EXT_shared_texture_palette
ConstScriptSub("GL_EXT_shared_texture_palette",GL_EXT_shared_texture_palette); //#define GL_EXT_shared_texture_palette 1
#endif
#ifdef GL_EXT_separate_specular_color
ConstScriptSub("GL_EXT_separate_specular_color",GL_EXT_separate_specular_color); //#define GL_EXT_separate_specular_color 1
#endif
#ifdef GL_EXT_secondary_color
ConstScriptSub("GL_EXT_secondary_color",GL_EXT_secondary_color); //#define GL_EXT_secondary_color 1
#endif
#ifdef GL_EXT_texture_perturb_normal
ConstScriptSub("GL_EXT_texture_perturb_normal",GL_EXT_texture_perturb_normal); //#define GL_EXT_texture_perturb_normal 1
#endif
#ifdef GL_EXT_multi_draw_arrays
ConstScriptSub("GL_EXT_multi_draw_arrays",GL_EXT_multi_draw_arrays); //#define GL_EXT_multi_draw_arrays 1
#endif
#ifdef GL_EXT_fog_coord
ConstScriptSub("GL_EXT_fog_coord",GL_EXT_fog_coord); //#define GL_EXT_fog_coord 1
#endif
#ifdef GL_REND_screen_coordinates
ConstScriptSub("GL_REND_screen_coordinates",GL_REND_screen_coordinates); //#define GL_REND_screen_coordinates 1
#endif
#ifdef GL_EXT_coordinate_frame
ConstScriptSub("GL_EXT_coordinate_frame",GL_EXT_coordinate_frame); //#define GL_EXT_coordinate_frame 1
#endif
#ifdef GL_EXT_texture_env_combine
ConstScriptSub("GL_EXT_texture_env_combine",GL_EXT_texture_env_combine); //#define GL_EXT_texture_env_combine 1
#endif
#ifdef GL_APPLE_specular_vector
ConstScriptSub("GL_APPLE_specular_vector",GL_APPLE_specular_vector); //#define GL_APPLE_specular_vector 1
#endif
#ifdef GL_APPLE_transform_hint
ConstScriptSub("GL_APPLE_transform_hint",GL_APPLE_transform_hint); //#define GL_APPLE_transform_hint 1
#endif
#ifdef GL_SGIX_fog_scale
ConstScriptSub("GL_SGIX_fog_scale",GL_SGIX_fog_scale); //#define GL_SGIX_fog_scale 1
#endif
#ifdef GL_SUNX_constant_data
ConstScriptSub("GL_SUNX_constant_data",GL_SUNX_constant_data); //#define GL_SUNX_constant_data 1
#endif
#ifdef GL_SUN_global_alpha
ConstScriptSub("GL_SUN_global_alpha",GL_SUN_global_alpha); //#define GL_SUN_global_alpha 1
#endif
#ifdef GL_SUN_triangle_list
ConstScriptSub("GL_SUN_triangle_list",GL_SUN_triangle_list); //#define GL_SUN_triangle_list 1
#endif
#ifdef GL_SUN_vertex
ConstScriptSub("GL_SUN_vertex",GL_SUN_vertex); //#define GL_SUN_vertex 1
#endif
#ifdef GL_EXT_blend_func_separate
ConstScriptSub("GL_EXT_blend_func_separate",GL_EXT_blend_func_separate); //#define GL_EXT_blend_func_separate 1
#endif
#ifdef GL_INGR_blend_func_separate
ConstScriptSub("GL_INGR_blend_func_separate",GL_INGR_blend_func_separate); //#define GL_INGR_blend_func_separate 1
#endif
#ifdef GL_INGR_color_clamp
ConstScriptSub("GL_INGR_color_clamp",GL_INGR_color_clamp); //#define GL_INGR_color_clamp 1
#endif
#ifdef GL_INGR_interlace_read
ConstScriptSub("GL_INGR_interlace_read",GL_INGR_interlace_read); //#define GL_INGR_interlace_read 1
#endif
#ifdef GL_EXT_stencil_wrap
ConstScriptSub("GL_EXT_stencil_wrap",GL_EXT_stencil_wrap); //#define GL_EXT_stencil_wrap 1
#endif
#ifdef GL_EXT_422_pixels
ConstScriptSub("GL_EXT_422_pixels",GL_EXT_422_pixels); //#define GL_EXT_422_pixels 1
#endif
#ifdef GL_NV_texgen_reflection
ConstScriptSub("GL_NV_texgen_reflection",GL_NV_texgen_reflection); //#define GL_NV_texgen_reflection 1
#endif
#ifdef GL_SUN_convolution_border_modes
ConstScriptSub("GL_SUN_convolution_border_modes",GL_SUN_convolution_border_modes); //#define GL_SUN_convolution_border_modes 1
#endif
#ifdef GL_EXT_texture_env_add
ConstScriptSub("GL_EXT_texture_env_add",GL_EXT_texture_env_add); //#define GL_EXT_texture_env_add 1
#endif
#ifdef GL_EXT_texture_lod_bias
ConstScriptSub("GL_EXT_texture_lod_bias",GL_EXT_texture_lod_bias); //#define GL_EXT_texture_lod_bias 1
#endif
#ifdef GL_EXT_texture_filter_anisotropic
ConstScriptSub("GL_EXT_texture_filter_anisotropic",GL_EXT_texture_filter_anisotropic); //#define GL_EXT_texture_filter_anisotropic 1
#endif
#ifdef GL_EXT_vertex_weighting
ConstScriptSub("GL_EXT_vertex_weighting",GL_EXT_vertex_weighting); //#define GL_EXT_vertex_weighting 1
#endif
#ifdef GL_NV_light_max_exponent
ConstScriptSub("GL_NV_light_max_exponent",GL_NV_light_max_exponent); //#define GL_NV_light_max_exponent 1
#endif
#ifdef GL_NV_vertex_array_range
ConstScriptSub("GL_NV_vertex_array_range",GL_NV_vertex_array_range); //#define GL_NV_vertex_array_range 1
#endif
#ifdef GL_NV_register_combiners
ConstScriptSub("GL_NV_register_combiners",GL_NV_register_combiners); //#define GL_NV_register_combiners 1
#endif
#ifdef GL_NV_fog_distance
ConstScriptSub("GL_NV_fog_distance",GL_NV_fog_distance); //#define GL_NV_fog_distance 1
#endif
#ifdef GL_NV_texgen_emboss
ConstScriptSub("GL_NV_texgen_emboss",GL_NV_texgen_emboss); //#define GL_NV_texgen_emboss 1
#endif
#ifdef GL_NV_blend_square
ConstScriptSub("GL_NV_blend_square",GL_NV_blend_square); //#define GL_NV_blend_square 1
#endif
#ifdef GL_NV_texture_env_combine4
ConstScriptSub("GL_NV_texture_env_combine4",GL_NV_texture_env_combine4); //#define GL_NV_texture_env_combine4 1
#endif
#ifdef GL_MESA_resize_buffers
ConstScriptSub("GL_MESA_resize_buffers",GL_MESA_resize_buffers); //#define GL_MESA_resize_buffers 1
#endif
#ifdef GL_MESA_window_pos
ConstScriptSub("GL_MESA_window_pos",GL_MESA_window_pos); //#define GL_MESA_window_pos 1
#endif
#ifdef GL_IBM_cull_vertex
ConstScriptSub("GL_IBM_cull_vertex",GL_IBM_cull_vertex); //#define GL_IBM_cull_vertex 1
#endif
#ifdef GL_IBM_multimode_draw_arrays
ConstScriptSub("GL_IBM_multimode_draw_arrays",GL_IBM_multimode_draw_arrays); //#define GL_IBM_multimode_draw_arrays 1
#endif
#ifdef GL_IBM_vertex_array_lists
ConstScriptSub("GL_IBM_vertex_array_lists",GL_IBM_vertex_array_lists); //#define GL_IBM_vertex_array_lists 1
#endif
#ifdef GL_SGIX_subsample
ConstScriptSub("GL_SGIX_subsample",GL_SGIX_subsample); //#define GL_SGIX_subsample 1
#endif
#ifdef GL_SGIX_ycrcba
ConstScriptSub("GL_SGIX_ycrcba",GL_SGIX_ycrcba); //#define GL_SGIX_ycrcba 1
#endif
#ifdef GL_SGIX_ycrcb_subsample
ConstScriptSub("GL_SGIX_ycrcb_subsample",GL_SGIX_ycrcb_subsample); //#define GL_SGIX_ycrcb_subsample 1
#endif
#ifdef GL_SGIX_depth_pass_instrument
ConstScriptSub("GL_SGIX_depth_pass_instrument",GL_SGIX_depth_pass_instrument); //#define GL_SGIX_depth_pass_instrument 1
#endif
#ifdef GL_3DFX_texture_compression_FXT1
ConstScriptSub("GL_3DFX_texture_compression_FXT1",GL_3DFX_texture_compression_FXT1); //#define GL_3DFX_texture_compression_FXT1 1
#endif
#ifdef GL_3DFX_multisample
ConstScriptSub("GL_3DFX_multisample",GL_3DFX_multisample); //#define GL_3DFX_multisample 1
#endif
#ifdef GL_3DFX_tbuffer
ConstScriptSub("GL_3DFX_tbuffer",GL_3DFX_tbuffer); //#define GL_3DFX_tbuffer 1
#endif
#ifdef GL_EXT_multisample
ConstScriptSub("GL_EXT_multisample",GL_EXT_multisample); //#define GL_EXT_multisample 1
#endif
#ifdef GL_SGIX_vertex_preclip
ConstScriptSub("GL_SGIX_vertex_preclip",GL_SGIX_vertex_preclip); //#define GL_SGIX_vertex_preclip 1
#endif
#ifdef GL_SGIX_convolution_accuracy
ConstScriptSub("GL_SGIX_convolution_accuracy",GL_SGIX_convolution_accuracy); //#define GL_SGIX_convolution_accuracy 1
#endif
#ifdef GL_SGIX_resample
ConstScriptSub("GL_SGIX_resample",GL_SGIX_resample); //#define GL_SGIX_resample 1
#endif
#ifdef GL_SGIS_point_line_texgen
ConstScriptSub("GL_SGIS_point_line_texgen",GL_SGIS_point_line_texgen); //#define GL_SGIS_point_line_texgen 1
#endif
#ifdef GL_SGIS_texture_color_mask
ConstScriptSub("GL_SGIS_texture_color_mask",GL_SGIS_texture_color_mask); //#define GL_SGIS_texture_color_mask 1
#endif
#ifdef GL_SGIX_igloo_interface
ConstScriptSub("GL_SGIX_igloo_interface",GL_SGIX_igloo_interface); //#define GL_SGIX_igloo_interface 1
#endif
#ifdef GL_EXT_texture_env_dot3
ConstScriptSub("GL_EXT_texture_env_dot3",GL_EXT_texture_env_dot3); //#define GL_EXT_texture_env_dot3 1
#endif
#ifdef GL_ATI_texture_mirror_once
ConstScriptSub("GL_ATI_texture_mirror_once",GL_ATI_texture_mirror_once); //#define GL_ATI_texture_mirror_once 1
#endif
#ifdef GL_NV_fence
ConstScriptSub("GL_NV_fence",GL_NV_fence); //#define GL_NV_fence 1
#endif
#ifdef GL_NV_evaluators
ConstScriptSub("GL_NV_evaluators",GL_NV_evaluators); //#define GL_NV_evaluators 1
#endif
#ifdef GL_NV_packed_depth_stencil
ConstScriptSub("GL_NV_packed_depth_stencil",GL_NV_packed_depth_stencil); //#define GL_NV_packed_depth_stencil 1
#endif
#ifdef GL_NV_register_combiners2
ConstScriptSub("GL_NV_register_combiners2",GL_NV_register_combiners2); //#define GL_NV_register_combiners2 1
#endif
#ifdef GL_NV_texture_compression_vtc
ConstScriptSub("GL_NV_texture_compression_vtc",GL_NV_texture_compression_vtc); //#define GL_NV_texture_compression_vtc 1
#endif
#ifdef GL_NV_texture_rectangle
ConstScriptSub("GL_NV_texture_rectangle",GL_NV_texture_rectangle); //#define GL_NV_texture_rectangle 1
#endif
#ifdef GL_NV_texture_shader
ConstScriptSub("GL_NV_texture_shader",GL_NV_texture_shader); //#define GL_NV_texture_shader 1
#endif
#ifdef GL_NV_texture_shader2
ConstScriptSub("GL_NV_texture_shader2",GL_NV_texture_shader2); //#define GL_NV_texture_shader2 1
#endif
#ifdef GL_NV_vertex_array_range2
ConstScriptSub("GL_NV_vertex_array_range2",GL_NV_vertex_array_range2); //#define GL_NV_vertex_array_range2 1
#endif
#ifdef GL_NV_vertex_program
ConstScriptSub("GL_NV_vertex_program",GL_NV_vertex_program); //#define GL_NV_vertex_program 1
#endif
#ifdef GL_SGIX_texture_coordinate_clamp
ConstScriptSub("GL_SGIX_texture_coordinate_clamp",GL_SGIX_texture_coordinate_clamp); //#define GL_SGIX_texture_coordinate_clamp 1
#endif
#ifdef GL_SGIX_scalebias_hint
ConstScriptSub("GL_SGIX_scalebias_hint",GL_SGIX_scalebias_hint); //#define GL_SGIX_scalebias_hint 1
#endif
#ifdef GL_OML_interlace
ConstScriptSub("GL_OML_interlace",GL_OML_interlace); //#define GL_OML_interlace 1
#endif
#ifdef GL_OML_subsample
ConstScriptSub("GL_OML_subsample",GL_OML_subsample); //#define GL_OML_subsample 1
#endif
#ifdef GL_OML_resample
ConstScriptSub("GL_OML_resample",GL_OML_resample); //#define GL_OML_resample 1
#endif
#ifdef GL_NV_copy_depth_to_color
ConstScriptSub("GL_NV_copy_depth_to_color",GL_NV_copy_depth_to_color); //#define GL_NV_copy_depth_to_color 1
#endif
#ifdef GL_ATI_envmap_bumpmap
ConstScriptSub("GL_ATI_envmap_bumpmap",GL_ATI_envmap_bumpmap); //#define GL_ATI_envmap_bumpmap 1
#endif
#ifdef GL_ATI_fragment_shader
ConstScriptSub("GL_ATI_fragment_shader",GL_ATI_fragment_shader); //#define GL_ATI_fragment_shader 1
#endif
#ifdef GL_ATI_pn_triangles
ConstScriptSub("GL_ATI_pn_triangles",GL_ATI_pn_triangles); //#define GL_ATI_pn_triangles 1
#endif
#ifdef GL_ATI_vertex_array_object
ConstScriptSub("GL_ATI_vertex_array_object",GL_ATI_vertex_array_object); //#define GL_ATI_vertex_array_object 1
#endif
#ifdef GL_EXT_vertex_shader
ConstScriptSub("GL_EXT_vertex_shader",GL_EXT_vertex_shader); //#define GL_EXT_vertex_shader 1
#endif
#ifdef GL_ATI_vertex_streams
ConstScriptSub("GL_ATI_vertex_streams",GL_ATI_vertex_streams); //#define GL_ATI_vertex_streams 1
#endif
#ifdef GL_ATI_element_array
ConstScriptSub("GL_ATI_element_array",GL_ATI_element_array); //#define GL_ATI_element_array 1
#endif
#ifdef GL_SUN_mesh_array
ConstScriptSub("GL_SUN_mesh_array",GL_SUN_mesh_array); //#define GL_SUN_mesh_array 1
#endif
#ifdef GL_SUN_slice_accum
ConstScriptSub("GL_SUN_slice_accum",GL_SUN_slice_accum); //#define GL_SUN_slice_accum 1
#endif
#ifdef GL_NV_multisample_filter_hint
ConstScriptSub("GL_NV_multisample_filter_hint",GL_NV_multisample_filter_hint); //#define GL_NV_multisample_filter_hint 1
#endif
#ifdef GL_NV_depth_clamp
ConstScriptSub("GL_NV_depth_clamp",GL_NV_depth_clamp); //#define GL_NV_depth_clamp 1
#endif
#ifdef GL_NV_occlusion_query
ConstScriptSub("GL_NV_occlusion_query",GL_NV_occlusion_query); //#define GL_NV_occlusion_query 1
#endif
#ifdef GL_NV_point_sprite
ConstScriptSub("GL_NV_point_sprite",GL_NV_point_sprite); //#define GL_NV_point_sprite 1
#endif
#ifdef GL_NV_texture_shader3
ConstScriptSub("GL_NV_texture_shader3",GL_NV_texture_shader3); //#define GL_NV_texture_shader3 1
#endif
#ifdef GL_NV_vertex_program1_1
ConstScriptSub("GL_NV_vertex_program1_1",GL_NV_vertex_program1_1); //#define GL_NV_vertex_program1_1 1
#endif
#ifdef GL_EXT_shadow_funcs
ConstScriptSub("GL_EXT_shadow_funcs",GL_EXT_shadow_funcs); //#define GL_EXT_shadow_funcs 1
#endif
#ifdef GL_EXT_stencil_two_side
ConstScriptSub("GL_EXT_stencil_two_side",GL_EXT_stencil_two_side); //#define GL_EXT_stencil_two_side 1
#endif
#ifdef GL_ATI_text_fragment_shader
ConstScriptSub("GL_ATI_text_fragment_shader",GL_ATI_text_fragment_shader); //#define GL_ATI_text_fragment_shader 1
#endif
#ifdef GL_APPLE_client_storage
ConstScriptSub("GL_APPLE_client_storage",GL_APPLE_client_storage); //#define GL_APPLE_client_storage 1
#endif
#ifdef GL_APPLE_element_array
ConstScriptSub("GL_APPLE_element_array",GL_APPLE_element_array); //#define GL_APPLE_element_array 1
#endif
#ifdef GL_APPLE_fence
ConstScriptSub("GL_APPLE_fence",GL_APPLE_fence); //#define GL_APPLE_fence 1
#endif
#ifdef GL_APPLE_vertex_array_object
ConstScriptSub("GL_APPLE_vertex_array_object",GL_APPLE_vertex_array_object); //#define GL_APPLE_vertex_array_object 1
#endif
#ifdef GL_APPLE_vertex_array_range
ConstScriptSub("GL_APPLE_vertex_array_range",GL_APPLE_vertex_array_range); //#define GL_APPLE_vertex_array_range 1
#endif
#ifdef GL_APPLE_ycbcr_422
ConstScriptSub("GL_APPLE_ycbcr_422",GL_APPLE_ycbcr_422); //#define GL_APPLE_ycbcr_422 1
#endif
#ifdef GL_S3_s3tc
ConstScriptSub("GL_S3_s3tc",GL_S3_s3tc); //#define GL_S3_s3tc 1
#endif
#ifdef GL_ATI_draw_buffers
ConstScriptSub("GL_ATI_draw_buffers",GL_ATI_draw_buffers); //#define GL_ATI_draw_buffers 1
#endif
#ifdef GL_ATI_pixel_format_float
ConstScriptSub("GL_ATI_pixel_format_float",GL_ATI_pixel_format_float); //#define GL_ATI_pixel_format_float 1
#endif
#ifdef GL_ATI_texture_env_combine3
ConstScriptSub("GL_ATI_texture_env_combine3",GL_ATI_texture_env_combine3); //#define GL_ATI_texture_env_combine3 1
#endif
#ifdef GL_ATI_texture_float
ConstScriptSub("GL_ATI_texture_float",GL_ATI_texture_float); //#define GL_ATI_texture_float 1
#endif
#ifdef GL_NV_float_buffer
ConstScriptSub("GL_NV_float_buffer",GL_NV_float_buffer); //#define GL_NV_float_buffer 1
#endif
#ifdef GL_NV_fragment_program
ConstScriptSub("GL_NV_fragment_program",GL_NV_fragment_program); //#define GL_NV_fragment_program 1
#endif
#ifdef GL_NV_half_float
ConstScriptSub("GL_NV_half_float",GL_NV_half_float); //#define GL_NV_half_float 1
#endif
#ifdef GL_NV_pixel_data_range
ConstScriptSub("GL_NV_pixel_data_range",GL_NV_pixel_data_range); //#define GL_NV_pixel_data_range 1
#endif
#ifdef GL_NV_primitive_restart
ConstScriptSub("GL_NV_primitive_restart",GL_NV_primitive_restart); //#define GL_NV_primitive_restart 1
#endif
#ifdef GL_NV_texture_expand_normal
ConstScriptSub("GL_NV_texture_expand_normal",GL_NV_texture_expand_normal); //#define GL_NV_texture_expand_normal 1
#endif
#ifdef GL_NV_vertex_program2
ConstScriptSub("GL_NV_vertex_program2",GL_NV_vertex_program2); //#define GL_NV_vertex_program2 1
#endif
#ifdef GL_ATI_map_object_buffer
ConstScriptSub("GL_ATI_map_object_buffer",GL_ATI_map_object_buffer); //#define GL_ATI_map_object_buffer 1
#endif
#ifdef GL_ATI_separate_stencil
ConstScriptSub("GL_ATI_separate_stencil",GL_ATI_separate_stencil); //#define GL_ATI_separate_stencil 1
#endif
#ifdef GL_ATI_vertex_attrib_array_object
ConstScriptSub("GL_ATI_vertex_attrib_array_object",GL_ATI_vertex_attrib_array_object); //#define GL_ATI_vertex_attrib_array_object 1
#endif
#ifdef GL_OES_read_format
ConstScriptSub("GL_OES_read_format",GL_OES_read_format); //#define GL_OES_read_format 1
#endif
#ifdef GL_EXT_depth_bounds_test
ConstScriptSub("GL_EXT_depth_bounds_test",GL_EXT_depth_bounds_test); //#define GL_EXT_depth_bounds_test 1
#endif
#ifdef GL_EXT_texture_mirror_clamp
ConstScriptSub("GL_EXT_texture_mirror_clamp",GL_EXT_texture_mirror_clamp); //#define GL_EXT_texture_mirror_clamp 1
#endif
#ifdef GL_EXT_blend_equation_separate
ConstScriptSub("GL_EXT_blend_equation_separate",GL_EXT_blend_equation_separate); //#define GL_EXT_blend_equation_separate 1
#endif
#ifdef GL_MESA_pack_invert
ConstScriptSub("GL_MESA_pack_invert",GL_MESA_pack_invert); //#define GL_MESA_pack_invert 1
#endif
#ifdef GL_MESA_ycbcr_texture
ConstScriptSub("GL_MESA_ycbcr_texture",GL_MESA_ycbcr_texture); //#define GL_MESA_ycbcr_texture 1
#endif
#ifdef GL_EXT_pixel_buffer_object
ConstScriptSub("GL_EXT_pixel_buffer_object",GL_EXT_pixel_buffer_object); //#define GL_EXT_pixel_buffer_object 1
#endif
#ifdef GL_NV_fragment_program_option
ConstScriptSub("GL_NV_fragment_program_option",GL_NV_fragment_program_option); //#define GL_NV_fragment_program_option 1
#endif
#ifdef GL_NV_fragment_program2
ConstScriptSub("GL_NV_fragment_program2",GL_NV_fragment_program2); //#define GL_NV_fragment_program2 1
#endif
#ifdef GL_NV_vertex_program2_option
ConstScriptSub("GL_NV_vertex_program2_option",GL_NV_vertex_program2_option); //#define GL_NV_vertex_program2_option 1
#endif
#ifdef GL_NV_vertex_program3
ConstScriptSub("GL_NV_vertex_program3",GL_NV_vertex_program3); //#define GL_NV_vertex_program3 1
#endif
#ifdef GL_EXT_framebuffer_object
ConstScriptSub("GL_EXT_framebuffer_object",GL_EXT_framebuffer_object); //#define GL_EXT_framebuffer_object 1
#endif
#ifdef GL_GREMEDY_string_marker
ConstScriptSub("GL_GREMEDY_string_marker",GL_GREMEDY_string_marker); //#define GL_GREMEDY_string_marker 1
#endif
// #define __BEOS__	1
// #define __BSDI__	1
// #define __DREAMCAST__	1
// #define __FREEBSD__	1
// #define __HPUX__	1
// #define __IRIX__	1
// #define __LINUX__	1
// #define __MACOSX__	1
// #define __MACOS__	1
// #define __NETBSD__	1
// #define __OPENBSD__	1
// #define __QNXNTO__	1
// #define __RISCOS__	1
// #define __SOLARIS__	1
// #define __WIN32__	1
#ifdef RW_SEEK_SET
ConstScriptSub("RW_SEEK_SET",RW_SEEK_SET); //#define RW_SEEK_SET	0	
#endif
#ifdef RW_SEEK_CUR
ConstScriptSub("RW_SEEK_CUR",RW_SEEK_CUR); //#define RW_SEEK_CUR	1	
#endif
#ifdef RW_SEEK_END
ConstScriptSub("RW_SEEK_END",RW_SEEK_END); //#define RW_SEEK_END	2	
#endif
ConstScriptSub("SDL_FALSE",SDL_FALSE); //	SDL_FALSE = 0,
ConstScriptSub("SDL_TRUE",SDL_TRUE); //	SDL_TRUE  = 1
ConstScriptSub("DUMMY_ENUM_VALUE",DUMMY_ENUM_VALUE); //	DUMMY_ENUM_VALUE
#ifdef malloc
#ifdef SDL_malloc
ConstScriptSub("SDL_malloc",SDL_malloc); //#define SDL_malloc	malloc
#endif
#endif
#ifdef calloc
#ifdef SDL_calloc
ConstScriptSub("SDL_calloc",SDL_calloc); //#define SDL_calloc	calloc
#endif
#endif
#ifdef realloc
#ifdef SDL_realloc
ConstScriptSub("SDL_realloc",SDL_realloc); //#define SDL_realloc	realloc
#endif
#endif
#ifdef free
#ifdef SDL_free
ConstScriptSub("SDL_free",SDL_free); //#define SDL_free	free
#endif
#endif
#ifdef getenv
#ifdef SDL_getenv
ConstScriptSub("SDL_getenv",SDL_getenv); //#define SDL_getenv	getenv
#endif
#endif
#ifdef putenv
#ifdef SDL_putenv
ConstScriptSub("SDL_putenv",SDL_putenv); //#define SDL_putenv	putenv
#endif
#endif
#ifdef qsort
#ifdef SDL_qsort
ConstScriptSub("SDL_qsort",SDL_qsort); //#define SDL_qsort	qsort
#endif
#endif
#ifdef strncasecmp
#ifdef SDL_strncasecmp
ConstScriptSub("SDL_strncasecmp",SDL_strncasecmp); //#define SDL_strncasecmp strncasecmp
#endif
#endif
// #define SDL_strncasecmp _strnicmp
#ifdef iconv_close
#ifdef SDL_iconv_close
ConstScriptSub("SDL_iconv_close",SDL_iconv_close); //#define SDL_iconv_close iconv_close
#endif
#endif
#ifdef X11Cursor
#ifdef Cursor
ConstScriptSub("Cursor",Cursor); //#define Cursor X11Cursor
#endif
#endif
//ConstScriptSub("SDL_SYSWM_X11",SDL_SYSWM_X11); //	SDL_SYSWM_X11
#ifdef TIMER_RESOLUTION
ConstScriptSub("TIMER_RESOLUTION",TIMER_RESOLUTION); //#define TIMER_RESOLUTION	10	
#endif
#ifdef SDL_MAJOR_VERSION
ConstScriptSub("SDL_MAJOR_VERSION",SDL_MAJOR_VERSION); //#define SDL_MAJOR_VERSION	1
#endif
#ifdef SDL_MINOR_VERSION
ConstScriptSub("SDL_MINOR_VERSION",SDL_MINOR_VERSION); //#define SDL_MINOR_VERSION	2
#endif
#ifdef SDL_ALPHA_OPAQUE
ConstScriptSub("SDL_ALPHA_OPAQUE",SDL_ALPHA_OPAQUE); //#define SDL_ALPHA_OPAQUE 255
#endif
#ifdef SDL_ALPHA_TRANSPARENT
ConstScriptSub("SDL_ALPHA_TRANSPARENT",SDL_ALPHA_TRANSPARENT); //#define SDL_ALPHA_TRANSPARENT 0
#endif
#ifdef SDL_Color
#ifdef SDL_Colour
ConstScriptSub("SDL_Colour",SDL_Colour); //#define SDL_Colour SDL_Color
#endif
#endif
#ifdef SDL_SWSURFACE
ConstScriptSub("SDL_SWSURFACE",SDL_SWSURFACE); //#define SDL_SWSURFACE	0x00000000	
#endif
#ifdef SDL_HWSURFACE
ConstScriptSub("SDL_HWSURFACE",SDL_HWSURFACE); //#define SDL_HWSURFACE	0x00000001	
#endif
#ifdef SDL_ASYNCBLIT
ConstScriptSub("SDL_ASYNCBLIT",SDL_ASYNCBLIT); //#define SDL_ASYNCBLIT	0x00000004	
#endif
#ifdef SDL_ANYFORMAT
ConstScriptSub("SDL_ANYFORMAT",SDL_ANYFORMAT); //#define SDL_ANYFORMAT	0x10000000	
#endif
#ifdef SDL_HWPALETTE
ConstScriptSub("SDL_HWPALETTE",SDL_HWPALETTE); //#define SDL_HWPALETTE	0x20000000	
#endif
#ifdef SDL_DOUBLEBUF
ConstScriptSub("SDL_DOUBLEBUF",SDL_DOUBLEBUF); //#define SDL_DOUBLEBUF	0x40000000	
#endif
#ifdef SDL_FULLSCREEN
ConstScriptSub("SDL_FULLSCREEN",SDL_FULLSCREEN); //#define SDL_FULLSCREEN	0x80000000	
#endif
#ifdef SDL_OPENGLBLIT
ConstScriptSub("SDL_OPENGLBLIT",SDL_OPENGLBLIT); //#define SDL_OPENGLBLIT	0x0000000A	
#endif
#ifdef SDL_RESIZABLE
ConstScriptSub("SDL_RESIZABLE",SDL_RESIZABLE); //#define SDL_RESIZABLE	0x00000010	
#endif
#ifdef SDL_NOFRAME
ConstScriptSub("SDL_NOFRAME",SDL_NOFRAME); //#define SDL_NOFRAME	0x00000020	
#endif
#ifdef SDL_HWACCEL
ConstScriptSub("SDL_HWACCEL",SDL_HWACCEL); //#define SDL_HWACCEL	0x00000100	
#endif
#ifdef SDL_SRCCOLORKEY
ConstScriptSub("SDL_SRCCOLORKEY",SDL_SRCCOLORKEY); //#define SDL_SRCCOLORKEY	0x00001000	
#endif
#ifdef SDL_RLEACCELOK
ConstScriptSub("SDL_RLEACCELOK",SDL_RLEACCELOK); //#define SDL_RLEACCELOK	0x00002000	
#endif
#ifdef SDL_RLEACCEL
ConstScriptSub("SDL_RLEACCEL",SDL_RLEACCEL); //#define SDL_RLEACCEL	0x00004000	
#endif
#ifdef SDL_SRCALPHA
ConstScriptSub("SDL_SRCALPHA",SDL_SRCALPHA); //#define SDL_SRCALPHA	0x00010000	
#endif
#ifdef SDL_PREALLOC
ConstScriptSub("SDL_PREALLOC",SDL_PREALLOC); //#define SDL_PREALLOC	0x01000000	
#endif
ConstScriptSub("SDL_GL_RED_SIZE",SDL_GL_RED_SIZE); //    SDL_GL_RED_SIZE,
ConstScriptSub("SDL_GL_GREEN_SIZE",SDL_GL_GREEN_SIZE); //    SDL_GL_GREEN_SIZE,
ConstScriptSub("SDL_GL_BLUE_SIZE",SDL_GL_BLUE_SIZE); //    SDL_GL_BLUE_SIZE,
ConstScriptSub("SDL_GL_ALPHA_SIZE",SDL_GL_ALPHA_SIZE); //    SDL_GL_ALPHA_SIZE,
ConstScriptSub("SDL_GL_BUFFER_SIZE",SDL_GL_BUFFER_SIZE); //    SDL_GL_BUFFER_SIZE,
ConstScriptSub("SDL_GL_DOUBLEBUFFER",SDL_GL_DOUBLEBUFFER); //    SDL_GL_DOUBLEBUFFER,
ConstScriptSub("SDL_GL_DEPTH_SIZE",SDL_GL_DEPTH_SIZE); //    SDL_GL_DEPTH_SIZE,
ConstScriptSub("SDL_GL_STENCIL_SIZE",SDL_GL_STENCIL_SIZE); //    SDL_GL_STENCIL_SIZE,
ConstScriptSub("SDL_GL_ACCUM_RED_SIZE",SDL_GL_ACCUM_RED_SIZE); //    SDL_GL_ACCUM_RED_SIZE,
ConstScriptSub("SDL_GL_ACCUM_GREEN_SIZE",SDL_GL_ACCUM_GREEN_SIZE); //    SDL_GL_ACCUM_GREEN_SIZE,
ConstScriptSub("SDL_GL_ACCUM_BLUE_SIZE",SDL_GL_ACCUM_BLUE_SIZE); //    SDL_GL_ACCUM_BLUE_SIZE,
ConstScriptSub("SDL_GL_ACCUM_ALPHA_SIZE",SDL_GL_ACCUM_ALPHA_SIZE); //    SDL_GL_ACCUM_ALPHA_SIZE,
ConstScriptSub("SDL_GL_STEREO",SDL_GL_STEREO); //    SDL_GL_STEREO,
ConstScriptSub("SDL_GL_MULTISAMPLEBUFFERS",SDL_GL_MULTISAMPLEBUFFERS); //    SDL_GL_MULTISAMPLEBUFFERS,
ConstScriptSub("SDL_GL_MULTISAMPLESAMPLES",SDL_GL_MULTISAMPLESAMPLES); //    SDL_GL_MULTISAMPLESAMPLES,
ConstScriptSub("SDL_GL_ACCELERATED_VISUAL",SDL_GL_ACCELERATED_VISUAL); //    SDL_GL_ACCELERATED_VISUAL,
ConstScriptSub("SDL_GL_SWAP_CONTROL",SDL_GL_SWAP_CONTROL); //    SDL_GL_SWAP_CONTROL
#ifdef SDL_LOGPAL
ConstScriptSub("SDL_LOGPAL",SDL_LOGPAL); //#define SDL_LOGPAL 0x01
#endif
#ifdef SDL_PHYSPAL
ConstScriptSub("SDL_PHYSPAL",SDL_PHYSPAL); //#define SDL_PHYSPAL 0x02
#endif
#ifdef SDL_UpperBlit
#ifdef SDL_BlitSurface
ConstScriptSub("SDL_BlitSurface",SDL_BlitSurface); //#define SDL_BlitSurface SDL_UpperBlit
#endif
#endif
ConstScriptSub("SDL_GRAB_QUERY",SDL_GRAB_QUERY); //	SDL_GRAB_QUERY = -1,
ConstScriptSub("SDL_GRAB_OFF",SDL_GRAB_OFF); //	SDL_GRAB_OFF = 0,
ConstScriptSub("SDL_GRAB_ON",SDL_GRAB_ON); //	SDL_GRAB_ON = 1,
ConstScriptSub("SDL_GRAB_FULLSCREEN",SDL_GRAB_FULLSCREEN); //	SDL_GRAB_FULLSCREEN	
/*************************
* End: constants for SDL *
*************************/
/************************
* Constants for SDL_ttf *
************************/
ConstScriptSub("UNICODE_BOM_NATIVE",0xFEFF); //#define UNICODE_BOM_NATIVE	0xFEFF
ConstScriptSub("UNICODE_BOM_SWAPPED",0xFFFE); //#define UNICODE_BOM_SWAPPED	0xFFFE
ConstScriptSub("TTF_STYLE_NORMAL",0x00); //#define TTF_STYLE_NORMAL	0x00
ConstScriptSub("TTF_STYLE_ITALIC",0x02); //#define TTF_STYLE_ITALIC	0x02
ConstScriptSub("TTF_STYLE_UNDERLINE",0x04); //#define TTF_STYLE_UNDERLINE	0x04
/*****************************
* End: constants for SDL_ttf *
*****************************/
/**************************
* Constants for SDL_mixer *
**************************/
typedef enum {
    MIX_NO_FADING,
    MIX_FADING_OUT,
    MIX_FADING_IN
} Mix_Fading;
typedef enum {
    MUS_NONE,
    MUS_CMD,
    MUS_WAV,
    MUS_MOD,
    MUS_MID,
    MUS_OGG,
    MUS_MP3
} Mix_MusicType;
ConstScriptSub("MIX_CHANNELS",8); //#define MIX_CHANNELS	8
ConstScriptSub("MIX_DEFAULT_FREQUENCY",22050); //#define MIX_DEFAULT_FREQUENCY	22050
#ifdef AUDIO_S16LSB
ConstScriptSub("MIX_DEFAULT_FORMAT",AUDIO_S16LSB); //#define MIX_DEFAULT_FORMAT	AUDIO_S16LSB
#endif
ConstScriptSub("MIX_DEFAULT_CHANNELS",2); //#define MIX_DEFAULT_CHANNELS	2
ConstScriptSub("MIX_NO_FADING",MIX_NO_FADING); //	MIX_NO_FADING,
ConstScriptSub("MIX_FADING_OUT",MIX_FADING_OUT); //	MIX_FADING_OUT,
ConstScriptSub("MIX_FADING_IN",MIX_FADING_IN); //	MIX_FADING_IN
ConstScriptSub("MUS_NONE",MUS_NONE); //	MUS_NONE,
ConstScriptSub("MUS_CMD",MUS_CMD); //	MUS_CMD,
ConstScriptSub("MUS_WAV",MUS_WAV); //	MUS_WAV,
ConstScriptSub("MUS_MOD",MUS_MOD); //	MUS_MOD,
ConstScriptSub("MUS_MID",MUS_MID); //	MUS_MID,
ConstScriptSub("MUS_OGG",MUS_OGG); //	MUS_OGG,
ConstScriptSub("MUS_MP3",MUS_MP3); //	MUS_MP3,
//ConstScriptSub("MUS_MP3_MAD",MUS_MP3_MAD); //	MUS_MP3_MAD,
//ConstScriptSub("MUS_FLAC",MUS_FLAC); //	MUS_FLAC,
/*******************************
* End: constants for SDL_mixer *
*******************************/


	if (strcpy_s(code+pos,max-pos,footer)) throw NTE_NO_MEMORY;
	return SysAllocString(temp.TempUNI((LPSTR)code));
}
/* Following PHP script is used to generate above constant-definition code.
   Some manual modification is required after insertiion of the generated code.
<?php

$result='';
$d=dir('./');
while(($file=$d->read())!==false){
	if (substr($file,-2)!='.h') continue;
	$result.=checkfile($file);
}
file_put_contents('result.txt', $result);

function checkfile($file){
	static $defined=array();
	$ret='';
	$struct=false;
	$code=file_get_contents($file);
	$code=preg_replace('!/\*[\s\S]*?\*'.'/!','',$code);  // remove comments
	$code=preg_replace('!//.*([\r\n])!','$1',$code);  // remove comments
	$code=preg_replace('!\\\\([\r\n]+)!','$1',$code); // avoid multiple line using "\"
	foreach(preg_split('/[\r\n]+/',$code,-1,PREG_SPLIT_NO_EMPTY) as $line){
		$line.="\r\n";
		if ($struct){// actually, enum
			if (preg_match('/^\}/',$line)) {
				$struct=false;
			} else {
				if (preg_match('/^\s*([a-zA-Z][a-zA-Z0-9_]*)/',$line,$matches)) {
					if (in_array($matches[1],$defined)) continue;
					$defined[]=$matches[1];
					$line='ConstScriptSub("'.$matches[1].'",'.$matches[1].'); //'.$line;
				} else {
					$line="// $line";
				}
				$ret.=$line;
			}
		} elseif (preg_match('/^typedef\s+enum.*\{/',$line)) {
			$struct=true;
		} elseif (preg_match('/^#define\s[^\(\s]+\s[^\(\s]+(\s|$)/',$line)) {
			if (preg_match('/^#define\s+([a-zA-Z][a-zA-Z0-9_]*)\s+([a-zA-Z][a-zA-Z0-9_]*|[0-9]x?[0-9A-Fa-f]*)(\s|$)/',$line,$matches)) {
				if (in_array($matches[1],$defined)) continue;
				$defined[]=$matches[1];
				$line="#ifdef $matches[1]\r\n".
					'ConstScriptSub("'.$matches[1].'",'.$matches[1].'); //'.$line.
					"#endif\r\n";
				if (!preg_match('/^[0-9]/',$matches[2])) $line="#ifdef {$matches[2]}\r\n{$line}#endif\r\n";
			} else {
				$line="// $line";
			}
			$ret.=$line;
		} elseif (preg_match('/^const\s/',$line)) {
			$line="// $line";
			$ret.=$line;
		}
	}
	return $ret;
}
*/