#include "common.h"

//Method definition
DWORD ClassEx_GetIDsOfNames(LPOLESTR* rgszNames, UINT cNames, DISPID* rgDispId,COMDATA *data)
{
	int i,ret;
	LPOLESTR* rgszNames2=new LPOLESTR;
	DISPID* rgDispId2=new DISPID;
	for (i=0;i<(int)cNames;i++)
	{
		if (!lstrcmpiW(rgszNames[i],L"Register") && (!data->pDisp || !data->pDisp2)) {
			rgDispId[i]=0;
			return S_OK;
		}
		rgszNames2[0]=rgszNames[i];
		ret=data->pDisp->GetIDsOfNames(GUID_NULL, rgszNames2,1, NULL, rgDispId2);
		if (ret==S_OK) data->UseDisp2=FALSE;
		else {
			ret=data->pDisp2->GetIDsOfNames(GUID_NULL, rgszNames2,1, NULL, rgDispId2);
			if (ret!=S_OK) return DISP_E_MEMBERNOTFOUND;
			data->UseDisp2=TRUE;
		}
		rgDispId[i]=rgDispId2[0];
	}
	return S_OK;
}

//Method Invoke
DWORD ClassEx_Invoke(DISPID dispIdMember, REFIID riid, LCID lcid, WORD wFlags,
            DISPPARAMS* pDispParams, VARIANT* pVarResult,
            EXCEPINFO* pExcepInfo, UINT *puArgErr,COMDATA *data)
{
	int cArgs = pDispParams->cArgs;
	VARIANTARG* rgvarg = pDispParams->rgvarg;

	switch (dispIdMember)
	{
	case 0:	//Declare
		if (cArgs!=2) return DISP_E_BADPARAMCOUNT;
		if (rgvarg[0].vt!=VT_DISPATCH) return DISP_E_BADPARAMCOUNT;
		if (rgvarg[1].vt!=VT_DISPATCH) return DISP_E_BADPARAMCOUNT;
		data->pDisp=rgvarg[1].pdispVal;
		data->pDisp2=rgvarg[0].pdispVal;
		return S_OK;
	default: //forward to child IDispatch
		if (data->UseDisp2) return data->pDisp2->Invoke(dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr);
		else return data->pDisp->Invoke(dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr);
	}
}
