#include "suppon.h"


LPWSTR getLanguage(char* cmdLine){
	// Go to the last '.' first.
	// Then, check the first character of extension (VBScript or JScript).
	// Finally, check the third character of extension (encoded or not).
	int i,j=0;
	for(i=0;cmdLine[i];i++) j=cmdLine[i]=='.' ? i : j;
	bool isJS= cmdLine[j+1]=='j' || cmdLine[j+1]=='J';
	bool encoded= cmdLine[j+3]=='e' || cmdLine[j+3]=='E';
	if (i<j+3 || j==0) isJS=encoded=false; // '.' not found or extension too short.
	if (isJS) return encoded ? L"jscript.encode" : L"jscript";
	else return encoded ? L"vbscript.encode" : L"vbscript";
}

int ShowMessage(int e) {
	LPVOID lpMsgBuf;
	if (e==DISP_E_EXCEPTION) lpMsgBuf=(LPVOID)ExcepInfoDescription();
	else FormatMessageW(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,
	         NULL, e, MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), (LPWSTR) &lpMsgBuf, 0, NULL);
	MessageBoxW(NULL, (LPWSTR)lpMsgBuf, L"Error", MB_OK | MB_ICONINFORMATION);
	return e;
}

int _stdcall WinMain(HINSTANCE hInstance, HINSTANCE hPrevInst, char* cmdLine, int intShowCmd) {

	int i;
	try {
		// Initialize
		TryAndThrow( OleInitialize(NULL) );
		// Create Suppon object
		IDispatch* Suppon=SupponObject();

		// Resolve suppon.exe full path
		char ModulePath[_MAX_PATH];
		int len=GetModuleFileNameA(NULL,ModulePath,_MAX_PATH);
		if (_MAX_PATH-1<=len || !len) throw NTE_NO_MEMORY;

		// Create WScript object
		BSTR bstr=WScript();
		if (!bstr) MK_E_CANTOPENFILE;
		IDispatch* ppvWScript=ScriptControl();
		if (!ppvWScript) throw CS_E_OBJECT_NOTFOUND;
		TryAndThrow( CallMethod(ppvWScript, L"Language",L"JScript") );
		TryAndThrow( CallMethod(ppvWScript, L"AddCode",bstr) );
		SysFreeString(bstr);

		// Get WScript object through the suppon function in suppon.jp
		VARIANT VarResult;
		VarResult.vt=VT_EMPTY;
		TryAndThrow( CallMethod(ppvWScript, &VarResult, L"Run", L"suppon", Suppon, ModulePath, cmdLine) );
		if (VarResult.vt!=VT_DISPATCH) throw CO_E_CLASS_CREATE_FAILED;
		// The pointer to ScriptControl object will be lost in the next line, but the object remains.
		// Instead, ppvWScript will be the pointer to WScript object in suppon.js.
		ppvWScript=VarResult.pdispVal;

		// Resolve script file name to execute and get script text.
		char* scriptFile;
		BSTR scriptText;
		if (!cmdLine) cmdLine="";
		if (cmdLine[0]=='\0') {
			while (true) {
				if (scriptText=ReadScriptFile(scriptFile="start.vbs")) break;
				if (scriptText=ReadScriptFile(scriptFile="start.js")) break;
				if (scriptText=ReadScriptFile(scriptFile="start.vbe")) break;
				if (scriptText=ReadScriptFile(scriptFile="start.jse")) break;
				throw STG_E_FILENOTFOUND;
				break;
			}
		} else {
			scriptFile=new char[_MAX_PATH];
			bool Quoted=(cmdLine[0]=='"');
			if (Quoted) cmdLine++;
			for (i=0;i<_MAX_PATH-2;i++) {
				if ( cmdLine[i]==(Quoted?'"':'\0') ) break;
				scriptFile[i]=cmdLine[i];
			}
			scriptFile[i]='\0';
			scriptText=ReadScriptFile(scriptFile);
			if (!scriptText) throw STG_E_FILENOTFOUND;
		}

		// Construct ScriptControl object to execute main script.
		WCHAR* lang=getLanguage(scriptFile);
		IDispatch* ppvObject=ScriptControl();
		if (!ppvObject) throw CS_E_OBJECT_NOTFOUND;
		TryAndThrow( CallMethod(ppvObject, L"Language",lang) );

		// Set WScript object in ScriptControl object.
		if (lang[0]==L'v') {
			TryAndThrow( CallMethod(ppvObject, L"ExecuteStatement",L"Dim WScript") );
			TryAndThrow( CallMethod(ppvObject, L"AddCode",L"\
				function suppon_set_wscript(obj,dummy1,dummy2)\
					set WScript=obj\
				end function") );
		} else {
			TryAndThrow( CallMethod(ppvObject, L"AddCode",L"\
				var WScript;\
				function suppon_set_wscript(obj,dummy1,dummy2){\
					WScript=obj;\
				}") );
		}
		TryAndThrow( CallMethod(ppvObject, &VarResult, L"Run", L"suppon_set_wscript", ppvWScript, "", "") );

		// Execute the main script
		TryAndThrow( CallMethod(ppvObject, L"ExecuteStatement",scriptText) );

		OleUninitialize();
	} catch (long e) {
		OleUninitialize();
		return ShowMessage(e);
	} catch (int e) {
		OleUninitialize();
		return ShowMessage(e);
	} catch (SupponQuit quit) {
		OleUninitialize();
		return quit.e;
	}
	return 0;
}