using System;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;

using SystemNeo.Collections;
using SystemNeo.IO;
using SystemNeo.Text;

namespace SystemNeo.Drawing.Imaging
{
	/// <summary>
	/// 
	/// </summary>
	public sealed class IptcIimRecord
	{
		#region private static fields
		private const byte markerValue = 28;
		#endregion

		#region private fields
		private readonly byte marker;
		private readonly uint size;
		private readonly byte[] valueBytes;
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public IptcIimDataSet DataSet { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public byte DataSetNumber { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public IptcIimRecordType RecordType { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public object Value { get; private set; }

		// private RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="reader"></param>
		private IptcIimRecord(BinaryReaderNeo reader)
		{
			this.marker = reader.ReadByte();
			if (this.marker != markerValue) {
				string msg = string.Format("IIM̃}[J[słB[{0}]", this.marker);
				throw new BadImageFormatException(msg);
			}
			this.RecordType = (IptcIimRecordType)reader.ReadByte();
			this.DataSetNumber = reader.ReadByte();
			this.DataSet = IptcIimDataSet.GetDataSet(this.RecordType, this.DataSetNumber);
			ushort size = reader.ReadUInt16();
			if (size < 0x8000) {
				this.size = size;
			} else {
				size &= 0x7FFF;
				switch (size) {
				case sizeof(ushort):
					this.size = reader.ReadUInt16();
					break;
				case sizeof(uint):
					this.size = reader.ReadUInt32();
					break;
				default:
					string msg = string.Format("oCg̒sȂ߁A"
							+ "ɕϊł܂B[{0}]", size & 0x7FFF);
					throw new NotSupportedException(msg);
				}
			}
			this.valueBytes = reader.ReadBytes((int)this.size);
			if (this.DataSet != null) {
				this.Value = this.DataSet.Convert(this.valueBytes);
			}
		}

		// public static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name='input'></param>
		/// <returns></returns>
		public static IptcIimRecord[] ReadRecords(Stream input)
		{
			var list = new List<IptcIimRecord>();
			var reader = new BinaryReaderNeo(input, ByteOrder.BigEndian, Encoding.ASCII);
			while (! reader.EOF) {
				list.Add(new IptcIimRecord(reader));
			}
			return list.ToArray();
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override string ToString()
		{
			var sw = new StringWriter();
			sw.Write("{Record=");
			sw.Write(this.RecordType);
			sw.Write(", DataSet=");
			if (this.DataSet != null) {
				sw.Write(this.DataSet.Name);
			}
			sw.Write("(");
			sw.Write((byte)this.RecordType);
			sw.Write(":");
			sw.Write(this.DataSetNumber);
			sw.Write("), Value=");
			if (this.Value == null) {
				new ByteArrayFormatter(24).WriteTo(sw, this.valueBytes);
			} else if (this.Value is string) {
				new QuotedStringFormatter().WriteTo(sw, this.Value);
			} else {
				sw.Write(this.Value);
			}
			sw.Write("}");
			return sw.ToString();
		}
	}
}
