using System;
using System.Drawing;
using System.IO;

using SystemNeo.IO;
using SystemNeo.Text;

namespace SystemNeo.Drawing.Imaging.Jfif
{
	/// <summary>
	/// 
	/// </summary>
	public sealed class App0SegmentContent : SegmentContent
	{
		/// <summary>
		/// 
		/// </summary>
		public const string ExtendedJfifId = "JFXX\0";

		/// <summary>
		/// 
		/// </summary>
		public const string JfifId = "JFIF\0";

		#region private fields
		private readonly byte[] version;
		private readonly ushort xPixelDensity;
		private readonly ushort yPixelDensity;
		private readonly byte thumbnailWidth;
		private readonly byte thumbnailHeight;
		private readonly byte extensionCode;
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public string Id { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public Point PixelDensity
		{
			get {
				return new Point(this.xPixelDensity, this.yPixelDensity);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public JfifPixelDensityUnit PixelDensityUnit { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public Size ThumbnailSize
		{
			get {
				return new Size(this.thumbnailWidth, this.thumbnailHeight);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public string Version
		{
			get {
				return this.version == null ? null
						: string.Format("{0}.{1:00}", this.version[0], this.version[1]);
			}
		}

		// internal RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="reader"></param>
		internal App0SegmentContent(BinaryReaderNeo reader)
		{
			this.Id = reader.ReadString(JfifId.Length);
			if (this.Id == JfifId) {
				this.version = reader.ReadBytes(2);
				this.PixelDensityUnit = (JfifPixelDensityUnit)reader.ReadByte();
				this.xPixelDensity = reader.ReadUInt16();
				this.yPixelDensity = reader.ReadUInt16();
				this.thumbnailWidth = reader.ReadByte();
				this.thumbnailHeight = reader.ReadByte();
			} else if (this.Id == ExtendedJfifId) {
				this.extensionCode = reader.ReadByte();
			} else {
				string msg = "APP0IDsłB" + new QuotedStringFormatter().ToString(this.Id);
				throw new BadImageFormatException(msg);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override string ToString()
		{
			var sw = new StringWriter();
			sw.Write("Id=");
			sw.Write(this.Id.TrimEnd('\0'));
			if (this.Id == JfifId) {
				sw.Write(", Version=");
				sw.Write(this.Version);
				sw.Write(", PixelDensity={");
				sw.Write(this.xPixelDensity);
				sw.Write(":");
				sw.Write(this.yPixelDensity);
				sw.Write(", Unit=");
				sw.Write(this.PixelDensityUnit);
				sw.Write("}");
				if (this.thumbnailWidth > 0 && this.thumbnailHeight > 0) {
					sw.Write(", ThumbnailSize=");
					sw.Write(this.thumbnailWidth);
					sw.Write("x");
					sw.Write(this.thumbnailHeight);
				}
			} else if (this.Id == ExtendedJfifId) {
				sw.Write(", ExtensionCode=0x");
				sw.Write(this.extensionCode.ToString("X2"));
			}
			return sw.ToString();
		}
	}
}
