using System;
using System.IO;
using System.Linq;
using System.Text;

using SystemNeo.Collections;
using SystemNeo.IO;
using SystemNeo.Text;

namespace SystemNeo.Drawing.Imaging.Jfif
{
	/// <summary>
	/// 
	/// </summary>
	public sealed class App12SegmentContent : SegmentContent
	{
		#region private static fields
		private const string idValue = "Ducky";
		private static readonly ushort[] versionValue = new ushort[] {1, 4, 0};
		private static readonly CollectionFormatter versionFormatter
				= new CollectionFormatter(string.Empty, string.Empty, ".");
		#endregion

		#region private fields
		private readonly ushort[] version;
		private readonly bool hasCopyrightInfo;
		private readonly ushort dataLength;
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public string Copyright { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public string Id { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public int Quality { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public string Version
		{
			get {
				return versionFormatter.ToString(this.version);
			}
		}

		// internal RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="reader"></param>
		internal App12SegmentContent(BinaryReaderNeo reader)
		{
			this.Id = reader.ReadString(idValue.Length);
			if (this.Id != idValue) {
				throw new BadImageFormatException("APP12IDsłB");
			}
			this.version = reader.ReadUInt16s(versionValue.Length);
			if (! this.version.SequenceEqual(versionValue)) {
				throw new BadImageFormatException("APP12̃o[WsłB");
			}
			this.Quality = reader.ReadUInt16();
			ushort f = reader.ReadUInt16();
			switch (f) {
			case 0:
				this.hasCopyrightInfo = false;
				break;
			case 2:
			case 3:
				this.hasCopyrightInfo = true;
				break;
			default:
				string msg = string.Format("쌠tOsłB[{0}]", f);
				throw new BadImageFormatException(msg);
			}
			if (this.hasCopyrightInfo) {
				this.dataLength = reader.ReadUInt16();
				ushort dummy1 = reader.ReadUInt16();
				int copyrightLength = reader.ReadUInt16();
				BinaryReaderNeo unicodeReader = new BinaryReaderNeo(
						reader.BaseStream, ByteOrder.BigEndian, Encoding.BigEndianUnicode);
				this.Copyright = unicodeReader.ReadString(copyrightLength);
				ushort dummy2 = reader.ReadUInt16();
			}
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override string ToString()
		{
			var sw = new StringWriter();
			sw.Write("Id=");
			sw.Write(this.Id);
			sw.Write(", Version=");
			sw.Write(this.Version);
			sw.Write(", Quality=");
			sw.Write(this.Quality);
			sw.Write(", Copyright=");
			if (this.hasCopyrightInfo) {
				sw.Write(new QuotedStringFormatter().ToString(this.Copyright));
			} else {
				sw.Write("none");
			}
			return sw.ToString();
		}
	}
}
