using System;
using System.IO;
using System.Text;

using SystemNeo.IO;
using SystemNeo.Text;

namespace SystemNeo.Drawing.Imaging.Jfif
{
	/// <summary>
	/// 
	/// </summary>
	public sealed class App14SegmentContent : SegmentContent
	{
		#region private static fields
		private const string idValue = "Adobe";
		private const ushort progressiveFlag = 0x0300;
		#endregion

		#region private fields
		private readonly Flag0 flag0;
		private readonly ushort flag1;
		private readonly ColorTransform colorTransform;
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public string Id { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public bool Progressive { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public int Version { get; private set; }

		// internal RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="reader"></param>
		internal App14SegmentContent(BinaryReaderNeo reader)
		{
			this.Id = reader.ReadString(idValue.Length);
			if (this.Id != idValue) {
				var qsf = new QuotedStringFormatter();
				string msg = string.Format("APP14IDsłi{0}jB̒l͒ʏA{1} łB",
						qsf.ToString(this.Id), qsf.ToString(idValue));
				throw new BadImageFormatException(msg);
			}
			this.Version = reader.ReadUInt16();
			this.flag0 = (Flag0)reader.ReadUInt16();
			this.flag1 = reader.ReadUInt16();
			this.colorTransform = (ColorTransform)reader.ReadByte();
			if (reader.Position < reader.Length) {
				switch (reader.ReadUInt16()) {
				case progressiveFlag:
					this.Progressive = true;
					break;
				default:
					throw new BadImageFormatException();
				}
			}
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override string ToString()
		{
			var sw = new StringWriter();
			sw.Write("Id=");
			sw.Write(this.Id);
			sw.Write(", Version=");
			sw.Write(this.Version);
			sw.Write(", Flag0=");
			sw.Write(this.flag0);
			sw.Write(", Flag1=");
			sw.Write(this.flag1);
			sw.Write(", ColorTransform=");
			sw.Write(this.colorTransform);
			sw.Write(", Progressive=");
			sw.Write(this.Progressive.ToString().ToLower());
			return sw.ToString();
		}

		// ^ //

		/// <summary>
		/// 
		/// </summary>
		public enum ColorTransform : byte
		{
			Undefined = 0,
			YCbCr = 1,
			Ycck = 2
		}

		/// <summary>
		/// 
		/// </summary>
		public enum Flag0 : ushort
		{
			NoDownsampling = 0,
			Compress_9_12 = 0x4000,
			Downsampling = 0x8000,
			WebUse = 0xC000
		}
	}
}
