using System;
using System.IO;

using SystemNeo.IO;
using SystemNeo.Text;

namespace SystemNeo.Drawing.Imaging.Jfif
{
	/// <summary>
	/// 
	/// </summary>
	public sealed class DhtSegmentContent : SegmentContent
	{
		#region private static fields
		private const int codeCountsLength = 16;
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public DhtClass Class { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public byte[] CodeCounts { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public int TableId { get; private set; }

		// internal RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="reader"></param>
		internal DhtSegmentContent(BinaryReaderNeo reader)
		{
			byte upper;
			byte lower;
			ObjectUtil.SplitBits(reader.ReadByte(), out upper, out lower);
			this.Class = (DhtClass)upper;
			this.CodeCounts = reader.ReadBytes(codeCountsLength);
			this.TableId = lower;
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override string ToString()
		{
			var sw = new StringWriter();
			sw.Write("TableId=");
			sw.Write(this.TableId);
			sw.Write(", Class=");
			sw.Write(this.Class);
			sw.Write(", CodeCounts=");
			new CollectionFormatter().WriteTo(sw, this.CodeCounts);
			return sw.ToString();
		}

		// ^ //

		/// <summary>
		/// 
		/// </summary>
		public enum DhtClass : byte
		{
			DC = 0,
			AC = 1
		}
	}
}
