using System;
using System.Collections;
using System.Collections.Generic;
using System.IO;

using SystemNeo;
using SystemNeo.IO;
using SystemNeo.Text;

namespace SystemNeo.Drawing.Imaging.Tiff
{
	/// <summary>
	/// Tiff 摜Ɋ܂܂ Image File Directory \܂B
	/// </summary>
	public sealed class Ifd
	{
		#region private static fields
		private static readonly CollectionFormatter formatter = new CollectionFormatter() {
			BeginBracket = "[" + Environment.NewLine + CharUtil.Tab,
			EndBracket = Environment.NewLine + "]",
			Separator = "," + Environment.NewLine + CharUtil.Tab
		};
		#endregion

		#region private fields
		private readonly long offset;
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public ICollection<IfdEntry> Entries { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public string Name { get; private set; }

		// private RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="name"></param>
		/// <param name="offset"></param>
		private Ifd(string name, long offset)
		{
			this.Name = name;
			this.offset = offset;
			this.Entries = new List<IfdEntry>();
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override string ToString()
		{
			var sw = new StringWriter();
			sw.Write(this.Name);
			sw.Write("=");
			if (this.Entries.Count == 0) {
				sw.Write("none");
			} else {
				formatter.WriteTo(sw, this.Entries);
			}
			return sw.ToString();
		}

		// internal static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="reader"></param>
		/// <param name="name"></param>
		/// <param name="ifdList"></param>
		/// <returns></returns>
		internal static Ifd ReadIfd(BinaryReaderNeo reader, string name, IList<Ifd> ifdList)
		{
			foreach (var ifd in ifdList) {
				if (ifd.Name == name) {
					return ifd;
				}
			}
			var result = new Ifd(name, reader.Position);
			ifdList.Add(result);
			int count = reader.ReadUInt16();
			for (int i = 0; i < count; i++) {
				result.Entries.Add(new IfdEntry(reader, ifdList));
			}
			return result;
		}
	}
}
