using System;
using System.Collections;
using System.Collections.Generic;
using System.Drawing;
using System.IO;

using SystemNeo.Drawing.Imaging.Icc;
using SystemNeo.IO;

namespace SystemNeo.Drawing.Imaging.Tiff
{
	/// <summary>
	/// 
	/// </summary>
	public class TiffData
	{
		#region private static fields
		private const ushort idValue = 42;
		private const string ifdNamePrefix = "IFD";
		#endregion

		#region private fields
		private readonly long beginOffset;
		private readonly IList<Ifd> ifdList = new List<Ifd>();
		private readonly ushort id;
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public TiffByteOrder ByteOrder { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public ICollection<Ifd> IfdCollection
		{
			get {
				return this.ifdList;
			}
		}

		// private RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="input"></param>
		private TiffData(Stream input)
		{
			this.beginOffset = input.Position;
			var reader = new BinaryReaderNeo(input);
			this.ByteOrder = (TiffByteOrder)reader.ReadUInt16();
			switch (this.ByteOrder) {
			case TiffByteOrder.BigEndian:
				reader.ByteOrder = SystemNeo.IO.ByteOrder.BigEndian;
				break;
			case TiffByteOrder.LittleEndian:
				reader.ByteOrder = SystemNeo.IO.ByteOrder.LittleEndian;
				break;
			default:
				string msg = string.Format(
						"oCgI[_[̒lsłB0x{0:X4}", this.ByteOrder);
				throw new BadImageFormatException(msg);
			}
			this.id = reader.ReadUInt16();
			if (this.id != idValue) {
				string msg = string.Format(
						"IDsłi{0}jB̒l͒ʏA{1} łB", this.id, idValue);
				throw new BadImageFormatException(msg);
			}
			uint firstIfdOffset = reader.ReadUInt32();
			reader.Position = firstIfdOffset;
			this.ReadIfdEntries(reader);
		}

		// public static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="input"></param>
		/// <returns></returns>
		public static TiffData FromStream(Stream input)
		{
			return new TiffData(input);
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override string ToString()
		{
			var sw = new StringWriter();
			sw.Write("{ByteOrder=");
			sw.Write(this.ByteOrder);
			foreach (var ifd in this.ifdList) {
				sw.Write(", ");
				sw.Write(ifd);
			}
			sw.Write("}");
			return sw.ToString();
		}

		// private \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="reader"></param>
		private void ReadIfdEntries(BinaryReaderNeo reader)
		{
			int index = 0;
			long nextIfdOffset = reader.Position;
			while (0 < nextIfdOffset && nextIfdOffset < reader.Length) {
				reader.Position = nextIfdOffset;
				Ifd.ReadIfd(reader, ifdNamePrefix + index, this.ifdList);
				nextIfdOffset = reader.ReadUInt32();
				index++;
			}
		}
	}
}
