using System;
using System.Collections;
using System.Collections.Generic;
using System.Drawing;
using System.IO;
using System.Runtime.InteropServices;
using System.Security.Permissions;
using System.Text;
using System.Windows.Forms;

using SystemNeo;
using SystemNeo.Text;
using SystemNeo.Windows;

namespace SystemNeo.Windows
{
	/// <summary>
	/// tH_ƃt@CɊւ郁\bh񋟂܂B
	/// </summary>
	public static class FileUtil
	{
		// public 萔 //

		/// <summary>
		/// 
		/// </summary>
		public const string CurrentDirectoryPath = ".";

		/// <summary>
		/// 
		/// </summary>
		public const string ParentDirectoryPath = "..";

		/// <summary>
		/// 
		/// </summary>
		public const int PathMaxLength = 260;

		// public static \bh //

		/// <summary>
		/// t@CRs[܂B
		/// </summary>
		/// <param name="sourcePaths"></param>
		/// <param name="destPath"></param>
		/// <param name="control"></param>
		/// <returns></returns>
		public static bool CopyFiles(
				IEnumerable<string> sourcePaths, string destPath, Control control)
		{
			return CopyFiles(sourcePaths, destPath, 0, control);
		}

		/// <summary>
		/// t@CRs[܂B
		/// </summary>
		/// <param name="sourcePaths"></param>
		/// <param name="destPaths"></param>
		/// <param name="control"></param>
		/// <returns></returns>
		public static bool CopyFiles(
				IEnumerable<string> sourcePaths, IEnumerable<string> destPaths, Control control)
		{
			return CopyFiles(sourcePaths, destPaths, 0, control);
		}

		/// <summary>
		/// t@CRs[܂B
		/// </summary>
		/// <param name="sourcePaths"></param>
		/// <param name="destPath"></param>
		/// <param name="flags"></param>
		/// <param name="control"></param>
		/// <returns></returns>
		public static bool CopyFiles(IEnumerable<string> sourcePaths,
				string destPath, SHFileOperationFlags flags, Control control)
		{
			bool aborted;
			bool result = SHFileOperation(control, SHFileOperationFunc.FO_COPY,
					sourcePaths, new string[] {destPath}, flags, out aborted, null);
			return result && ! aborted;
		}

		/// <summary>
		/// t@CRs[܂B
		/// </summary>
		/// <param name="sourcePaths"></param>
		/// <param name="destPaths"></param>
		/// <param name="flags"></param>
		/// <param name="control"></param>
		/// <returns></returns>
		public static bool CopyFiles(IEnumerable<string> sourcePaths,
				IEnumerable<string> destPaths, SHFileOperationFlags flags, Control control)
		{
			bool aborted;
			bool result = SHFileOperation(control, SHFileOperationFunc.FO_COPY, sourcePaths,
					destPaths, flags | SHFileOperationFlags.FOF_MULTIDESTFILES, out aborted, null);
			return result && ! aborted;
		}

		/// <summary>
		/// t@C폜܂B
		/// </summary>
		/// <param name="targetPaths"></param>
		/// <param name="flags"></param>
		/// <param name="control"></param>
		/// <returns></returns>
		public static bool DeleteFiles(
				IEnumerable<string> targetPaths, SHFileOperationFlags flags, Control control)
		{
			bool aborted;
			bool result = SHFileOperation(control, SHFileOperationFunc.FO_DELETE,
					targetPaths, new string[] {}, flags, out aborted, null);
			return result && ! aborted;
		}

		/// <summary>
		/// w肵p^[ɈvTufBNgw肵fBNg擾܂B
		/// </summary>
		/// <param name="path"></param>
		/// <param name="searchPattern"></param>
		/// <returns></returns>
		public static IEnumerable<FileSystemInfo> GetDirectories(string path, string searchPattern)
		{
			return new FileSystemEnumerable(path, searchPattern, true);
		}

		/// <summary>
		/// t@CɊ֘AtꂽACR擾܂B
		/// </summary>
		/// <param name="fileName"></param>
		/// <param name="smallIcon"></param>
		public static Icon GetFileIcon(string fileName, bool smallIcon)
		{
			return GetFileIcon(fileName, smallIcon, false);
		}

		/// <summary>
		/// t@CɊ֘AtꂽACR擾܂B
		/// </summary>
		/// <param name="fileName"></param>
		/// <param name="smallIcon"></param>
		/// <param name="openIcon"></param>
		public static Icon GetFileIcon(string fileName, bool smallIcon, bool openIcon)
		{
			if (! File.Exists(fileName) && ! Directory.Exists(fileName)) {
				throw new FileNotFoundException(null, fileName);
			}
			var sfi = new SHFILEINFO();
			SHGetFileInfoFlags uFlags = SHGetFileInfoFlags.SHGFI_ICON
					| (smallIcon ? SHGetFileInfoFlags.SHGFI_SMALLICON : SHGetFileInfoFlags.SHGFI_LARGEICON)
					| (openIcon ? SHGetFileInfoFlags.SHGFI_OPENICON : 0);
			IntPtr hSuccess = NativeMethods.SHGetFileInfo(fileName, 0, ref sfi, uFlags);
			return (hSuccess == IntPtr.Zero ? null : Icon.FromHandle(sfi.hIcon));
		}

		/// <summary>
		/// t@CĂACR擾܂B
		/// </summary>
		/// <param name="fileName"></param>
		/// <param name="iconIndex"></param>
		/// <param name="smallIcon"></param>
		/// <returns></returns>
		public static Icon GetFileIcon(string fileName, int iconIndex, bool smallIcon)
		{
			IntPtr[] arr = {IntPtr.Zero};
			if (smallIcon) {
				NativeMethods.ExtractIconEx(fileName, iconIndex, null, arr, 1);
			} else {
				NativeMethods.ExtractIconEx(fileName, iconIndex, arr, null, 1);
			}
			return (arr[0] == IntPtr.Zero ? null : Icon.FromHandle(arr[0]));
		}

		/// <summary>
		/// t@CĂACR̐擾܂B
		/// </summary>
		/// <param name="fileName"></param>
		/// <returns></returns>
		public static int GetFileIconCount(string fileName)
		{
			return NativeMethods.ExtractIconEx(fileName, -1, null, null, 0);
		}

		/// <summary>
		/// w肵Ɉvt@CуTufBNgA
		/// w肵fBNg擾܂B
		/// </summary>
		/// <param name="path"></param>
		/// <param name="searchPattern"></param>
		/// <param name="directoryOnly"></param>
		/// <returns></returns>
		public static IEnumerable<FileSystemInfo> GetFileSystemInfos(
				string path, string searchPattern, bool directoryOnly)
		{
			return new FileSystemEnumerable(path, searchPattern, directoryOnly);
		}

		/// <summary>
		/// t@C^CvɊ֘AtꂽACR擾܂B
		/// </summary>
		/// <param name="extension"></param>
		/// <param name="smallIcon"></param>
		/// <returns></returns>
		public static Icon GetFileTypeIcon(string extension, bool smallIcon)
		{
			string tmpFile = Path.Combine(Path.GetTempPath(), "DummyFile" + extension);
			new FileIOPermission(FileIOPermissionAccess.Write, tmpFile).Demand();
			try {
				return GetFileIcon(tmpFile, smallIcon);
			} catch (FileNotFoundException) {
				FileFlagsAndAttributes flags = FileFlagsAndAttributes.FILE_ATTRIBUTE_NORMAL
						| FileFlagsAndAttributes.FILE_FLAG_DELETE_ON_CLOSE;
				IntPtr hFile = NativeMethods.CreateFile(tmpFile,
						FileSecurityAndGenericRights.GENERIC_WRITE,
						FileShare.None, FileMode.CreateNew, flags);
				try {
					return GetFileIcon(tmpFile, smallIcon);
				} finally {
					NativeMethods.CloseHandle(hFile);
				}
			}
		}

		/// <summary>
		/// w ini t@Cw̃L[̒l擾܂B
		/// </summary>
		/// <param name="fileName">ini t@C̖OB</param>
		/// <param name="sectionName">ini t@C̃ZNVB</param>
		/// <param name="keyName">ini t@C̃L[B</param>
		/// <param name="maxLength">擾l̍ő̒B</param>
		/// <returns></returns>
		public static string GetInitializeFileValue(
				string fileName, string sectionName, string keyName, int maxLength)
		{
			return GetInitializeFileValue(fileName, sectionName, keyName, null, maxLength);
		}

		/// <summary>
		/// w ini t@Cw̃L[̒l擾܂B
		/// </summary>
		/// <param name="fileName">ini t@C̖OB</param>
		/// <param name="sectionName">ini t@C̃ZNVB</param>
		/// <param name="keyName">ini t@C̃L[B</param>
		/// <param name="defaultValue">w̃L[݂Ȃꍇɂ̃\bhԂlB</param>
		/// <param name="maxLength">擾l̍ő̒B</param>
		/// <returns></returns>
		public static string GetInitializeFileValue(string fileName,
				string sectionName, string keyName, string defaultValue, int maxLength)
		{
			var sb = new StringBuilder(maxLength);
			NativeMethods.GetPrivateProfileString(
					sectionName, keyName, defaultValue, sb, (uint)maxLength, fileName);
			return sb.ToString();
		}

		/// <summary>
		/// t@Cړ܂B
		/// </summary>
		/// <param name="sourcePaths"></param>
		/// <param name="destPath"></param>
		/// <param name="control"></param>
		/// <returns></returns>
		public static bool MoveFiles(
				IEnumerable<string> sourcePaths, string destPath, Control control)
		{
			return MoveFiles(sourcePaths, destPath, 0, control);
		}

		/// <summary>
		/// t@Cړ܂B
		/// </summary>
		/// <param name="sourcePaths"></param>
		/// <param name="destPaths"></param>
		/// <param name="control"></param>
		/// <returns></returns>
		public static bool MoveFiles(
				IEnumerable<string> sourcePaths, IEnumerable<string> destPaths, Control control)
		{
			return MoveFiles(sourcePaths, destPaths, 0, control);
		}

		/// <summary>
		/// t@Cړ܂B
		/// </summary>
		/// <param name="sourcePaths"></param>
		/// <param name="destPath"></param>
		/// <param name="flags"></param>
		/// <param name="control"></param>
		/// <returns></returns>
		public static bool MoveFiles(IEnumerable<string> sourcePaths,
				string destPath, SHFileOperationFlags flags, Control control)
		{
			bool aborted;
			bool result = SHFileOperation(control, SHFileOperationFunc.FO_MOVE,
					sourcePaths, new string[] {destPath}, flags, out aborted, null);
			return result && ! aborted;
		}

		/// <summary>
		/// t@Cړ܂B
		/// </summary>
		/// <param name="sourcePaths"></param>
		/// <param name="destPaths"></param>
		/// <param name="flags"></param>
		/// <param name="control"></param>
		/// <returns></returns>
		public static bool MoveFiles(IEnumerable<string> sourcePaths,
				IEnumerable<string> destPaths, SHFileOperationFlags flags, Control control)
		{
			bool aborted;
			bool result = SHFileOperation(control, SHFileOperationFunc.FO_MOVE, sourcePaths,
					destPaths, flags | SHFileOperationFlags.FOF_MULTIDESTFILES, out aborted, null);
			return result && ! aborted;
		}

		// private static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="control"></param>
		/// <param name="func"></param>
		/// <param name="sourcePaths"></param>
		/// <param name="destPaths"></param>
		/// <param name="flags"></param>
		/// <param name="aborted"></param>
		/// <param name="progressTitle"></param>
		/// <returns></returns>
		private static bool SHFileOperation(Control control, SHFileOperationFunc func,
				IEnumerable<string> sourcePaths, IEnumerable<string> destPaths,
				SHFileOperationFlags flags, out bool aborted, string progressTitle)
		{
			ArgumentUtil.AssertInvalidEnum(func, "func");
			FileIOPermissionAccess fipaSource = 0;
			FileIOPermissionAccess fipaDest = 0;

			// eɉăZLeB`FbN̓e߂
			switch (func) {
			case SHFileOperationFunc.FO_COPY:
				fipaSource = FileIOPermissionAccess.Read;
				fipaDest = FileIOPermissionAccess.Write;
				break;
			case SHFileOperationFunc.FO_DELETE:
				fipaSource = FileIOPermissionAccess.Write;
				break;
			case SHFileOperationFunc.FO_MOVE:
			case SHFileOperationFunc.FO_RENAME:
				fipaSource = FileIOPermissionAccess.Read | FileIOPermissionAccess.Write;
				fipaDest = FileIOPermissionAccess.Write;
				break;
			}

			// ZLeB`FbNs
			if (fipaSource != 0) {
				foreach (string path in sourcePaths) {
					new FileIOPermission(fipaSource, Path.GetFullPath(path)).Demand();
				}
			}
			if (fipaDest != 0) {
				foreach (string path in destPaths) {
					new FileIOPermission(fipaDest, Path.GetFullPath(path)).Demand();
				}
			}

			string separator = CharUtil.Null.ToString();
			var cf = new CollectionFormatter(null, separator, separator);
			string from = cf.ToString(sourcePaths);
			string to   = cf.ToString(destPaths);

			// s
			var op = new SHFILEOPSTRUCT(control, func, from, to, flags, progressTitle);
			int result = NativeMethods.SHFileOperation(ref op);
			aborted = op.AnyOperationsAborted;
			return result == 0;
		}
	}
}
