using System;
using System.ComponentModel;
using System.Globalization;
using System.Windows.Forms;

using SystemNeo;

namespace SystemNeo.Windows.Forms
{
	/// <summary>
	/// t͂邽߂̃eLXg{bNXłB
	/// </summary>
	public class DateTextBox : TextBoxEx
	{
		#region private fields
		private string defaultFormat = "yyyy/MM/dd";
		private string[] formats = {
				"yy/M/d", "yyyy/M/d",
				"yy-M-d", "yyyy-M-d",
				"yyMMdd", "yyyyMMdd"};
		private DateTimeStyles style = DateTimeStyles.None;
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		[DefaultValue("yyyy/MM/dd")]
		public string DefaultFormat
		{
			get {
				return this.defaultFormat;
			}
			set {
				this.defaultFormat = value;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		protected virtual string[] Formats
		{
			get {
				return this.formats;
			}
			set {
				this.formats = value;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		[Browsable(false)]
		[DefaultValue(ImeMode.Disable)]
		protected new ImeMode ImeMode
		{
			get {
				return base.ImeMode;
			}
			set {
			}
		}

		/// <summary>
		/// 
		/// </summary>
		protected DateTimeStyles Style
		{
			get {
				return this.style;
			}
			set {
				this.style = value;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		[Browsable(false)]
		public override object Value
		{
			get {
				return this.GetValue();
			}
			set {
				if (IsNull(value)) {
					this.Text = string.Empty;
				} else if (value is DateTime) {
					this.Text = this.Format((DateTime)value);
				} else {
					throw new ArgumentException();
				}
			}
		}

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		public DateTextBox()
		{
			base.ImeMode = ImeMode.Disable;
		}

		// protected \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="c"></param>
		/// <returns></returns>
		protected override bool AcceptChar(char c)
		{
			switch (c) {
			case CharUtil.Backspace:
			case CharUtil.Hyphen:
			case CharUtil.Slash:
				return true;
			default:
				return CharUtil.IsAsciiDigit(c);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		protected string Format(DateTime value)
		{
			return value.ToString(this.defaultFormat);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		protected object GetValue()
		{
			if (this.Text == null) {
				return DBNull.Value;
			} else {
				return this.Parse(this.Text);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="e"></param>
		protected override void OnValidating(CancelEventArgs e)
		{
			try {
				object dt = this.GetValue();
				if (dt is DateTime) {
					this.Text = this.Format((DateTime)dt);
				}
			} catch (FormatException) {
				e.Cancel = true;
			}
			base.OnValidating(e);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		protected DateTime Parse(string value)
		{
			return DateTime.ParseExact(value, this.formats, null, this.style);
		}
	}
}
