using System;

namespace SystemNeo
{
	/// <summary>
	/// Ɋւ郁\bh񋟂܂B
	/// </summary>
	public static class CharUtil
	{
		// public 萔 //

		public const char Ampersand = '&';
		public const char Asterisk = '*';
		public const char Atmark = '@';
		public const char BackQuote = '`';
		public const char BackSlash = '\\';
		public const char Backspace = '\x0008';
		public const char Colon = ':';
		public const char Comma = ',';
		public const char CarriageReturn = '\r';
		public const char Dollar = '$';
		public const char Dot = '.';
		public const char DoubleQuote = '\"';
		public const char Equal = '=';
		public const char ExclamationMark = '!';
		public const char Hyphen = '-';
		public const char LineFeed = '\n';
		public const char Minus = '-';
		public const char Null = '\0';
		public const char Period = '.';
		public const char Percent = '%';
		public const char Pipe = '|';
		public const char Plus = '+';
		public const char QuestionMark = '?';
		public const char Semicolon = ';';
		public const char Sharp = '#';
		public const char SingleQuote = '\'';
		public const char Slash = '/';
		public const char Space = ' ';
		public const char Tab = '\t';
		public const char Tilde = '~';
		public const char Underscore = '_';
		public const char VerticalTab = '\v';

		// internal static tB[h //

		internal static readonly char[] HalfWidthDakuonKanaMap = {
				'', 'K', '', 'M', '', 'O', '', 'Q', '', 'S',
				'', 'U', '', 'W', '', 'Y', '', '[', '', ']',
				'', '_', '', 'a', '', 'd', '', 'f', '', 'h',
				'', 'o', '', 'r', '', 'u', '', 'x', '', '{',
				'', ''};

		internal static readonly char[] HalfWidthDigitMap = {
				'0', 'O', '1', 'P', '2', 'Q', '3', 'R', '4', 'S',
				'5', 'T', '6', 'U', '7', 'V', '8', 'W', '9', 'X'};

		internal static readonly char[] HalfWidthHandakuonKanaMap = {
				'', 'p', '', 's', '', 'v', '', 'y', '', '|'};

		internal static readonly char[] HalfWidthKanaMap = {
				'', 'A', '', 'C', '', 'E', '', 'G', '', 'I',
				'', 'J', '', 'L', '', 'N', '', 'P', '', 'R',
				'', 'T', '', 'V', '', 'X', '', 'Z', '', '\',
				'', '^', '', '`', '', 'c', '', 'e', '', 'g',
				'', 'i', '', 'j', '', 'k', '', 'l', '', 'm',
				'', 'n', '', 'q', '', 't', '', 'w', '', 'z',
				'', '}', '', '~', '', '', '', '', '', '',
				'', '', '', '', '', '',
				'', '', '', '', '', '', '', '', '', '',
				'', '', '', '', '', '', '', 'J', 'K', 'K',
				'', '@', '', 'B', '', 'D', '', 'F', '', 'H',
				'', '', '', '', '', '', '', 'b', '', '[',
				'', 'B', '', 'A', '', 'u', '', 'v', '', 'E'};

		// public static \bh //

		/// <summary>
		/// 10i\̂Ɏgp镶ǂ肵܂B
		/// </summary>
		/// <param name="c"></param>
		/// <returns></returns>
		public static bool IsAsciiDigit(char c)
		{
			return '0' <= c && c <= '9';
		}

		/// <summary>
		/// 16i\̂Ɏgp镶ǂ肵܂B
		/// </summary>
		/// <param name="c"></param>
		/// <returns></returns>
		public static bool IsAsciiHex(char c)
		{
			return '0' <= c && c <= '9'
				|| 'A' <= c && c <= 'F'
				|| 'a' <= c && c <= 'f';
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="c"></param>
		/// <returns></returns>
		public static bool IsAsciiLetter(char c)
		{
			return IsAsciiLower(c) || IsAsciiUpper(c);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="c"></param>
		/// <returns></returns>
		public static bool IsAsciiLower(char c)
		{
			return 'a' <= c && c <= 'z';
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="c"></param>
		/// <returns></returns>
		public static bool IsAsciiUpper(char c)
		{
			return 'A' <= c && c <= 'Z';
		}
	}
}
