﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;

namespace SystemNeo.Collections
{
	/// <summary>
	/// 
	/// </summary>
	/// <typeparam name="TKey"></typeparam>
	/// <typeparam name="TValue"></typeparam>
	public class NonGenericDictionary<TKey, TValue> : IDictionary
	{
		#region private fields
		private readonly IDictionary<TKey, TValue> source;
		#endregion

		// public プロパティ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <returns></returns>
		public object this[object key]
		{
			get {
				return this.source[(TKey)key];
			}
			set {
				this.source[(TKey)key] = (TValue)value;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public int Count
		{
			get {
				return this.source.Count;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public bool IsFixedSize
		{
			get {
				return this.source.IsReadOnly;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public bool IsReadOnly
		{
			get {
				return this.source.IsReadOnly;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public bool IsSynchronized
		{
			get {
				return false;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public ICollection Keys
		{
			get {
				return this.source.Keys.ToList();
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public object SyncRoot
		{
			get {
				return this.source;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public ICollection Values
		{
			get {
				return this.source.Values.ToList();
			}
		}

		// public コンストラクタ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="source"></param>
		public NonGenericDictionary(IDictionary<TKey, TValue> source)
		{
			ArgumentUtil.AssertNull(source, "source");
			this.source = source;
		}

		// public メソッド //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <param name="value"></param>
		public void Add(object key, object value)
		{
			this.source.Add((TKey)key, (TValue)value);
		}

		/// <summary>
		/// 
		/// </summary>
		public void Clear()
		{
			this.source.Clear();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <returns></returns>
		public bool Contains(object key)
		{
			return this.source.ContainsKey((TKey)key);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="array"></param>
		/// <param name="index"></param>
		public void CopyTo(Array array, int index)
		{
			throw new NotImplementedException();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public IDictionaryEnumerator GetEnumerator()
		{
			throw new NotImplementedException();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		public void Remove(object key)
		{
			this.source.Remove((TKey)key);
		}

		// private メソッド //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		IEnumerator IEnumerable.GetEnumerator()
		{
			return this.source.GetEnumerator();
		}
	}
}
