using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;

using SystemNeo;

namespace SystemNeo.Collections
{
	/// <summary>
	/// c[\f[^ɑ΂Ċȇs\bh񋟂܂B
	/// ͒ۃNXłB
	/// </summary>
	public abstract class TreeManager : ITreeManager
	{
		// public 萔 //

		/// <summary>
		/// 
		/// </summary>
		public const int DepthInfinity = -1;

		// public static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="source"></param>
		/// <param name="dest"></param>
		/// <param name="sourceManager"></param>
		/// <param name="destManager"></param>
		/// <param name="converter"></param>
		public static void Convert(object source, object dest,
				ITreeManager sourceManager, ITreeManager destManager, Func<object, object> converter)
		{
			Convert(source, dest, sourceManager, destManager, converter, DepthInfinity);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="source"></param>
		/// <param name="dest"></param>
		/// <param name="sourceManager"></param>
		/// <param name="destManager"></param>
		/// <param name="converter"></param>
		/// <param name="depth"></param>
		public static void Convert(object source, object dest, ITreeManager sourceManager,
				ITreeManager destManager, Func<object, object> converter, int depth)
		{
			ArgumentUtil.AssertNull(source, "source");
			ArgumentUtil.AssertNull(dest, "dest");
			ArgumentUtil.AssertNull(sourceManager, "sourceManager");
			ArgumentUtil.AssertNull(destManager, "destManager");
			ArgumentUtil.AssertNull(converter, "converter");
			ConvertInternal(source, dest, sourceManager, destManager, converter, depth);
		}

		// public \bh //

		/// <summary>
		/// m[hɎqm[hǉ܂B
		/// </summary>
		/// <param name="parentNode"></param>
		/// <param name="child"></param>
		public abstract void AddChild(object parent, object child);

		/// <summary>
		/// w肳ꂽm[h̎q̂Aw肳ꂽɍm[h1ȏ゠邩ǂׂ܂B
		/// </summary>
		/// <param name="baseNode"></param>
		/// <param name="match"></param>
		/// <returns></returns>
		public bool Any(object baseNode, Predicate<object> match)
		{
			return this.FindFirst(baseNode, match, TreeSearchAlgorithm.Default, DepthInfinity) != null;
		}

		/// <summary>
		/// w肳ꂽm[h̎q̂Aw肳ꂽɍm[h1ȏ゠邩ǂׂ܂B
		/// </summary>
		/// <param name="baseNode"></param>
		/// <param name="match"></param>
		/// <returns></returns>
		public bool Any<T>(object baseNode, Func<T, bool> match)
		{
			return this.FindFirst(baseNode, match, TreeSearchAlgorithm.Default, DepthInfinity) != null;
		}

		/// <summary>
		/// w肳ꂽm[h̎q̂Aw肳ꂽɍŏ̃m[h擾܂B
		/// </summary>
		/// <param name="baseNode"></param>
		/// <param name="match"></param>
		/// <returns></returns>
		public object FindFirst(object baseNode, Predicate<object> match)
		{
			return this.FindFirst(baseNode, match, TreeSearchAlgorithm.Default, DepthInfinity);
		}

		/// <summary>
		/// w肳ꂽm[h̎q̂Aw肳ꂽɍŏ̃m[h擾܂B
		/// </summary>
		/// <param name="baseNode"></param>
		/// <param name="match"></param>
		/// <param name="depth"></param>
		/// <returns></returns>
		public object FindFirst(object baseNode, Predicate<object> match, int depth)
		{
			return this.FindFirst(baseNode, match, TreeSearchAlgorithm.Default, depth);
		}

		/// <summary>
		/// w肳ꂽm[h̎q̂Aw肳ꂽɍŏ̃m[h擾܂B
		/// </summary>
		/// <param name="baseNode"></param>
		/// <param name="match"></param>
		/// <param name="algorithm"></param>
		/// <param name="depth"></param>
		/// <returns></returns>
		public object FindFirst(object baseNode,
				Predicate<object> match, TreeSearchAlgorithm algorithm, int depth)
		{
			ArgumentUtil.AssertNull(baseNode, "baseNode");
			ArgumentUtil.AssertNull(match, "match");
			return this.FindFirstInternal(baseNode, match, algorithm, depth);
		}

		/// <summary>
		/// w肳ꂽm[hƂ̎q̃m[hɑ΂āAw肳ꂽs܂B
		/// </summary>
		/// <param name="baseNode"></param>
		/// <param name="action"></param>
		public void ForEach(object baseNode, Action<object> action)
		{
			this.ForEach(baseNode, action, TreeSearchAlgorithm.Default, DepthInfinity);
		}

		/// <summary>
		/// w肳ꂽm[hƂ̎q̃m[hɑ΂āAw肳ꂽs܂B
		/// </summary>
		/// <param name="baseNode"></param>
		/// <param name="action"></param>
		/// <param name="depth"></param>
		public void ForEach(object baseNode, Action<object> action, int depth)
		{
			this.ForEach(baseNode, action, TreeSearchAlgorithm.Default, depth);
		}

		/// <summary>
		/// w肳ꂽm[hƂ̎q̃m[hɑ΂āAw肳ꂽs܂B
		/// </summary>
		/// <param name="baseNode"></param>
		/// <param name="action"></param>
		/// <param name="algorithm"></param>
		/// <param name="depth"></param>
		public void ForEach(
				object baseNode, Action<object> action, TreeSearchAlgorithm algorithm, int depth)
		{
			ArgumentUtil.AssertNull(baseNode, "baseNode");
			ArgumentUtil.AssertNull(action, "action");
			ArgumentUtil.AssertInvalidEnum(algorithm, "algorithm");
			Predicate<object> match = (obj) => {
				action(obj);
				return false;
			};
			// ǂ̃m[hɂ}b`Ȃ̂ŁAʓIɑSẴm[hH
			this.FindInternal(baseNode, match, algorithm, 1, depth);
		}

		/// <summary>
		/// w肳ꂽm[h̑c̃m[h珇ɒH񋓎q擾܂B
		/// </summary>
		/// <param name="baseNode"></param>
		/// <returns></returns>
		public virtual IEnumerable GetAncestors(object baseNode)
		{
			ArgumentUtil.AssertNull(baseNode, "baseNode");
			object node = baseNode;
			for (;;) {
				node = this.GetParent(node);
				if (node == null) {
					break;
				}
				yield return node;
			}
		}

		/// <summary>
		/// w肳ꂽm[h̑Oɂm[htɒH񋓎q擾܂B
		/// </summary>
		/// <param name="baseNode"></param>
		/// <param name="loop"></param>
		/// <returns></returns>
		public virtual IEnumerable GetBackwards(object baseNode, bool loop)
		{
			return new BackwardEnumerable(this, baseNode, this.IsSame, loop);
		}

		/// <summary>
		/// w肳ꂽm[h̎qm[h񋓂񋓎q擾܂B
		/// </summary>
		/// <param name="node"></param>
		/// <returns></returns>
		public abstract IEnumerable GetChildren(object node);

		/// <summary>
		/// w肳ꂽm[h̍ŏ̎qm[h擾܂B
		/// </summary>
		/// <param name="node"></param>
		/// <returns></returns>
		public virtual object GetFirstChild(object node)
		{
			return this.GetChildren(node).Cast<object>().FirstOrDefault();
		}

		/// <summary>
		/// w肳ꂽm[ȟɂm[hɒH񋓎q擾܂B
		/// </summary>
		/// <param name="baseNode"></param>
		/// <param name="loop"></param>
		/// <returns></returns>
		public virtual IEnumerable GetForwards(object baseNode, bool loop)
		{
			return new ForwardEnumerable(this, baseNode, this.IsSame, loop);
		}

		/// <summary>
		/// w肳ꂽm[h̍Ō̎qm[h擾܂B
		/// </summary>
		/// <param name="node"></param>
		/// <param name="recurse"></param>
		/// <returns></returns>
		public virtual object GetLastChild(object node, bool recurse)
		{
			if (recurse) {
				object child = this.GetLastChild(node, false);
				if (child == null) {
					return null;
				} else {
					object descendant = this.GetLastChild(child, true);
					return descendant ?? child;
				}
			} else {
				return this.GetChildren(node).Cast<object>().LastOrDefault();
			}
		}

		/// <summary>
		/// w肳ꂽm[h̒i邢͖jɂm[h擾܂B
		/// </summary>
		/// <param name="node"></param>
		/// <returns></returns>
		public virtual object GetNextSibling(object node)
		{
			ArgumentUtil.AssertNull(node, "node");
			object parent = this.GetParent(node);
			if (parent == null) {
				return null;
			} else {
				return CollectionUtil.GetNextItem(this.GetChildren(parent), node);
			}
		}

		/// <summary>
		/// w肳ꂽm[h̐em[h擾܂B
		/// </summary>
		/// <param name="node"></param>
		/// <returns></returns>
		public abstract object GetParent(object node);

		/// <summary>
		/// w肳ꂽm[ȟZi邢͎ojɂm[h擾܂B
		/// </summary>
		/// <param name="node"></param>
		/// <returns></returns>
		public virtual object GetPreviousSibling(object node)
		{
			ArgumentUtil.AssertNull(node, "node");
			object parent = this.GetParent(node);
			if (parent == null) {
				return null;
			} else {
				return CollectionUtil.GetPreviousItem(this.GetChildren(parent), node);
			}
		}

		/// <summary>
		/// w肳ꂽm[hqm[hĂ邩ǂ𒲂ׂ܂B
		/// </summary>
		/// <param name="node"></param>
		/// <returns></returns>
		public virtual bool HasChildren(object node)
		{
			return GetChildren(node).GetEnumerator().MoveNext();
		}

		/// <summary>
		/// m[hɎqm[hǉ܂B
		/// </summary>
		/// <param name="parentNode"></param>
		/// <param name="child"></param>
		/// <param name="index"></param>
		public abstract void Insert(object parent, object child, int index);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="parentNode"></param>
		/// <param name="child"></param>
		/// <param name="comparer"></param>
		public void InsertSorted(object parent, object child, IComparer comparer)
		{
			ArgumentUtil.AssertNull(parent, "parentNode");
			ArgumentUtil.AssertNull(child, "child");
			ArgumentUtil.AssertNull(comparer, "comparer");
			this.InsertSortedInternal(parent, child, comparer);
		}

		/// <summary>
		/// w肳ꂽm[h̎qm[hSč폜܂B
		/// </summary>
		/// <param name="node"></param>
		public virtual void RemoveAllChildren(object node)
		{
			throw new NotSupportedException();
		}

		/// <summary>
		/// w肳ꂽqm[h폜܂B
		/// </summary>
		/// <param name="parentNode"></param>
		/// <param name="child"></param>
		public abstract void RemoveChild(object parent, object child);

		/// <summary>
		/// w肳ꂽm[h̎qm[hבւ܂B
		/// </summary>
		/// <param name="node"></param>
		/// <param name="comparer"></param>
		/// <param name="recurse"></param>
		public void Sort(object node, IComparer comparer, bool recurse)
		{
			ArgumentUtil.AssertNull(node, "node");
			ArgumentUtil.AssertNull(comparer, "comparer");
			this.SortInternal(node, comparer, recurse);
		}

		// protected \bh //

		/// <summary>
		/// w肳ꂽm[h̎q̂Aw肳ꂽɍŏ̃m[h擾܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="baseNode"></param>
		/// <param name="match"></param>
		/// <param name="algorithm"></param>
		/// <param name="depth"></param>
		/// <returns></returns>
		protected T FindFirst<T>(
				object baseNode, Func<T, bool> match, TreeSearchAlgorithm algorithm, int depth)
		{
			ArgumentUtil.AssertNull(baseNode, "baseNode");
			ArgumentUtil.AssertNull(match, "match");
			Predicate<object> p = (obj) => obj is T && match((T)obj);
			return (T)this.FindFirstInternal(baseNode, p, algorithm, depth);
		}

		/// <summary>
		/// w肳ꂽm[hɂm[ĥAw肳ꂽɍŏ̃m[h擾܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="currentNode"></param>
		/// <param name="match"></param>
		/// <param name="loop"></param>
		/// <returns></returns>
		protected T FindNext<T>(object currentNode, Func<T, bool> match, bool loop)
		{
			return FindInternal<T>(currentNode, match, loop, this.GetForwards);
		}

		/// <summary>
		/// w肳ꂽm[h̒i邢͖jɂm[ĥAw肳ꂽɍŏ̃m[h擾܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="currentNode"></param>
		/// <param name="match"></param>
		/// <returns></returns>
		protected T FindNextSibling<T>(object currentNode, Func<T, bool> match)
		{
			return FindSiblingInternal<T>(currentNode, match, this.GetNextSibling);
		}

		/// <summary>
		/// w肳ꂽm[hOɂm[ĥAw肳ꂽɍŌ̃m[h擾܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="currentNode"></param>
		/// <param name="match"></param>
		/// <param name="loop"></param>
		/// <returns></returns>
		protected T FindPrevious<T>(object currentNode, Func<T, bool> match, bool loop)
		{
			return FindInternal<T>(currentNode, match, loop, this.GetBackwards);
		}

		/// <summary>
		/// w肳ꂽm[ȟZi邢͎ojɂm[ĥAw肳ꂽɍŌ̃m[h擾܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="currentNode"></param>
		/// <param name="match"></param>
		/// <returns></returns>
		protected T FindPreviousSibling<T>(object currentNode, Func<T, bool> match)
		{
			return FindSiblingInternal<T>(currentNode, match, this.GetPreviousSibling);
		}

		/// <summary>
		/// w肳ꂽm[hƂ̎q̃m[hɑ΂āAw肳ꂽs܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="baseNode"></param>
		/// <param name="action"></param>
		/// <param name="algorithm"></param>
		/// <param name="depth"></param>
		protected void ForEach<T>(
				object baseNode, Action<T> action, TreeSearchAlgorithm algorithm, int depth)
		{
			ArgumentUtil.AssertNull(baseNode, "baseNode");
			ArgumentUtil.AssertNull(action, "action");
			Predicate<object> match = (obj) => {
				if (obj is T) {
					action((T)obj);
				}
				return false;
			};
			// ǂ̃m[hɂ}b`Ȃ̂ŁAʓIɑSẴm[hH
			this.FindFirstInternal(baseNode, match, algorithm, depth);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="parentNode"></param>
		/// <param name="child"></param>
		/// <param name="comparer"></param>
		protected void InsertSorted<T>(object parent, T child, IComparer<T> comparer)
		{
			ArgumentUtil.AssertNull(parent, "parentNode");
			ArgumentUtil.AssertNull(child, "child");
			ArgumentUtil.AssertNull(comparer, "comparer");
			var cc = new ComparisonComparer<T>(comparer.Compare);
			this.InsertSortedInternal(parent, child, cc);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="parentNode"></param>
		/// <param name="child"></param>
		/// <param name="comparison"></param>
		protected void InsertSorted<T>(object parent, T child, Comparison<T> comparison)
		{
			ArgumentUtil.AssertNull(parent, "parentNode");
			ArgumentUtil.AssertNull(child, "child");
			ArgumentUtil.AssertNull(comparison, "comparison");
			var cc = new ComparisonComparer<T>(comparison);
			this.InsertSortedInternal(parent, child, cc);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		protected virtual bool IsSame(object x, object y)
		{
			return x == y;
		}

		/// <summary>
		/// w肳ꂽm[h̎qm[hבւ܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="node"></param>
		/// <param name="comparer"></param>
		/// <param name="recurse"></param>
		protected void Sort<T>(object node, IComparer<T> comparer, bool recurse)
		{
			ArgumentUtil.AssertNull(node, "node");
			ArgumentUtil.AssertNull(comparer, "comparer");
			var cc = new ComparisonComparer<T>(comparer.Compare);
			this.SortInternal(node, cc, recurse);
		}

		/// <summary>
		/// w肳ꂽm[h̎qm[hבւ܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="node"></param>
		/// <param name="comparison"></param>
		/// <param name="recurse"></param>
		protected void Sort<T>(object node, Comparison<T> comparison, bool recurse)
		{
			ArgumentUtil.AssertNull(node, "node");
			ArgumentUtil.AssertNull(comparison, "comparison");
			var cc = new ComparisonComparer<T>(comparison);
			this.SortInternal(node, cc, recurse);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="node"></param>
		/// <param name="comparer"></param>
		/// <param name="recurse"></param>
		protected void SortInternal(object node, IComparer comparer, bool recurse)
		{
			Array array = Enumerable.ToArray(this.GetChildren(node).Cast<object>());
			Array.Sort(array, comparer);
			this.RemoveAllChildren(node);
			foreach (object child in array) {
				this.AddChild(node, child);
				if (recurse) {
					this.SortInternal(child, comparer, true);
				}
			}
		}

		// private static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="source"></param>
		/// <param name="dest"></param>
		/// <param name="sourceManager"></param>
		/// <param name="destManager"></param>
		/// <param name="converter"></param>
		/// <param name="depth"></param>
		private static void ConvertInternal(
				object source, object dest, ITreeManager sourceManager,
				ITreeManager destManager, Func<object, object> converter, int depth)
		{
			foreach (object sourceChild in sourceManager.GetChildren(source)) {
				object destChild = converter(sourceChild);
				if (destChild != null) {
					destManager.AddChild(dest, destChild);
					if (depth != 0) {
						ConvertInternal(sourceChild, 
								destChild, sourceManager, destManager, converter, depth - 1);
					}
				}
			}
		}

		/// <summary>
		/// <paramref name="currenctNode"/> N_ɂ
		/// <paramref name="enumerable"/> Ŏ擾m[hQ̂A
		/// <paramref name="match"/> Œ`ꂽɍŏ̃m[h擾܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="currentNode"></param>
		/// <param name="match"></param>
		/// <param name="loop"></param>
		/// <param name="enumerable"></param>
		/// <returns></returns>
		private static T FindInternal<T>(object currentNode,
				Func<T, bool> match, bool loop, Func<object, bool, IEnumerable> enumerable)
		{
			ArgumentUtil.AssertNull(currentNode, "currentNode");
			ArgumentUtil.AssertNull(match, "match");
			ArgumentUtil.AssertNull(enumerable, "enumerable");
			Predicate<object> p = (obj) => obj is T && match((T)obj);
			return (T)FindInternal(currentNode, p, loop, enumerable);
		}

		/// <summary>
		/// <paramref name="currenctNode"/> N_ɂ
		/// <paramref name="enumerable"/> Ŏ擾m[hQ̂A
		/// <paramref name="match"/> Œ`ꂽɍŏ̃m[h擾܂B
		/// </summary>
		/// <param name="currentNode"></param>
		/// <param name="match"></param>
		/// <param name="loop"></param>
		/// <param name="enumerable"></param>
		/// <returns></returns>
		private static object FindInternal(object currentNode,
				Predicate<object> match, bool loop, Func<object, bool, IEnumerable> enumerable)
		{
			foreach (object node in enumerable(currentNode, loop)) {
				if (match(node)) {
					return node;
				}
			}
			return null;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="currentNode"></param>
		/// <param name="match"></param>
		/// <param name="siblingGetter"></param>
		/// <returns></returns>
		private static T FindSiblingInternal<T>(
				object currentNode, Func<T, bool> match, Func<object, object> siblingGetter)
		{
			ArgumentUtil.AssertNull(currentNode, "currentNode");
			ArgumentUtil.AssertNull(match, "match");
			ArgumentUtil.AssertNull(siblingGetter, "siblingGetter");
			T node = (T)currentNode;
			for (;;) {
				node = (T)siblingGetter(node);
				if (node == null) {
					return default(T);
				}
				if (match(node)) {
					return node;
				}
			}
		}

		// private \bh //

		/// <summary>
		/// DTs܂B
		/// </summary>
		/// <param name="baseNode"></param>
		/// <param name="match"></param>
		/// <param name="foundNodes"></param>
		/// <param name="maxCount"></param>
		/// <param name="depth"></param>
		/// <returns></returns>
		private bool FindByBreadthFirstAlgorithm(
				object baseNode, Predicate<object> match, IList foundNodes, int maxCount, int depth)
		{
			var queue = new Queue();
			queue.Enqueue(baseNode);
			do {
				object node = queue.Dequeue();
				if (match(node)) {
					foundNodes.Add(node);
					if (foundNodes.Count >= maxCount) {
						return false;
					}
				}
				foreach (object childNode in this.GetChildren(node)) {
					queue.Enqueue(childNode);
				}
			} while (queue.Count > 0 && depth-- != 0);
			return true;
		}

		/// <summary>
		/// [DTs܂B
		/// </summary>
		/// <param name="baseNode"></param>
		/// <param name="match"></param>
		/// <param name="foundNodes"></param>
		/// <param name="maxCount"></param>
		/// <param name="depth"></param>
		/// <returns></returns>
		private bool FindByDepthFirstAlgorithm(object baseNode,
				Predicate<object> match, IList foundNodes, int maxCount, int depth)
		{
			if (foundNodes.Count >= maxCount) {
				return false;
			}
			if (match(baseNode)) {
				foundNodes.Add(baseNode);
			}
			if (depth != 0) {
				foreach (object childNode in this.GetChildren(baseNode)) {
					bool result = this.FindByDepthFirstAlgorithm(
							childNode, match, foundNodes, maxCount, depth - 1);
					if (! result) {
						return false;
					}
				}
			}
			return true;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="baseNode"></param>
		/// <param name="match"></param>
		/// <param name="algorithm"></param>
		/// <param name="depth"></param>
		/// <returns></returns>
		private object FindFirstInternal(object baseNode,
				Predicate<object> match, TreeSearchAlgorithm algorithm, int depth)
		{
			foreach (object node in this.FindInternal(baseNode, match, algorithm, 1, depth)) {
				return node;
			}
			return null;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="baseNode"></param>
		/// <param name="match"></param>
		/// <param name="algorithm"></param>
		/// <param name="maxCount"></param>
		/// <param name="depth"></param>
		/// <returns></returns>
		private ICollection FindInternal(object baseNode,
				Predicate<object> match, TreeSearchAlgorithm algorithm, int maxCount, int depth)
		{
			var foundNodes = new ArrayList();
			switch (algorithm) {
			case TreeSearchAlgorithm.BreadthFirstSearch:
				this.FindByBreadthFirstAlgorithm(baseNode, match, foundNodes, maxCount, depth);
				break;
			case TreeSearchAlgorithm.DepthFirstSearch:
				this.FindByDepthFirstAlgorithm(baseNode, match, foundNodes, maxCount, depth);
				break;
			default:
				ArgumentUtil.AssertInvalidEnum(algorithm, "algorithm");
				break;
			}
			return foundNodes;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="parentNode"></param>
		/// <param name="child"></param>
		/// <param name="comparer"></param>
		private void InsertSortedInternal(object parent, object child, IComparer comparer)
        {
			int index = 0;
			foreach (object c in this.GetChildren(parent)) {
				if (comparer.Compare(child, c) < 0) {
					this.Insert(parent, child, index);
					return;
				}
				index++;
			}
			this.AddChild(parent, child);
		}

		// ^ //

		/// <summary>
		/// 
		/// </summary>
		private class Enumeration
		{
			// protected tB[h //

			protected readonly object baseNode;
			protected readonly EqualityComparison comparison;
			protected readonly bool loop;
			protected readonly TreeManager manager;

			// protected RXgN^ //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="manager"></param>
			/// <param name="baseNode"></param>
			/// <param name="comparison"></param>
			/// <param name="loop"></param>
			protected Enumeration(
					TreeManager manager, object baseNode, EqualityComparison comparison, bool loop)
			{
				this.manager = manager;
				this.baseNode = baseNode;
				this.comparison = comparison;
				this.loop = loop;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		private class BackwardEnumerable : Enumeration, IEnumerable
		{
			// internal RXgN^ //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="manager"></param>
			/// <param name="baseNode"></param>
			/// <param name="comparison"></param>
			/// <param name="loop"></param>
			internal BackwardEnumerable(
					TreeManager manager, object baseNode, EqualityComparison comparison, bool loop)
					: base(manager, baseNode, comparison, loop) {}

			// private \bh//

			/// <summary>
			/// 
			/// </summary>
			/// <returns></returns>
			IEnumerator IEnumerable.GetEnumerator()
			{
				return new BackwardEnumerator(
						this.manager, this.baseNode, this.comparison, this.loop);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		private class ForwardEnumerable : Enumeration, IEnumerable
		{
			// internal RXgN^ //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="manager"></param>
			/// <param name="baseNode"></param>
			/// <param name="comparison"></param>
			/// <param name="loop"></param>
			internal ForwardEnumerable(
					TreeManager manager, object baseNode, EqualityComparison comparison, bool loop)
					: base(manager, baseNode, comparison, loop) {}

			// private \bh//

			/// <summary>
			/// 
			/// </summary>
			/// <returns></returns>
			IEnumerator IEnumerable.GetEnumerator()
			{
				return new ForwardEnumerator(
						this.manager, this.baseNode, this.comparison, this.loop);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		private abstract class AbstractEnumerator : Enumeration, IEnumerator
		{
			// protected tB[h //

			protected object current;
			protected bool ready;

			// protected RXgN^ //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="manager"></param>
			/// <param name="baseNode"></param>
			/// <param name="comparison"></param>
			/// <param name="loop"></param>
			protected AbstractEnumerator(
					TreeManager manager, object baseNode, EqualityComparison comparison, bool loop)
					: base(manager, baseNode, comparison, loop)
			{
				this.current = baseNode;
			}

			// private vpeB //

			/// <summary>
			/// 
			/// </summary>
			object IEnumerator.Current
			{
				get {
					if (! this.ready) {
						throw new InvalidOperationException();
					}
					return this.current;
				}
			}

			// public \bh //

			/// <summary>
			/// 
			/// </summary>
			/// <returns></returns>
			public abstract bool MoveNext();

			// protected \bh //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="node"></param>
			/// <returns></returns>
			protected bool MoveNextInternal(object node)
			{
				if (this.comparison(node, this.baseNode)) {
					this.ready = false;
				} else {
					this.current = node;
					this.ready = true;
				}
				return this.ready;
			}

			// private \bh //

			/// <summary>
			/// 
			/// </summary>
			void IEnumerator.Reset()
			{
				this.current = this.baseNode;
				this.ready = false;
			}
		}

		/// <summary>
		/// m[htɒH񋓎qłB
		/// </summary>
		private class BackwardEnumerator : AbstractEnumerator
		{
			// internal RXgN^ //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="manager"></param>
			/// <param name="baseNode"></param>
			/// <param name="comparison"></param>
			/// <param name="loop"></param>
			internal BackwardEnumerator(
					TreeManager manager, object baseNode, EqualityComparison comparison, bool loop)
					: base(manager, baseNode, comparison, loop) {}

			// public \bh //

			/// <summary>
			/// 
			/// </summary>
			/// <returns></returns>
			public override bool MoveNext()
			{
				// Z΁A̍Ō̎qI
				object node = this.manager.GetPreviousSibling(this.current);
				if (node != null) {
					object descendant = this.manager.GetLastChild(node, true);
					return this.MoveNextInternal(descendant == null ? node : descendant);
				}
				// eΑI
				node = this.manager.GetParent(this.current);
				if (node != null) {
					return this.MoveNextInternal(node);
				}
				// g[g̏ꍇ́A̍Ō̎q
				if (this.loop) {
					node = this.manager.GetLastChild(this.current, true);
					if (node != null) {
						return this.MoveNextInternal(node);
					}
				}
				this.ready = false;
				return false;
			}
		}

		/// <summary>
		/// m[hɒH񋓎qłB
		/// </summary>
		private class ForwardEnumerator : AbstractEnumerator
		{
			// internal RXgN^ //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="manager"></param>
			/// <param name="baseNode"></param>
			/// <param name="comparison"></param>
			/// <param name="loop"></param>
			internal ForwardEnumerator(
					TreeManager manager, object baseNode, EqualityComparison comparison, bool loop)
					: base(manager, baseNode, comparison, loop) {}

			// public \bh //

			/// <summary>
			/// 
			/// </summary>
			/// <returns></returns>
			public override bool MoveNext()
			{
				// qꍇ́A̒qI
				object node = this.manager.GetFirstChild(this.current);
				if (node != null) {
					return this.MoveNextInternal(node);
				}
				// 킪ΑI
				node = this.manager.GetNextSibling(this.current);
				if (node != null) {
					return this.MoveNextInternal(node);
				}
				// e̒킪ΑI
				node = this.current;
				for (;;) {
					object parent = this.manager.GetParent(node);
					if (parent == null) {
						break;
					}
					object next = this.manager.GetNextSibling(parent);
					if (next != null) {
						return this.MoveNextInternal(next);
					}
					node = parent;
				}
				// g[̏ꍇ́A[gɖ߂
				if (this.loop) {
					node = this.baseNode;
					for (;;) {
						object parent = this.manager.GetParent(node);
						if (parent == null) {
							return this.MoveNextInternal(node);
						}
						node = parent;
					}
				}
				this.ready = false;
				return false;
			}
		}
	}
}
