using System;
using System.IO;

namespace SystemNeo.IO
{
	/// <summary>
	/// Xg[𑀍삷郁\bh񋟂܂B
	/// </summary>
	public static class StreamUtil
	{
		// public 萔 //

		/// <summary>
		/// 
		/// </summary>
		public const int DefaultBufferSize = 4 * 1024;

		// public static \bh //

		/// <summary>
		/// ̃Xg[̖܂ł̃oCgV[PXǂݎA
		/// <paramref name="dest"/> ɏ݂܂B
		/// </summary>
		/// <param name="src"></param>
		/// <param name="dest"></param>
		public static void CopyTo(this Stream src, Stream dest)
		{
			ReadWrite(src, dest);
		}

		/// <summary>
		/// 2̃Xg[݈̌ʒu疖܂ł̃oCgV[PXǂݎA
		/// ҂vĂ邩ǂ𔻒肵܂B
		/// </summary>
		/// <param name="stream1"></param>
		/// <param name="stream2"></param>
		/// <returns></returns>
		public static bool Equals(Stream stream1, Stream stream2)
		{
			try {
				long length1 = stream1.Length - stream1.Position;
				long length2 = stream2.Length - stream2.Position;
				if (length1 != length2) {
					return false;
				}
			} catch (NotSupportedException) {
			}
			byte[] buf1 = new byte[DefaultBufferSize];
			byte[] buf2 = new byte[DefaultBufferSize];
			for (;;) {
				int count1 = stream1.Read(buf1, 0, DefaultBufferSize);
				int count2 = stream2.Read(buf2, 0, DefaultBufferSize);
				if (count1 != count2) {
					return false;
				}
				if (count1 == 0) {
					return true;
				}
				for (int i = 0; i < count1; i++) {
					if (buf1[i] != buf2[i]) {
						return false;
					}
				}
			}
		}

		/// <summary>
		/// t@C Xg[ɓǂݏo܂B
		/// </summary>
		/// <param name="fileName"></param>
		/// <returns></returns>
		public static MemoryStream ReadToMemoryStream(string fileName)
		{
			return ReadToMemoryStream(new FileInfo(fileName));
		}

		/// <summary>
		/// t@C Xg[ɓǂݏo܂B
		/// </summary>
		/// <param name="fileName"></param>
		/// <param name="bufferSize"></param>
		/// <returns></returns>
		public static MemoryStream ReadToMemoryStream(string fileName, int bufferSize)
		{
			return ReadToMemoryStream(new FileInfo(fileName), bufferSize);
		}

		/// <summary>
		/// t@C Xg[ɓǂݏo܂B
		/// </summary>
		/// <param name="file"></param>
		/// <returns></returns>
		public static MemoryStream ReadToMemoryStream(FileInfo file)
		{
			return ReadToMemoryStream(file, DefaultBufferSize);
		}

		/// <summary>
		/// t@C Xg[ɓǂݏo܂B
		/// </summary>
		/// <param name="file"></param>
		/// <param name="bufferSize"></param>
		/// <returns></returns>
		public static MemoryStream ReadToMemoryStream(FileInfo file, int bufferSize)
		{
			ArgumentUtil.AssertNull(file, "file");
			using (FileStream fs = file.OpenRead()) {
				int capacity = (int)Math.Min(fs.Length, int.MaxValue);
				return ReadToMemoryStream(fs, capacity, bufferSize);
			}
		}

		/// <summary>
		/// w肳ꂽXg[̓eׂă Xg[ɓǂݏo܂B
		/// </summary>
		/// <param name="stream"></param>
		/// <returns><paramref name="stream"/> ǂݏoeێ郁 Xg[B</returns>
		public static MemoryStream ReadToMemoryStream(Stream stream)
		{
			return ReadToMemoryStream(stream, DefaultBufferSize, DefaultBufferSize);
		}

		/// <summary>
		/// w肳ꂽXg[̓eׂă Xg[ɓǂݏo܂B
		/// </summary>
		/// <param name="stream"></param>
		/// <param name="capacity"></param>
		/// <param name="bufferSize"></param>
		/// <returns><paramref name="stream"/> ǂݏoeێ郁 Xg[B</returns>
		public static MemoryStream ReadToMemoryStream(Stream stream, int capacity, int bufferSize)
		{
			if (capacity < 0) {
				throw new ArgumentOutOfRangeException("capacity");
			}
			var ms = new MemoryStream(capacity);
			ReadWrite(stream, ms, bufferSize);
			return ms;
		}

		/// <summary>
		/// Xg[ <paramref name="inStream"/> ̖܂ł̃oCgV[PXǂݎA
		/// <paramref name="outStream"/> ɏ݂܂B
		/// </summary>
		/// <param name="inStream"></param>
		/// <param name="outStream"></param>
		/// <returns></returns>
		public static long ReadWrite(Stream inStream, Stream outStream)
		{
			return ReadWrite(inStream, outStream, DefaultBufferSize);
		}

		/// <summary>
		/// Xg[ <paramref name="inStream"/> ̖܂ł̃oCgV[PXǂݎA
		/// <paramref name="outStream"/> ɏ݂܂B
		/// </summary>
		/// <param name="inStream"></param>
		/// <param name="outStream"></param>
		/// <param name="bufferSize"></param>
		/// <returns>ǂݎoCgV[PX̒B</returns>
		public static long ReadWrite(Stream inStream, Stream outStream, int bufferSize)
		{
			ArgumentUtil.AssertNull(inStream, "inStream");
			ArgumentUtil.AssertNull(outStream, "outStream");
			if (bufferSize <= 0) {
				throw new ArgumentOutOfRangeException("bufferSize");
			}
			if (inStream == outStream) {
				throw new ArgumentException("̃Xg[ɂ͓ǂݏł܂B");
			}
			byte[] buffer = new byte[bufferSize];
			long result = 0;
			for (;;) {
				int count = inStream.Read(buffer, 0, bufferSize);
				if (count <= 0) {
					break;
				}
				result += count;
				outStream.Write(buffer, 0, count);
			}
			outStream.Flush();
			return result;
		}
	}
}
