using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Reflection;

using SystemNeo;
using SystemNeo.Reflection;

namespace SystemNeo
{
	/// <summary>
	/// IuWFNǧ^ϊȂǂs\bh񋟂܂B
	/// </summary>
	public static class ObjectUtil
	{
		// public static \bh //

		/// <summary>
		/// IuWFNgw肳ꂽ^ɃLXg܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="value"></param>
		/// <returns></returns>
		public static T Cast<T>(object value)
		{
			return (T)value;
		}

		/// <summary>
		/// IuWFNgw肳ꂽ^ɃLXg܂B
		/// </summary>
		/// <typeparam name="TInput"></typeparam>
		/// <typeparam name="TOutput"></typeparam>
		/// <param name="value"></param>
		/// <returns></returns>
		public static TOutput Cast<TInput, TOutput>(TInput value)
		{
			return (TOutput)((object)value);
		}

		/// <summary>
		/// IuWFNgw肳ꂽ^ɕϊ܂B
		/// </summary>
		/// <param name="value"></param>
		/// <param name="conversionType">ϊ̌^B</param>
		/// <returns></returns>
		public static object ChangeType(object value, Type conversionType)
		{
			ArgumentUtil.AssertNull(conversionType, "conversionType");
			if (value == null) {
				if (conversionType.IsValueType) {
					throw new InvalidCastException("null QƂl^ɕϊł܂B");
				}
				return null;
			}
			Type valueType = value.GetType();
			// ϊsvH
			if (conversionType.IsAssignableFrom(valueType)) {
				return value;
			}
			// IConvertible ĂꍇA ChangeType \bhɂϊ
			if (value is IConvertible) {
				try {
					return Convert.ChangeType(value, conversionType);
				} catch (InvalidCastException) {
				}
			}
			do {
				// ^ϊZqTA炻gĕϊs
				var operators = MemberUtil.GetCastOperatorMethods(conversionType, valueType);
				foreach (var @operator in operators) {
					if (@operator != null && @operator.ReturnType == conversionType) {
						return @operator.Invoke(null, new object[] {value});
					}
				}
				// {NXɂČ𑱂
				valueType = valueType.BaseType;
			} while (valueType != null);
			string msg = string.Format(
					"^ {0}  {1} ֕ϊł܂B", value.GetType(), conversionType);
			throw new InvalidCastException(msg);
		}

		/// <summary>
		/// IuWFNgw肳ꂽ^ɕϊ܂B
		/// </summary>
		/// <typeparam name="TInput"></typeparam>
		/// <typeparam name="TOutput"></typeparam>
		/// <param name="value"></param>
		/// <returns></returns>
		public static TOutput ChangeType<TInput, TOutput>(TInput value)
		{
			return (TOutput)ChangeType(value, typeof(TOutput));
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T0"></typeparam>
		/// <typeparam name="T1"></typeparam>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <param name="f1"></param>
		/// <returns></returns>
		public static int Compare<T0, T1>(T0 x, T0 y, Func<T0, T1> f1) where T1 : IComparable<T1>
		{
			return Comparer<T1>.Default.Compare(f1(x), f1(y));
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T0"></typeparam>
		/// <typeparam name="T1"></typeparam>
		/// <typeparam name="T2"></typeparam>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <param name="f1"></param>
		/// <param name="f2"></param>
		/// <returns></returns>
		public static int Compare<T0, T1, T2>(T0 x, T0 y, Func<T0, T1> f1, Func<T0, T2> f2)
				where T1 : IComparable<T1> where T2 : IComparable<T2>
		{
			int result = Comparer<T1>.Default.Compare(f1(x), f1(y));
			return (result == 0) ? Compare(x, y, f2) : result;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T0"></typeparam>
		/// <typeparam name="T1"></typeparam>
		/// <typeparam name="T2"></typeparam>
		/// <typeparam name="T3"></typeparam>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <param name="f1"></param>
		/// <param name="f2"></param>
		/// <param name="f3"></param>
		/// <returns></returns>
		public static int Compare<T0, T1, T2, T3>(
				T0 x, T0 y, Func<T0, T1> f1, Func<T0, T2> f2, Func<T0, T3> f3)
				where T1 : IComparable<T1> where T2 : IComparable<T2> where T3 : IComparable<T3>
		{
			int result = Comparer<T1>.Default.Compare(f1(x), f1(y));
			return (result == 0) ? Compare(x, y, f2, f3) : result;
		}

		/// <summary>
		/// 2̃IuWFNgǂ𔻒肵܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <returns></returns>
		public static bool Equals<T>(T x, T y)
		{
			return object.Equals(x, y);
		}

		/// <summary>
		/// nbV֐Ƃċ@\܂B
		/// </summary>
		/// <param name="obj"></param>
		/// <returns></returns>
		public static int GetHashCode(object obj)
		{
			return obj == null ? 0 : obj.GetHashCode();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <returns></returns>
		public static T GetGreater<T>(T x, T y) where T : IComparable
		{
			return x.CompareTo(y) < 0 ? y : x;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <returns></returns>
		public static T GetLess<T>(T x, T y) where T : IComparable
		{
			return x.CompareTo(y) < 0 ? x : y;
		}

		/// <summary>
		/// 8rbgl4rbgƉ4rbgɕ܂B
		/// </summary>
		/// <param name="value"></param>
		/// <param name="upper"></param>
		/// <param name="lower"></param>
		public static void SplitBits(byte value, out byte upper, out byte lower)
		{
			uint u = value;
			upper = (byte)(u >> 4);
			lower = (byte)(u & 0x0F);
		}

		/// <summary>
		/// IuWFNg𕶎ɕϊ܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="value"></param>
		/// <returns></returns>
		public static string ToString<T>(T value)
		{
			return Convert.ToString(value);
		}
	}
}
