using System;
using System.Collections;
using System.Linq;

using SystemNeo;
using SystemNeo.Collections;

namespace SystemNeo.Predicates
{
	/// <summary>
	/// 
	/// </summary>
	/// <typeparam name="TTarget"></typeparam>
	/// <typeparam name="TItem"></typeparam>
	public class ContainsPredicateProvider<TTarget, TItem> : JointPredicateProvider<TTarget, TItem>
	{
		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="basePredicateProvider"></param>
		public ContainsPredicateProvider(IPredicateProvider<TItem> basePredicateProvider)
				: base(basePredicateProvider) {}

		// protected \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="obj"></param>
		/// <returns></returns>
		public override bool IsMatch(TTarget obj)
		{
			if (obj is IEnumerable) {
				return ((IEnumerable)obj).Cast<TItem>().Any(this.BasePredicateProvider.Func);
			}
			if (obj is Enum) {
				return this.IsEnumMatch(obj);
			}
			return false;
		}

		// private \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="obj"></param>
		/// <returns></returns>
		private bool IsEnumMatch(TTarget obj)
		{
			Type enumType = obj.GetType();
			ulong uObj = Convert.ToUInt64(obj);
			foreach (string name in Enum.GetNames(enumType)) {
				TItem item = ObjectUtil.ChangeType<string, TItem>(name);
				if (this.BasePredicateProvider.IsMatch(item)) {
					ulong uItem = Convert.ToUInt64(Enum.Parse(enumType, name));
					if ((uObj & uItem) == uItem) {
						return true;
					}
				}
			}
			return false;
		}
	}
}
