using System;

using SystemNeo;
using SystemNeo.Reflection;

namespace SystemNeo.Predicates
{
	/// <summary>
	/// 
	/// </summary>
	/// <typeparam name="TTarget"></typeparam>
	/// <typeparam name="TItem"></typeparam>
	public class ItemPredicateProvider<TTarget, TItem> : JointPredicateProvider<TTarget, TItem>
	{
		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public string ItemName { get; set; }

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="itemName"></param>
		public ItemPredicateProvider(string itemName,
				IPredicateProvider<TItem> basePredicateProvider) : base(basePredicateProvider)
		{
			this.ItemName = itemName;
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="obj"></param>
		/// <returns></returns>
		public override bool IsMatch(TTarget obj)
		{
			if (obj == null) {
				return false;
			}
			var lb = new LateBinder(obj);
			object value;
			try {
				value = lb[this.ItemName].Eval();
			} catch (MissingMemberException) {
				// Y郁o[Ȃꍇ false Ԃ
				return false;
			}
			if (value == null || value is TItem) {
				return this.BasePredicateProvider.IsMatch((TItem)value);
			}
			string msg = string.Format(
					"{0} ^ '{1}' ɕϊł܂B", this.ItemName, typeof(TItem).FullName);
			throw new InvalidCastException(msg);
		}
	}
}
