using System;
using System.Linq;
using System.Reflection;

using SystemNeo.Collections;

namespace SystemNeo.Reflection
{
	/// <summary>
	/// RXgN^\܂B
	/// <see cref="System.Reflection.ConstructorInfo">ConstructorInfo</see> ̑Ɏgpł܂B
	/// </summary>
	public sealed class ConstructorInfoNeo : MethodBaseNeo
	{
		// internal RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="constructor"></param>
		internal ConstructorInfoNeo(ConstructorInfo constructor) : base(constructor) {}

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		private ConstructorInfo AsConstructor
		{
			get {
				return (ConstructorInfo)this.member;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override bool IsOverriding
		{
			get {
				return this.DeclaringType.BaseType != null;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override TypeNeo MappedInterface
		{
			get {
				return null;
			}
		}

		// public static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="constructors"></param>
		/// <returns></returns>
		public static ConstructorInfoNeo[] ConvertArray(ConstructorInfo[] constructors)
		{
			if (constructors == null) {
				return null;
			} else {
				return Array.ConvertAll(constructors, (c) => (ConstructorInfoNeo)c);
			}
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="parameters"></param>
		/// <returns></returns>
		public object Invoke(params object[] parameters)
		{
			return this.AsConstructor.Invoke(parameters);
		}

		// Zq //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="constructor"></param>
		/// <returns></returns>
		public static implicit operator ConstructorInfoNeo(ConstructorInfo constructor)
		{
			return (ConstructorInfoNeo)GetCachedInstance(constructor);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="constructor"></param>
		/// <returns></returns>
		public static explicit operator ConstructorInfo(ConstructorInfoNeo constructor)
		{
			if (constructor == null) {
				return null;
			} else {
				return constructor.AsConstructor;
			}
		}
	}
}
