using System;
using System.Collections;
using System.Globalization;
using System.Reflection;

namespace SystemNeo.Reflection
{
	/// <summary>
	/// \bh\܂B
	/// <see cref="System.Reflection.MethodInfo">MethodInfo</see> ̑Ɏgpł܂B
	/// </summary>
	public sealed class MethodInfoNeo : MethodBaseNeo
	{
		// public 萔 //

		/// <summary>
		/// 
		/// </summary>
		[Obsolete]
		public const string DelegateInvokeMethodName = "Invoke";

		/// <summary>
		/// 
		/// </summary>
		[Obsolete]
		public const string DestructorMethodName = "Finalize";
		
		/// <summary>
		/// IȌ^ϊZq\\bhB
		/// </summary>
		[Obsolete]
		public const string ExplicitOperatorMethodName = "op_Explicit";

		/// <summary>
		/// Öق̌^ϊZq\\bhB
		/// </summary>
		[Obsolete]
		public const string ImplicitOperatorMethodName = "op_Implicit";

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public EventInfoNeo AccessingEvent
		{
			get {
				return this.DeclaringType.GetEventFromAccessor(this.AsMethod);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public PropertyInfoNeo AccessingProperty
		{
			get {
				return this.DeclaringType.GetPropertyFromAccessor(this.AsMethod);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public MethodInfoNeo BaseDefinition
		{
			get {
				return this.AsMethod.GetBaseDefinition();
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public bool IsDestructor
		{
			get {
				return (Type)this.BaseDefinition.DeclaringType == typeof(object)
					&& this.Name == MemberUtil.DestructorMethodName;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public bool IsEventAccessor
		{
			get {
				return (this.AccessingEvent != null);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public bool IsFunction
		{
			get {
				return this.ReturnType != typeof(void);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public bool IsGenericMethod
		{
			get {
				return this.AsMethod.IsGenericMethod;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public bool IsGenericMethodDefinition
		{
			get {
				return this.AsMethod.IsGenericMethodDefinition;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override bool IsOverriding
		{
			get {
				Type baseDecType = this.AsMethod.GetBaseDefinition().DeclaringType;
				return baseDecType != this.AsMethod.DeclaringType;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public bool IsPropertyAccessor
		{
			get {
				return (this.AccessingProperty != null);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override TypeNeo MappedInterface
		{
			get {
				MethodInfoNeo method = this.MappedInterfaceMethod;
				return (method == null ? null : method.DeclaringType);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public MethodInfoNeo MappedInterfaceMethod
		{
			get {
				return this.DeclaringType.GetMappedInterfaceMethod(this.AsMethod);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public Type ReturnType
		{
			get {
				return this.AsMethod.ReturnType;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public ICustomAttributeProvider ReturnTypeCustomAttributes
		{
			get {
				return this.AsMethod.ReturnTypeCustomAttributes;
			}
		}

		// private vpeB //

		/// <summary>
		/// 
		/// </summary>
		private MethodInfo AsMethod
		{
			get {
				return (MethodInfo)this.member;
			}
		}

		// internal RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="method"></param>
		internal MethodInfoNeo(MethodInfo method) : base(method) {}

		// public static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="methods"></param>
		/// <returns></returns>
		public static MethodInfoNeo[] ConvertArray(MethodInfo[] methods)
		{
			return methods == null ? null : Array.ConvertAll(methods, (m) => (MethodInfoNeo)m);
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public MethodInfoNeo GetGenericMethodDefinition()
		{
			return (MethodInfoNeo)this.AsMethod.GetGenericMethodDefinition();
		}

		// Zq //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="method"></param>
		/// <returns></returns>
		public static implicit operator MethodInfoNeo(MethodInfo method)
		{
			return (MethodInfoNeo)GetCachedInstance(method);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="methodEx"></param>
		/// <returns></returns>
		public static explicit operator MethodInfo(MethodInfoNeo methodEx)
		{
			if (methodEx == null) {
				return null;
			} else {
				return methodEx.AsMethod;
			}
		}

		/// <summary>
		///  C^[tF[X\bh̖IȎǂ܂B
		/// </summary>
		public bool IsExplicitImplementation
		{
			get {
				return AsMethod.Name.IndexOf('.') >= 0 && AsMethod.IsPrivate;
			}
		}

		// ^ //

		/// <summary>
		/// 
		/// </summary>
		public static class AccessorPrefix
		{
			public const string EventAdd = "add_";
			public const string EventRaise = "raise_";
			public const string EventRemove = "remove_";
			public const string PropertyGet = "get_";
			public const string PropertySet = "set_";
		}

		/// <summary>
		/// 
		/// </summary>
		public static class OperatorNames
		{
			public const string Addition = "op_Addition";               // Z
			public const string BitwideAnd = "op_BitwiseAnd";           // rbgZAND
			public const string BitwiseOr = "op_BitwiseOr";             // rbgZOR
			public const string Decrement = "op_Decrement";             // fNg
			public const string Division = "op_Division";               // Z
			public const string Equality = "op_Equality";               // 
			public const string ExclusiveOr = "op_ExclusiveOr";         // rI_a
			public const string Explicit = "op_Explicit";               // I^ϊ
			public const string GreaterThan = "op_GreaterThan";                 // 
			public const string GreaterThanOrEqual = "op_GreaterThanOrEqual";   // ȏ
			public const string Implicit = "op_Implicit";               // ÖٓI^ϊ
			public const string Increment = "op_Increment";             // CNg
			public const string Inequality = "op_Inequality";           // 񓙉
			public const string LeftShift = "op_LeftShift";             // Vtg
			public const string LessThan = "op_LessThan";               // 
			public const string LessThanOrEqual = "op_LessThanOrEqual"; // ȉ
			public const string LogicalAnd = "op_LogicalAnd";           // _
			public const string LogicalOr = "op_LogicalOr";             // _a
			public const string Modulus = "op_Modulus";                 // ]
			public const string Multiply = "op_Multiply";               // Z
			public const string OnesComplement = "op_OnesComplement";   // ␔
			public const string RightShisft= "op_RightShift";           // EVtg
			public const string Subtraction = "op_Subtraction";         // Z
			public const string UnaryNegation = "op_UnaryNegation";     // 
			public const string UnaryPlus = "op_UnaryPlus";             // 
		}
	}
}
