using System;
using System.ComponentModel;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;

using SystemNeo.Collections;

namespace SystemNeo
{
	/// <summary>
	/// Ɋւ郁\bh񋟂܂B
	/// </summary>
	public static class StringUtil
	{
		// public 萔 //

		/// <summary>
		/// 
		/// </summary>
		public const string CrLf = "\r\n";

		// public static \bh //

		/// <summary>
		/// Q̗̕ގ[FV^C擾܂B
		/// </summary>
		/// <param name="s1"></param>
		/// <param name="s2"></param>
		/// <returns></returns>
		public static int CalcLevenshteinDistance(string s1, string s2)
		{
			int[,] d = new int[s1.Length + 1, s2.Length + 1];
			for (int i1 = 0; i1 <= s1.Length; i1++) {
				d[i1, 0] = i1;
			}
			for (int i2 = 0; i2 <= s2.Length; i2++) {
				d[0, i2] = i2;
			}
			for (int i1 = 1; i1 <= s1.Length; i1++) {
				for (int i2 = 1; i2 <= s2.Length; i2++) {
					int insertCost  = d[i1 - 1, i2 - 0] + 1;
					int deleteCost  = d[i1 - 0, i2 - 1] + 1;
					int replaceCost = d[i1 - 1, i2 - 1] + (s1[i1 - 1] == s2[i2 - 1] ? 0 : 1);
					d[i1, i2] = Math.Min(Math.Min(insertCost, deleteCost), replaceCost);
				}
			}
			return d[s1.Length, s2.Length];
		}

		/// <summary>
		/// w肳ꂽ̐擪̕啶ɂ܂B
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public static string Capitalize(string value)
		{
			if (value == null || value.Length == 0) {
				return value;
			} else {
				return value.Substring(0, 1).ToUpper() + value.Substring(1);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <param name="currentEncoding">݂̃GR[fBOB</param>
		/// <param name="newEncoding">ύX̃GR[fBOB</param>
		/// <returns></returns>
		public static string ChangeEncoding(
				string value, Encoding currentEncoding, Encoding newEncoding)
		{
			ArgumentUtil.AssertNull(value, "value");
			ArgumentUtil.AssertNull(currentEncoding, "currentEncoding");
			ArgumentUtil.AssertNull(newEncoding, "newEncoding");
			if (value == null || value == string.Empty) {
				return value;
			}
			return newEncoding.GetString(currentEncoding.GetBytes(value));
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <returns></returns>
		public static int CompareInt32String(string x, string y)
		{
			return CompareInt32String(x, y, 0);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <param name="defaultValue"></param>
		/// <returns></returns>
		public static int CompareInt32String(string x, string y, int defaultValue)
		{
			int ix;
			int iy;
			try {
				ix = int.Parse(x);
			} catch (Exception) {
				ix = defaultValue;
			}
			try {
				iy = int.Parse(y);
			} catch (Exception) {
				iy = defaultValue;
			}
			return ix - iy;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <returns></returns>
		public static int CompareInt32Part(string x, string y)
		{
			Regex re = new Regex(@"\d+");
			Match xm = re.Match(x);
			Match ym = re.Match(y);
			if (xm.Success && ym.Success) {
				return CompareInt32String(xm.Value, ym.Value);
			} else {
				return 0;
			}
		}

		/// <summary>
		/// ̔z񂩂當𐶐܂B
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public static string Create(params char[] value)
		{
			return new string(value);
		}

		/// <summary>
		/// 󕶎̔z쐬܂B
		/// </summary>
		/// <param name="length"></param>
		/// <returns></returns>
		public static string[] CreateEmptyArray(int length)
		{
			return CollectionUtil.CreateArray(length, (i) => string.Empty);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public static string CreateUnicodeSequence(string value)
		{
			return CreateUnicodeSequence(value, "U+{0:X4}", " ");
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <param name="format"></param>
		/// <param name="separator"></param>
		/// <returns></returns>
		public static string CreateUnicodeSequence(string value, string format, string separator)
		{
			ArgumentUtil.AssertNull(value, "value");
			ArgumentUtil.AssertNull(format, "format");
			var sb = new StringBuilder(value.Length * 5);
			foreach (char c in value) {
				if (sb.Length > 0) {
					sb.Append(separator);
				}
				sb.AppendFormat(format, (ushort)c);
			}
			return sb.ToString();
		}

		/// <summary>
		/// w肳ꂽQd܂B
		/// </summary>
		/// <param name="value"></param>
		/// <param name="target"></param>
		/// <returns></returns>
		public static string Duplicate(string value, char target)
		{
			return Duplicate(value, target.ToString());
		}

		/// <summary>
		/// w肳ꂽQd܂B
		/// </summary>
		/// <param name="value"></param>
		/// <param name="target"></param>
		/// <returns></returns>
		public static string Duplicate(string value, string target)
		{
			ArgumentUtil.AssertNull(value, "value");
			return value.Replace(target, target + target);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <param name="beginBracket"></param>
		/// <param name="endBracket"></param>
		/// <returns></returns>
		public static string Enclose(string value, string beginBracket, string endBracket)
		{
			return value == null || value == string.Empty ?
					string.Empty : beginBracket + value + endBracket;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <returns>
		/// value  null ̏ꍇ EmptyBȊȌꍇ value ́B
		/// </returns>
		public static string EnsureNotNull(string value)
		{
			return value ?? string.Empty;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public static string PopLine(ref string value)
		{
			string result;
			Regex r = new Regex(@"^([^\r\n]*)(\r?\n|\r)");
			Match m = r.Match(value);
			if (m.Success) {
				result = m.Groups[1].Value;
				value = value.Substring(m.Value.Length);
			} else {
				result = value;
				value = null;
			}
			return result;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <param name="separator"></param>
		/// <returns></returns>
		public static string PopString(ref string value, char separator)
		{
			if (value == null) {
				return null;
			}
			string result;
			int pos = value.IndexOf(separator);
			if (pos >= 0) {
				result = value.Substring(0, pos);
				value = value.Substring(pos + 1);
			} else {
				result = value;
				value = string.Empty;
			}
			return result;
		}

		/// <summary>
		///	pŊ܂B
		/// </summary>
		/// <param name="value">pŊ镶B</param>
		/// <param name="quotation">pƂėp镶B</param>
		/// <returns></returns>
		public static string Quote(string value, char quotation)
		{
			return string.Concat(quotation, Duplicate(value, quotation), quotation);
		}

		/// <summary>
		/// w肳ꂽɈv镶폜܂B
		/// </summary>
		/// <param name="value"></param>
		/// <param name="match"></param>
		/// <returns></returns>
		public static string RemoveChars(string value, Predicate<char> match)
		{
			return RemoveChars(value, match, false);
		}

		/// <summary>
		/// w肳ꂽɈv镶폜܂B
		/// </summary>
		/// <param name="value"></param>
		/// <param name="match"></param>
		/// <param name="invert"></param>
		/// <returns></returns>
		public static string RemoveChars(string value, Predicate<char> match, bool invert)
		{
			return ReplaceChars(value, match, (c => string.Empty), invert);
		}

		/// <summary>
		/// w肳ꂽRNVɊ܂܂镶폜܂B
		/// </summary>
		/// <param name="value"></param>
		/// <param name="targetChars"></param>
		/// <returns></returns>
		public static string RemoveChars(string value, ICollection<char> targetChars)
		{
			return RemoveChars(value, targetChars, false);
		}

		/// <summary>
		/// w肳ꂽRNVɊ܂܂镶폜܂B
		/// </summary>
		/// <param name="value"></param>
		/// <param name="targetChars"></param>
		/// <param name="invert"></param>
		/// <returns></returns>
		public static string RemoveChars(string value, ICollection<char> targetChars, bool invert)
		{
			ArgumentUtil.AssertNull(targetChars, "targetChars");
			return RemoveChars(value, targetChars.Contains, invert);
		}

		/// <summary>
		/// w肳ꂽRNVɊ܂܂镶폜܂B
		/// </summary>
		/// <param name="value"></param>
		/// <param name="targetChars"></param>
		/// <returns></returns>
		public static string RemoveChars(string value, params char[] targetChars)
		{
			return RemoveChars(value, (ICollection<char>)targetChars);
		}

		/// <summary>
		/// w肳ꂽɈv镶ϊ܂B
		/// </summary>
		/// <param name="value">ϊƂȂ镶B</param>
		/// <param name="match">ϊ镶̏` PredicateB</param>
		/// <param name="replacer">ϊ FuncB</param>
		/// <returns></returns>
		public static string ReplaceChars(
				string value, Predicate<char> match, Func<char, char> replacer)
		{
			return ReplaceChars(value, match, replacer, false);
		}

		/// <summary>
		/// w肳ꂽɈv镶ϊ܂B
		/// </summary>
		/// <param name="value">ϊƂȂ镶B</param>
		/// <param name="match">ϊ镶̏` PredicateB</param>
		/// <param name="replacer">ϊ FuncB</param>
		/// <param name="invert">match ̏𔽓]ꍇ trueB</param>
		/// <returns></returns>
		public static string ReplaceChars(string value,
				Predicate<char> match, Func<char, char> replacer, bool invert)
		{
			ArgumentUtil.AssertNull(replacer, "replacer");
			return ReplaceChars(value, match, (c) => replacer(c).ToString(), invert);
		}

		/// <summary>
		/// w肳ꂽɈv镶ϊ܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="value">ϊƂȂ镶B</param>
		/// <param name="match">ϊ镶̏` PredicateB</param>
		/// <param name="replacer">ϊ FuncB</param>
		/// <returns></returns>
		public static string ReplaceChars<T>(
				string value, Predicate<char> match, Func<char, T> replacer)
		{
			return ReplaceChars(value, match, replacer, false);
		}

		/// <summary>
		/// w肳ꂽɈv镶ϊ܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="value">ϊƂȂ镶B</param>
		/// <param name="match">ϊ镶̏` PredicateB</param>
		/// <param name="replacer">ϊ FuncB</param>
		/// <param name="invert">match ̏𔽓]ꍇ trueB</param>
		/// <returns></returns>
		public static string ReplaceChars<T>(string value,
				Predicate<char> match, Func<char, T> replacer, bool invert)
		{
			ArgumentUtil.AssertNull(match, "match");
			ArgumentUtil.AssertNull(replacer, "replacer");
			if (value == null) {
				return null;
			}
			var sb = new StringBuilder();
			foreach (char c in value) {
				if (match(c) == invert) {
					sb.Append(c);
				} else {
					sb.Append(replacer(c));
				}
			}
			return sb.ToString();
		}

		/// <summary>
		/// w肳ꂽRNVɊ܂܂镶ϊ܂B
		/// </summary>
		/// <param name="value">ϊƂȂ镶B</param>
		/// <param name="targetChars">ϊ镶SĊ܂ރRNVB</param>
		/// <param name="replacer">ϊ FuncB</param>
		/// <returns></returns>
		public static string ReplaceChars(string value,
				ICollection<char> targetChars, Func<char, char> replacer)
		{
			return ReplaceChars(value, targetChars, replacer, false);
		}

		/// <summary>
		/// w肳ꂽRNVɊ܂܂镶ϊ܂B
		/// </summary>
		/// <param name="value">ϊƂȂ镶B</param>
		/// <param name="targetChars">ϊ镶SĊ܂ރRNVB</param>
		/// <param name="replacer">ϊ FuncB</param>
		/// <param name="invert">
		/// targetChars Ɋ܂܂镶ϊꍇ falseB
		/// targetChars Ɋ܂܂Ȃϊꍇ trueB
		/// </param>
		/// <returns></returns>
		public static string ReplaceChars(string value,
				ICollection<char> targetChars, Func<char, char> replacer, bool invert)
		{
			ArgumentUtil.AssertNull(targetChars, "targetChars");
			return ReplaceChars(value, targetChars.Contains, replacer, invert);
		}

		/// <summary>
		/// w肳ꂽRNVɊ܂܂镶ϊ܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="value">ϊƂȂ镶B</param>
		/// <param name="targetChars">ϊ镶SĊ܂ރRNVB</param>
		/// <param name="replacer">ϊ FuncB</param>
		/// <returns></returns>
		public static string ReplaceChars<T>(string value,
				ICollection<char> targetChars, Func<char, T> replacer)
		{
			return ReplaceChars(value, targetChars, replacer, false);
		}

		/// <summary>
		/// w肳ꂽRNVɊ܂܂镶ϊ܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="value">ϊƂȂ镶B</param>
		/// <param name="targetChars">ϊ镶SĊ܂ރRNVB</param>
		/// <param name="replacer">ϊ FuncB</param>
		/// <param name="invert">
		/// targetChars Ɋ܂܂镶ϊꍇ falseB
		/// targetChars Ɋ܂܂Ȃϊꍇ trueB
		/// </param>
		/// <returns></returns>
		public static string ReplaceChars<T>(string value,
				ICollection<char> targetChars, Func<char, T> replacer, bool invert)
		{
			ArgumentUtil.AssertNull(targetChars, "targetChars");
			return ReplaceChars(value, targetChars.Contains, replacer, invert);
		}

		/// <summary>
		/// sɂ܂镶̒̍s폜܂B
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public static string RemoveEmptyLine(string value)
		{
			value = Regex.Replace(value,
					@"^(\s*\r?\leftCount)+", string.Empty, RegexOptions.Singleline);
			return Regex.Replace(value,
					@"(\leftCount)\s*\r?\leftCount", @"$1", RegexOptions.Singleline);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public static IList<string> SplitLines(string value)
		{
			var lines = new List<string>();
			string tmpValue = value;
			while (tmpValue != null) {
				lines.Add(PopLine(ref tmpValue));
			}
			return lines;
		}

		/// <summary>
		/// Ɋ܂܂Ă锼pJiSpJiɕϊ܂B
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public static string ToFullWidthKana(string value)
		{
			ArgumentUtil.AssertNull(value, "value");
			var queue = new Queue<char>(value);
			var sb = new StringBuilder();
			while (queue.Count > 0) {
				char c = (char)queue.Dequeue();
				if (queue.Count > 0) {
					switch ((char)queue.Peek()) {
					case '':
						sb.Append(CharConverter.DakuonKanaFullWidth.Convert(c));
						queue.Dequeue();
						continue;
					case '':
						sb.Append(CharConverter.HandakuonKanaFullWidth.Convert(c));
						queue.Dequeue();
						continue;
					}
				}
				sb.Append(CharConverter.SimpleKanaFullWidth.Convert(c));
			}
			return sb.ToString();
		}
	}
}
