using System;
using System.Text;

using SystemNeo;

namespace SystemNeo.Text
{
	/// <summary>
	/// 
	/// </summary>
	public class CharFilterProvider
	{
		#region private fields
		private readonly char[] acceptingChars;
		private readonly bool invert;
		#endregion

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="acceptingChars"></param>
		public CharFilterProvider(params char[] acceptingChars) : this(false, acceptingChars) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="invert"></param>
		/// <param name="acceptingChars"></param>
		public CharFilterProvider(bool invert, params char[] acceptingChars)
		{
			ArgumentUtil.AssertNull(acceptingChars, "acceptingChars");
			this.invert = invert;
			Array.Sort(acceptingChars);
			this.acceptingChars = acceptingChars;
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="c"></param>
		/// <returns></returns>
		public bool Accept(char c)
		{
			bool accept = Array.BinarySearch(this.acceptingChars, c) >= 0;
			return accept ^ this.invert;
		}
	}
}
