using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.IO;
using System.Reflection;
using System.Text;

using SystemNeo;
using SystemNeo.Collections;

namespace SystemNeo.Text
{
	/// <summary>
	/// 
	/// </summary>
	public class DictionaryFormatter : AbstractFormatter
	{
		// public static tB[h //

		/// <summary>
		/// 
		/// </summary>
		public const string DefaultBeginBracket = "{";

		/// <summary>
		/// 
		/// </summary>
		public const string DefaultBinder = "=";

		/// <summary>
		/// 
		/// </summary>
		public const string DefaultEndBracket = "}";

		/// <summary>
		/// 
		/// </summary>
		public const string DefaultSeparator = ", ";

		#region private fields
		private readonly AbstractFormatter formatter;
		private string beginBracket = DefaultBeginBracket;
		private string binder = DefaultBinder;
		private string endBracket = DefaultEndBracket;
		private string separator = DefaultSeparator;
		private IList dictionaryControllers = new ArrayList();
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		[DefaultValue(DefaultBeginBracket)]
		public string BeginBracket
		{
			get {
				return this.beginBracket;
			}
			set {
				this.beginBracket = value;
			}
		}

		/// <summary>
		/// L[ƒlȂ擾܂͐ݒ肵܂B
		/// </summary>
		[DefaultValue(DefaultBinder)]
		public string Binder
		{
			get {
				return this.binder;
			}
			set {
				this.binder = value;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		[DefaultValue(DefaultEndBracket)]
		public string EndBracket
		{
			get {
				return this.endBracket;
			}
			set {
				this.endBracket = value;
			}
		}

		/// <summary>
		/// L[/lyA鍶ʂ擾܂͐ݒ肵܂B
		/// </summary>
		public string EntryBeginBracket { get; set; }

		/// <summary>
		/// L[/lyAEʂ擾܂͐ݒ肵܂B
		/// </summary>
		public string EntryEndBracket { get; set; }

		/// <summary>
		/// 
		/// </summary>
		public IComparer KeyComparer { get; set; }

		/// <summary>
		/// 
		/// </summary>
		public IFormatter KeyFormatter { get; set; }

		/// <summary>
		/// L[/lyAm؂镶擾܂͐ݒ肵܂B
		/// </summary>
		[DefaultValue(DefaultSeparator)]
		public string Separator
		{
			get {
				return this.separator;
			}
			set {
				this.separator = value;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public IFormatter ValueFormatter { get; set; }

		// internal RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="formatter"></param>
		internal DictionaryFormatter(AbstractFormatter formatter)
		{
			ArgumentUtil.AssertNull(formatter, "formatter");
			this.formatter = formatter;
			this.dictionaryControllers.Add(new BasicDictionaryController());
			this.dictionaryControllers.Add(new GenericDictionaryController());
		}

		// protected internal \bh //
		
		/// <summary>
		/// 
		/// </summary>
		/// <param name="writer"></param>
		/// <param name="value"></param>
		protected internal override void WriteToInternal(TextWriter writer, object value)
		{
			IDictionaryController controller;
			IEnumerable keys;
			this.GetController(value, out controller, out keys);
			Debug.Assert(controller != null);
			Debug.Assert(keys != null);
			if (this.KeyComparer != null) {
				keys = keys.OrderBy(this.KeyComparer);
			}
			int count = 0;
			writer.Write(this.beginBracket);
			foreach (object key in keys) {
				if (count++ > 0) {
					writer.Write(this.separator);
				}
				object keyedValue = controller.GetValue(value, key);
				this.WriteKeyValue(writer, key, keyedValue);
			}
			writer.Write(this.endBracket);
		}

		// private \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <param name="controller"></param>
		/// <param name="keys"></param>
		private void GetController(
				object value, out IDictionaryController controller, out IEnumerable keys)
		{
			foreach (IDictionaryController ctrl in this.dictionaryControllers) {
				try {
					keys = ctrl.GetKeys(value);
					if (keys != null) {
						controller = ctrl;
						return;
					}
				} catch (Exception) {
				}
			}
			throw new ArgumentException();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="writer"></param>
		/// <param name="key"></param>
		/// <param name="value"></param>
		private void WriteKeyValue(TextWriter writer, object key, object value)
		{
			writer.Write(this.EntryBeginBracket);
			if (this.KeyFormatter == null) {
				this.formatter.WriteToInternal(writer, key);
			} else {
				this.KeyFormatter.WriteTo(writer, key);
			}
			writer.Write(this.binder);
			if (this.ValueFormatter == null) {
				this.formatter.WriteToInternal(writer, value);
			} else {
				this.ValueFormatter.WriteTo(writer, value);
			}
			writer.Write(this.EntryEndBracket);
		}

		// ^ //

		/// <summary>
		/// 
		/// </summary>
		internal interface IDictionaryController
		{
			/// <summary>
			/// 
			/// </summary>
			/// <param name="dictionary"></param>
			/// <returns></returns>
			IEnumerable GetKeys(object dictionary);
			
			/// <summary>
			/// 
			/// </summary>
			/// <param name="dictionary"></param>
			/// <param name="key"></param>
			/// <returns></returns>
			object GetValue(object dictionary, object key);
		}

		/// <summary>
		/// 
		/// </summary>
		private class BasicDictionaryController : IDictionaryController
		{
			// private \bh //
			
			/// <summary>
			/// 
			/// </summary>
			/// <param name="dictionary"></param>
			/// <returns></returns>
			IEnumerable IDictionaryController.GetKeys(object dictionary)
			{
				if (dictionary is IDictionary) {
					return ((IDictionary)dictionary).Keys;
				}
				throw new ArgumentException();
			}

			/// <summary>
			/// 
			/// </summary>
			/// <param name="dictionary"></param>
			/// <param name="key"></param>
			/// <returns></returns>
			object IDictionaryController.GetValue(object dictionary, object key)
            {
				if (dictionary is IDictionary) {
					return ((IDictionary)dictionary)[key];
				}
				throw new ArgumentException();
			}
		}

		/// <summary>
		/// 
		/// </summary>
		private class GenericDictionaryController : IDictionaryController
		{
			#region private static fields
			private const string itemPropertyName = "Item";
			private const string keysPropertyName = "Keys";
			private static readonly Type genericIDictionaryInterface;
			#endregion

			/// <summary>
			/// 
			/// </summary>
			static GenericDictionaryController()
			{
				genericIDictionaryInterface
						= typeof(IDictionary<object, object>).GetGenericTypeDefinition();
			}

			// private static \bh //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="value"></param>
			/// <param name="genericInterface"></param>
			/// <returns></returns>
			private static bool IsGenericDictionary(object value, out Type genericInterface)
			{
				genericInterface = null;
				if (value == null || ! (value is IEnumerable)) {
					return false;
				}
				Type valueType = value.GetType();
				foreach (Type @interface in valueType.GetInterfaces()) {
					if (@interface.IsGenericType) {
						Type genericDefinition = @interface.GetGenericTypeDefinition();
						if (genericDefinition.Equals(genericIDictionaryInterface)) {
							genericInterface = @interface;
							return true;
						}
					}
				}
				return false;
			}

			// private \bh //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="dictionary"></param>
			/// <returns></returns>
			IEnumerable IDictionaryController.GetKeys(object dictionary)
			{
				Type type;
				if (IsGenericDictionary(dictionary, out type)) {
					PropertyInfo keysProperty = type.GetProperty(keysPropertyName);
					return (IEnumerable)keysProperty.GetValue(dictionary, null);
				}
				throw new ArgumentException();
			}

			/// <summary>
			/// 
			/// </summary>
			/// <param name="dictionary"></param>
			/// <param name="key"></param>
			/// <returns></returns>
			object IDictionaryController.GetValue(object dictionary, object key)
			{
				Type type;
				if (IsGenericDictionary(dictionary, out type)) {
					PropertyInfo itemProperty = type.GetProperty(itemPropertyName);
					return itemProperty.GetValue(dictionary, new object[] {key});
				}
				throw new ArgumentException();
			}
		}
	}
}
