using System;
using System.IO;

namespace SystemNeo.Text
{
	/// <summary>
	/// \[XƂĎgpAO㗼ւ Seekiʒuړj\
	/// <see cref="System.IO.TextReader"> TextReader</see> ̎łB
	/// </summary>
	public class StringReaderNeo : TextReader
	{
		#region private tB[h

		private int index;
		private char[] value;

		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public int Position
		{
			get {
				return this.index;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public string Value
		{
			get {
				return this.value == null ? null : new string(this.value);
			}
		}

		// RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		public StringReaderNeo(string value)
		{
			ArgumentUtil.AssertNull(value, "value");
			this.value = value.ToCharArray();
		}

		// public \bh

		/// <summary>
		/// ݈ʒu̎̕ǂݎAPʒui߂܂B
		/// </summary>
		/// <returns>
		/// ݈ʒu̎̕B
		/// gpł镶Ȃꍇ -1B
		/// </returns>
		public override int Read()
		{
			int c = this.Peek();
			if (this.index < this.value.Length) {
				this.index++;
			}
			return c;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="length"></param>
		/// <returns></returns>
		public string Read(int length)
		{
			string result = this.Peek(length);
			this.index += result.Length;
			return result;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="filter"></param>
		/// <returns></returns>
		public string Read(Predicate<char> filter)
		{
			return this.Read(filter, int.MaxValue, false);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="filter"></param>
		/// <param name="maxLength"></param>
		/// <returns></returns>
		public string Read(Predicate<char> filter, int maxLength)
		{
			return this.Read(filter, maxLength, false);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="filter"></param>
		/// <param name="invertCondition"></param>
		/// <returns></returns>
		public string Read(Predicate<char> filter, bool invertCondition)
		{
			return this.Read(filter, int.MaxValue, invertCondition);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="filter"></param>
		/// <param name="maxLength"></param>
		/// <param name="invertCondition"></param>
		/// <returns></returns>
		public string Read(Predicate<char> filter, int maxLength, bool invertCondition)
		{
			string result = this.Peek(filter, maxLength, invertCondition);
			this.index += result.Length;
			return result;
		}

		/// <summary>
		/// ݈ʒu玟̂PǂݎĕԂ܂B
		/// </summary>
		/// <returns>
		/// ݈ʒu̎̕B
		/// gpł镶Ȃꍇ -1B
		/// </returns>
		public override int Peek()
		{
			this.CheckNotDisposed();
			if (this.index >= this.value.Length) {
				return -1;
			}
			return this.value[this.index];
		}

		/// <summary>
		/// ݈ʒu length Ŏw肳ꂽ̕ǂݎĕԂ܂B
		/// </summary>
		/// <exception cref="System.ObjectDisposedException">
		/// [_[Ă܂B
		/// </exception>
		/// <exception cref="System.ArgumentOutOfRangeException">
		/// length  0 łB
		/// </exception>
		public string Peek(int length)
		{
			this.CheckNotDisposed();
			if (length < 0) {
				throw new ArgumentOutOfRangeException("length");
			}
			if (length > this.value.Length - this.index) {
				length = this.value.Length - this.index;
			}
			char[] result = new char[length];
			if (length > 0) {
				Array.Copy(this.value, this.index, result, 0, length);
			}
			return new string(result);
		}

		/// <summary>
		/// ݈ʒuAfilter Ŏw肳ꂽtB^ŋe镶̕т
		/// ǂݎĕԂ܂B
		/// </summary>
		public string Peek(Predicate<char> filter)
		{
			return this.Peek(filter, int.MaxValue, false);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="filter"></param>
		/// <param name="maxLength"></param>
		/// <returns></returns>
		public string Peek(Predicate<char> filter, int maxLength)
		{
			return this.Peek(filter, maxLength, false);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="filter"></param>
		/// <param name="invertCondition"></param>
		/// <returns></returns>
		public string Peek(Predicate<char> filter, bool invertCondition)
		{
			return this.Peek(filter, int.MaxValue, invertCondition);
		}

		/// <summary>
		/// ݈ʒuAtB^ŋei܂́Aۂj̕т
		/// ǂݎĕԂ܂B
		/// </summary>
		public string Peek(Predicate<char> filter, int maxLength, bool invertCondition)
		{
			int length = 0;
			while (length < maxLength) {
				if (this.index + length >= this.value.Length) {
					break;
				}
				if (filter(this.value[this.index + length]) == invertCondition) {
					break;
				}
				length++;
			}
			return length == 0 ? string.Empty : new string(this.value, this.index, length);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public string FindRead(char value)
		{
			return this.FindRead(value.ToString(), false);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <param name="includeValue"></param>
		/// <returns></returns>
		public string FindRead(char value, bool includeValue)
		{
			return this.FindRead(value.ToString(), includeValue);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public string FindRead(string value)
		{
			return this.FindRead(value, false);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <param name="includeValue"></param>
		/// <returns></returns>
		public string FindRead(string value, bool includeValue)
		{
			string result = this.FindPeek(value, includeValue);
			if (result != null) {
				this.index += result.Length;
			}
			return result;
		}

		/// <summary>
		/// ݈ʒuȍ~ value Ŏw肳ꂽTA
		/// ꍇ͂̒O܂ł̕Ԃ܂B
		/// </summary>
		public string FindPeek(string value)
		{
			return this.FindPeek(value, false);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <param name="includeValue"></param>
		/// <returns></returns>
		public string FindPeek(string value, bool includeValue)
		{
			if (value == null || value.Length == 0) {
				throw new ArgumentException(" 1 ȏ̕񂪕KvłB", "value");
			}
			for (int i = this.index; i <= this.value.Length - value.Length; i++) {
				bool same = true;
				for (int j = 0; j < value.Length; j++) {
					if (this.value[i + j] != value[j]) {
						same = false;
						break;
					}
				}
				if (same) {
					int length = i - this.index + (includeValue ? value.Length : 0);
					return new string(this.value, this.index, length);
				}
			}
			return string.Empty;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="delta"></param>
		public void Seek(int delta)
		{
			this.CheckNotDisposed();
			this.index += delta;
			if (this.index < 0) {
				this.index = 0;
			}
			if (this.index > this.value.Length) {
				this.index = this.value.Length;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public bool StartsWith(string value)
		{
			this.CheckNotDisposed();
			ArgumentUtil.AssertNull(value, "value");
			if (value.Length == 0) {
				throw new ArgumentException();
			}
			char[] valueChars = value.ToCharArray();
			for (int i = 0; i < value.Length; i++) {
				if (this.index + i >= this.value.Length) {
					return false;
				}
				if (this.value[this.index + i] != valueChars[i]) {
					return false;
				}
			}
			return true;
		}

		/// <summary>
		/// 
		/// </summary>
		public override void Close()
		{
			this.Dispose(true);
		}

		// protected \bh

		/// <summary>
		/// 
		/// </summary>
		/// <param name="disposing"></param>
		protected override void Dispose(bool disposing)
		{
			this.value = null;
			this.index = 0;
			base.Dispose(disposing);
		}

		// private \bh

		/// <summary>
		/// 
		/// </summary>
		private void CheckNotDisposed()
		{
			if (this.value == null) {
				throw new ObjectDisposedException(null, "Cannot read from a closed TextReader.");
			}
		}
	}
}
