using System;

namespace SystemNeo.Text
{
	/// <summary>
	/// 
	/// </summary>
	public class TextElement
	{
		/// <summary>
		/// 
		/// </summary>
		/// <param name="sourceText"></param>
		protected TextElement(string sourceText)
		{
			this.SourceText = sourceText;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="obj"></param>
		/// <returns></returns>
		public override bool Equals(object obj)
		{
			return obj is TextElement && (TextElement)obj == this;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override int GetHashCode()
		{
			return this.SourceText.GetHashCode();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override string ToString()
		{
			return this.SourceText;
		}

		/// <summary>
		/// 
		/// </summary>
		public string SourceText { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		/// <param name="e1"></param>
		/// <param name="e2"></param>
		/// <returns></returns>
		public static bool operator ==(TextElement e1, TextElement e2)
		{
			bool isNull1 = object.ReferenceEquals(e1, null);
			bool isNull2 = object.ReferenceEquals(e2, null);
			return (isNull1 && isNull2) || (! isNull1 && ! isNull2
				&& e1.GetType() == e2.GetType() && e1.SourceText == e2.SourceText);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="e1"></param>
		/// <param name="e2"></param>
		/// <returns></returns>
		public static bool operator !=(TextElement e1, TextElement e2)
		{
			return ! (e1 == e2);
		}
	}
}
