﻿using System;
using System.Collections;
using System.Text;

namespace SystemNeo.Xml.Tiny
{
	/// <summary>
	/// 
	/// </summary>
	internal class TinyXmlChildNodes : TinyXmlNodeList
	{
		#region private fields
		private TinyXmlNode container;
		#endregion

		// public プロパティ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="i"></param>
		/// <returns></returns>
		public override TinyXmlNode this[int i]
		{
			get {
				if (i < 0 || this.Count <= i) {
					throw new ArgumentOutOfRangeException("i");
				}
				return this.container.childNodes[i];
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override int Count
		{
			get {
				return this.container.GetChildCount();
			}
		}

		// internal コンストラクタ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="container"></param>
		internal TinyXmlChildNodes(TinyXmlNode container)
		{
			this.container = container;
		}

		// public メソッド //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override IEnumerator GetEnumerator()
		{
			throw new NotImplementedException();
		}
	}
}
