using System;
using System.Collections;
using System.Xml;

using SystemNeo.Collections;
using SystemNeo.Xml;

using NUnit.Framework;

namespace SystemNeoTest.Collections.TreeManagerTest
{
	[TestFixture]
	public class GetForwardEnumerable
	{
		private XmlDocument doc;

		[SetUp]
		public void SetUp()
		{
			const string xml = @"<root>"
							 + @"<country name='Japan'><city name='Tokyo'/><city name='Osaka'/></country>"
							 + @"<country name='China'><city name='Beijing'/><city name='Hong Kong'/></country>"
							 + @"</root>";
			this.doc = new XmlDocument();
			this.doc.LoadXml(xml);
		}

		[Test]
		public void [v()
		{
			// 
			XmlNode baseNode = this.doc.SelectSingleNode(@"/root/country[@name='Japan']/city[@name='Tokyo']");

			// s
			IEnumerable result = XmlTreeManager.Default.GetForwards(baseNode, true);

			// 
			IEnumerator e = result.GetEnumerator();
			XmlElement elem;

			Assert.True(e.MoveNext());
			elem = (XmlElement)e.Current;
			Assert.AreEqual("city", elem.Name);
			Assert.AreEqual("Osaka", elem.GetAttribute("name"));

			Assert.True(e.MoveNext());
			elem = (XmlElement)e.Current;
			Assert.AreEqual("country", elem.Name);
			Assert.AreEqual("China", elem.GetAttribute("name"));

			Assert.True(e.MoveNext());
			elem = (XmlElement)e.Current;
			Assert.AreEqual("city", elem.Name);
			Assert.AreEqual("Beijing", elem.GetAttribute("name"));

			Assert.True(e.MoveNext());
			elem = (XmlElement)e.Current;
			Assert.AreEqual("city", elem.Name);
			Assert.AreEqual("Hong Kong", elem.GetAttribute("name"));

			Assert.True(e.MoveNext());
			Assert.AreSame(typeof(XmlDocument), e.Current.GetType());

			Assert.True(e.MoveNext());
			elem = (XmlElement)e.Current;
			Assert.AreEqual("root", elem.Name);

			Assert.True(e.MoveNext());
			elem = (XmlElement)e.Current;
			Assert.AreEqual("country", elem.Name);
			Assert.AreEqual("Japan", elem.GetAttribute("name"));

			Assert.False(e.MoveNext());
		}

		[Test]
		public void [vȂ()
		{
			// 
			XmlNode baseNode = this.doc.SelectSingleNode(@"/root/country[@name='Japan']/city[@name='Osaka']");

			// s
			IEnumerable result = XmlTreeManager.Default.GetForwards(baseNode, false);

			// 
			IEnumerator e = result.GetEnumerator();
			XmlElement elem;

			Assert.True(e.MoveNext());
			elem = (XmlElement)e.Current;
			Assert.AreEqual("country", elem.Name);
			Assert.AreEqual("China", elem.GetAttribute("name"));

			Assert.True(e.MoveNext());
			elem = (XmlElement)e.Current;
			Assert.AreEqual("city", elem.Name);
			Assert.AreEqual("Beijing", elem.GetAttribute("name"));

			Assert.True(e.MoveNext());
			elem = (XmlElement)e.Current;
			Assert.AreEqual("city", elem.Name);
			Assert.AreEqual("Hong Kong", elem.GetAttribute("name"));

			Assert.False(e.MoveNext());
		}
	}
}
