using System.Collections.Generic;
using SystemNeo.Text;
using NUnit.Framework;

namespace SystemNeoTest.Text.HtmlParserTest
{
	[TestFixture]
	public class Parse
	{
		[Test]
		public void Normal()
		{
			// 
			var hp = new HtmlParser();
			string html = @"<p><a href=""hoge"" title=HOGE>HOGE</a> (P&amp;G) <br/><!-- hoge -->";
			var list = new List<TextElement>();

			// s
			hp.Parse(html, list);

			// 
			Assert.AreEqual(9, list.Count);
			HtmlParser.TagElement _0 = (HtmlParser.TagElement)list[0];
			Assert.AreEqual(HtmlParser.TagType.Begin, _0.Type);
			Assert.AreEqual("<p>", _0.SourceText);
			Assert.AreEqual("p", _0.Name);
			HtmlParser.TagElement _1 = (HtmlParser.TagElement)list[1];
			Assert.AreEqual(HtmlParser.TagType.Begin, _1.Type);
			Assert.AreEqual(@"<a href=""hoge"" title=HOGE>", _1.SourceText);
			Assert.AreEqual("a", _1.Name);
			Assert.AreEqual(2, _1.Attributes.Count);
			Assert.AreEqual("hoge", _1.Attributes["href"]);
			Assert.AreEqual("HOGE", _1.Attributes["title"]);
			HtmlParser.PlainTextElement _2 = (HtmlParser.PlainTextElement)list[2];
			Assert.AreEqual("HOGE", _2.SourceText);
			HtmlParser.TagElement _3 = (HtmlParser.TagElement)list[3];
			Assert.AreEqual(HtmlParser.TagType.End, _3.Type);
			Assert.AreEqual("</a>", _3.SourceText);
			Assert.AreEqual("a", _3.Name);
			Assert.AreEqual(0, _3.Attributes.Count);
			HtmlParser.PlainTextElement _4 = (HtmlParser.PlainTextElement)list[4];
			Assert.AreEqual(" (P", _4.SourceText);
			HtmlParser.CharacterReferenceElement _5 = (HtmlParser.CharacterReferenceElement)list[5];
			Assert.AreEqual("&amp;", _5.SourceText);
			Assert.AreEqual("&", _5.Value);
			HtmlParser.PlainTextElement _6 = (HtmlParser.PlainTextElement)list[6];
			Assert.AreEqual("G) ", _6.SourceText);
			HtmlParser.TagElement _7 = (HtmlParser.TagElement)list[7];
			Assert.AreEqual(HtmlParser.TagType.BeginEnd, _7.Type);
			Assert.AreEqual("<br/>", _7.SourceText);
			Assert.AreEqual("br", _7.Name);
			HtmlParser.CommentElement _8 = (HtmlParser.CommentElement)list[8];
			Assert.AreEqual("<!-- hoge -->", _8.SourceText);
		}
	}
}
