﻿using System;
using System.IO;
using System.Xml;
using SystemNeo.Xml.Tiny;
using NUnit.Framework;

namespace SystemNeoTest.Xml.Tiny.TinyXmlDocumentTest
{
	[TestFixture]
	public class Load_XmlReader
	{
		[Test]
		public void Normal()
		{
			// 準備
			string xml = @"<?xml version='1.0' encoding='utf-16'?>
<root>
	<country name='Japan'>
		<city name='Tokyo' metropolis='true' govornor='Ishihara' wards='23' area='2,187km^2' population='12,790,000'>
			<ward name='Shinjuku'/> <ward name='Chiyoda'/> <ward name='Chuo'/>
			<ward name='Minato'/>   <ward name='Taito'/>   <ward name='Shibuya'/>
			<ward name='Toshima'/>  <ward name='Bunkyo'/>  <ward name='Sumida'/>
		</city>
		<city name='Osaka'/>
	</country>
	<country name='China'>
	</country>
</root>
			";
			StringReader sr = new StringReader(xml);
			XmlReader reader = XmlReader.Create(sr);
			TinyXmlDocument doc = new TinyXmlDocument();

			// 実行
			doc.Load(reader);

			// 検証
			Assert.That(doc.ParentNode, Is.Null);
			Assert.That(doc.ChildNodes.Count, Is.EqualTo(2));
			Assert.That(doc.ChildNodes[0], Is.InstanceOf<TinyXmlDeclaration>());
			Assert.That(doc.ChildNodes[0].ParentNode, Is.SameAs(doc));
			Assert.That(doc.ChildNodes[0].ChildNodes.Count, Is.EqualTo(0));

			// root
			TinyXmlElement rootElem = (TinyXmlElement)doc.ChildNodes[1];
			Assert.That(rootElem.Name, Is.EqualTo("root"));
			Assert.That(rootElem.ParentNode, Is.SameAs(doc));
			Assert.That(rootElem.ChildNodes.Count, Is.EqualTo(2));

			// Japan
			TinyXmlElement japanElem = (TinyXmlElement)rootElem.ChildNodes[0];
			Assert.That(japanElem.Name, Is.EqualTo("country"));
			Assert.That(japanElem.ParentNode, Is.SameAs(rootElem));
			Assert.That(japanElem.ChildNodes.Count, Is.EqualTo(2));
			Assert.That(japanElem.GetAttribute("name"), Is.EqualTo("Japan"));

			// Japan - Tokyo
			TinyXmlElement tokyoElem = (TinyXmlElement)japanElem.ChildNodes[0];
			Assert.That(tokyoElem.Name, Is.EqualTo("city"));
			Assert.That(tokyoElem.ParentNode, Is.SameAs(japanElem));
			Assert.That(tokyoElem.ChildNodes.Count, Is.EqualTo(9));
			Assert.That(tokyoElem.GetAttribute("name"), Is.EqualTo("Tokyo"));
			Assert.That(tokyoElem.GetAttribute("metropolis"), Is.EqualTo("true"));
			Assert.That(tokyoElem.GetAttribute("govornor"), Is.EqualTo("Ishihara"));
			Assert.That(tokyoElem.GetAttribute("wards"), Is.EqualTo("23"));
			Assert.That(tokyoElem.GetAttribute("area"), Is.EqualTo("2,187km^2"));
			Assert.That(tokyoElem.GetAttribute("population"), Is.EqualTo("12,790,000"));

			Assert.That(((TinyXmlElement)tokyoElem.ChildNodes[0]).GetAttribute("name"),
					Is.EqualTo("Shinjuku"));
			Assert.That(((TinyXmlElement)tokyoElem.ChildNodes[1]).GetAttribute("name"),
					Is.EqualTo("Chiyoda"));
			Assert.That(((TinyXmlElement)tokyoElem.ChildNodes[2]).GetAttribute("name"),
					Is.EqualTo("Chuo"));
			Assert.That(((TinyXmlElement)tokyoElem.ChildNodes[3]).GetAttribute("name"),
					Is.EqualTo("Minato"));
			Assert.That(((TinyXmlElement)tokyoElem.ChildNodes[4]).GetAttribute("name"),
					Is.EqualTo("Taito"));
			Assert.That(((TinyXmlElement)tokyoElem.ChildNodes[5]).GetAttribute("name"),
					Is.EqualTo("Shibuya"));
			Assert.That(((TinyXmlElement)tokyoElem.ChildNodes[6]).GetAttribute("name"),
					Is.EqualTo("Toshima"));
			Assert.That(((TinyXmlElement)tokyoElem.ChildNodes[7]).GetAttribute("name"),
					Is.EqualTo("Bunkyo"));
			Assert.That(((TinyXmlElement)tokyoElem.ChildNodes[8]).GetAttribute("name"),
					Is.EqualTo("Sumida"));

			// Japan - Osaka
			TinyXmlElement osakaElem = (TinyXmlElement)japanElem.ChildNodes[1];
			Assert.That(osakaElem.Name, Is.EqualTo("city"));
			Assert.That(osakaElem.ParentNode, Is.SameAs(japanElem));
			Assert.That(osakaElem.ChildNodes.Count, Is.EqualTo(0));
			Assert.That(osakaElem.GetAttribute("name"), Is.EqualTo("Osaka"));

			// China
			TinyXmlElement chinaElem = (TinyXmlElement)rootElem.ChildNodes[1];
			Assert.That(chinaElem.Name, Is.EqualTo("country"));
			Assert.That(chinaElem.ParentNode, Is.SameAs(rootElem));
			Assert.That(chinaElem.ChildNodes.Count, Is.EqualTo(0));
			Assert.That(chinaElem.GetAttribute("name"), Is.EqualTo("China"));
		}
	}
}
