require 'archivers'

class Arc < ActiveGroonga::Base
  def code
    key
  end

  def create_entries(path)
    archiver = Archivers.load(path, extname)
    unless archiver
      puts "archiver not found: #{path}"
      return
    end
    archiver.each_entry do |ent|
      case ent
      when /\.pm[dx]\z/
        puts [ code, ent ].join(' ')
        pmds = Pmd.select { |rec| rec.arc == code && rec.path == ent }
        pmds.count != 0 || Pmd.create(:arc => code, :path => ent)
      when /\.vmd\z/
        puts [ code, ent ].join(' ')
        vmds = Vmd.select { |rec| rec.arc == code && rec.path == ent }
        vmds.count != 0 || Vmd.create(:arc => code, :path => ent)
      when /\.x\z/
        puts [ code, ent ].join(' ')
        xes = X.select { |rec| rec.arc == code && rec.path == ent }
        xes.count != 0 || X.create(:arc => code, :path => ent)
      end
    end
  end
end
