#!ruby
# encoding: utf-8
$LOAD_PATH.unshift File.expand_path(File.dirname(__FILE__) + '/../lib')
require 'scrap'

location = ARGV.shift || 'mmd'
scrap = Scrap.find_by_location_code(location)

require 'rubygems'
require 'bundler/setup'
require 'zipruby'
require 'nkf'

def encode(str)
  str && NKF.nkf('-Sw', str)
end

def dump_zip(path)
  Zip::Archive.open(path) do |ar|
    puts "# #{path}"

    n = ar.num_files # number of entries
    n.times do |i|
      entry_name = ar.get_name(i) # get entry name from archive

      # open entry
      ar.fopen(i) do |f|
        puts [ f.size, f.comp_size, f.mtime.strftime("%d-%m-%y %H:%M"), encode(f.name) ].join("\t")

        # content = f.read # read entry content
      end
    end
  end
rescue Zip::Error => exc
  puts "error: " + exc.message
end

ent = "/Volumes/uploader/src/#{location}/index.html"
open(ent) do |f|
  while line = f.gets
    if scrap.match(line)
      name, = scrap.row
      dump_zip("/Volumes/uploader/arc/#{location}/#{name}")
      puts
    end
  end
end
