require 'lib/bowl'

describe 'Bowl', 'arc dl9588' do
  subject { Bowl.load('dl9588') }
  its "code" do
    should == 'dl9588'
  end
  its "summary" do
    should == '誰得鉄道モデルセット'
  end
  its "tabs" do
    should == %w[ MikuMikuDance MMDアクセサリ MMD鉄道 ]
  end
  its "origname" do
    should == '誰得鉄道モデルセット.zip'
  end
  its "number" do
    should == 9588
  end
  it "should not be locked" do
    should_not be_locked
  end
end

describe 'Bowl', 'arc dl9587' do
  subject { Bowl.load('dl9587') }
  it "should be locked" do
    should be_locked
  end
end

describe 'Bowl', 'arc dl671' do
  subject { Bowl.load('dl671') }
  its "code" do
    should == 'dl671'
  end
  its "extname" do
    should == 'zip'
  end
  its "summary" do
    should == 'デリンジャーver.1.00'
  end
  its "tabs" do
    should == %w[ MikuMikuDance MMDアクセサリ MMDモデル ]
  end
  its "origname" do
    should == 'デリンジャー.zip'
  end
  its "number" do
    should == 671
  end
end
