class Site < ActiveGroonga::Base
  def code
    key
  end

  def locked_path_pattern
    case self.code
    when 'mmd', 'mmd3dcu'
      "upload\\.cgi\\?mode=dl&file=(\\d+)"
    when 'mmdfile'
      "\\?mode=pass&idd=(\\d+)"
    end
  end

  def locked_path_re
    @_locked_path_re ||=
      locked_path_pattern ? Regexp.new(Regexp.escape(url) + locked_path_pattern) : nil
  end

  def path_pattern
    case self.code
    when 'mmd', 'mmd3dcu'
      "src/(\\w+)"
    when 'mmdfile'
      "\\?id=(\\d+)"
    when 'mmdacc1'
      "log/(\\w+)"
    when 'mmdacc2'
      "src/(\\w+)"
    when 'mmdbowl'
      "(dl\\d+)"
    end
  end

  def path_re
    @_path_re ||=
      path_pattern ? Regexp.new(Regexp.escape(url) + path_pattern) : nil
  end

  def generate_locked_arc_code(name)
    case self.code
    when 'mmd'
      code = 'up%04d' % name.to_i
    when 'mmdfile'
      code = 'file%04d' % name.to_i
    when 'mmd3dcu'
      code = 'cu%04d' % name.to_i
    end
    code
  end

  def generate_arc_code_and_extname(name)
    if md = /\.(.+)\z/.match(name)
      extname = md[1]
      code = File.basename(name, '.' + extname)
    else
      extname = nil
      code = name.dup
    end
    case self.code
    when 'mmd'
      #
    when 'mmdfile'
      code = 'file%04d' % code.to_i
    when 'mmdacc1'
      code = 'mini%04d' % code.to_i
    when 'mmdacc2'
      code = code[3..-1]
    when 'mmd3dcu'
      code = 'cu%04d' % code[3..-1].to_i
    when 'mmdbowl'
      code = 'bo%04d' % code[2..-1].to_i
    end
    [ code, extname ]
  end

  def create_arc(name, summary, size, date, origname, locked = false)
    code, extname = generate_arc_code_and_extname(name)
    arc = Arc.find(code)
    if arc
      puts "found code: #{code}"
      return arc
    end
    puts "arcs.create code: #{code}"
    arc = Arc.create(:site => self.code, :key => code, :extname => extname, :summary => summary, :origname => origname, :locked => !!locked)
  end

  def update_arc(name, summary, size, date, origname, locked = false)
    code, extname = generate_arc_code_and_extname(name)
    arc = Arc.find(code) || Arc.new(:site => self.code, :key => code)
    puts "arc code: #{code}"
    arc.update_attributes(:extname => extname, :summary => summary, :origname => origname, :locked => locked)
  end
end
