#!ruby
# encoding: utf-8
$LOAD_PATH.unshift File.expand_path(File.dirname(__FILE__) + '/../lib')
$LOAD_PATH.unshift File.expand_path(File.dirname(__FILE__) + '/../app/models')
require 'connection'
require 'site'
require 'arc'
require 'thumb'

def link(thumb, code)
  arc = Arc.find(code)
  unless arc
    puts "not found arc.code: #{code}"
    return
  end
  unless arc.thumbs.include?(thumb)
    arc.thumbs << { :key => thumb.key }
    arc.save
  end
  unless thumb.arcs.include?(arc)
    thumb.arcs << { :key => arc.key }
    thumb.save
  end
end

sites = Site.all
thumbs = Thumb.all
thumbs.each do |thumb|
  # puts "# #{thumb.video_id}"
  sites.each do |site|
    if md = site.path_re.match(thumb.description)
      name = md[1]
      code, extname = site.generate_arc_code_and_extname(name)
      puts [ thumb.video_id, "", code ].join("\t")
      link(thumb, code)
    end

    next unless site.locked_path_re
    if md = site.locked_path_re.match(thumb.description)
      name = md[1]
      code = site.generate_locked_arc_code(name)
      puts [ thumb.video_id, "locked", code ].join("\t")
      link(thumb, code)
    end
  end
end
