#!ruby
# encoding: utf-8
$LOAD_PATH.unshift File.expand_path(File.dirname(__FILE__) + '/../lib')
$LOAD_PATH.unshift File.expand_path(File.dirname(__FILE__) + '/../app/models')
require 'connection'
require 'site'
require 'arc'
require 'pmd'
require 'vmd'
require 'x'
require 'thumb'
require 'bowl'

site = Site.find('mmdbowl')

for number in 745..1045
  code = "dl#{number}"
  bowl = Bowl.new(code)
  unless File.exist?(bowl.src_path)
    puts "PASS: src #{code} not found"
    next
  end
  bowl.load
  next if bowl.removed? || bowl.denied?

  name = bowl.name
  summary = bowl.summary
  size = '0KB'
  date = '01/01/01(Mon),00:00:00'
  origname = bowl.origname
  locked = bowl.locked?

  arc = site.create_arc(name, summary, size, date, origname, locked)
  unless File.exist?(bowl.arc_path)
    puts "PASS: arc #{code} not found"
    next
  end
  bowl.load
  arc.create_entries("/Volumes/uploader/arc/#{site.code}/#{name}") unless locked
  puts
end
