# encoding: utf-8

require 'net/http'
require 'rss'

class Bowl
  attr_reader :code

  def self.rss_path
    "/Volumes/uploader/src/mmdbowl/bowlroll.atom"
  end

  def self.save_rss
    http = Net::HTTP.new('bowlroll.net')
    http.start do
      http.request_get('/feed/up?feed=ATOM&count=50&tab=MikuMikuDance') do |response|
        open(rss_path, 'wb') { |f|
          response.read_body { |buf| f.write buf }
        }
      end
    end
  end

  def self.each_code_in_rss
    feed = RSS::Parser.parse(IO.read(rss_path))
    feed.items.each do |item|
      code = /(dl\d+)\z/.match(item.link.href)[1]
      yield code
    end
  end

  def src_path
    "/Volumes/uploader/src/mmdbowl/#{code}.html"
  end

  def save_src_0
    http = Net::HTTP.new('bowlroll.net')
    http.start do
      http.request_get("/up/#{code}") do |response|
        open(src_path, 'wb') { |f|
          response.read_body { |buf| f.write buf }
        }
      end
    end
  end

  def save_src
    if File.exist? src_path
      return false
    end
    save_src_0
    true
  end

  def initialize(code)
    @code = code
  end

  def self.load(code)
    instance = new(code)
    instance.load
    instance
  end

  def load
    @source = IO.read(src_path)
  end

  def removed?
    !!/削除されました/.match(@source)
  end

  def denied?
    !!/アクセス制限が/.match(@source)
  end

  def locked?
    !!/認証キーを入力/.match(@source)
  end

  def summary
    %r(<meta property="og:title" content="(.+?)">).match(@source)[1]
  end

  def tabs
    keywords.split(/,/)[1..-1]
  end

  def keywords
    %r(<meta name="keywords" content="(.+?)">).match(@source)[1]
  end

  def description
    %r(<meta name="description" content="(.+?)">).match(@source)[1]
  end

  def extname
    File.extname(origname)[1..-1]
  end

  def origname
    %r(<h3><b>ファイル名</b>&nbsp;：&nbsp;(.+?)</h3>).match(@source)[1]
  end

  def boundary
    "myboundary"
  end

  def request_header
    header = {}
    header["user-agent"] = "Mozilla/5.0 (Windows; U; Windows NT 6.0; ja; rv:1.9.0.10) Gecko/2009042316 Firefox/3.0.10 (.NET CLR 3.5.30729)"
    header["accept"] = "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8"
    header["accept-language"] = "ja,en-us;q=0.7,en;q=0.3"
    header["accept-charset"] = "Shift_JIS,utf-8;q=0.7,*;q=0.7"
    header["referer"] = "http://bowlroll.net/up/#{code}"
    # header["content-type"] = "multipart/form-data; boundary=#{boundary}"
    header
  end

  def request_body
    "upDlVal=&upDlNum=#{number}"
  end

  def number
    /dl(\d+)/.match(code)[1].to_i
  end

  def name
    "#{code}.#{extname}"
  end

  def arc_path
    "/Volumes/uploader/arc/mmdbowl/#{name}"
  end

  def save_arc_0
    response_code = nil
    http = Net::HTTP.new('bowlroll.net')
    http.start do
      request = Net::HTTP::Post.new('/Php/p3UpDlTop.php')

      request_header.each do |key, value|
        request[key] = value
      end
      request.body = request_body

      http.request(request) do |response|
        p response.code
        p response['content-type']
        response_code = response.code.to_i
        if response_code == 200
          open(arc_path, 'wb') { |f|
            response.read_body { |buf| f.write buf }
          }
        end
      end
    end
    response_code == 200
  end

  def save_arc
    if removed? || denied? || locked?
      return false
    end
    if File.exist? arc_path
      return false
    end
    save_arc_0
  end
end
