#include <stdio.h>
#include <string.h>
#include "bootpack.h"

struct FIFO32 *fdfifo;

//̃t@CŋʂŎgfdtime
struct FDTIME *fdTime1;

//FD^XNč쐬BN
struct SHEET *fdtask_make(struct SHTCTL *shtctl,struct MEMMAN *memman,struct BOOTINFO *binfo)
{
  //eXgEBhD
  //=============================
  //܂~Ă
  struct SHEET *fdtask_sht = sheet_alloc(shtctl);
  
  //̃V[gɏ߂悤Aobt@mۂB
  //傫̂memman_allocgifj
  unsigned char *fdtaskbuf=(unsigned char *) memman_alloc_4k(memman,400*400);

  //̃obt@fdtaskwin~Ŏgpł悤ɓč
  sheet_setbuf(fdtask_sht,fdtaskbuf,400,400,-1);

  //obt@ɃEBhD쐬
  make_window8(fdtaskbuf,400,400,"FD TASK",0);

  //V^XN邽߁Ataskman^XNĂ
  struct TASK *fd_task = task_alloc();


  //̃^XNŎgfifoobt@mۂ
  int *fd_task_fifo = (int *) memman_alloc_4k(memman,128*4);

  //^XÑWX^
  fd_task->cons_stack = memman_alloc_4k(memman,64*1024);
  fd_task->tss.esp = fd_task->cons_stack + 64 * 1024 - 12;

  //^XN̎s֐̃AhX𓖂č
  fd_task->tss.eip = (int) &fdtask;
  fd_task->tss.es = 1 * 8;
  fd_task->tss.cs = 2 * 8;
  fd_task->tss.ss = 1 * 8;
  fd_task->tss.ds = 1 * 8;
  fd_task->tss.fs = 1 * 8;
  fd_task->tss.gs = 1 * 8;
	
  //͎s֐ɓni *sheetnj
  *((int *) (fd_task->tss.esp + 4)) = (int) fdtask_sht;
  //	*((int *) (testtask->tss.esp + 8)) = memtotal;

  //ŌɁAsheetł^XN悤sheet\̂ɂ̃^XN𓖂č
  fdtask_sht->task = fd_task;

  //^XN𑖂点
  task_run(fd_task, 2, 2); /* level=2, priority=2 */

  //^XNfiroɓč݂s
  fifo32_init(&fd_task->fifo, 128, fd_task_fifo, fd_task);

  return fdtask_sht;

}


//FD^XN̎s
void fdtask(struct SHEET *sheet){
  struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;

  //DMȀꏊ
  char *DMA_ADD;
  DMA_ADD = 0x7c00;

  char sector[512];

  struct TASK *task = task_now();
  struct TIMER *timer1 = timer_alloc();
  timer_init(timer1,&task->fifo,9);

  int i;
  int fifodata;
  char s[40];
  char ascii;
  int cmdmode;


  //BPEۑp\
  struct FD_BPE fdbpe;

  //Ԍvp̃^C}[FIFO
  struct TIMER *ttimer = timer_alloc();
  int tfifobuf[32];
  struct FIFO32 *tfifo;
  fifo32_init(tfifo,32,tfifobuf,0);
  timer_init(ttimer,tfifo,10);

  //[^[AԌvKvȂ̂̃p[^̍\
  //ʂɔzł񂾂ǂ₱̂ŖO
  struct FDTIME fdtime1;
  fdtime1.timer = ttimer;
  fdtime1.fifo = tfifo;
  fdtime1.DMA_ADD = DMA_ADD;
  fdtime1.moter_time = 123;



  int counter;
  counter = 0;

  //====== DMȀ===============
  io_out8(0x00d6, 0xc0); /* }X^ch0JXP[h[h */
  io_out8(0x00c0, 0x00); /* X[uDMA */
  io_out8(0x000a, 0x06); /* }X^ch2DMA}XN */


  //FDC̊荞݂ɐ؂ւĂ
  int ssd;
  ssd = init_fd(&fdtime1);




  //[^[~BňUmɂƂ߂
  fd_moter(0);
  fdtime1.moter_set_stop = 0;




  for(;;){
    counter++;
    if ( counter >100000 ){counter=0;}

    io_cli();

    if (fifo32_status(&task->fifo) ==0){
      io_sti();
    }
    else{
      fifodata = fifo32_get(&task->fifo);
      io_sti();
      //      if (fifodata >= 3000) {fifodata=fifodata+cmdmode;}

      //==========^C}[̎
      if (fifodata == 9)
	{
	  //̊荞݂̓[^[~p̃^C}
	  if (fdtime1.sect_job == 0)
	    {
	      fd_moter(0);
	      fdtime1.moter_set_stop = 0;
	    }
	}
      //FIFOM̎
      if ( fifodata == 1024 )
	{
	  char s[40];
	  sprintf(s,"ooo! kita---! %04d",fifodata);
	  putfonts8_asc_sht(sheet,8,16*4,COL8_000000,COL8_FFFFFF,s,14);

	}




      //========== L[{[hꍇ̏ ========
      if (256 <= fifodata && fifodata <=511){ 
	ascii=fifodata-256;

	//-------[0]ꍇiV[gNAj
	if (ascii == 0x30)
	  {
	    int xs = 8*1;
	    int xw = 8*48;
	    int ys = 16*3;
	    int yh = 16*24;

	    boxfill8(sheet->buf,sheet->bxsize,COL8_FFFFFF,xs,ys,xw,yh);
	    sheet_refresh(sheet,xs,ys,xw,yh);
	  }




	//-------[2]ꍇiǂݍ݃R[h̎sj
	if (ascii == 0x32)
	  {
	    int i;
	    char *p;
	    p = 0x4e9000;
	    
	    sprintf(s,"bubububub=%08x",p);
	    putfonts8_asc_sht(sheet,8,16*4,COL8_000000,COL8_FFFFFF,s,11);


	    for ( i = 0; i <= 512*60; i++)
	      {
		p[i] = 0x8;

	      }
	  }






	//-------[1]ꍇiǂݍ݃R[h̎sj
	if (ascii == 0x31)
	  {


	    int xs = 8*1;
	    int xw = 8*48;
	    int ys = 16*3;
	    int yh = 16*24;

	    boxfill8(sheet->buf,sheet->bxsize,COL8_FFFFFF,xs,ys,xw,yh);
	    sheet_refresh(sheet,xs,ys,xw,yh);




	    //܂AZN^0ǂBPE擾
	    int i;
	    char s[50];
	    int err1;
	    struct FD_BPE fdbpe1;

	    //֐2BPE𓾂Ă݂
	    err1 = fd_get_bpe(900,&fdbpe1);
	    if ( (err1 & 0xFFFF) == 0 )
	      {
		//ʂɏoČ
		sprintf(s,"sec_suu=%03d",fdbpe1.sec_suu);
		putfonts8_asc_sht(sheet,8,16*4,COL8_000000,COL8_FFFFFF,s,11);

		sprintf(s,"cras_size=%03d",fdbpe1.cras_size);
		putfonts8_asc_sht(sheet,8,16*5,COL8_000000,COL8_FFFFFF,s,13);

		sprintf(s,"fat_start=%03d",fdbpe1.fat_start);
		putfonts8_asc_sht(sheet,8,16*6,COL8_000000,COL8_FFFFFF,s,13);

		sprintf(s,"fat_suu=%03d",fdbpe1.fat_suu);
		putfonts8_asc_sht(sheet,8,16*7,COL8_000000,COL8_FFFFFF,s,11);

		sprintf(s,"root_len=%03d",fdbpe1.root_len);
		putfonts8_asc_sht(sheet,8,16*8,COL8_000000,COL8_FFFFFF,s,12);

		sprintf(s,"disk_size=%04d",fdbpe1.disk_size);
		putfonts8_asc_sht(sheet,8,16*9,COL8_000000,COL8_FFFFFF,s,14);

		sprintf(s,"fat_len=%03d",fdbpe1.fat_len);
		putfonts8_asc_sht(sheet,8,16*10,COL8_000000,COL8_FFFFFF,s,11);

		sprintf(s,"track_suu=%03d",fdbpe1.fat_len);
		putfonts8_asc_sht(sheet,8,16*11,COL8_000000,COL8_FFFFFF,s,13);

		sprintf(s,"head_suu=%03d",fdbpe1.head_suu);
		putfonts8_asc_sht(sheet,8,16*12,COL8_000000,COL8_FFFFFF,s,12);

		sprintf(s,"allsec_suu=%04d",fdbpe1.allsec_suu);
		putfonts8_asc_sht(sheet,8,16*13,COL8_000000,COL8_FFFFFF,s,15);
		//===================================

		sprintf(s,"ipl=%03d",fdbpe1.r_ipl);
		putfonts8_asc_sht(sheet,8*20,16*4,COL8_000000,COL8_FFFFFF,s,7);

		sprintf(s,"FAT1=%03d - %03d",fdbpe1.r_fat1s,fdbpe1.r_fat1e);
		putfonts8_asc_sht(sheet,8*20,16*5,COL8_000000,COL8_FFFFFF,s,14);

		sprintf(s,"FAT2=%03d - %03d",fdbpe1.r_fat2s,fdbpe1.r_fat2e);
		putfonts8_asc_sht(sheet,8*20,16*6,COL8_000000,COL8_FFFFFF,s,14);

		sprintf(s,"RootDir=%03d - %03d",fdbpe1.r_roots,fdbpe1.r_roote);
		putfonts8_asc_sht(sheet,8*20,16*7,COL8_000000,COL8_FFFFFF,s,17);

		sprintf(s,"Data=%04d - %04d",fdbpe1.r_datas,fdbpe1.r_datae);
		putfonts8_asc_sht(sheet,8*20,16*8,COL8_000000,COL8_FFFFFF,s,16);


	      }
	    else
	      {
		sprintf(s,"Err=%08X",err1);
		putfonts8_asc_sht(sheet,8*26,16*2,COL8_000000,COL8_FFFFFF,s,12);
	      }




	  }

	//L[{[h[3]EEE
	if (ascii == 0x33)
	  {

	    int xs = 8*1;
	    int xw = 8*48;
	    int ys = 16*3;
	    int yh = 16*24;

	    boxfill8(sheet->buf,sheet->bxsize,COL8_FFFFFF,xs,ys,xw,yh);
	    sheet_refresh(sheet,xs,ys,xw,yh);




	    int err1;
	    int i,i2;
	    char s[128];
	    char *ssbuf2;
	    ssbuf2 = 0x7c00;

	    //KȃZN^ǂœëꕔ\

	    //EEEEA_ZN^285ɂ܂傤B
	    int Rsec = 202;

	    //_ZN^𕨗ZN^ɕϊ
	    int parm[3];
	    fd_r2b(Rsec,parm);

	    //ړĨV_ɃV[NI
	    err1 = fd_seek(parm[0],parm[1],900);
	    if ( (err1 & 0xFFFF) == 0 )
	      {

		//DMAJ
		fd_dma_set(0);

		//[hR}hM
		err1 = fd_read_sector(parm[0],parm[1],parm[2],900);
		if ( (err1 & 0xFFFF) == 0 )
		  {
		    //DMA
		    fd_dma_set(1);

		    //DMAɓeĂ̂ŕ\Ă݂
	    
		    for ( i = 0; i <= 255; i=i+16)
		      {
			sprintf(s, "%02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X",ssbuf2[i] & 0xFF,ssbuf2[i+1] & 0xFF,ssbuf2[i+2] & 0xFF,ssbuf2[i+3] & 0xFF,ssbuf2[i+4] & 0xFF,ssbuf2[i+5] & 0xFF,ssbuf2[i+6] & 0xFF,ssbuf2[i+7] & 0xFF,ssbuf2[i+8] & 0xFF,ssbuf2[i+9] & 0xFF,ssbuf2[i+10] & 0xFF,ssbuf2[i+11] & 0xFF,ssbuf2[i+12] & 0xFF,ssbuf2[i+13] & 0xFF,ssbuf2[i+14] & 0xFF,ssbuf2[i+15] & 0xFF);
			putfonts8_asc_sht(sheet,8*i2+8,16*(i/16+6),COL8_000000,COL8_FFFFFF,s,48);

		      }
		  }
		else
		  {
		    //DMA
		    fd_dma_set(1);
		    sprintf(s,"Err=%08X",err1);
		    putfonts8_asc_sht(sheet,8*26,16*2,COL8_000000,COL8_FFFFFF,s,12);
		  }

	      }
	    else
	      {
		sprintf(s,"Err=%08X",err1);
		putfonts8_asc_sht(sheet,8*26,16*2,COL8_000000,COL8_FFFFFF,s,12);
	      }


	  }

	//L[{[h[5]EEE
	if (ascii == 0x35)
	  {


	    int xs = 8*1;
	    int xw = 8*48;
	    int ys = 16*3;
	    int yh = 16*24;

	    boxfill8(sheet->buf,sheet->bxsize,COL8_FFFFFF,xs,ys,xw,yh);
	    sheet_refresh(sheet,xs,ys,xw,yh);




	    //[gfBNgGAǂŃt@Co܂
	    int err1;
	    struct FD_BPE fdbpe1;

	    char *rootbuf;

	    struct FILEINFO *finfo1;    //[gfBNg͗p

	    int i;
	    char s[128];

	    //܂̓ZN^0ǂ݁ABPE肵܂
	    err1 = fd_get_bpe(900,&fdbpe1);
	    if ( (err1 & 0xFFFF) == 0 )
	      {
		//܂ASĊi[邽߂̃pӂ܂
		//傫̂memman_allocg܂
		rootbuf = memman_alloc_4k(memman,512 * (fdbpe1.r_roote - fdbpe1.r_roots+1) );

		//[gfBNgSēǂݍ݂܂
		err1 = fd_get_rootdir(900,&fdbpe1,rootbuf);
		if ( (err1 & 0xFFFF) == 0 )
		  {

		    //ʂɕ\Ă݂

		    finfo1 = rootbuf;
		    for ( i =0; i <= 20; i++)
		      {
			sprintf(s,"%s",finfo1[i].name);
			putfonts8_asc_sht(sheet,8*2,16*(3+i),COL8_000000,COL8_FFFFFF,s,11);
		      }
		    
		    for ( i =0; i <= 20; i++)
		      {
			sprintf(s,"%08s",finfo1[i+21].name);
			putfonts8_asc_sht(sheet,8*16,16*(3+i),COL8_000000,COL8_FFFFFF,s,11);
		      }

		    for ( i =0; i <= 20; i++)
		      {
			sprintf(s,"%08s",finfo1[i+40].name);
			putfonts8_asc_sht(sheet,8*32,16*(3+i),COL8_000000,COL8_FFFFFF,s,11);
		      }

		  }
		else
		  {
		    sprintf(s,"Err=%08X",err1);
		    putfonts8_asc_sht(sheet,8*26,16*2,COL8_000000,COL8_FFFFFF,s,12);
		  }

	      }
	    else
	      {
		sprintf(s,"Err=%08X",err1);
		putfonts8_asc_sht(sheet,8*26,16*2,COL8_000000,COL8_FFFFFF,s,12);
	      }



	  }

      }

      //===========t@CT[`߂III===================
      else if ( fifodata == 3200 )
	{
	  int i2,i3;
	  int cmd[5];
	  struct FIFO *waitflag;
	  char *fbuf;

	  cmd[0] = fifodata;

	  //cSQbg
	  for ( i2 = 1; i2 <= 4; i2++)
	    {
	      cmd[i2] = fifo32_get(&task->fifo);
	      if (cmd[i2] == 3999){break;}
	    }

	  waitflag = cmd[3];
	  fbuf = cmd[2];


	  //putfonts8_asc_sht(sheet,8*26,16*10,COL8_000000,COL8_FFFFFF,srcptn,16);

	  //[gfBNgGAǂŃt@Co܂
	  int err1;
	  struct FD_BPE fdbpe1;

	  char *rootbuf;

	  int i;
	  char s[128];

	  //܂̓ZN^0ǂ݁ABPE肵܂
	  err1 = fd_get_bpe(900,&fdbpe1);
	  if ( (err1 & 0xFFFF) == 0 )
	    {
	      //܂ASĊi[邽߂̃pӂ܂
	      //傫̂memman_allocg܂
	      rootbuf = memman_alloc_4k(memman,512 * (fdbpe1.r_roote - fdbpe1.r_roots+1) );

	      //[gfBNgSēǂݍ݂܂
	      err1 = fd_get_rootdir(900,&fdbpe1,rootbuf);
	      if ( (err1 & 0xFFFF) == 0 )
		{

		  //		  sprintf(s,"%08x,%08x,%08x",rootbuf,rootbuf2,err1);
		  //		  putfonts8_asc_sht(sheet,8*8,16*14,COL8_000000,COL8_FFFFFF,s,34);



		  //t@C͗pɍ\̂ɓč
		  struct FILEINFO *finfo1;    //[gfBNg
		  struct FILEINFO *finfo2;    //[gfBNg

		  finfo1 = rootbuf;
		  finfo2 = fbuf;
		  for ( i2 = 0; i2 <= 223; i2++)
		    {
		      finfo2[i2] = finfo1[i2];
		    }

		  //ɏI悤Ȃ̂ő҂FIFOɑMďI
		  memman_free_4k(memman,rootbuf,512 * (fdbpe1.r_roote - fdbpe1.r_roots+1) );
		  fifo32_put(waitflag,0xFFFFFFF0);

		}
	      else
		{
		  memman_free_4k(memman,rootbuf,512 * (fdbpe1.r_roote - fdbpe1.r_roots+1) );
		  fifo32_put(waitflag,0xFFFFFFFF);   //G[I 
		}

	    }
	  else
	    {
	      fifo32_put(waitflag,0xFFFFFFFF);   //G[I 
	    }


	}







      //t@CI[v(rojI
      //[hI[Ȃ̂ŁAobt@쐬đSǂݍŕԂ
      else if ( fifodata == 3500 )
	{
	  char s[128];

	  int cmd[10];      //̖߂̃R}h	
	  struct FIFO *waitflag;
	  char *filename;
	  struct FILEHANDLE *fh;

	  char *rootbuf;
	  struct FILEINFO *finfo1;
	  char tmpfilename[11];
	  struct FD_BPE fdbpe1;
	  char *filebuf,*filebuf2;
	  int cl2ro;

	  int err1;
	  int i,i2;

	  //\̂̃f[^𒼐ڎgƂ낢܂炵̂ŁEEE
	  int fi_size;
	  


	  //cSQbg
	  for ( i2 = 1; i2 <= 10; i2++)
	    {
	      cmd[i2] = fifo32_get(&task->fifo);
	      if (cmd[i2] == 3999){break;}
	    }

	  filename = cmd[1];
	  waitflag = cmd[2];
	  fh = cmd[3];
	  
	  if ( fifo32_status(waitflag) != 0 )
	    {
	  sprintf(s,"fifo not 0!");
	  putfonts8_asc_sht(sheet,8*16,16*8,COL8_000000,COL8_FFFFFF,s,11);
	    }


	  //t@C͌`ς݂̂͂Ȃ̂Ń[gǂ݁AT[`JnI
	  //܂̓ZN^0ǂ݁ABPE肵܂
	  err1 = fd_get_bpe(900,&fdbpe1);
	  if ( (err1 & 0xFFFF) == 0 )
	    {

	      //܂ASĊi[邽߂̃pӂ܂
	      //傫̂memman_allocg܂
	      rootbuf = memman_alloc_4k(memman,512 * (fdbpe1.r_roote - fdbpe1.r_roots+1) );

	      //[gfBNgSēǂݍ݂܂
	      err1 = fd_get_rootdir(900,&fdbpe1,rootbuf);
	      if ( (err1 & 0xFFFF) == 0 )
		{

		  sprintf(s,"filename=%s!");putfonts8_asc_sht(sheet,8*3,16*3,COL8_000000,COL8_FFFFFF,s,20);


		  //t@C͗pɍ\̂ɓč
		  finfo1 = rootbuf;
		  for ( i = 0; i <= 243; i++)
		    {

		      //ꎞϐɈڂ
		      for ( i2 = 0; i2 <= 7; i2++)
			{tmpfilename[i2] = finfo1[i].name[i2];}
		      for ( i2 = 8; i2 <= 10; i2++)
			{tmpfilename[i2] = finfo1[i].ext[i2 - 8];}
	  sprintf(s,"aaaaaa!");putfonts8_asc_sht(sheet,8*10,16*4,COL8_000000,COL8_FFFFFF,s,7);


			  sprintf(s,"%s",filename);
			  putfonts8_asc_sht(sheet,8*16,16*11,COL8_000000,COL8_FFFFFF,s,13);
			  sprintf(s,"%s",tmpfilename);
			  putfonts8_asc_sht(sheet,8*16,16*12,COL8_000000,COL8_FFFFFF,s,13);




		      //II
		      if ( strcmp(filename,tmpfilename) == 0 )
			{

			  sprintf(s,"crst=%08x",finfo1[i].clustno);
			  putfonts8_asc_sht(sheet,8*16,16*16,COL8_000000,COL8_FFFFFF,s,13);

			  //obt@݂ăt@C̓eSēǂݍ

			  //͒PZN^t@CI
			  if ( fdbpe1.sec_suu > finfo1[i].size )
			    {
			      filebuf = memman_alloc_4k(memman, fdbpe1.sec_suu );

			      //NX^no_ZN^ɕϊ
			      cl2ro = fdbpe1.r_datas - 2 + finfo1[i].clustno;

			      //ZN^[h
			      err1 = fd_read_rsec(cl2ro,filebuf,900);
			      if ( (err1 & 0xFFFF) == 0 )
				{
				  //̂悤
				  
				  //`Ƃobt@pӂ
				  fi_size = finfo1[i].size;
				  filebuf2 = memman_alloc_4k(memman, fi_size );

				  for ( i2 = 0; i2 <= fi_size; i2++)
				    {
				      filebuf2[i2] = filebuf[i2];
				    }

				  //Âobt@͂Ȃ̂̂łƌn
				  memman_free_4k(memman,filebuf,fdbpe1.sec_suu);


				  //t@CnhɃZbg
				  fh->startcluster = finfo1[i].clustno;
				  //߂ĎgpɃ}[N
				  fh->used = 1;
				  for ( i2 = 0; i2 <= 10; i2++)
				    {
				      fh->filename[i2] = tmpfilename[i2];
				    }
				  fh->size = finfo1[i].size;
				  fh->memsize = finfo1[i].size;
				  fh->disksectersize = fdbpe1.sec_suu;
				  fh->pos = 0;
				  //obt@𓖂č
				  fh->buf = filebuf2;

				  //`ďII
				  fifo32_put(waitflag,0xFFFFFFF0);
				  break;
				}
			      else {fifo32_put(waitflag,0xFFFFFFFF);}   //I 
			    }

			  //ZN^t@Ĉ悤I
			  else
			    {
			      //֐ɔC
			      filebuf = fd_file_read(finfo1[i],fdbpe1);

			      if ( filebuf != 0 )
				{
				  //̂悤
				  //t@CnhɃZbg
				  fh->startcluster = finfo1[i].clustno;
				  //߂ĎgpɃ}[N
				  fh->used = 1;
				  for ( i2 = 0; i2 <= 10; i2++)
				    {
				      fh->filename[i2] = tmpfilename[i2];
				    }
				  fh->size = finfo1[i].size;
				  fh->memsize = finfo1[i].size;
				  fh->disksectersize = fdbpe1.sec_suu;
				  fh->pos = 0;
				  //obt@𓖂č
				  fh->buf = filebuf;

				  //`ďII
				  fifo32_put(waitflag,0xFFFFFFF0);
				  break;
				}
			      else {fifo32_put(waitflag,0xFFFFFFFF);}   //I 
			    }
			}
		    }
		  //Ȃ̏
		  if (i >= 244 )
		    {fifo32_put(waitflag,0xFFFFFFFF);}
		}
	      else {fifo32_put(waitflag,0xFFFFFFFF);}   //I 

	    }else{fifo32_put(waitflag,0xFFFFFFFF);}   //I 

	}



      //NX^[h߂I
      //EEEEEEEEEEp~EEEE
      else if ( fifodata == 3600 )
	{
	  char s[128];

	  int cmd[10];      //̖߂̃R}h	
	  struct FIFO *waitflag;
	  int readcluster;
	  char *readbuf;

	  int cl2ro;

	  int err1;
	  int i,i2;

	  //cSQbg
	  for ( i2 = 1; i2 <= 10; i2++)
	    {
	      cmd[i2] = fifo32_get(&task->fifo);
	      if (cmd[i2] == 3999){break;}
	    }

	  readcluster = cmd[1];
	  waitflag = cmd[2];
	  readbuf = cmd[3];

	  //NX^no_ZN^ɕϊ
	  cl2ro = 33 - 2 + readcluster;

	  //ZN^[h
	  err1 = fd_read_rsec(cl2ro,readbuf,900);
	  if ( (err1 & 0xFFFF) == 0 )
	    {
	      sprintf(s, "OK! %08x",cl2ro);
	      putfonts8_asc_sht(sheet,8*1,16*6,COL8_008484,COL8_FFFFFF,s,12);

	      //`
	      fifo32_put(waitflag,0xFFFFFFF0);
	    }
	  else
	    {
	      //s`
	      fifo32_put(waitflag,0xFFFFFFFF);

	    }







	}



    }

      sprintf(s, "Counter=%5d  Moter=",counter);
      putfonts8_asc_sht(sheet,8*1,16*2,COL8_008484,COL8_FFFFFF,s,21);


      //[^[j^
      if (fdtime1.moter_now == 0)
	{
	  sprintf(s,"*");
	  putfonts8_asc_sht(sheet,8*23,16*2,COL8_C6C6C6,COL8_FFFFFF,s,1);
	}
      else
	{
	  sprintf(s,"*");
	  putfonts8_asc_sht(sheet,8*23,16*2,COL8_FF0000,COL8_FFFFFF,s,1);
	}

      //jobI؂Ă̂Ƀ[^[Ă
      if (fdtime1.moter_now != 0 && fdtime1.sect_job == 0 && fdtime1.moter_set_stop == 0)
	{
	  //~͔CB^C}[Zbĝ݁I
	  timer_settime(timer1,300);
	  fdtime1.moter_set_stop = 1;
	}

  }
}




























void inthandler26(int *esp)
/* FDRg[̊荞 */
{
 	/**/
 	io_out8(PIC0_OCW2, 0x66);	/* IRQ-06tPICɒʒm */

	fifo32_put(fdfifo,3000);
	return;
}

//void init_fd(struct FIFO32 *fifo)
void init_fd(struct FDTIME *fdtimeS)
{

  //ʎgpłfdTime1Ɩ{̃^XNfdtime1т
  fdTime1 = fdtimeS;
  fdfifo = fdTime1->fifo;

  //  fdfifo = fdtime1->fifo;
  //  return fdfifo;
  return;
}

//ZN^[0̏񂩂BPEъe_ZN^ʒuZo
void bpe_read(struct FD_BPE *fdbpe,char *buf)
{
  int i;

  fdbpe->sec_suu=buf[12]*0x100 + buf[11];
  fdbpe->cras_size=buf[13];
  fdbpe->fat_start=buf[15]*0x100 + buf[14];
  fdbpe->fat_suu=buf[16];

  fdbpe->root_len=buf[18]*0x100 + (buf[17] & 0xf0);

  fdbpe->disk_size=buf[20]*0x100 + buf[19];
  fdbpe->fat_len=buf[23]*0x100 + buf[22];
  fdbpe->track_suu=buf[25]*0x100 + buf[24];
  fdbpe->head_suu=buf[27]*0x100 + buf[26];
  fdbpe->allsec_suu=buf[35]*0x100000 + buf[34]*0x1000 + buf[33]*0x100 + buf[32];

  for ( i = 0; i <= 11; i++)
    {
      fdbpe->volume[i] = buf[43 + i];
    }

  for ( i = 0; i <= 5; i++)
    {
      fdbpe->disktype[i]= buf[54 + i];
    }

  //_ZN^ւ̉Z
  fdbpe->r_ipl = 0;

  fdbpe->r_fat1s = fdbpe->r_ipl + fdbpe->fat_start;
  fdbpe->r_fat1e = fdbpe->r_fat1s + fdbpe->fat_len - 1;
  //ʂ邪AFATȂꍇ̑Ώ
  if ( fdbpe->fat_suu == 2 )
    {
      fdbpe->r_fat2s = fdbpe->r_fat1s + fdbpe->fat_len;
      fdbpe->r_fat2e = fdbpe->r_fat2s + fdbpe->fat_len - 1;
    }
  else
    {
      //蔲EEEE
      fdbpe->r_fat2s = 0;
      fdbpe->r_fat2e = 0;
    }

  //[g̈
  fdbpe->r_roots = fdbpe->r_fat1s + ( fdbpe->fat_suu * fdbpe->fat_len);
  fdbpe->r_roote = fdbpe->r_roots + ( fdbpe->root_len * 32 / fdbpe->sec_suu)-1;

  //f[^̈
  fdbpe->r_datas = fdbpe->r_roote + 1;
  fdbpe->r_datae = fdbpe->allsec_suu - 1;


  return;
}


void fd_dma_set(int onoff)
{
  //DMȀꏊ
  char *DMA_ADD;
  DMA_ADD = 0x7c00;





  if(onoff == 0)
    {
      //=============ǂݍݗpDMAݒ=============
      //[hݒFf}hEAhXEւ̏݁Ech2
      io_out8(0x000b, 0x06);
      // ǂݍރoCg̐ݒ i512oCgݒ肵j
      io_out8(0x0005, 0xff);
      io_out8(0x0005, 1 * 2 - 1);
      // ǂݍރԒn̐ݒ 
      io_out8(0x0004, ((int)0x7c00) & 0xff);
      io_out8(0x0004, ((int)0x7c00 >> 8) & 0xff); 
      io_out8(0x0081, ((int)0x7c00 >> 16) & 0xff);
      // }X^ch2DMA}XN 
      io_out8(0x000a, 0x02); 
      //=============================================
    }
  else
    {
      io_out8(0x000a, 0x06); /* }X^ch2DMA}XN */
    }






  return;

}


//_ZN^𕨗ZN^ɕϊ
void fd_r2b(int rsec, int *parm)
{
  int Mc = 80;
  int Mh = 2;
  int Ms = 18;

  parm[2] = rsec % Ms +1;
  parm[1] = (rsec / Ms) % Mh;
  parm[0] = (rsec / Ms) / Mh;



  return;
}





int send_sec_read(char C, char H, char S,int wtime)
{

  int f;

  //[^[mFAĂȂȂ܂킷
  if ( fdTime1->moter_now == 0)
    {
      fd_moter(1);
    }
  //R}hMO̊mFё҂
  //^C}[3bɐݒBȏ㔽ȂȂG[B
  timer_settime(fdTime1->timer,wtime);
  while( (io_in8(0x03f4) & 0x11) != 0x00 )
    {
      if (fifo32_status(fdTime1->fifo) !=0)
      	{
	  f = fifo32_get(fdTime1->fifo);
	  if ( f == 10)
      	    {
      	      return 0x01;
      	    }
      	}
    }

  //ǂݍ݃R}hsiC0AH0AS1j
  while( (io_in8(0x03f4) & 0xC0) != 0x80 )
    {
      if (fifo32_status(fdTime1->fifo) !=0)
      	{
	  f = fifo32_get(fdTime1->fifo);
	  if ( f == 10)
      	    {
      	      return 0x02;
      	    }
      	}
    }
  io_out8(0x03f5, 0xE6);

  //============ H << 2 ================
  while( (io_in8(0x03f4) & 0xC0) != 0x80 )
    {
      if (fifo32_status(fdTime1->fifo) !=0)
      	{
	  f = fifo32_get(fdTime1->fifo);
	  if ( f == 10)
      	    {
      	      return 0x03;
      	    }
      	}
    }
  io_out8(0x03f5, H << 2);

  //============ C ================
  while( (io_in8(0x03f4) & 0xC0) != 0x80 )
    {
      if (fifo32_status(fdTime1->fifo) !=0)
      	{
	  f = fifo32_get(fdTime1->fifo);
	  if ( f == 10)
      	    {
      	      return 0x04;
      	    }
      	}
    }
  io_out8(0x03f5, C);

  //============ H ================
  while( (io_in8(0x03f4) & 0xC0) != 0x80 )
    {
      if (fifo32_status(fdTime1->fifo) !=0)
      	{
	  f = fifo32_get(fdTime1->fifo);
	  if ( f == 10)
      	    {
      	      return 0x05;
      	    }
      	}
    }
  io_out8(0x03f5, H);

  //============ S ================
  while( (io_in8(0x03f4) & 0xC0) != 0x80 )
    {
      if (fifo32_status(fdTime1->fifo) !=0)
      	{
	  f = fifo32_get(fdTime1->fifo);
	  if ( f == 10)
      	    {
      	      return 0x05;
      	    }
      	}
    }
  io_out8(0x03f5, S);
	  
  while( (io_in8(0x03f4) & 0xC0) != 0x80 )
    {
      if (fifo32_status(fdTime1->fifo) !=0)
	{
	  f = fifo32_get(fdTime1->fifo);
	  if ( f == 10)
      	    {
      	      return 0x06;
      	    }
      	}
    }
    io_out8(0x03f5, 0x02);

  while( (io_in8(0x03f4) & 0xC0) != 0x80 )
    {
      if (fifo32_status(fdTime1->fifo) !=0)
      	{
	  f = fifo32_get(fdTime1->fifo);
	  if ( f == 10)
	    {
      	      return 0x07;
      	    }
      	}
    }
  io_out8(0x03f5, 0x12);

  while( (io_in8(0x03f4) & 0xC0) != 0x80 )
    {
      if (fifo32_status(fdTime1->fifo) !=0)
      	{
	  f = fifo32_get(fdTime1->fifo);
	  if ( f == 10)
      	    {
      	      return 0x08;
      	    }
      	}
    }
  io_out8(0x03f5, 0x01);

  while( (io_in8(0x03f4) & 0xC0) != 0x80 )
    {
      if (fifo32_status(fdTime1->fifo) !=0)
      	{
	  f = fifo32_get(fdTime1->fifo);
	  if ( f == 10)
      	    {
      	      return 0x09;
      	    }
      	}
    }
    io_out8(0x03f5, 0xFF);


  //sB
    timer_cancel(fdTime1->timer);

    return 0;
}


int send_seek(char C, char H, int wtime)
{
  int f;

  //[^[mFAĂȂȂ܂킷
  if ( fdTime1->moter_now == 0)
    {
      fd_moter(1);
    }
  //R}hMO̊mFё҂
  //^C}[3bɐݒBȏ㔽ȂȂG[B
  timer_settime(fdTime1->timer,wtime);
  while( (io_in8(0x03f4) & 0x11) != 0x00 )
    {
      if (fifo32_status(fdTime1->fifo) !=0)
      	{
	  f = fifo32_get(fdTime1->fifo);
	  if ( f == 10)
     	    {
      	      return 0x01;
      	    }
      	}
    }

  //SEEKR}hs
  while( (io_in8(0x03f4) & 0xC0) != 0x80 )
    {
      if (fifo32_status(fdTime1->fifo) !=0)
	      {
		f = fifo32_get(fdTime1->fifo);
		if ( f == 10)
		  {
		    return 0x02;
		  }
	      }
    }
  io_out8(0x03f5, 0x0F);

  //============ H << 2 ================
  while( (io_in8(0x03f4) & 0xC0) != 0x80 )
    {
      if (fifo32_status(fdTime1->fifo) !=0)
      	{
	  f = fifo32_get(fdTime1->fifo);
	  if ( f == 10)
      	    {
      	      return 0x03;
      	    }
      	}
    }
  io_out8(0x03f5, H << 2);

  //============ C ================
  while( (io_in8(0x03f4) & 0xC0) != 0x80 )
    {
      if (fifo32_status(fdTime1->fifo) !=0)
      	{
	  f = fifo32_get(fdTime1->fifo);
	  if ( f == 10)
      	    {
      	      return 0x04;
      	    }
      	}
    }
  io_out8(0x03f5, C);

  //sB
  timer_cancel(fdTime1->timer);

  return 0;
}

int send_reset(int wtime)
{
  int f;

  //[^[mFAĂȂȂ܂킷
  if ( fdTime1->moter_now == 0)
    {
      fd_moter(1);
    }
  //R}hMO̊mFё҂
  //^C}[3bɐݒBȏ㔽ȂȂG[B
  timer_settime(fdTime1->timer,wtime);
  while( (io_in8(0x03f4) & 0x11) != 0x00 )
    {
      if (fifo32_status(fdTime1->fifo) !=0)
      	{
	  f = fifo32_get(fdTime1->fifo);
	  if ( f == 10)
     	    {
      	      return 0x01;
      	    }
      	}
    }

  //ǂݍ݃R}hs
  while( (io_in8(0x03f4) & 0xC0) != 0x80 )
    {
      if (fifo32_status(fdTime1->fifo) !=0)
	      {
		f = fifo32_get(fdTime1->fifo);
		if ( f == 10)
		  {
		    return 0x02;
		  }
	      }
    }
  io_out8(0x03f5, 0x07);

  while( (io_in8(0x03f4) & 0xC0) != 0x80 )
    {
      if (fifo32_status(fdTime1->fifo) !=0)
      	{
	  f = fifo32_get(fdTime1->fifo);
	  if ( f == 10)
      	    {
      	      return 0x03;
      	    }
      	}
    }
  io_out8(0x03f5, 0x00);

  //sB
  timer_cancel(fdTime1->timer);

  return 0;
}

//UgR[h̎Mߔs==============================
int get_rez(int wtime)
{
  int f;
  //Ug̎󂯎M
  int rez[40];


  //uCN̂ŃUgQbg
	  
  timer_settime(fdTime1->timer,wtime);

  while( (io_in8(0x03f4) & 0xC0) != 0xC0 )
    {
      if (fifo32_status(fdTime1->fifo) !=0)
	{
	f = fifo32_get(fdTime1->fifo);
	if ( f == 10)
	    {
	      return 0xFF01;
	    }
	}
    }
  rez[0] = io_in8(0x03f5);

  while( (io_in8(0x03f4) & 0xC0) != 0xC0 )
    {
      if (fifo32_status(fdTime1->fifo) !=0)
	{
	f = fifo32_get(fdTime1->fifo);
	if ( f == 10)
	    {
	      return 0xFF02;
	    }
	}
    }
  rez[1] = io_in8(0x03f5);

  while( (io_in8(0x03f4) & 0xC0) != 0xC0 )
    {
      if (fifo32_status(fdTime1->fifo) !=0)
	{
	f = fifo32_get(fdTime1->fifo);
	if ( f == 10)
	    {
	      return 0xFF03;
	    }
	}
    }
  rez[2] = io_in8(0x03f5);
  
  while( (io_in8(0x03f4) & 0xC0) != 0xC0 )
    {
      if (fifo32_status(fdTime1->fifo) !=0)
	{
	f = fifo32_get(fdTime1->fifo);
	if ( f == 10)
	    {
	      return 0xFF04;
	    }
	}
    }
  rez[3] = io_in8(0x03f5);

  while( (io_in8(0x03f4) & 0xC0) != 0xC0 )
    {
      if (fifo32_status(fdTime1->fifo) !=0)
	{
	f = fifo32_get(fdTime1->fifo);
	if ( f == 10)
	    {
	      return 0xFF05;
	    }
	}
    }
  rez[4] = io_in8(0x03f5);

  while( (io_in8(0x03f4) & 0xC0) != 0xC0 )
    {
      if (fifo32_status(fdTime1->fifo) !=0)
	{
	f = fifo32_get(fdTime1->fifo);
	if ( f == 10)
	    {
	      return 0xFF06;
	    }
	}
    }
  rez[5] = io_in8(0x03f5);

  while( (io_in8(0x03f4) & 0xC0) != 0xC0 )
    {
      if (fifo32_status(fdTime1->fifo) !=0)
	{
	f = fifo32_get(fdTime1->fifo);
	if ( f == 10)
	    {
	      return 0x07;
	    }
	}
    }
  rez[6] = io_in8(0x03f5);

  //ȂƂȂAŏIƂƂŒǉ
  rez[7] = 0x00;

  //ɏI悤Ȃ̂Ń^C}[̌n
  timer_cancel(fdTime1->timer);

  //  fdtime1->moter_time = 125;

  return (rez[0] & 0xc0) * 0x100 ;
}


//=========FD[^[̐============
void fd_moter(char v)
{
  int f;


  if (v == 0)
    {
      //[^[~
      io_out8(0x03f2, 0x0c); 
      //[^[~mɂ邽߁Ab҂
      timer_settime(fdTime1->timer,300);
      for (;;)
	{
	  if (fifo32_status(fdTime1->fifo) !=0)
	    {
	      f = fifo32_get(fdTime1->fifo);
	      if ( f == 10)
		{
		  break;
		}
	    }
	}
      fdTime1->moter_now = 0;
      fdTime1->moter_time = 0;
      fdTime1->sect_job = 0;
    }
  else
    {
      //[^[]
      io_out8(0x03f2, 0x1c); 
      //[^[]mɂ邽߁Ab҂
      timer_settime(fdTime1->timer,300);
      for (;;)
	{
	  if (fifo32_status(fdTime1->fifo) !=0)
	    {
	      f = fifo32_get(fdTime1->fifo);
	      if ( f == 10)
		{
		  break;
		}
	    }
	}
      fdTime1->moter_now = 1;
      //      fdtime1->moter_time = 1;
    }

  return;
}


//荞ݏԎ擾
int int6check(int wtime)
{
  int f;
  char st0,c;
  int err1;

  //^C}[ZbgB
  timer_settime(fdTime1->timer,wtime);
  while( (io_in8(0x03f4) & 0x10) != 0x00 )
    {
      if (fifo32_status(fdTime1->fifo) !=0)
      	{
	  f = fifo32_get(fdTime1->fifo);
	  if ( f == 10)
      	    {
      	      return 0xFF01;
      	    }
      	}
    }

  //08R}hs
  while( (io_in8(0x03f4) & 0xC0) != 0x80 )
    {
      if (fifo32_status(fdTime1->fifo) !=0)
      	{
	  f = fifo32_get(fdTime1->fifo);
	  if ( f == 10)
      	    {
      	      return 0xFF02;
      	    }
      	}
    }
  io_out8(0x03f5, 0x08);


  //Ug󂯎(ST0)
  while( (io_in8(0x03f4) & 0xC0) != 0xC0 )
    {
      if (fifo32_status(fdTime1->fifo) !=0)
      	{
	  f = fifo32_get(fdTime1->fifo);
	  if ( f == 10)
      	    {
      	      return 0xFF03;
      	    }
      	}
    }
  st0 = io_in8(0x03f5);

  //============ C ================
  while( (io_in8(0x03f4) & 0xC0) != 0xC0 )
    {
      if (fifo32_status(fdTime1->fifo) !=0)
      	{
	  f = fifo32_get(fdTime1->fifo);
	  if ( f == 10)
      	    {
      	      return 0xFF04;
      	    }
      	}
    }
  c = io_in8(0x03f5);
 
  //I

  timer_cancel(fdTime1->timer);
  err1 = (st0 & 0xc0)* 0x100;
  return err1;
}


//IRQ6̊荞݂҂֐
int int6wait(int wtime)
{
  int err1;
  int fifodata;

  //^C}[ZbgB
  timer_settime(fdTime1->timer,wtime);
  for (;;)
    {
      //		io_cli();
      if (fifo32_status(fdTime1->fifo) !=0)
	{
	  fifodata = fifo32_get(fdTime1->fifo);
	  //荞݂uCN
	  break;
	}
    }

  if ( fifodata == 3000 )
    {
      err1 = 0;
      timer_cancel(fdTime1->timer);
    }
  else if ( fifodata == 10 )
    {
      err1 = 0x0F;
    }
  else
    {
      err1 = 0x10;
    }





  return err1;


}


//=========================================================
//====================@֐ҁ@======================
//=========================================================

//ZN^[hʂ
int fd_read_sector(char CC,char HH,char SS,int wtime)
{
  int myerr;
  myerr = 0x30000000;

  int err1;

  //ǂݍ݃R}hs
  //₱Afdtime͔ԒnƂēn
  err1 = send_sec_read(CC,HH,SS,wtime);
  if ( err1 != 0 )
    {
      return myerr + 0x01000000 + err1;
    }

  //荞ݑ҂
  err1 = int6wait(wtime);
  if ( err1 != 0 )
    {
      return myerr + 0x02000000 + err1;
    }

  //Ug̎擾
  err1 = get_rez(wtime);
  if ( err1 != 0 )
    {
      return myerr + 0x03000000 + err1;
    }
	    
  //I{UgԂ
  return myerr + err1;

}

//Zbgʂ
int fd_reset(int wtime)
{
  int myerr;
  myerr = 0x20000000;

  int err1;

  //ZbgR}hM
  err1 = send_reset(wtime);

  if ( err1 != 0 )
    {
      return myerr + 0x01000000 + err1;
    }

  //荞ݑ҂
   err1 = int6wait(wtime);
  if ( err1 != 0 )
    {
      return myerr + 0x02000000 + err1;
    }

  //荞ݏԎ擾
  err1 = int6check(wtime);
  if ( ((err1 >> 6) & 0xc0) != 0 )
    {
      return myerr + 0x03000000 + err1;
    }
  
  //I{Ug
  return myerr + err1;

}

//V[Nʂ
int fd_seek(int CC,int HH, int wtime)
{
  int myerr;
  myerr = 0x10000000;

  int err1;

  //SEEKR}hs
  err1 = send_seek(CC,HH,wtime);
  if ( err1 != 0 )
    {
      return myerr + 0x01000000 + err1 ;
    }
	    
  //荞ݑ҂
  err1 = int6wait(wtime);
  if ( err1 != 0 )
    {
      return myerr + 0x02000000 + err1;
    }


  //荞ݏԎ擾
  err1 = int6check(wtime);
  if ( ((err1 >> 6) & 0xc0) != 0 )
    {
      return myerr + 0x03000000 + err1;
    }

  return myerr + err1;

}




//=========================================================
//====================@֐ҁ@2======================
//=========================================================
//BPE̎擾ꊇčs
int fd_get_bpe(int wtime,struct FD_BPE *fdbpe1){
  int err1;
  int *sec0;
  sec0 = 0x7c00;

  //܂ZN^Oǂ
  err1 = fd_seek(0,0,900);
  if ( (err1 & 0xFFFF) != 0)
    {
      return err1;
    }

  //DMAJ
  fd_dma_set(0);
  //ZN^ǂݍ
  err1 = fd_read_sector(0,0,1,900);
  if ( (err1 & 0xFFFF) != 0)
    {
      //DMA
      fd_dma_set(1);
      return err1;
    }
  //DMA
  fd_dma_set(1);

  bpe_read(fdbpe1,sec0);

  return err1;
}


//[gfBNgꊇēǂݍ
int fd_get_rootdir(int wtime,struct FD_BPE *fdbpe1,char *rootbuf){
  //ZN^0́fd_get_bpeŊɍsĂ邱ƂOB
  int err1;

  int nowC;
  int nowP;

  int i,i2;

  int parm[3];

  char *sec0;
  sec0 = 0x7c00;

  //܂̓obt@ݒuBbpevZ
  //傫̂memman_allocg܂
  //  rootbuf = memman_alloc_4k(memman,512 * (fdbpe1->r_roote - fdbpe1.r->roots+1) );


  nowC = 0;
  nowP = 0;
  //[gfBNgSēǂݍ݂܂
  for (i = fdbpe1->r_roots; i < fdbpe1->r_roote; i++)
    {
      //_ZN^𕨗ZN^ɕϊ
      fd_r2b(i,parm);
	       
      //݂̃V_ƈقȂȂV[N
      if ( nowC != parm[0] )
	{
	  //V[NR}h𔭍s
	  err1 = fd_seek(parm[0],parm[1],900);
	  nowC = parm[0];
	}

      //DMAJ
      fd_dma_set(0);

      //ZN^[h߂𔭍s
      err1 = fd_read_sector(parm[0],parm[1],parm[2],900);

      //DMA
      fd_dma_set(1);

      //DMAɓǂݍ܂ꂽeɈړ
      for ( i2 = 0; i2 <= 511; i2++)
	{
	  rootbuf[nowP] = sec0[i2];
	  nowP++;
	}
    }



  return err1;


}



//̖Õt@C邩ǂT
int searchfile(const char *filename){
  int err1;

  //܂̓[gfBNgǂޏB

  //BPE擾邽߃ZN^Oǂ
  //܂̓V_0ɃV[NI
  //  err1 = fd_seek(0,0,900,fdtime1);

}


//_ZN^[hʂ
int fd_read_rsec(int rsec,char *sendbufadd,int wtime){
  int err1;
  int parm[3];

  char *DMA_BUF;
  DMA_BUF = 0x7c00;

  int i;

  //܂_ZN^𕨗ZN^ɕϊ
  fd_r2b(rsec,parm);

  //ړĨV_ɃV[NI
  err1 = fd_seek(parm[0],parm[1],wtime);
  if ( (err1 & 0xFFFF) == 0 )
    {
      
      //DMAJ
      fd_dma_set(0);

      //[hR}hM
      err1 = fd_read_sector(parm[0],parm[1],parm[2],wtime);
      if ( (err1 & 0xFFFF) == 0 )
	{
	  //DMA
	  fd_dma_set(1);

	  //DMAɓeĂ̂ŖړĨobt@ɓ]
	  for ( i = 0; i <= 511; i++)
	    {
	      sendbufadd[i] = DMA_BUF[i];

	    }



	}
    }

  return err1;

}



//擪NX^玩ŏI[܂œǂ݁Aobt@Ԃ(ɑZN^pj
//G[̏ꍇNULLi0jԂ
char *fd_file_read(struct FILEINFO finfo1,struct FD_BPE fdbpe1){

  /*  char *s;

  int tmp1,tmp2;


  tmp1 = finfo1.size;
  tmp2 = fdbpe1.sec_suu;

  sprintf(s,"tmp1=%04d");
  //		putfonts8_asc(0xa0000,640,8,16*0,COL8_008484,s);
  //		sprintf(s,"tmp2=%04d",tmp2);
  //		putfonts8_asc(0xa0000,640,8,16*2,COL8_008484,s);

  */




  struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;

  int err1;
  int i2,i3;

  int cl2ro;
  char *fbuf,*fbuf2;

  int nextchain;
  unsigned int base1,base2,base3;
  unsigned int nextclust;
  int chain_suu;

  //\̂̒l𒼐ڎgƂ낢ƕs肻Ȃ̂ŁEEE
  int bpe_sec_suu;
  bpe_sec_suu = fdbpe1.sec_suu;
  unsigned int bpe_r_fat1e;
  bpe_r_fat1e = fdbpe1.r_fat1e;
  unsigned int bpe_r_fat1s;
  bpe_r_fat1s = fdbpe1.r_fat1s;
  unsigned int bpe_r_datas;
  bpe_r_datas = fdbpe1.r_datas;
  int fi_clustno;
  fi_clustno = finfo1.clustno;
  int fi_size;
  fi_size = finfo1.size;

  //FAT̈ǂ݁A`F[c
  //傫̂mallocŁEEE
  char *fat_base;
  unsigned int *fat_chain;
  fat_base = memman_alloc_4k(memman,512 * (bpe_r_fat1e - bpe_r_fat1s + 1 ) );
  fat_chain = memman_alloc_4k(memman,2880 * 4 );

  for (i2=bpe_r_fat1s; i2 <= bpe_r_fat1e; i2++)
    {
      err1 = fd_read_rsec(i2,fat_base + (512 * (i2 - bpe_r_fat1s) ),900);
    }

  //FAT`F[͊Jn


  //ŏ̒lZbg
  fat_chain[0] = fi_clustno;
  char s[40];
  chain_suu = 0;
  nextclust = 0;

  for (;;)
    {
      if ( fat_chain[chain_suu] % 2 == 0 )
	{
	  nextchain = fat_chain[chain_suu] * 3 /2;
	  
	  base1 = fat_base[nextchain];
	  base2 = fat_base[nextchain + 1];
	  base3 = fat_base[nextchain + 2];

	  nextclust = ( base2 & 0x0f ) * 0x100 + ( base1 & 0xff );
	}
      else
	{
	  nextchain = ( fat_chain[chain_suu] - 1 ) * 3 /2;

	  base1 = fat_base[nextchain];
	  base2 = fat_base[nextchain + 1];
	  base3 = fat_base[nextchain + 2];

	  nextclust = ( base3 & 0xff ) * 0x10 + ( (base2 & 0xf0) / 0x10 );
	}

      if ( nextclust >= 0x0ff8 ) { break;}

      chain_suu++;
      fat_chain[chain_suu] = nextclust;

    }

		
  //ŃNX^`F[łIƂ͓]I
  //b̑傫̃obt@pӂAǂݍ

  fbuf = memman_alloc_4k( memman, chain_suu * bpe_sec_suu );

  for ( i3 = 0; i3 <= chain_suu; i3++)
    {
      //NX^no_ZN^ɕϊ
      cl2ro = bpe_r_datas - 2 + fat_chain[i3];

      //ZN^[h
      err1 = fd_read_rsec(cl2ro, fbuf + (512 * i3), 900);
      if ( (err1 & 0xFFFF) == 0 )
	{
	
			      
	}
      else
	{
	  //G[IُI
	  return 0;

	}
    }
  //SĂ܂s悤Ȃ̂łƂobt@pӂĈڂ
  fbuf2 = memman_alloc_4k( memman, fi_size );
  for ( i2 = 0; i2 <= fi_size; i2++ )
    {
      fbuf2[i2] = fbuf[i2];
    }
  
  //Ȃobt@̌n
  memman_free_4k(memman,(int)fat_base,512 * (bpe_r_fat1e - bpe_r_fat1s + 1 ));
  memman_free_4k(memman,(int)fat_chain,2880 * 4);
  memman_free_4k(memman,(int)fbuf,chain_suu * bpe_sec_suu);

  //AhXԂďI


  return fbuf2;
}


