#ifndef		__T_ANALYS_LINER_H_INCLUDE_
#define		__T_ANALYS_LINER_H_INCLUDE_

#include "../contena/t_image_base.h"
#include "../common/t_com_allscan.h"
#include "../data/t_line.h"

#include <vector>

namespace t_image_engine{

// 摜̃Cf[^
class t_analys_liner
{
public:
	// Cf[^쐬
	inline static bool make_line(
		const t_image_interface& src, 
		std::vector<t_line>* linedata
	)
	{
		// oCif[^̂ݗL
		switch(src.tag()){
		case binary_1bit: return t_analys_liner_f<t_image_binary>::func(src, linedata);
		}
		return false;
	}

protected:
	// Cf[^\zNX
	class t_analys_linemaker
	{
	public:
		t_analys_linemaker() 
			: flag_(false), sx_(0), ex_(0), y_(-1){}

		bool	flag_;
		int		sx_;
		int		ex_;
		int		y_;
		std::vector<t_line> linedata_;
	};

	// Cf[^\z֐
	struct t_analys_f_liner_binaly{
		inline static void f(const unsigned char *buff, t_analys_linemaker* dst, int x, int y)
		{
			if(dst->y_ == y){
				_f(buff, dst, x, y);
			}else{
				if(dst->flag_){
					dst->linedata_.push_back(t_line(dst->sx_, dst->ex_, dst->y_));
					dst->flag_ = false;
				}
				dst->y_  = y;
				_f(buff, dst, x, y);
			}
		}

		inline static void _f(const unsigned char *buff, t_analys_linemaker* dst, int x, int y)
		{
			if(*buff){
				if(!dst->flag_){
					dst->sx_ = dst->ex_ = x;
					dst->flag_ = true;
				}else{
					dst->ex_ = x;
				}
			}else{
				if(dst->flag_){
					dst->linedata_.push_back(t_line(dst->sx_, dst->ex_, y));
					dst->flag_ = false;
				}
			}
		}
	};

	// Cf[^\zC
	template< typename _CLASS > class t_analys_liner_f
	{
	public:
		static bool func(const t_image_interface& src, std::vector<t_line>* linedata)
		{	
			return _func(reinterpret_cast<const _CLASS*>(&src),  linedata);
		}

	protected:
		static bool _func(const _CLASS* src, std::vector<t_line>* linedata)
		{
			t_analys_linemaker linemaker;
			bool ret =  t_com_allscan_pos<_CLASS, t_analys_linemaker, t_analys_f_liner_binaly>::func(*src, &linemaker);
			if(ret){
				*linedata = linemaker.linedata_;
			}
			return ret;
		}
	};

	
};


};

#endif
