#ifndef		__T_COM_ALLCONV_H_INCLUDE_
#define		__T_COM_ALLCONV_H_INCLUDE_

#include "template/t_com_template_conv_functor.h"

namespace t_image_engine{

// Sfϊ(PFUNCTORs)
template <typename _SRCT, typename _DSTT, typename _FUNCTOR>
class t_com_allconv
{
protected:
	typename typedef _SRCT::imagetype_ _ST;
	typename typedef _DSTT::imagetype_ _DT;

public:
	inline static bool func(const _SRCT& src, _DSTT* dst)
	{
		if(!dst || (src.width() != dst->width() || src.height() != dst->height())){
			if(!dst->create(src.width(), src.height())){
				return false;
			}
		}

		const _ST* sp =  src.pointer_safe();
		_DT* dp =  dst->pointer();
		for(int i = 0; i < src.size(); i++, sp++, dp++){
			_FUNCTOR::f(sp, dp);
		}
		return true;
	}
};


//  Sfϊ(ϐt)
template <typename _SRCT, typename _DSTT, typename _FUNCTOR, typename _FUNCTOR_A, bool _POS_FLAG = false>
class t_com_allconv_a1
{
protected:
	typename typedef _SRCT::imagetype_ _ST;
	typename typedef _DSTT::imagetype_ _DT;

public:
	inline static bool func(const _SRCT& src, _DSTT* dst, _FUNCTOR_A arg)
	{
		if(!dst || (src.width() != dst->width() || src.height() != dst->height())){
			if(!dst->create(src.width(), src.height())){
				return false;
			}
		}

		const int w = src.width();
		int offset = 0;
		for(int y = 0; y < src.height(); y++){
			const _ST* sp =  src.pointer_safe() + offset;
			_DT* dp =  dst->pointer() + offset;
			for(int x = 0; x < src.width(); x++, sp++, dp++){
				t_com_template_conv_functor_a1<_ST, _DT, _FUNCTOR, _FUNCTOR_A, _POS_FLAG>::f(x,y,sp,dp,arg);
			}
			offset += w;
		}
		return true;
	}
};

};

#endif