#ifndef		__T_COM_AREACONV_H_INCLUDE_
#define		__T_COM_AREACONV_H_INCLUDE_

#include "../data/t_rect.h"
#include "template/t_com_template_conv_functor.h"

namespace t_image_engine{

// ̈fϊ(PFUNCTORs)
template <typename _SRCT, typename _DSTT, typename _FUNCTOR>
class t_com_areaconv
{
protected:
	typename typedef _SRCT::imagetype_ _ST;
	typename typedef _DSTT::imagetype_ _DT;

public:
	inline static bool func(const _SRCT& src, _DSTT* dst, const t_rect* rect)
	{
		if(!dst || (src.width() != dst->width() || src.height() != dst->height())){
			if(!dst->create(src.width(), src.height())){
				return false;
			}
		}

		const int w = src.width();
		int offset = w * rect->top_ + rect->left_;
		for(int y = rect->top_; y < rect->bottom_; y++){
			const _ST* sp =  src.pointer_safe() + offset;
			_DT* dp =  dst->pointer() + offset;
			for(int x = rect->left_; x < rect->right_; x++, sp++, dp++){
				_FUNCTOR::f(sp, dp);
			}
			offset += w;
		}
		return true;
	}
};

// ̈fϊ(ϐt)
template <typename _SRCT, typename _DSTT, typename _FUNCTOR, typename _FUNCTOR_A, bool _POS_FLAG = false>
class t_com_areaconv_a1
{
protected:
	typename typedef _SRCT::imagetype_ _ST;
	typename typedef _DSTT::imagetype_ _DT;

public:
	inline static bool func(const _SRCT& src, _DSTT* dst, _FUNCTOR_A arg, const t_rect* rect)
	{
		if(!dst || (src.width() != dst->width() || src.height() != dst->height())){
			if(!dst->create(src.width(), src.height())){
				return false;
			}
		}
		const int w = src.width();
		int offset = w * rect->top_ + rect->left_;
		for(int y = rect->top_; y < rect->bottom_; y++){
			const _ST* sp =  src.pointer_safe() + offset;
			_DT* dp =  dst->pointer() + offset;
			for(int x = rect->left_; x < rect->right_; x++, sp++, dp++){
				t_com_template_conv_functor_a1<_ST, _DT, _FUNCTOR, _FUNCTOR_A, _POS_FLAG>::f(x,y,sp,dp,arg);
			}
			offset += w;
		}
		return true;
	}
};

}

#endif