#ifndef		__T_COM_AREACONV_COMP_H_INCLUDE_
#define		__T_COM_AREACONV_COMP_H_INCLUDE_

namespace t_image_engine{
	
// p ̈ϊ(YCƂfunctors)
template <class _SRCT, class _DSTT, class _FUNCTOR> 
class t_com_areaconv_comp
{
protected:
	typename typedef _SRCT::imagetype_ _ST;
	typename typedef _DSTT::imagetype_ _DT;

public:
	inline static bool func(
		const _SRCT& src, 
		_DSTT* dst,   
		int dstSx, 
		int dstSy, 
		int srcSx, 
		int srcSy, 
		int srcWidth, 
		int srcHeight
	)
	{
		if(!dst)
			return false;
		if(!srcWidth)	
			srcWidth  = src.width(); 
		if(!srcHeight)	
			srcHeight = src.height();
		if(dstSx + srcWidth > dst->width())
			srcWidth -= (dstSx + srcWidth-dst->width());
		if(dstSy + srcHeight > dst->height())
			srcHeight -= (dstSy + srcHeight-dst->height());

		const int sw = src.width();
		const int dw = dst->width();
		_DT* dpbase = dst->pointer();
		const _ST* spbase = src.pointer_safe();

		// CƂ̏
		for(int y = 0; y < srcHeight; y++){
			_FUNCTOR::f(
				dpbase + (y + dstSy) * dw + dstSx, 
				spbase + (y + srcSy) * sw + srcSx, srcWidth);
		}
		return true;
	}
};

}

#endif