#ifndef		__T_COM_LINECONV_H_INCLUDE_
#define		__T_COM_LINECONV_H_INCLUDE_

#include "../data/t_line.h"
#include "template/t_com_template_conv_functor.h"

namespace t_image_engine{

// Cf[^fϊ(PFUNCTORs)
template <typename _SRCT, typename _DSTT, typename _FUNCTOR>
class t_com_lineconv
{
protected:
	typename typedef _SRCT::imagetype_ _ST;
	typename typedef _DSTT::imagetype_ _DT;

public:
	inline static bool func(const _SRCT& src, _DSTT* dst, const std::vector<t_line>* lines)
	{
		if(!dst || (src.width() != dst->width() || src.height() != dst->height())){
			if(!dst->create(src.width(), src.height())){
				return false;
			}
		}
		for(std::vector<t_line>::const_iterator it = lines->begin(); it != lines->end(); it++){
			// 
		}
		return true;
	}
};

// Cf[^fϊ(ϐt)
template <typename _SRCT, typename _DSTT, typename _FUNCTOR, typename _FUNCTOR_A, bool _POS_FLAG = false>
class t_com_lineconv_a1
{
protected:
	typename typedef _SRCT::imagetype_ _ST;
	typename typedef _DSTT::imagetype_ _DT;

public:
	inline static bool func(const _SRCT& src, _DSTT* dst, _FUNCTOR_A arg, const std::vector<t_line>* lines)
	{
		if(!dst || (src.width() != dst->width() || src.height() != dst->height())){
			if(!dst->create(src.width(), src.height())){
				return false;
			}
		}
		const int w = src.width();
		for(std::vector<t_line>::const_iterator it = lines->begin(); it != lines->end(); it++){
			const int y = it->y_;
			const _ST* sp =  src.pointer_safe() + y * w + it->sx_;
			_DT* dp =  dst->pointer() + y * w + it->sx_;;
			for(int x = it->sx_; x < it-> ex_; x++, sp++, dp++){
				t_com_template_conv_functor_a1<_ST, _DT, _FUNCTOR, _FUNCTOR_A, _POS_FLAG>::f(x,y,sp,dp,arg);
			}
		}
		return true;
	}
};

}

#endif