#ifndef		__T_COM_SORT_FUNCTOR_H_INCLUDE_
#define		__T_COM_SORT_FUNCTOR_H_INCLUDE_

#include "../type/t_type_define.h"
#include "../type/t_type_rgb.h"
#include "../converter/t_conv_rgb2ycrcb.h"

//! STL sortp ֐IuWFNg
namespace t_image_engine{

//! RGB\[g֐
// r : ch_rgb_r
template <typename _T> struct t_sortop_r{
	static bool operator_(const _T* a, const _T* b)
	{return a->r_>b->r_;}
};
// g : ch_rgb_g
template <typename _T> struct t_sortop_g{
	static bool operator_(const _T* a, const _T* b)
	{return a->g_>b->g_;}
};
// b : ch_rgb_b
template <typename _T> struct t_sortop_b{
	static bool operator_(const _T* a, const _T* b)
	{return a->b_>b->b_;}
};
// a : ch_rgb_a
template <typename _T> struct t_sortop_a{
	static bool operator_(const _T* a, const _T* b)
	{return a->b_>b->b_;}
};
// average : ch_avr
template <typename _T> struct t_sortop_rgb_avr{
	typename typedef t_type_upper_unsigned_template<_T>::_TL _TYPE;
	static bool operator_(const _T* a, const _T* b)
	{return ((_TYPE)(a->r_)+(_TYPE)(a->g_)+(_TYPE)(a->b_)) >
			((_TYPE)(b->r_)+(_TYPE)(b->g_)+(_TYPE)(b->b_));}
};
// luminances : ch_lum
template <typename _T> struct t_sortop_rgb_lum{
	typename typedef _T::_SINGLE_T	_TYPE;
	static bool operator_(const _T* a, const _T* b)
	{return t_conv_c_rgb2ycrcb<_TYPE, _TYPE>::calc_y(a->r_, a->g_, a->b_) >
			t_conv_c_rgb2ycrcb<_TYPE, _TYPE>::calc_y(b->r_, b->g_, b->b_);}
};

//! PF\[g֐
template <typename _T> struct t_sortop_gray{
	static bool operator_(const _T* a, const _T* b)
	{return *a>*b;}
};

// ֐`
template < typename _PROCT > class t_com_sortop_base
{
protected:
	typedef bool (*operation)(const _PROCT*, const _PROCT*);
};

//! \[gIy[^ZNg Template
template < typename _PROCT > 
struct t_com_sortop_select : protected t_com_sortop_base<_PROCT>
{
	static operation select_op(channel_type t = ch_default)
	{
		return t_sortop_gray<_PROCT>::operator_;
	}
};

//! \[gIy[^ZNg@RGB
template <> 
struct t_com_sortop_select < t_type_rgb >: protected t_com_sortop_base <t_type_rgb>
{
	static operation select_op(channel_type t = ch_default)
	{
		operation op;
		switch(t){
		case ch_default:	op=t_sortop_g<t_type_rgb>::operator_; break;
		case ch_rgb_r:		op=t_sortop_r<t_type_rgb>::operator_; break;
		case ch_rgb_g:		op=t_sortop_g<t_type_rgb>::operator_; break;
		case ch_rgb_b:		op=t_sortop_b<t_type_rgb>::operator_; break;
		case ch_avr:		op=t_sortop_rgb_avr<t_type_rgb>::operator_; break;
		case ch_lum:		op=t_sortop_rgb_lum<t_type_rgb>::operator_; break;
		}
		return op;
	}
};

//! \[gIy[^ZNg@RGBA
template <> 
struct t_com_sortop_select < t_type_rgba >: protected t_com_sortop_base <t_type_rgba >
{
	static operation select_op(channel_type t = ch_default)
	{
		operation op;
		switch(t){
		case ch_default:	op=t_sortop_g<t_type_rgba>::operator_; break;
		case ch_rgb_r:		op=t_sortop_r<t_type_rgba>::operator_; break;
		case ch_rgb_g:		op=t_sortop_g<t_type_rgba>::operator_; break;
		case ch_rgb_b:		op=t_sortop_b<t_type_rgba>::operator_; break;
		case ch_rgb_a:		op=t_sortop_b<t_type_rgba>::operator_; break;
		case ch_avr:		op=t_sortop_rgb_avr<t_type_rgba>::operator_; break;
		case ch_lum:		op=t_sortop_rgb_lum<t_type_rgba>::operator_; break;
		}
		return op;
	}
};


//! \[g Template
template < typename _PROCT > 
class t_com_sort_functor : protected t_com_sortop_base <_PROCT>
{
protected:
	operation operation_;

public:
	t_com_sort_functor()
	{
		operation_ = t_com_sortop_select<_PROCT>::select_op();
	}
	t_com_sort_functor(channel_type t)
	{
		operation_ = t_com_sortop_select<_PROCT>::select_op(t);
	}
	inline bool operator()(const _PROCT* a, const _PROCT* b)
	{
		return operation_(a, b);
	}
};

}

#endif