#ifndef		__T_COMP_RGB_H_INCLUDE_
#define		__T_COMP_RGB_H_INCLUDE_

#include "t_comp_base.h"
#include "t_comp_template_sse2.h"
#include "../common/t_com_operator.h"
#include "../common/t_com_areaconv_comp.h"
#include "../contena/t_image_rgb.h"

namespace t_image_engine{


// RGBNX
class t_comp_rgb 
{
public:
	static inline bool composit(
		t_image_rgb* dst, const t_image_rgb& src, comp_operation operation = comp_copy,
		int dstSx = 0, int dstSy = 0, int srcSx = 0, int srcSy = 0, 
		int srcWidth = 0, int srcHeight = 0)
	{
		t_comp_rgb_template_base* compfunc = NULL;
		switch(operation){
case comp_copy:		compfunc = new t_comp_rgb_template<t_comp_rgb_copy>; break;
		case comp_and:		compfunc = new t_comp_rgb_template<t_comp_rgb_and>; break;
		case comp_or:		compfunc = new t_comp_rgb_template<t_comp_rgb_or>; break;
		case comp_xor:		compfunc = new t_comp_rgb_template<t_comp_rgb_xor>;	break; 
		case comp_add:		compfunc = new t_comp_rgb_template<t_comp_rgb_add>; break;
		case comp_sub:		compfunc = new t_comp_rgb_template<t_comp_rgb_sub>; break;
		case comp_multi:	compfunc = new t_comp_rgb_template<t_comp_rgb_multi>; break;
		case comp_div:		compfunc = new t_comp_rgb_template<t_comp_rgb_div>;	break;
		case comp_not_black:compfunc = new t_comp_rgb_template<t_comp_rgb_not_black>; break;
		case comp_not_white:compfunc = new t_comp_rgb_template<t_comp_rgb_not_white>; break;
		}
		bool ret = false;
		if(compfunc){
			ret = compfunc->f(dst,src,dstSx,dstSy,srcSx,srcSy,srcWidth,srcHeight);
			delete compfunc;
		}
		return ret;
	}

protected:
	// functor template base
	class t_comp_rgb_template_base
	{
	public:
		virtual bool f(t_image_rgb* dst, const t_image_rgb& src,
			int dstSx, int dstSy, int srcSx, int srcSy, int srcWidth, int srcHeight) = 0;
	};

	// functor template 
	template <typename _FUNCTOR>
	class t_comp_rgb_template : public t_comp_rgb_template_base
	{
	public:
		bool f(t_image_rgb* dst, const t_image_rgb& src,
			int dstSx, int dstSy, int srcSx, int srcSy, int srcWidth, int srcHeight)
		{
			return t_com_areaconv_comp< t_image_rgb , t_image_rgb, _FUNCTOR >::func(
				src, dst, dstSx, dstSy, srcSx, srcSy, srcWidth, srcHeight);
		}
	};

protected:
	// copy
	struct t_comp_rgb_copy{
		inline static void f(t_type_rgb* d, const t_type_rgb* s, int width)
		{memcpy(d, s, width*3);}
	};

	// or
	struct t_comp_rgb_or{
		inline static void f(t_type_rgb* d, const t_type_rgb* s, int width)
		{for(int x = 0; x < width; x++, d++, s++){
			d->r_|=s->r_; d->g_|=s->g_; d->b_|=s->b_;}}
	};
	
	// xor
	struct t_comp_rgb_xor{
		inline static void f(t_type_rgb* d, const t_type_rgb* s, int width)
		{for(int x = 0; x < width; x++, d++, s++)
			{d->r_^=s->r_; d->g_^=s->g_; d->b_^=s->b_;}}
	};

	// div
	struct t_comp_rgb_div{
		inline static void f(t_type_rgb* d, const t_type_rgb* s, int width)
		{for(int x = 0; x < width; x++, d++, s++)
			{d->r_=ucd(d->r_, s->r_); d->g_=ucd(d->g_, s->g_); d->b_=ucd(d->b_, s->b_); }}
	};

	// not_black
	struct t_comp_rgb_not_black{
		inline static void f(t_type_rgb* d, const t_type_rgb* s, int width)
		{for(int x = 0; x < width; x++, d++, s++)
			{if(*(unsigned int*)s&0x00ffffff) *d=*s;}}				
	};

	// not_white
	struct t_comp_rgb_not_white{
		static inline void f(t_type_rgb* d, const t_type_rgb* s, int width)
		{for(int x = 0; x < width; x++, d++, s++)
			{if((*(unsigned int*)s&0x00ffffff)!=0x00ffffff) *d=*s;}}	
	};

// SSE2Ή֐
#ifdef USING_SSE2
	// add
	struct t_comp_rgb_add{
		inline static void f(t_type_rgb* d, const t_type_rgb* s, int width)
		{t_comp_uc_sse2<t_type_rgb, t_type_rgb, 3>::add(d,s,width);}
	};

	// sub
	struct t_comp_rgb_sub{
		inline static void f(t_type_rgb* d, const t_type_rgb* s, int width)
		{t_comp_uc_sse2<t_type_rgb, t_type_rgb, 3>::sub(d,s,width);}
	};

	// multi
	struct t_comp_rgb_multi{
		inline static void f(t_type_rgb* d, const t_type_rgb* s, int width)
		{t_comp_uc_sse2<t_type_rgb, t_type_rgb, 3>::multi(d,s,width);}
	};

	// and
	struct t_comp_rgb_and{
		inline static void f(t_type_rgb* d, const t_type_rgb* s, int width)
		{t_comp_uc_sse2<t_type_rgb, t_type_rgb, 3>::and(d,s,width);}
	};

#else
	// add
	struct t_comp_rgb_add{
		inline static void f(t_type_rgb* d, const t_type_rgb* s, int width)
		{for(int x = 0; x < width; x++, d++, s++){
			d->r_=uca(d->r_, s->r_); d->g_=uca(d->g_, s->g_); d->b_=uca(d->b_, s->b_);}}	
	};

	// sub
	struct t_comp_rgb_sub{
		inline static void f(t_type_rgb* d, const t_type_rgb* s, int width)
		{for(int x = 0; x < width; x++, d++, s++){
			d->r_=ucs(d->r_, s->r_); d->g_=ucs(d->g_, s->g_); d->b_=ucs(d->b_, s->b_); }}
	};

	// multi
	struct t_comp_rgb_multi{
		inline static void f(t_type_rgb* d, const t_type_rgb* s, int width)
		{for(int x = 0; x < width; x++, d++, s++)
			{d->r_=ucm(d->r_, s->r_); d->g_=ucm(d->g_, s->g_); d->b_=ucm(d->b_, s->b_); }}
	};

	// and
	struct t_comp_rgb_and{
		inline static void f(t_type_rgb* d, const t_type_rgb* s, int width)
		{for(int x = 0; x < width; x++, d++, s++){
			d->r_&=s->r_; d->g_&=s->g_; d->b_&=s->b_;}
		}
	};
#endif
		

};

}

#endif