#ifndef		__T_IMAGE_BASE_H_INCLUDE_
#define		__T_IMAGE_BASE_H_INCLUDE_

#include "../type/t_type_define.h"
#include "t_palette.h"

namespace t_image_engine{

///! 摜pC^[tFCX
class t_image_interface
{
protected:
	unsigned char	*image_;	//!< i[Ă摜̐擪|C^
	int				width_;		//!< 摜
	int				height_;	//!< 摜
	int				bit_;		//!< 摜rbg
	image_tag		tag_;		//!< 摜^Cv

	t_palette*		palette_;	//!< J[pbg()

public:
	// ʃC^[tFCX inline
	//! 摜̐擪|C^擾
	inline unsigned char *pointer_()					{return image_;}
	//! 摜̐擪|C^擾(lύXs)
	inline const unsigned char *pointer_safe_() const	{return image_;}

	//! 摜sNZPʂŎ擾
	inline int width() const					{return width_;}
	//! 摜sNZPʂŎ擾
	inline int height() const					{return height_;}
	//! 摜̑sNZ擾
	inline int size() const						{return width_ * height_;}
	//! 摜̃J[rbg擾
	inline int bitcount() const					{return bit_;}
	//! 摜^Cv̎擾
	inline image_tag tag() const				{return tag_;}
	//! 摜̃TCY擾
	inline int memorysize(int n) const			{return (bit_>=8)?n*(bit_/8):n/(bit_*8);}
	inline int memorysize() const				{return memorysize(size());}
	//! 摜̃C̃TCY擾
	inline int linesize() const					{return memorysize(width());}
	//! 摜̗L
	inline bool is_empty() const				{return image_?false:true;}
	//! J[pbgێ邩
	inline bool have_palette() const			{return palette_?true:false;}


	/*==========================================================================================*//*!
	@brief
		ftHgRXgN^
	*//*==========================================================================================*/
	t_image_interface() : image_(NULL), width_(0), height_(0), bit_(0), palette_(NULL)
	{
	}

	/*==========================================================================================*//*!
	@brief
		fXgN^
	*//*==========================================================================================*/
	virtual ~t_image_interface()
	{
		releace();
	}

	/*==========================================================================================*//*!
	@brief
		摜J
	*//*==========================================================================================*/
	virtual void releace()
	{
		// NULLłȂ΃f[^j 
		if(image_){
			delete [] image_;
			image_ = NULL;
		}
		if(palette_){
			delete palette_;
			palette_ = NULL;
		}
		width_ = height_ = 0;
	}

	/*==========================================================================================*//*!
	@brief
		^`FbN
	*//*==========================================================================================*/
	virtual bool is_same(const t_image_interface* rhs)
	{
		return (rhs && rhs->width() == width_ && rhs->height() == height() && rhs->tag() == tag_);
	}
};

//! 摜pNX
template <class _TYPE> class t_image_base : public t_image_interface
{
public:
	// ǧ^
	typedef _TYPE imagetype_;

	// AhX擾C^[tFCX
	//! 摜̐擪|C^擾
	inline _TYPE *pointer()						{return reinterpret_cast< _TYPE*>(image_);}
	//! 摜̐擪|C^擾(lύXs)
	inline const _TYPE *pointer_safe() const	{return reinterpret_cast< _TYPE*>(image_);}

	/*==========================================================================================*//*!
	@brief
		ftHgRXgN^
	*//*==========================================================================================*/
	t_image_base() : t_image_interface()
	{
	}

	/*==========================================================================================*//*!
	@brief
		fXgN^
	*//*==========================================================================================*/
	virtual ~t_image_base() 
	{
		releace();
	}

	/*==========================================================================================*//*!
	@brief
		摜̈mۊ֐

	@param	width	mۂ摜̕
	@param	height	mۂ摜̍
	@return
		֐
	*//*==========================================================================================*/
	virtual bool create(int width, int height)
	{
		// 摜̈̊m(AȂVmۂȂ)
		if ( width != width_ || height != height_ ){
			// 摜擪|C^NULLłȂΉ摜j
			if( image_ != NULL )
				delete [] image_;
			// V̈m
			width_  = width;
			height_ = height;
			image_ = new unsigned char [memorysize()];
		}
		// A
		memset(image_, 0, memorysize());

		return true;
	}

	/*==========================================================================================*//*!
	@brief
		摜Zbg֐

	@param	image	Zbg摜̐擪|C^
	@param	width	摜̕
	@param	height	摜̍
	@return
		֐
	*//*==========================================================================================*/
	virtual	bool set(const _TYPE *image, int width, int height)
	{
		// 摜|C^Rs[
		if(image && create(width, height)){
			memcpy(image_, image, memorysize());
			return true;
		}else{
			return false;
		}
	}

	/*==========================================================================================*//*!
	@brief
		摜Zbg֐

	@param	&image	Zbg摜
	@param	sx		ZbgJnʒu X
	@param	sy		ZbgJnʒu Y
	@return
		֐
	*//*==========================================================================================*/
	virtual	bool set(const t_image_base &image, int sx, int sy)
	{
		if(bit_ < 8)
			return false;
		const int copywidth = (width_ - sx) * sizeof(_TYPE);
		for(int yy = 0; yy < image.height(); yy++){
			const _TYPE *pt1 = (_TYPE*)image.pointer_safe() + yy * image.width();
			_TYPE		*pt2 = (_TYPE*)image_ + (yy + sy) * width_ + sx;
			memcpy(pt2, pt1, copywidth);
		}
		return true;
	}
	/*==========================================================================================*//*!
	@brief
		摜Rs[
	@param	sx			Rs[JnXW
	@param	sy			Rs[JnYW
	@param	width		Rs[镝
	@param	height		Rs[鍂
	@param	dst_image	Rs[摜
	@return
		֐
	*//*==========================================================================================*/
	virtual bool copy(int sx, int sy, int width, int height, t_image_base *dst_image)
	{
		// G[`FbN
		if(bit_ < 8)
			return false;
		if(sx < 0 || sx + width > width_)
			return false;
		if(sy < 0 || sy + height > height_)
			return false;

		// ̈m
		dst_image->create(width, height);

		const unsigned char* pimg = image_;
		unsigned char* pimg_d = (BYTE*)dst_image->pointer();

		// n_̃ItZbg
		pimg = pimg + (sy * width_ + sx) * sizeof(_TYPE);

		// Rs[
		for(int i = 0; i < height; i++){
			memcpy(pimg_d, pimg, sizeof(_TYPE) * width);
			pimg += width_ * sizeof(_TYPE);
			pimg_d += width * sizeof(_TYPE);
		}
		return true;
	}

	/*==========================================================================================*//*!
	@brief
		摜㉺]
	*//*==========================================================================================*/
	virtual bool reverse()
	{
		if(bit_ < 8)
			return false;
		// Rs[쐬
		unsigned char* copy = new unsigned char [memorysize()];
		unsigned char* dst = copy;
		unsigned char* src = image_ + (width() * (height() - 1)) * sizeof(_TYPE);
		// ㉺]
		for(int yy = 0; yy < height_; yy++){
			memcpy(dst, src, width() * sizeof(_TYPE));
			dst += width() * sizeof(_TYPE);
			src -= width() * sizeof(_TYPE);
		}
		// u
		delete [] image_;
		image_ = copy;
		return true;
	}

	/*==========================================================================================*//*!
	@brief
		摜ړ

  	@param	x		Xړl
	@param	y		Yړl
	*//*==========================================================================================*/
	virtual bool move(int x, int y)
	{
		const _TYPE*	src_pt;	// Rs[AhX
		_TYPE*			dst_pt;	// Rs[AhX
		int				offset; // AhXړl
	
		if(bit_ < 8)
			return false;
		// Rs[ARs[AhXƃItZbgl̎Zo
		if(y < 0){
			src_pt = ((const _TYPE*)pointer_safe())  + width() * abs(y);
			dst_pt = (_TYPE*)pointer();
			offset = width();
		}else{
			src_pt = ((const _TYPE*)pointer_safe()) + width() * (height() - y - 1);
			dst_pt = (_TYPE*)pointer() + width() * (height() - 1);
			offset = -width();
		}
		// Rs[AItZbgl̎Zo
		int	x_size = width() - abs(x);
		int dst_off;
		int src_off;
		if(x < 0){
			dst_off = 0;
			src_off = abs(x);
		}else{
			dst_off = x;
			src_off = 0;
		}

		// ړ
		int cpy_cnt = height() - abs(y);
		for(int yy = 0; yy < height(); yy++){
			_TYPE* buffer = new _TYPE [width()];
			memset(buffer, 0, width() * sizeof(_TYPE));
			if(yy < cpy_cnt){
				memcpy(buffer + dst_off, src_pt + src_off, x_size * sizeof(_TYPE));
				memcpy(dst_pt, buffer, width() * sizeof(_TYPE));
			}else{
				memcpy(dst_pt, buffer, width() * sizeof(_TYPE));
			}
			delete [] buffer;
			dst_pt += offset;
			src_pt += offset;
		}
		return true;
	}

	/*==========================================================================================*//*!
	@brief
		= Iy[^B^Iy[^
	@param	rhs	EӒl
	@return
		thisBg̎QƁB
	*//*==========================================================================================*/
	virtual t_image_base<_TYPE>& operator = (const t_image_base<_TYPE>& rhs)
	{
		set(rhs.pointer_safe(), rhs.width(), rhs.height());
		bit_ = rhs.bitcount();
		return *this;
	}

	/*==========================================================================================*//*!
	@brief
		hԂ
	@param	val hԂl
	*//*==========================================================================================*/
	void fill(const _TYPE& val)
	{
		_TYPE* pt = pointer();
		for(int i = 0; i < size(); i++)
			*pt++ = val;
	}
};	

};

#endif