#ifndef		__T_CONV_GRAY2BINARY_H_INCLUDE_
#define		__T_CONV_GRAY2BINARY_H_INCLUDE_

#include "../contena/t_image_gray.h"
#include "../contena/t_image_binary.h"

namespace t_image_engine{

class t_conv_gray2binary{
public:

	///! GrayBinaryɕϊ
	static bool gray2binary(const t_image_gray& src, t_image_binary* dst, unsigned char th = 128)
	{
		if(!dst || !dst->create(src.width(), src.height())){
			return false;
		}
		for(int y = 0; y < src.height(); y++){
			const unsigned char* sp = src.pointer_safe() + y * src.width();
			unsigned char* dp = dst->pointer() + y * dst->linesize();
			int i = 7;
			unsigned char data = 0x00;
			for(int x = 0; x < src.width(); x++, sp++){
				if(*sp > th){
					data+=bin_mask_table[i];
				}
				if(--i<0){
					*dp++ = data; 
					i=7; 
					data = 0x00;
				}
			}
		}
		return true;
	}


	///
	static bool binary2gray(const t_image_binary& src, t_image_gray* dst)
	{
		if(!dst || !dst->create(src.width(), src.height())){
			return false;
		}
		for(int y = 0; y < src.height(); y++){
			const unsigned char* sp = src.pointer_safe() + y * src.linesize();
			unsigned char* dp = dst->pointer() + y * src.width();
			int i = 7;
			for(int x = 0; x < src.width(); x++, dp++){
				if(*sp & bin_mask_table[i]){
					*dp = 0xff;
				}
				if(--i<0){
					sp++;
					i = 7;
				}
			}
		}
		return true;
	}
};

}

#endif