#ifndef		__T_CONV_RGB2RGBA_H_INCLUDE_
#define		__T_CONV_RGB2RGBA_H_INCLUDE_

#include "../contena/t_image_rgb.h"
#include "../contena/t_image_rgba.h"
#include "../common/t_com_allconv.h"

namespace t_image_engine{

class t_conv_rgb2rgba
{
public:
	//! RGB(24bit)->RGB(32bit)
	inline static bool rgb2rgba(const t_image_rgb& src, t_image_rgba* dst)
	{
		return t_com_allconv<t_image_rgb, t_image_rgba, t_conv_f_rgb2rgba>::func(src, dst);
	}

	//! RGB(32bit)->RGB(24bit)
	inline static bool rgb2rgba(const t_image_rgba& src, t_image_rgb* dst)
	{
		return t_com_allconv<t_image_rgba, t_image_rgb, t_conv_f_rgba2rgb>::func(src, dst);
	}

protected:
	//! RGB(24bit)->RGB(32bit)
	struct t_conv_f_rgb2rgba{
		inline static void f(const t_type_rgb* src, t_type_rgba* dst)
		{memcpy(dst, src, 3);}
	};
	//! RGB(32bit)->RGB(24bit)
	struct t_conv_f_rgba2rgb{
		inline static void f(const t_type_rgba* src, t_type_rgb* dst)
		{memcpy(dst, src, 3);}
	};
};

}

#endif
